/*
 * Copyright (c) 2025 DuckDuckGo
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.duckduckgo.app.browser.omnibar

enum class OmnibarType(val typeName: String) {
    SINGLE_TOP("TOP"),
    SINGLE_BOTTOM("BOTTOM"),
    SPLIT("SPLIT_TOP"),
    ;

    companion object {
        fun fromString(name: String): OmnibarType {
            return when (name) {
                "TOP" -> SINGLE_TOP
                "BOTTOM" -> SINGLE_BOTTOM
                "SPLIT_TOP" -> SPLIT
                else -> throw IllegalStateException("Unknown OmnibarType: $name")
            }
        }
    }
}
