/*
 * Copyright (c) 2023 DuckDuckGo
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.duckduckgo.autofill.impl.email.incontext

import android.webkit.WebChromeClient
import android.webkit.WebView

class EmailProtectionInContextSignUpWebChromeClient(
    private val callback: ProgressListener,
) : WebChromeClient() {

    interface ProgressListener {
        fun onPageFinished(url: String)
    }

    override fun onProgressChanged(
        webView: WebView?,
        newProgress: Int,
    ) {
        val url = webView?.url ?: return

        when (newProgress) {
            PROGRESS_PAGE_FINISH -> callback.onPageFinished(url)
        }
    }

    companion object {
        private const val PROGRESS_PAGE_FINISH = 100
    }
}
