/*
 * Copyright (c) 2025 DuckDuckGo
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.duckduckgo.common.ui.internal.ui

import androidx.lifecycle.ViewModel
import com.duckduckgo.common.ui.DuckDuckGoTheme
import com.duckduckgo.common.ui.internal.ui.store.AppComponentsPrefsDataStore
import kotlinx.coroutines.flow.Flow

class AppComponentsViewModel(
    private val appComponentsPrefsDataStore: AppComponentsPrefsDataStore,
) : ViewModel() {

    val themeFlow: Flow<DuckDuckGoTheme> = appComponentsPrefsDataStore.themeFlow

    suspend fun setTheme(theme: DuckDuckGoTheme) {
        appComponentsPrefsDataStore.setTheme(theme)
    }
}
