/*
 * Copyright (c) 2021 DuckDuckGo
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.duckduckgo.remote.messaging.fixtures

import com.duckduckgo.remote.messaging.api.Action
import com.duckduckgo.remote.messaging.api.CardItem
import com.duckduckgo.remote.messaging.api.CardItemType
import com.duckduckgo.remote.messaging.api.Content
import com.duckduckgo.remote.messaging.api.Content.Placeholder
import com.duckduckgo.remote.messaging.api.Content.Placeholder.ANNOUNCE
import com.duckduckgo.remote.messaging.api.Content.Placeholder.IMAGE_AI
import com.duckduckgo.remote.messaging.api.Content.Placeholder.MAC_AND_WINDOWS
import com.duckduckgo.remote.messaging.api.Content.Placeholder.RADAR
import com.duckduckgo.remote.messaging.api.RemoteMessage
import com.duckduckgo.remote.messaging.api.Surface

@Suppress("MemberVisibilityCanBePrivate")
object RemoteMessageOM {
    fun urlAction(
        url: String = "http://example.com",
    ) = Action.Url(value = url)

    fun smallContent(
        titleText: String = "title",
        descriptionText: String = "description",
    ) = Content.Small(
        titleText = titleText,
        descriptionText = descriptionText,
    )

    fun mediumContent(
        titleText: String = "title",
        descriptionText: String = "description",
        placeholder: Placeholder = ANNOUNCE,
    ) = Content.Medium(
        titleText = titleText,
        descriptionText = descriptionText,
        placeholder = placeholder,
    )

    fun bigSingleActionContent(
        titleText: String = "title",
        descriptionText: String = "description",
        placeholder: Placeholder = ANNOUNCE,
        primaryActionText: String = "Action1",
        primaryAction: Action = urlAction(),
    ) = Content.BigSingleAction(
        titleText = titleText,
        descriptionText = descriptionText,
        placeholder = placeholder,
        primaryActionText = primaryActionText,
        primaryAction = primaryAction,
    )

    fun bigTwoActionsContent(
        titleText: String = "title",
        descriptionText: String = "description",
        placeholder: Placeholder = ANNOUNCE,
        primaryActionText: String = "Action1",
        primaryAction: Action = urlAction(),
        secondaryActionText: String = "Action2",
        secondaryAction: Action = urlAction(),
    ) = Content.BigTwoActions(
        titleText = titleText,
        descriptionText = descriptionText,
        placeholder = placeholder,
        primaryActionText = primaryActionText,
        primaryAction = primaryAction,
        secondaryActionText = secondaryActionText,
        secondaryAction = secondaryAction,
    )

    fun promoSingleActionContent(
        titleText: String = "title",
        descriptionText: String = "description",
        placeholder: Placeholder = MAC_AND_WINDOWS,
        actionText: String = "Action",
        action: Action = urlAction(),
    ) = Content.PromoSingleAction(
        titleText = titleText,
        descriptionText = descriptionText,
        placeholder = placeholder,
        actionText = actionText,
        action = action,
    )

    fun cardsListContent(
        titleText: String = "title",
        descriptionText: String = "description",
        placeholder: Placeholder = ANNOUNCE,
        primaryActionText: String = "Action",
        primaryAction: Action = urlAction(),
        listItems: List<CardItem> = listOf(
            CardItem(
                id = "item1",
                type = CardItemType.TWO_LINE_LIST_ITEM,
                titleText = "Item Title 1",
                descriptionText = "Item Description 1",
                placeholder = IMAGE_AI,
                primaryAction = urlAction(),
            ),
            CardItem(
                id = "item2",
                type = CardItemType.TWO_LINE_LIST_ITEM,
                titleText = "Item Title 2",
                descriptionText = "Item Description 2",
                placeholder = RADAR,
                primaryAction = urlAction(),
            ),
        ),
    ) = Content.CardsList(
        titleText = titleText,
        descriptionText = descriptionText,
        placeholder = placeholder,
        primaryActionText = primaryActionText,
        primaryAction = primaryAction,
        listItems = listItems,
    )

    fun aSmallMessage(
        id: String = "id",
        content: Content = smallContent(),
        exclusionRules: List<Int> = emptyList(),
        matchingRules: List<Int> = emptyList(),
        surfaces: List<Surface> = emptyList(),
    ): RemoteMessage {
        return RemoteMessage(
            id = id,
            content = content,
            exclusionRules = exclusionRules,
            matchingRules = matchingRules,
            surfaces = surfaces,
        )
    }

    fun aMediumMessage(
        id: String = "id",
        content: Content = mediumContent(),
        exclusionRules: List<Int> = emptyList(),
        matchingRules: List<Int> = emptyList(),
        surfaces: List<Surface> = emptyList(),
    ): RemoteMessage {
        return RemoteMessage(
            id = id,
            content = content,
            exclusionRules = exclusionRules,
            matchingRules = matchingRules,
            surfaces = surfaces,
        )
    }

    fun aBigSingleActionMessage(
        id: String = "id",
        content: Content = bigSingleActionContent(),
        exclusionRules: List<Int> = emptyList(),
        matchingRules: List<Int> = emptyList(),
        surfaces: List<Surface> = emptyList(),
    ): RemoteMessage {
        return RemoteMessage(
            id = id,
            content = content,
            exclusionRules = exclusionRules,
            matchingRules = matchingRules,
            surfaces = surfaces,
        )
    }

    fun aBigTwoActionsMessage(
        id: String = "id",
        content: Content = bigTwoActionsContent(),
        exclusionRules: List<Int> = emptyList(),
        matchingRules: List<Int> = emptyList(),
        surfaces: List<Surface> = emptyList(),
    ): RemoteMessage {
        return RemoteMessage(
            id = id,
            content = content,
            exclusionRules = exclusionRules,
            matchingRules = matchingRules,
            surfaces = surfaces,
        )
    }

    fun aPromoSingleActionMessage(
        id: String = "id",
        content: Content = promoSingleActionContent(),
        exclusionRules: List<Int> = emptyList(),
        matchingRules: List<Int> = emptyList(),
        surfaces: List<Surface> = emptyList(),
    ): RemoteMessage {
        return RemoteMessage(
            id = id,
            content = content,
            exclusionRules = exclusionRules,
            matchingRules = matchingRules,
            surfaces = surfaces,
        )
    }

    fun aCardsListMessage(
        id: String = "id",
        content: Content = cardsListContent(),
        exclusionRules: List<Int> = emptyList(),
        matchingRules: List<Int> = emptyList(),
        surfaces: List<Surface> = emptyList(),
    ): RemoteMessage {
        return RemoteMessage(
            id = id,
            content = content,
            exclusionRules = exclusionRules,
            matchingRules = matchingRules,
            surfaces = surfaces,
        )
    }
}
