/*
 * Copyright (c) 2025 DuckDuckGo
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.duckduckgo.pir.impl.dashboard.messaging.model

/**
 * Represents the request body sent by the JS layer in PIR Web UI.
 */
sealed interface PirWebMessageRequest {

    data class AddNameToCurrentUserProfileRequest(
        val first: String,
        val middle: String? = null,
        val last: String,
    ) : PirWebMessageRequest

    data class AddAddressToCurrentUserProfileRequest(
        val city: String,
        val state: String,
    ) : PirWebMessageRequest

    data class SetBirthYearForCurrentUserProfileRequest(
        val year: Int,
    ) : PirWebMessageRequest

    data class RemoveAddressAtIndexFromCurrentUserProfileRequest(
        val index: Int,
    ) : PirWebMessageRequest

    data class RemoveNameAtIndexFromCurrentUserProfileRequest(
        val index: Int,
    ) : PirWebMessageRequest

    data class SetNameAtIndexInCurrentUserProfileRequest(
        val index: Int,
        val name: Name,
    ) : PirWebMessageRequest {
        data class Name(
            val first: String,
            val middle: String? = null,
            val last: String,
        )
    }

    data class SetAddressAtIndexForCurrentUserProfileRequest(
        val index: Int,
        val address: Address,
    ) : PirWebMessageRequest {
        data class Address(
            val city: String,
            val state: String,
        )
    }

    data class RemoveOptOutFromDashboardRequest(
        val recordId: Long,
    ) : PirWebMessageRequest
}
