/*
 * Copyright (c) 2024 DuckDuckGo
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.duckduckgo.subscriptions.impl

import com.duckduckgo.di.scopes.AppScope
import com.duckduckgo.feature.toggles.api.Toggle.State.Target
import com.duckduckgo.feature.toggles.api.Toggle.TargetMatcherPlugin
import com.duckduckgo.subscriptions.api.Subscriptions
import com.squareup.anvil.annotations.ContributesMultibinding
import kotlinx.coroutines.runBlocking
import javax.inject.Inject

@ContributesMultibinding(AppScope::class)
class SubscriptionsToggleTargetMatcherPlugin @Inject constructor(
    private val subscriptions: Subscriptions,
) : TargetMatcherPlugin {
    override fun matchesTargetProperty(target: Target): Boolean {
        return target.isPrivacyProEligible?.let { isPrivacyProEligible ->
            // runBlocking sucks I know :shrug:
            isPrivacyProEligible == runBlocking { subscriptions.isEligible() }
        } ?: true
    }
}
