/*
 * Copyright (c) 2024 DuckDuckGo
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.duckduckgo.app.browser.webview

import com.duckduckgo.anvil.annotations.ContributesRemoteFeature
import com.duckduckgo.di.scopes.AppScope
import com.duckduckgo.feature.toggles.api.Toggle
import com.duckduckgo.feature.toggles.api.Toggle.DefaultFeatureValue

@ContributesRemoteFeature(
    scope = AppScope::class,
    featureName = "webViewCompat",
)
interface WebViewCompatFeature {

    @Toggle.DefaultValue(DefaultFeatureValue.FALSE)
    fun self(): Toggle

    @Toggle.DefaultValue(DefaultFeatureValue.FALSE)
    fun jsSendsInitialPing(): Toggle

    @Toggle.DefaultValue(DefaultFeatureValue.FALSE)
    fun jsRepliesToNativeMessages(): Toggle

    @Toggle.DefaultValue(DefaultFeatureValue.FALSE)
    fun replyToInitialPing(): Toggle

    @Toggle.DefaultValue(DefaultFeatureValue.FALSE)
    fun useBlobDownloadsMessageListener(): Toggle

    @Toggle.DefaultValue(DefaultFeatureValue.FALSE)
    fun sendMessageOnContextMenuOpen(): Toggle

    @Toggle.DefaultValue(DefaultFeatureValue.FALSE)
    fun sendMessageOnPageStarted(): Toggle

    @Toggle.DefaultValue(DefaultFeatureValue.FALSE)
    fun sendMessagesUsingReplyProxy(): Toggle

    @Toggle.DefaultValue(DefaultFeatureValue.FALSE)
    fun useComplexScript(): Toggle

    @Toggle.DefaultValue(DefaultFeatureValue.FALSE)
    fun useLargeScript(): Toggle
}

data class WebViewCompatFeatureSettings(
    val jsInitialPingDelay: Long = 0,
    val initialPingDelay: Long = 0,
    val numberOfScriptsToInject: Long = 1,
)
