# Improve Language Translations
Thank you for taking the time to contribute to DuckDuckGo! :sparkles:

If you know any of the following languages and would like to help us improve the translations for them, please follow the instructions below.

⚠️ We only accept translations tweaks that fix actual issues (typos, grammatical errors) and won't accept minor changes that are only focused on tweaking the wording.

## List of languages
1. Bulgarian (bg)
1. Croatian (hr)
1. Czech (cs)
1. Danish (da)
1. Dutch (nl)
1. Estonian (et)
1. Finnish (fi)
1. French (fr)
1. German (de)
1. Greek (el)
1. Hungarian (hu)
1. Italian (it)
1. Latvian (lv)
1. Lithuanian (lt)
1. Norwegian bokmål (nb)
1. Polish (pl)
1. Portuguese (pt)
1. Romanian (ro)
1. Russian (ru)
1. Slovak (sk)
1. Slovenian (sl)
1. Spanish (es)
1. Swedish (sv)
1. Turkish (tr)

## How to help

1. Each language has a [`values`](https://github.com/duckduckgo/Android/tree/develop/app/src/main/res) directory containing the language code, and the `strings.xml` file contains the translations. Examples:
    - Italian translation files are located within `app/src/main/res/values-it/strings.xml`  
    - Spanish translation files are located within `app/src/main/res/values-es/strings.xml`
1. If you notice anything which should be fixed, you should create a PR containing the improved language suggestions.
    1. Make the changes to the relevant `strings.xml` file
    1. Test the app in the language you've improved, and ensure the changed strings look good
    1. Create a PR. As well as the changes themselves, explaining _why_ the changes are an improvement helps a lot.
             

ℹ️ Please note we are not looking for help with other languages at this time; only the languages listed above. We may open up requests in future for additional languages.
