## Pull Requests

If you are thinking of, or have prepared a pull request, **thank you!**  Your efforts are greatly appreciated by everyone associated with this project.

In order to get your PR accepted please ensure the following:

 * describe briefly the rational of the change, why did you do this (to create new feature, bug fix, add some missing docs etc...)?
 * detail the purpose of the change - **what is the expected change in behaviour**?
 * state which operating systems are affected
 * provide details on how to test the change
 
### How do I get it accepted?

Although there are lots of contributors you might not find one who has the time to test your change, and it needs to be tested before it gets merged.  

A good (and helpful) approach is to find someone to test your change before a contributor takes a look at it.  Perhaps ask someone else who has an outstanding PR to test your PR, and in exchange you offer to test theirs.  For very small changes (just a few lines of code maybe) then just one reviewer is probably sufficient.  But for larger changes try and find more than one person to test it.

### Testing a PR

If you are testing someones PR, please provide the following feedback:

 * are you happy that the purpose or intent of this PR is a suitable change for this project? (_is it a good idea?_)
 * are you happy that the change in behaviour works as described, and you have tested the change on all affected operating systems?
 * in your opinion, is the code written _sensibly_? 
   * is it clean and tidy? 
   * there are any unnecessary changes?
   * is it documented appropriately?
   
   
