"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bindByDisplayValueQueries = void 0;
var _reactNative = require("react-native");
var _filterNodeByType = require("../helpers/filterNodeByType");
var _findAll = require("../helpers/findAll");
var _matches = require("../matches");
var _config = require("../config");
var _hostComponentNames = require("../helpers/host-component-names");
var _makeQueries = require("./makeQueries");
const getTextInputNodeByDisplayValue = (node, value, options = {}) => {
  const {
    exact,
    normalizer
  } = options;
  const nodeValue = node.props.value !== undefined ? node.props.value : node.props.defaultValue;
  const shouldReturnHostTextInput = (0, _config.getConfig)().useBreakingChanges;
  const textInputType = shouldReturnHostTextInput ? (0, _hostComponentNames.getHostComponentNames)().textInput : _reactNative.TextInput;
  return (0, _filterNodeByType.filterNodeByType)(node, textInputType) && (0, _matches.matches)(value, nodeValue, normalizer, exact);
};
const queryAllByDisplayValue = instance => function queryAllByDisplayValueFn(displayValue, queryOptions) {
  return (0, _findAll.findAll)(instance, node => getTextInputNodeByDisplayValue(node, displayValue, queryOptions), queryOptions);
};
const getMultipleError = displayValue => `Found multiple elements with display value: ${String(displayValue)} `;
const getMissingError = displayValue => `Unable to find an element with displayValue: ${String(displayValue)}`;
const {
  getBy,
  getAllBy,
  queryBy,
  queryAllBy,
  findBy,
  findAllBy
} = (0, _makeQueries.makeQueries)(queryAllByDisplayValue, getMissingError, getMultipleError);
const bindByDisplayValueQueries = instance => ({
  getByDisplayValue: getBy(instance),
  getAllByDisplayValue: getAllBy(instance),
  queryByDisplayValue: queryBy(instance),
  queryAllByDisplayValue: queryAllBy(instance),
  findByDisplayValue: findBy(instance),
  findAllByDisplayValue: findAllBy(instance)
});
exports.bindByDisplayValueQueries = bindByDisplayValueQueries;
//# sourceMappingURL=displayValue.js.map