"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorWithStack = void 0;
exports.copyStackTrace = copyStackTrace;
exports.prepareErrorMessage = exports.createQueryByError = exports.createLibraryNotSupportedError = void 0;
exports.printDeprecationWarning = printDeprecationWarning;
exports.throwRemovedFunctionError = throwRemovedFunctionError;
exports.throwRenamedFunctionError = throwRenamedFunctionError;
var _prettyFormat = _interopRequireDefault(require("pretty-format"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
class ErrorWithStack extends Error {
  constructor(message, callsite) {
    super(message);
    if (Error.captureStackTrace) {
      Error.captureStackTrace(this, callsite);
    }
  }
}
exports.ErrorWithStack = ErrorWithStack;
const createLibraryNotSupportedError = error => new Error(`Currently the only supported library to search by text is "react-native".\n\n${error instanceof Error ? error.message : ''}`);
exports.createLibraryNotSupportedError = createLibraryNotSupportedError;
const prepareErrorMessage = (error, name, value) => {
  let errorMessage;
  if (error instanceof Error) {
    // Strip info about custom predicate
    errorMessage = error.message.replace(/ matching custom predicate[^]*/gm, '');
  } else if (error && typeof error === 'object') {
    errorMessage = error.toString();
  } else {
    errorMessage = 'Caught unknown error';
  }
  if (name && value) {
    errorMessage += ` with ${name} ${(0, _prettyFormat.default)(value, {
      min: true
    })}`;
  }
  return errorMessage;
};
exports.prepareErrorMessage = prepareErrorMessage;
const createQueryByError = (error, callsite) => {
  if (error instanceof Error) {
    if (error.message.includes('No instances found')) {
      return null;
    }
    throw new ErrorWithStack(error.message, callsite);
  }
  throw new ErrorWithStack(
  // generic refining of `unknown` is very hard, you cannot do `'toString' in error` or anything like that
  // Converting as any with extra safe optional chaining will do the job just as well
  `Query: caught unknown error type: ${typeof error}, value: ${error?.toString?.()}`, callsite);
};
exports.createQueryByError = createQueryByError;
function copyStackTrace(target, stackTraceSource) {
  if (target instanceof Error && stackTraceSource.stack) {
    target.stack = stackTraceSource.stack.replace(stackTraceSource.message, target.message);
  }
}
const warned = {};
function printDeprecationWarning(functionName) {
  if (warned[functionName]) {
    return;
  }

  // eslint-disable-next-line no-console
  console.warn(`
  Deprecation Warning:
  Use of ${functionName} is not recommended and will be deleted in future versions of @testing-library/react-native.
  `);
  warned[functionName] = true;
}
function throwRemovedFunctionError(functionName, docsRef) {
  throw new Error(`"${functionName}" has been removed.\n\nPlease consult: https://callstack.github.io/react-native-testing-library/docs/${docsRef}`);
}
function throwRenamedFunctionError(functionName, newFunctionName) {
  throw new ErrorWithStack(`The "${functionName}" function has been renamed to "${newFunctionName}". Please replace all occurrences.`, throwRenamedFunctionError);
}
//# sourceMappingURL=errors.js.map