"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _reactNative = require("react-native");
var _act = _interopRequireDefault(require("./act"));
var _componentTree = require("./helpers/component-tree");
var _filterNodeByType = require("./helpers/filterNodeByType");
var _hostComponentNames = require("./helpers/host-component-names");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
const isTextInput = element => {
  if (!element) {
    return false;
  }

  // We have to test if the element type is either the TextInput component
  // (which would if it is a composite component) or the string
  // TextInput (which would be true if it is a host component)
  // All queries return host components but since fireEvent bubbles up
  // it would trigger the parent prop without the composite component check
  return (0, _filterNodeByType.filterNodeByType)(element, _reactNative.TextInput) || (0, _filterNodeByType.filterNodeByType)(element, (0, _hostComponentNames.getHostComponentNames)().textInput);
};
const isTouchResponder = element => {
  if (!(0, _componentTree.isHostElement)(element)) return false;
  return !!element?.props.onStartShouldSetResponder || isTextInput(element);
};
const isPointerEventEnabled = (element, isParent) => {
  const parentCondition = isParent ? element?.props.pointerEvents === 'box-only' : element?.props.pointerEvents === 'box-none';
  if (element?.props.pointerEvents === 'none' || parentCondition) {
    return false;
  }
  if (!element?.parent) return true;
  return isPointerEventEnabled(element.parent, true);
};
const isTouchEvent = eventName => {
  return eventName === 'press';
};
const isEventEnabled = (element, touchResponder, eventName) => {
  if (isTextInput(element)) return element?.props.editable !== false;
  if (!isPointerEventEnabled(element) && isTouchEvent(eventName)) return false;
  const touchStart = touchResponder?.props.onStartShouldSetResponder?.();
  const touchMove = touchResponder?.props.onMoveShouldSetResponder?.();
  if (touchStart || touchMove) return true;
  return touchStart === undefined && touchMove === undefined;
};
const findEventHandler = (element, eventName, callsite, nearestTouchResponder) => {
  const touchResponder = isTouchResponder(element) ? element : nearestTouchResponder;
  const handler = getEventHandler(element, eventName);
  if (handler && isEventEnabled(element, touchResponder, eventName)) return handler;
  if (element.parent === null || element.parent.parent === null) {
    return null;
  }
  return findEventHandler(element.parent, eventName, callsite, touchResponder);
};
const getEventHandler = (element, eventName) => {
  const eventHandlerName = toEventHandlerName(eventName);
  if (typeof element.props[eventHandlerName] === 'function') {
    return element.props[eventHandlerName];
  }
  if (typeof element.props[eventName] === 'function') {
    return element.props[eventName];
  }
  return undefined;
};
const invokeEvent = (element, eventName, callsite, ...data) => {
  const handler = findEventHandler(element, eventName, callsite);
  if (!handler) {
    return;
  }
  let returnValue;
  (0, _act.default)(() => {
    returnValue = handler(...data);
  });
  return returnValue;
};
const toEventHandlerName = eventName => `on${eventName.charAt(0).toUpperCase()}${eventName.slice(1)}`;
const pressHandler = (element, ...data) => invokeEvent(element, 'press', pressHandler, ...data);
const changeTextHandler = (element, ...data) => invokeEvent(element, 'changeText', changeTextHandler, ...data);
const scrollHandler = (element, ...data) => invokeEvent(element, 'scroll', scrollHandler, ...data);
const fireEvent = (element, eventName, ...data) => invokeEvent(element, eventName, fireEvent, ...data);
fireEvent.press = pressHandler;
fireEvent.changeText = changeTextHandler;
fireEvent.scroll = scrollHandler;
var _default = fireEvent;
exports.default = _default;
//# sourceMappingURL=fireEvent.js.map