Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toHaveTextContent = toHaveTextContent;

var _jestMatcherUtils = require("jest-matcher-utils");

var _utils = require("./utils");

function collectNormalizedText(element) {
  var childrenText = collectChildrenText(element).join('');
  return (0, _utils.normalize)(childrenText);
}

function collectChildrenText(element) {
  if (!element || !element.children) {
    return typeof element === 'string' ? [element] : [''];
  }

  return element.children.reduce(function (texts, child) {
    return texts.concat(collectChildrenText(child));
  }, []);
}

function toHaveTextContent(element, checkWith) {
  var _this = this;

  (0, _utils.checkReactElement)(element, toHaveTextContent, this);
  var textContent = collectNormalizedText(element);
  return {
    pass: (0, _utils.matches)(textContent, checkWith),
    message: function message() {
      var to = _this.isNot ? 'not to' : 'to';
      return (0, _utils.getMessage)((0, _jestMatcherUtils.matcherHint)((_this.isNot ? '.not' : '') + ".toHaveTextContent", 'element', ''), "Expected element " + to + " have text content", checkWith, 'Received', textContent);
    }
  };
}