/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */

import groupFilesByType from '../groupFilesByType';

describe('groupFilesByType', () => {
  it('should group files by its type', () => {
    const fonts = ['fonts/a.ttf', 'fonts/b.ttf'];
    const images = ['images/a.jpg', 'images/c.jpeg'];

    const groupedFiles = groupFilesByType(fonts.concat(images));

    expect(groupedFiles.font).toEqual(fonts);
    expect(groupedFiles.image).toEqual(images);
  });
});
