"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bindByPlaceholderTextQueries = void 0;
var _reactNative = require("react-native");
var _findAll = require("../helpers/findAll");
var _matches = require("../matches");
var _config = require("../config");
var _filterNodeByType = require("../helpers/filterNodeByType");
var _hostComponentNames = require("../helpers/host-component-names");
var _makeQueries = require("./makeQueries");
const getTextInputNodeByPlaceholderText = (node, placeholder, options = {}) => {
  const {
    exact,
    normalizer
  } = options;
  const shouldReturnHostTextInput = (0, _config.getConfig)().useBreakingChanges;
  const textInputType = shouldReturnHostTextInput ? (0, _hostComponentNames.getHostComponentNames)().textInput : _reactNative.TextInput;
  return (0, _filterNodeByType.filterNodeByType)(node, textInputType) && (0, _matches.matches)(placeholder, node.props.placeholder, normalizer, exact);
};
const queryAllByPlaceholderText = instance => function queryAllByPlaceholderFn(placeholder, queryOptions) {
  return (0, _findAll.findAll)(instance, node => getTextInputNodeByPlaceholderText(node, placeholder, queryOptions), queryOptions);
};
const getMultipleError = placeholder => `Found multiple elements with placeholder: ${String(placeholder)} `;
const getMissingError = placeholder => `Unable to find an element with placeholder: ${String(placeholder)}`;
const {
  getBy,
  getAllBy,
  queryBy,
  queryAllBy,
  findBy,
  findAllBy
} = (0, _makeQueries.makeQueries)(queryAllByPlaceholderText, getMissingError, getMultipleError);
const bindByPlaceholderTextQueries = instance => ({
  getByPlaceholderText: getBy(instance),
  getAllByPlaceholderText: getAllBy(instance),
  queryByPlaceholderText: queryBy(instance),
  queryAllByPlaceholderText: queryAllBy(instance),
  findByPlaceholderText: findBy(instance),
  findAllByPlaceholderText: findAllBy(instance)
});
exports.bindByPlaceholderTextQueries = bindByPlaceholderTextQueries;
//# sourceMappingURL=placeholderText.js.map