"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.flushMicroTasks = flushMicroTasks;
var _timers = require("./helpers/timers");
function flushMicroTasks() {
  return {
    // using "thenable" instead of a Promise, because otherwise it breaks when
    // using "modern" fake timers
    then(resolve) {
      (0, _timers.setImmediate)(resolve);
    }
  };
}
//# sourceMappingURL=flushMicroTasks.js.map