# Contributing to drip aka CONDRIPUTING

So good to see you here, hello :wave_tone1: :wave_tone2: :wave_tone3: :wave_tone4: :wave_tone5:

## Table Of Contents

[TL;DR](#tldr)

[What should I know before I get started?](#what-should-i-know-before-i-get-started)

[How can I condripute?](#how-can-i-condripute)

[Thank you](#thank-you)

## TL;DR

You just want to say hello? Send us a [nice email](mailto:drip@mailbox.org?Subject=Nice%20incoming%20mail) :postbox:, toot :mammoth: [@dripapp@mastodon.social](https://mastodon.social/@dripapp) or tweet :bird: at us [@dripberlin](https://twitter.com/dripberlin).

## What should I know before I get started?

We have prepared something for **you**: check out our [README](https://gitlab.com/bloodyhealth/drip/blob/main/README.md) for more information on how to set up and install everything you'll need.
[Ping us](mailto:drip@mailbox.org) if you could need some help :helmet_with_cross: !

Let us know if you want to suggest improvements for the README and open a merge request (which is just like Github's pull request)

## How can I condripute?

We are an open source project and we highly appreciate contributions. At the same time please keep some things in mind: :heart:

- The drip maintainers are usually around 2-3 people and are responsible for everything from developing new features to answering press inquiries or fixing bugs. Most of this work is done unpaid. (If you write a nice email your chances to get an answer are much higher than if you behave like a tech bro.)
- We have a plan for the direction in which drip should evolve. This means that even if it isn't always transparent on gitlab, we have a list of features that we are building and more importantly, which bugs need to be fixed and which dependencies need to be updated.
- drips core values are:
  - 🔮 open source
  - 🩸 feminist and gender inclusive
  - 🔒 secure: data entered stays with that person/on their device
  - 🔬 science-based: we implemented the sympto-thermal method

This means that we will never implement anything that contradicts these core values. Some examples: We will never build a cloud integration, we will never make an ovulation prediction.

- If you would like to make a sustainable contribution to the project, we would be happy to join the game.

### Reporting Bugs or Making Suggestions

If you found a bug or have suggestions, please :one: first review the [list of existing issues](https://gitlab.com/bloodyhealth/drip/issues) to make sure the bug/suggestion is unknown; :two: after that, take time to investigate and write a detailed issue report. Best you use our [templates for bug /chore/ feature](https://gitlab.com/bloodyhealth/drip/-/tree/main/.gitlab/issue_templates) (you can choose when creating a new issue) in gitlab or send us an email to our [gitlab email](mailto:incoming+bloodyhealth/drip@incoming.gitlab.com). It will automagically add a new issue to the list with a description text taken from the body of your email. Please attach screenshots or other helpful things.

### Your First Condripution

- If you want to contribute to drip's code or translation, please get in touch with us. We can tell you if someone is already working on something similar, if your idea does (not) match drip's core values, etc. Of course, you can always create a drip version for your private use with anything you want, but please don't expect us to review and merge code that has not been discussed before.
- If you want to open a merge request, yeah :tada: exciting! We are using a template for merge requests to make sure we explain what we have done and why.
- Keep in mind that people who will review your merge request are more motivated to do so when the merge request is well explained and ideally not too big.

### Thank you

![](https://media.giphy.com/media/kPA88elN9kYco/giphy.gif)

Thank you for condriputing to open source, thank you for condriputing to drip!
Much love from Bloody Health :heart_exclamation:
