// Autogenerated file. Do not edit.
// Generated from an annotated version of jni.h provided in Android NDK.
// (NDK Version 23.1.7779620)
// The license for original file is provided below:

/*
 * Copyright (C) 2006 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * JNI specification, as defined by Sun:
 * http://java.sun.com/javase/6/docs/technotes/guides/jni/spec/jniTOC.html
 *
 * Everything here is expected to be VM-neutral.
 */

// ignore_for_file: always_specify_types
// ignore_for_file: camel_case_types
// ignore_for_file: non_constant_identifier_names
// ignore_for_file: constant_identifier_names
// ignore_for_file: unused_field
// ignore_for_file: unused_element
// coverage:ignore-file

// AUTO GENERATED FILE, DO NOT EDIT.
//
// Generated by `package:ffigen`.
// ignore_for_file: type=lint
import 'dart:ffi' as ffi;

/// Bindings for libdartjni.so which is part of jni plugin.
///
/// It also transitively includes type definitions such as JNIEnv from third_party/jni.h;
///
/// However, functions prefixed JNI_ are not usable because they are in a different shared library.
///
/// Regenerate bindings with `flutter pub run ffigen --config ffigen.yaml`.
///
class JniBindings {
  /// Holds the symbol lookup function.
  final ffi.Pointer<T> Function<T extends ffi.NativeType>(String symbolName)
      _lookup;

  /// The symbols are looked up in [dynamicLibrary].
  JniBindings(ffi.DynamicLibrary dynamicLibrary)
      : _lookup = dynamicLibrary.lookup;

  /// The symbols are looked up with [lookup].
  JniBindings.fromLookup(
    ffi.Pointer<T> Function<T extends ffi.NativeType>(String symbolName) lookup,
  ) : _lookup = lookup;

  late final ffi.Pointer<pthread_key_t> _tlsKey = _lookup<pthread_key_t>(
    'tlsKey',
  );

  Dart__darwin_pthread_key_t get tlsKey => _tlsKey.value;

  set tlsKey(Dart__darwin_pthread_key_t value) => _tlsKey.value = value;

  JniClassLookupResult FindClass(ffi.Pointer<ffi.Char> name) {
    return _FindClass(name);
  }

  late final _FindClassPtr = _lookup<
      ffi.NativeFunction<
          JniClassLookupResult Function(ffi.Pointer<ffi.Char>)>>('FindClass');
  late final _FindClass = _FindClassPtr.asFunction<
      JniClassLookupResult Function(ffi.Pointer<ffi.Char>)>();

  JniExceptionDetails GetExceptionDetails(JThrowablePtr exception) {
    return _GetExceptionDetails(exception);
  }

  late final _GetExceptionDetailsPtr =
      _lookup<ffi.NativeFunction<JniExceptionDetails Function(JThrowablePtr)>>(
    'GetExceptionDetails',
  );
  late final _GetExceptionDetails = _GetExceptionDetailsPtr.asFunction<
      JniExceptionDetails Function(JThrowablePtr)>();

  ffi.Pointer<JavaVM$1> GetJavaVM() {
    return _GetJavaVM();
  }

  late final _GetJavaVMPtr =
      _lookup<ffi.NativeFunction<ffi.Pointer<JavaVM$1> Function()>>(
    'GetJavaVM',
  );
  late final _GetJavaVM =
      _GetJavaVMPtr.asFunction<ffi.Pointer<JavaVM$1> Function()>();

  ffi.Pointer<JniEnv$1> GetJniEnv() {
    return _GetJniEnv();
  }

  late final _GetJniEnvPtr =
      _lookup<ffi.NativeFunction<ffi.Pointer<JniEnv$1> Function()>>(
    'GetJniEnv',
  );
  late final _GetJniEnv =
      _GetJniEnvPtr.asFunction<ffi.Pointer<JniEnv$1> Function()>();

  /// Spawn a JVM with given arguments.
  ///
  /// Returns JNI_OK on success, and one of the documented JNI error codes on
  /// failure. It returns DART_JNI_SINGLETON_EXISTS if an attempt to spawn multiple
  /// JVMs is made, even if the underlying API potentially supports multiple VMs.
  JniErrorCode SpawnJvm(ffi.Pointer<JavaVMInitArgs> args) {
    return JniErrorCode.fromValue(_SpawnJvm(args));
  }

  late final _SpawnJvmPtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ffi.Pointer<JavaVMInitArgs>)>>(
      'SpawnJvm');
  late final _SpawnJvm =
      _SpawnJvmPtr.asFunction<int Function(ffi.Pointer<JavaVMInitArgs>)>();

  /// Returns Application classLoader (on Android),
  /// which can be used to load application and platform classes.
  ///
  /// On other platforms, NULL is returned.
  JObjectPtr GetClassLoader() {
    return _GetClassLoader();
  }

  late final _GetClassLoaderPtr =
      _lookup<ffi.NativeFunction<JObjectPtr Function()>>('GetClassLoader');
  late final _GetClassLoader =
      _GetClassLoaderPtr.asFunction<JObjectPtr Function()>();

  /// Returns application context on Android.
  ///
  /// On other platforms, NULL is returned.
  JObjectPtr GetApplicationContext() {
    return _GetApplicationContext();
  }

  late final _GetApplicationContextPtr =
      _lookup<ffi.NativeFunction<JObjectPtr Function()>>(
    'GetApplicationContext',
  );
  late final _GetApplicationContext =
      _GetApplicationContextPtr.asFunction<JObjectPtr Function()>();

  /// Returns current activity of the app on Android.
  JObjectPtr GetCurrentActivity() {
    return _GetCurrentActivity();
  }

  late final _GetCurrentActivityPtr =
      _lookup<ffi.NativeFunction<JObjectPtr Function()>>('GetCurrentActivity');
  late final _GetCurrentActivity =
      _GetCurrentActivityPtr.asFunction<JObjectPtr Function()>();

  int InitDartApiDL(ffi.Pointer<ffi.Void> data) {
    return _InitDartApiDL(data);
  }

  late final _InitDartApiDLPtr =
      _lookup<ffi.NativeFunction<ffi.IntPtr Function(ffi.Pointer<ffi.Void>)>>(
    'InitDartApiDL',
  );
  late final _InitDartApiDL =
      _InitDartApiDLPtr.asFunction<int Function(ffi.Pointer<ffi.Void>)>();

  int GetCurrentIsolateId() {
    return _GetCurrentIsolateId();
  }

  late final _GetCurrentIsolateIdPtr =
      _lookup<ffi.NativeFunction<ffi.Int64 Function()>>('GetCurrentIsolateId');
  late final _GetCurrentIsolateId =
      _GetCurrentIsolateIdPtr.asFunction<int Function()>();

  JniResult DartException__ctor(JStringPtr message, JThrowablePtr cause) {
    return _DartException__ctor(message, cause);
  }

  late final _DartException__ctorPtr = _lookup<
          ffi.NativeFunction<JniResult Function(JStringPtr, JThrowablePtr)>>(
      'DartException__ctor');
  late final _DartException__ctor = _DartException__ctorPtr.asFunction<
      JniResult Function(JStringPtr, JThrowablePtr)>();

  JniResult PortContinuation__ctor(int j) {
    return _PortContinuation__ctor(j);
  }

  late final _PortContinuation__ctorPtr =
      _lookup<ffi.NativeFunction<JniResult Function(ffi.Int64)>>(
    'PortContinuation__ctor',
  );
  late final _PortContinuation__ctor =
      _PortContinuation__ctorPtr.asFunction<JniResult Function(int)>();

  void resultFor(ffi.Pointer<CallbackResult> result, JObjectPtr object) {
    return _resultFor(result, object);
  }

  late final _resultForPtr = _lookup<
      ffi.NativeFunction<
          ffi.Void Function(
              ffi.Pointer<CallbackResult>, JObjectPtr)>>('resultFor');
  late final _resultFor = _resultForPtr
      .asFunction<void Function(ffi.Pointer<CallbackResult>, JObjectPtr)>();

  Dart_FinalizableHandle newJObjectFinalizableHandle(
    Object object,
    JObjectPtr reference,
    JObjectRefType refType,
  ) {
    return _newJObjectFinalizableHandle(object, reference, refType.value);
  }

  late final _newJObjectFinalizableHandlePtr = _lookup<
      ffi.NativeFunction<
          Dart_FinalizableHandle Function(
            ffi.Handle,
            JObjectPtr,
            ffi.UnsignedInt,
          )>>('newJObjectFinalizableHandle');
  late final _newJObjectFinalizableHandle = _newJObjectFinalizableHandlePtr
      .asFunction<Dart_FinalizableHandle Function(Object, JObjectPtr, int)>();

  Dart_FinalizableHandle newBooleanFinalizableHandle(
    Object object,
    ffi.Pointer<ffi.Bool> reference,
  ) {
    return _newBooleanFinalizableHandle(object, reference);
  }

  late final _newBooleanFinalizableHandlePtr = _lookup<
      ffi.NativeFunction<
          Dart_FinalizableHandle Function(ffi.Handle,
              ffi.Pointer<ffi.Bool>)>>('newBooleanFinalizableHandle');
  late final _newBooleanFinalizableHandle =
      _newBooleanFinalizableHandlePtr.asFunction<
          Dart_FinalizableHandle Function(Object, ffi.Pointer<ffi.Bool>)>();

  void deleteFinalizableHandle(
    Dart_FinalizableHandle finalizableHandle,
    Object object,
  ) {
    return _deleteFinalizableHandle(finalizableHandle, object);
  }

  late final _deleteFinalizableHandlePtr = _lookup<
      ffi.NativeFunction<
          ffi.Void Function(
              Dart_FinalizableHandle, ffi.Handle)>>('deleteFinalizableHandle');
  late final _deleteFinalizableHandle = _deleteFinalizableHandlePtr
      .asFunction<void Function(Dart_FinalizableHandle, Object)>();

  ffi.Pointer<GlobalJniEnvStruct> GetGlobalEnv() {
    return _GetGlobalEnv();
  }

  late final _GetGlobalEnvPtr =
      _lookup<ffi.NativeFunction<ffi.Pointer<GlobalJniEnvStruct> Function()>>(
    'GetGlobalEnv',
  );
  late final _GetGlobalEnv =
      _GetGlobalEnvPtr.asFunction<ffi.Pointer<GlobalJniEnvStruct> Function()>();
}

enum JniBooleanValues {
  FALSE(0),
  TRUE(1);

  final int value;
  const JniBooleanValues(this.value);

  static JniBooleanValues fromValue(int value) => switch (value) {
        0 => FALSE,
        1 => TRUE,
        _ => throw ArgumentError('Unknown value for JniBooleanValues: $value'),
      };
}

enum JniVersions {
  VERSION_1_1(65537),
  VERSION_1_2(65538),
  VERSION_1_4(65540),
  VERSION_1_6(65542);

  final int value;
  const JniVersions(this.value);

  static JniVersions fromValue(int value) => switch (value) {
        65537 => VERSION_1_1,
        65538 => VERSION_1_2,
        65540 => VERSION_1_4,
        65542 => VERSION_1_6,
        _ => throw ArgumentError('Unknown value for JniVersions: $value'),
      };
}

enum JniErrorCode {
  /// no error
  OK(0),

  /// generic error
  ERR(-1),

  /// thread detached from the VM
  EDETACHED(-2),

  /// JNI version error
  EVERSION(-3),

  /// Out of memory
  ENOMEM(-4),

  /// VM already created
  EEXIST(-5),

  /// Invalid argument
  EINVAL(-6),
  SINGLETON_EXISTS(-99);

  final int value;
  const JniErrorCode(this.value);

  static JniErrorCode fromValue(int value) => switch (value) {
        0 => OK,
        -1 => ERR,
        -2 => EDETACHED,
        -3 => EVERSION,
        -4 => ENOMEM,
        -5 => EEXIST,
        -6 => EINVAL,
        -99 => SINGLETON_EXISTS,
        _ => throw ArgumentError('Unknown value for JniErrorCode: $value'),
      };
}

enum JniBufferWriteBack {
  /// copy content, do not free buffer
  COMMIT(1),

  /// free buffer w/o copying back
  ABORT(2);

  final int value;
  const JniBufferWriteBack(this.value);

  static JniBufferWriteBack fromValue(int value) => switch (value) {
        1 => COMMIT,
        2 => ABORT,
        _ =>
          throw ArgumentError('Unknown value for JniBufferWriteBack: $value'),
      };
}

final class _opaque_pthread_mutex_t extends ffi.Struct {
  @ffi.Long()
  external int __sig;

  @ffi.Array.multi([56])
  external ffi.Array<ffi.Char> __opaque;
}

typedef __darwin_pthread_mutex_t = _opaque_pthread_mutex_t;
typedef pthread_mutex_t = __darwin_pthread_mutex_t;
typedef MutexLock = pthread_mutex_t;

final class _opaque_pthread_cond_t extends ffi.Struct {
  @ffi.Long()
  external int __sig;

  @ffi.Array.multi([40])
  external ffi.Array<ffi.Char> __opaque;
}

typedef __darwin_pthread_cond_t = _opaque_pthread_cond_t;
typedef pthread_cond_t = __darwin_pthread_cond_t;
typedef ConditionVariable = pthread_cond_t;

/// Reference types, in C.
typedef JObjectPtr = ffi.Pointer<ffi.Void>;

final class CallbackResult extends ffi.Struct {
  external MutexLock lock;

  external ConditionVariable cond;

  @ffi.Int()
  external int ready;

  external JObjectPtr object;
}

typedef __darwin_pthread_key_t = ffi.UnsignedLong;
typedef Dart__darwin_pthread_key_t = int;
typedef pthread_key_t = __darwin_pthread_key_t;

/// Types used by JNI API to distinguish between primitive types.
enum JniCallType {
  booleanType(0),
  byteType(1),
  shortType(2),
  charType(3),
  intType(4),
  longType(5),
  floatType(6),
  doubleType(7),
  objectType(8),
  voidType(9);

  final int value;
  const JniCallType(this.value);

  static JniCallType fromValue(int value) => switch (value) {
        0 => booleanType,
        1 => byteType,
        2 => shortType,
        3 => charType,
        4 => intType,
        5 => longType,
        6 => floatType,
        7 => doubleType,
        8 => objectType,
        9 => voidType,
        _ => throw ArgumentError('Unknown value for JniCallType: $value'),
      };
}

/// Primitive types that match up with Java equivalents.
typedef JBooleanMarker = ffi.Uint8;
typedef DartJBooleanMarker = int;
typedef JByteMarker = ffi.Int8;
typedef DartJByteMarker = int;
typedef JCharMarker = ffi.Uint16;
typedef DartJCharMarker = int;
typedef JShortMarker = ffi.Int16;
typedef DartJShortMarker = int;
typedef JIntMarker = ffi.Int32;
typedef DartJIntMarker = int;
typedef JLongMarker = ffi.Int64;
typedef DartJLongMarker = int;
typedef JFloatMarker = ffi.Float;
typedef DartJFloatMarker = double;
typedef JDoubleMarker = ffi.Double;
typedef DartJDoubleMarker = double;

final class JValue extends ffi.Union {
  @JBooleanMarker()
  external int z;

  @JByteMarker()
  external int b;

  @JCharMarker()
  external int c;

  @JShortMarker()
  external int s;

  @JIntMarker()
  external int i;

  @JLongMarker()
  external int j;

  @JFloatMarker()
  external double f;

  @JDoubleMarker()
  external double d;

  external JObjectPtr l;
}

typedef JThrowablePtr = JObjectPtr;

/// Result type for use by JNI.
///
/// If [exception] is null, it means the result is valid.
/// It's assumed that the caller knows the expected type in [result].
final class JniResult extends ffi.Struct {
  external JValue value;

  external JThrowablePtr exception;
}

typedef JClassPtr = JObjectPtr;

/// Similar to [JniResult] but for class lookups.
final class JniClassLookupResult extends ffi.Struct {
  external JClassPtr value;

  external JThrowablePtr exception;
}

/// Similar to [JniResult] but for method/field ID lookups.
final class JniPointerResult extends ffi.Struct {
  external ffi.Pointer<ffi.Void> value;

  external JThrowablePtr exception;
}

typedef JStringPtr = JObjectPtr;

/// JniExceptionDetails holds 2 jstring objects, one is the result of
/// calling `toString` on exception object, other is stack trace;
final class JniExceptionDetails extends ffi.Struct {
  external JStringPtr message;

  external JStringPtr stacktrace;
}

typedef JavaVM = ffi.Pointer<JNIInvokeInterface>;
typedef JniEnv = ffi.Pointer<JNINativeInterface>;

/// "cardinal indices and sizes"
typedef JSizeMarker = JIntMarker;

final class jmethodID_ extends ffi.Opaque {}

typedef JMethodIDPtr = ffi.Pointer<jmethodID_>;

final class jfieldID_ extends ffi.Opaque {}

typedef JFieldIDPtr = ffi.Pointer<jfieldID_>;
typedef JArrayPtr = JObjectPtr;
typedef JObjectArrayPtr = JArrayPtr;
typedef JBooleanArrayPtr = JArrayPtr;
typedef JByteArrayPtr = JArrayPtr;
typedef JCharArrayPtr = JArrayPtr;
typedef JShortArrayPtr = JArrayPtr;
typedef JIntArrayPtr = JArrayPtr;
typedef JLongArrayPtr = JArrayPtr;
typedef JFloatArrayPtr = JArrayPtr;
typedef JDoubleArrayPtr = JArrayPtr;

final class JNINativeMethod extends ffi.Struct {
  external ffi.Pointer<ffi.Char> name;

  external ffi.Pointer<ffi.Char> signature;

  external ffi.Pointer<ffi.Void> fnPtr;
}

typedef JWeakPtr = JObjectPtr;

enum JObjectRefType {
  JNIInvalidRefType(0),
  JNILocalRefType(1),
  JNIGlobalRefType(2),
  JNIWeakGlobalRefType(3);

  final int value;
  const JObjectRefType(this.value);

  static JObjectRefType fromValue(int value) => switch (value) {
        0 => JNIInvalidRefType,
        1 => JNILocalRefType,
        2 => JNIGlobalRefType,
        3 => JNIWeakGlobalRefType,
        _ => throw ArgumentError('Unknown value for JObjectRefType: $value'),
      };
}

/// Table of interface function pointers.
final class JNINativeInterface extends ffi.Struct {
  external ffi.Pointer<ffi.Void> reserved0;

  external ffi.Pointer<ffi.Void> reserved1;

  external ffi.Pointer<ffi.Void> reserved2;

  external ffi.Pointer<ffi.Void> reserved3;

  external ffi
      .Pointer<ffi.NativeFunction<JIntMarker Function(ffi.Pointer<JniEnv> env)>>
      GetVersion;

  external ffi.Pointer<
      ffi.NativeFunction<
          JClassPtr Function(
            ffi.Pointer<JniEnv> env,
            ffi.Pointer<ffi.Char> name,
            JObjectPtr loader,
            ffi.Pointer<JByteMarker> buf,
            JSizeMarker bufLen,
          )>> DefineClass;

  external ffi.Pointer<
      ffi.NativeFunction<
          JClassPtr Function(
              ffi.Pointer<JniEnv> env, ffi.Pointer<ffi.Char> name)>> FindClass;

  external ffi.Pointer<
      ffi.NativeFunction<
          JMethodIDPtr Function(
              ffi.Pointer<JniEnv> env, JObjectPtr method)>> FromReflectedMethod;

  external ffi.Pointer<
          ffi.NativeFunction<
              JFieldIDPtr Function(ffi.Pointer<JniEnv> env, JObjectPtr field)>>
      FromReflectedField;

  /// spec doesn't show jboolean parameter
  external ffi.Pointer<
      ffi.NativeFunction<
          JObjectPtr Function(
            ffi.Pointer<JniEnv> env,
            JClassPtr cls,
            JMethodIDPtr methodId,
            JBooleanMarker isStatic,
          )>> ToReflectedMethod;

  external ffi.Pointer<
          ffi.NativeFunction<
              JClassPtr Function(ffi.Pointer<JniEnv> env, JClassPtr clazz)>>
      GetSuperclass;

  external ffi.Pointer<
      ffi.NativeFunction<
          JBooleanMarker Function(
            ffi.Pointer<JniEnv> env,
            JClassPtr clazz1,
            JClassPtr clazz2,
          )>> IsAssignableFrom;

  /// spec doesn't show jboolean parameter
  external ffi.Pointer<
      ffi.NativeFunction<
          JObjectPtr Function(
            ffi.Pointer<JniEnv> env,
            JClassPtr cls,
            JFieldIDPtr fieldID,
            JBooleanMarker isStatic,
          )>> ToReflectedField;

  external ffi.Pointer<
          ffi.NativeFunction<
              JIntMarker Function(ffi.Pointer<JniEnv> env, JThrowablePtr obj)>>
      Throw;

  external ffi.Pointer<
      ffi.NativeFunction<
          JIntMarker Function(
            ffi.Pointer<JniEnv> env,
            JClassPtr clazz,
            ffi.Pointer<ffi.Char> message,
          )>> ThrowNew;

  external ffi.Pointer<
          ffi.NativeFunction<JThrowablePtr Function(ffi.Pointer<JniEnv> env)>>
      ExceptionOccurred;

  external ffi
      .Pointer<ffi.NativeFunction<ffi.Void Function(ffi.Pointer<JniEnv> env)>>
      ExceptionDescribe;

  external ffi
      .Pointer<ffi.NativeFunction<ffi.Void Function(ffi.Pointer<JniEnv> env)>>
      ExceptionClear;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
              ffi.Pointer<JniEnv> env, ffi.Pointer<ffi.Char> msg)>> FatalError;

  external ffi.Pointer<
      ffi.NativeFunction<
          JIntMarker Function(
              ffi.Pointer<JniEnv> env, JIntMarker capacity)>> PushLocalFrame;

  external ffi.Pointer<
          ffi.NativeFunction<
              JObjectPtr Function(ffi.Pointer<JniEnv> env, JObjectPtr result)>>
      PopLocalFrame;

  external ffi.Pointer<
          ffi.NativeFunction<
              JObjectPtr Function(ffi.Pointer<JniEnv> env, JObjectPtr obj)>>
      NewGlobalRef;

  external ffi.Pointer<
          ffi.NativeFunction<
              ffi.Void Function(ffi.Pointer<JniEnv> env, JObjectPtr globalRef)>>
      DeleteGlobalRef;

  external ffi.Pointer<
          ffi.NativeFunction<
              ffi.Void Function(ffi.Pointer<JniEnv> env, JObjectPtr localRef)>>
      DeleteLocalRef;

  external ffi.Pointer<
      ffi.NativeFunction<
          JBooleanMarker Function(
            ffi.Pointer<JniEnv> env,
            JObjectPtr ref1,
            JObjectPtr ref2,
          )>> IsSameObject;

  external ffi.Pointer<
          ffi.NativeFunction<
              JObjectPtr Function(ffi.Pointer<JniEnv> env, JObjectPtr obj)>>
      NewLocalRef;

  external ffi.Pointer<
          ffi.NativeFunction<
              JIntMarker Function(
                  ffi.Pointer<JniEnv> env, JIntMarker capacity)>>
      EnsureLocalCapacity;

  external ffi.Pointer<
          ffi.NativeFunction<
              JObjectPtr Function(ffi.Pointer<JniEnv> env, JClassPtr clazz)>>
      AllocObject;

  external ffi.Pointer<
      ffi.NativeFunction<
          JObjectPtr Function(
            ffi.Pointer<JniEnv> env,
            JClassPtr clazz,
            JMethodIDPtr methodID,
          )>> NewObject;

  external ffi.Pointer<
      ffi.NativeFunction<
          JObjectPtr Function(
            ffi.Pointer<JniEnv>,
            JClassPtr,
            JMethodIDPtr,
            ffi.Pointer<ffi.Void>,
          )>> NewObjectV;

  external ffi.Pointer<
      ffi.NativeFunction<
          JObjectPtr Function(
            ffi.Pointer<JniEnv> env,
            JClassPtr clazz,
            JMethodIDPtr methodID,
            ffi.Pointer<JValue> args,
          )>> NewObjectA;

  external ffi.Pointer<
          ffi.NativeFunction<
              JClassPtr Function(ffi.Pointer<JniEnv> env, JObjectPtr obj)>>
      GetObjectClass;

  external ffi.Pointer<
      ffi.NativeFunction<
          JBooleanMarker Function(
            ffi.Pointer<JniEnv> env,
            JObjectPtr obj,
            JClassPtr clazz,
          )>> IsInstanceOf;

  external ffi.Pointer<
      ffi.NativeFunction<
          JMethodIDPtr Function(
            ffi.Pointer<JniEnv> env,
            JClassPtr clazz,
            ffi.Pointer<ffi.Char> name,
            ffi.Pointer<ffi.Char> sig,
          )>> GetMethodID;

  external ffi.Pointer<
      ffi.NativeFunction<
          JObjectPtr Function(
            ffi.Pointer<JniEnv> env,
            JObjectPtr obj,
            JMethodIDPtr methodID,
          )>> CallObjectMethod;

  external ffi.Pointer<
      ffi.NativeFunction<
          JObjectPtr Function(
            ffi.Pointer<JniEnv>,
            JObjectPtr,
            JMethodIDPtr,
            ffi.Pointer<ffi.Void>,
          )>> CallObjectMethodV;

  external ffi.Pointer<
      ffi.NativeFunction<
          JObjectPtr Function(
            ffi.Pointer<JniEnv> env,
            JObjectPtr obj,
            JMethodIDPtr methodID,
            ffi.Pointer<JValue> args,
          )>> CallObjectMethodA;

  external ffi.Pointer<
      ffi.NativeFunction<
          JBooleanMarker Function(
            ffi.Pointer<JniEnv> env,
            JObjectPtr obj,
            JMethodIDPtr methodID,
          )>> CallBooleanMethod;

  external ffi.Pointer<
      ffi.NativeFunction<
          JBooleanMarker Function(
            ffi.Pointer<JniEnv>,
            JObjectPtr,
            JMethodIDPtr,
            ffi.Pointer<ffi.Void>,
          )>> CallBooleanMethodV;

  external ffi.Pointer<
      ffi.NativeFunction<
          JBooleanMarker Function(
            ffi.Pointer<JniEnv> env,
            JObjectPtr obj,
            JMethodIDPtr methodId,
            ffi.Pointer<JValue> args,
          )>> CallBooleanMethodA;

  external ffi.Pointer<
      ffi.NativeFunction<
          JByteMarker Function(
            ffi.Pointer<JniEnv> env,
            JObjectPtr obj,
            JMethodIDPtr methodID,
          )>> CallByteMethod;

  external ffi.Pointer<
      ffi.NativeFunction<
          JByteMarker Function(
            ffi.Pointer<JniEnv>,
            JObjectPtr,
            JMethodIDPtr,
            ffi.Pointer<ffi.Void>,
          )>> CallByteMethodV;

  external ffi.Pointer<
      ffi.NativeFunction<
          JByteMarker Function(
            ffi.Pointer<JniEnv> env,
            JObjectPtr obj,
            JMethodIDPtr methodID,
            ffi.Pointer<JValue> args,
          )>> CallByteMethodA;

  external ffi.Pointer<
      ffi.NativeFunction<
          JCharMarker Function(
            ffi.Pointer<JniEnv> env,
            JObjectPtr obj,
            JMethodIDPtr methodID,
          )>> CallCharMethod;

  external ffi.Pointer<
      ffi.NativeFunction<
          JCharMarker Function(
            ffi.Pointer<JniEnv>,
            JObjectPtr,
            JMethodIDPtr,
            ffi.Pointer<ffi.Void>,
          )>> CallCharMethodV;

  external ffi.Pointer<
      ffi.NativeFunction<
          JCharMarker Function(
            ffi.Pointer<JniEnv> env,
            JObjectPtr obj,
            JMethodIDPtr methodID,
            ffi.Pointer<JValue> args,
          )>> CallCharMethodA;

  external ffi.Pointer<
      ffi.NativeFunction<
          JShortMarker Function(
            ffi.Pointer<JniEnv> env,
            JObjectPtr obj,
            JMethodIDPtr methodID,
          )>> CallShortMethod;

  external ffi.Pointer<
      ffi.NativeFunction<
          JShortMarker Function(
            ffi.Pointer<JniEnv>,
            JObjectPtr,
            JMethodIDPtr,
            ffi.Pointer<ffi.Void>,
          )>> CallShortMethodV;

  external ffi.Pointer<
      ffi.NativeFunction<
          JShortMarker Function(
            ffi.Pointer<JniEnv> env,
            JObjectPtr obj,
            JMethodIDPtr methodID,
            ffi.Pointer<JValue> args,
          )>> CallShortMethodA;

  external ffi.Pointer<
      ffi.NativeFunction<
          JIntMarker Function(
            ffi.Pointer<JniEnv> env,
            JObjectPtr obj,
            JMethodIDPtr methodID,
          )>> CallIntMethod;

  external ffi.Pointer<
      ffi.NativeFunction<
          JIntMarker Function(
            ffi.Pointer<JniEnv>,
            JObjectPtr,
            JMethodIDPtr,
            ffi.Pointer<ffi.Void>,
          )>> CallIntMethodV;

  external ffi.Pointer<
      ffi.NativeFunction<
          JIntMarker Function(
            ffi.Pointer<JniEnv> env,
            JObjectPtr obj,
            JMethodIDPtr methodID,
            ffi.Pointer<JValue> args,
          )>> CallIntMethodA;

  external ffi.Pointer<
      ffi.NativeFunction<
          JLongMarker Function(
            ffi.Pointer<JniEnv> env,
            JObjectPtr obj,
            JMethodIDPtr methodID,
          )>> CallLongMethod;

  external ffi.Pointer<
      ffi.NativeFunction<
          JLongMarker Function(
            ffi.Pointer<JniEnv>,
            JObjectPtr,
            JMethodIDPtr,
            ffi.Pointer<ffi.Void>,
          )>> CallLongMethodV;

  external ffi.Pointer<
      ffi.NativeFunction<
          JLongMarker Function(
            ffi.Pointer<JniEnv> env,
            JObjectPtr obj,
            JMethodIDPtr methodID,
            ffi.Pointer<JValue> args,
          )>> CallLongMethodA;

  external ffi.Pointer<
      ffi.NativeFunction<
          JFloatMarker Function(
            ffi.Pointer<JniEnv> env,
            JObjectPtr obj,
            JMethodIDPtr methodID,
          )>> CallFloatMethod;

  external ffi.Pointer<
      ffi.NativeFunction<
          JFloatMarker Function(
            ffi.Pointer<JniEnv>,
            JObjectPtr,
            JMethodIDPtr,
            ffi.Pointer<ffi.Void>,
          )>> CallFloatMethodV;

  external ffi.Pointer<
      ffi.NativeFunction<
          JFloatMarker Function(
            ffi.Pointer<JniEnv> env,
            JObjectPtr obj,
            JMethodIDPtr methodID,
            ffi.Pointer<JValue> args,
          )>> CallFloatMethodA;

  external ffi.Pointer<
      ffi.NativeFunction<
          JDoubleMarker Function(
            ffi.Pointer<JniEnv> env,
            JObjectPtr obj,
            JMethodIDPtr methodID,
          )>> CallDoubleMethod;

  external ffi.Pointer<
      ffi.NativeFunction<
          JDoubleMarker Function(
            ffi.Pointer<JniEnv>,
            JObjectPtr,
            JMethodIDPtr,
            ffi.Pointer<ffi.Void>,
          )>> CallDoubleMethodV;

  external ffi.Pointer<
      ffi.NativeFunction<
          JDoubleMarker Function(
            ffi.Pointer<JniEnv> env,
            JObjectPtr obj,
            JMethodIDPtr methodID,
            ffi.Pointer<JValue> args,
          )>> CallDoubleMethodA;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Pointer<JniEnv> env,
            JObjectPtr obj,
            JMethodIDPtr methodID,
          )>> CallVoidMethod;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Pointer<JniEnv>,
            JObjectPtr,
            JMethodIDPtr,
            ffi.Pointer<ffi.Void>,
          )>> CallVoidMethodV;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Pointer<JniEnv> env,
            JObjectPtr obj,
            JMethodIDPtr methodID,
            ffi.Pointer<JValue> args,
          )>> CallVoidMethodA;

  external ffi.Pointer<
      ffi.NativeFunction<
          JObjectPtr Function(
            ffi.Pointer<JniEnv> env,
            JObjectPtr obj,
            JClassPtr clazz,
            JMethodIDPtr methodID,
          )>> CallNonvirtualObjectMethod;

  external ffi.Pointer<
      ffi.NativeFunction<
          JObjectPtr Function(
            ffi.Pointer<JniEnv>,
            JObjectPtr,
            JClassPtr,
            JMethodIDPtr,
            ffi.Pointer<ffi.Void>,
          )>> CallNonvirtualObjectMethodV;

  external ffi.Pointer<
      ffi.NativeFunction<
          JObjectPtr Function(
            ffi.Pointer<JniEnv> env,
            JObjectPtr obj,
            JClassPtr clazz,
            JMethodIDPtr methodID,
            ffi.Pointer<JValue> args,
          )>> CallNonvirtualObjectMethodA;

  external ffi.Pointer<
      ffi.NativeFunction<
          JBooleanMarker Function(
            ffi.Pointer<JniEnv> env,
            JObjectPtr obj,
            JClassPtr clazz,
            JMethodIDPtr methodID,
          )>> CallNonvirtualBooleanMethod;

  external ffi.Pointer<
      ffi.NativeFunction<
          JBooleanMarker Function(
            ffi.Pointer<JniEnv>,
            JObjectPtr,
            JClassPtr,
            JMethodIDPtr,
            ffi.Pointer<ffi.Void>,
          )>> CallNonvirtualBooleanMethodV;

  external ffi.Pointer<
      ffi.NativeFunction<
          JBooleanMarker Function(
            ffi.Pointer<JniEnv> env,
            JObjectPtr obj,
            JClassPtr clazz,
            JMethodIDPtr methodID,
            ffi.Pointer<JValue> args,
          )>> CallNonvirtualBooleanMethodA;

  external ffi.Pointer<
      ffi.NativeFunction<
          JByteMarker Function(
            ffi.Pointer<JniEnv> env,
            JObjectPtr obj,
            JClassPtr clazz,
            JMethodIDPtr methodID,
          )>> CallNonvirtualByteMethod;

  external ffi.Pointer<
      ffi.NativeFunction<
          JByteMarker Function(
            ffi.Pointer<JniEnv>,
            JObjectPtr,
            JClassPtr,
            JMethodIDPtr,
            ffi.Pointer<ffi.Void>,
          )>> CallNonvirtualByteMethodV;

  external ffi.Pointer<
      ffi.NativeFunction<
          JByteMarker Function(
            ffi.Pointer<JniEnv> env,
            JObjectPtr obj,
            JClassPtr clazz,
            JMethodIDPtr methodID,
            ffi.Pointer<JValue> args,
          )>> CallNonvirtualByteMethodA;

  external ffi.Pointer<
      ffi.NativeFunction<
          JCharMarker Function(
            ffi.Pointer<JniEnv> env,
            JObjectPtr obj,
            JClassPtr clazz,
            JMethodIDPtr methodID,
          )>> CallNonvirtualCharMethod;

  external ffi.Pointer<
      ffi.NativeFunction<
          JCharMarker Function(
            ffi.Pointer<JniEnv>,
            JObjectPtr,
            JClassPtr,
            JMethodIDPtr,
            ffi.Pointer<ffi.Void>,
          )>> CallNonvirtualCharMethodV;

  external ffi.Pointer<
      ffi.NativeFunction<
          JCharMarker Function(
            ffi.Pointer<JniEnv> env,
            JObjectPtr obj,
            JClassPtr clazz,
            JMethodIDPtr methodID,
            ffi.Pointer<JValue> args,
          )>> CallNonvirtualCharMethodA;

  external ffi.Pointer<
      ffi.NativeFunction<
          JShortMarker Function(
            ffi.Pointer<JniEnv> env,
            JObjectPtr obj,
            JClassPtr clazz,
            JMethodIDPtr methodID,
          )>> CallNonvirtualShortMethod;

  external ffi.Pointer<
      ffi.NativeFunction<
          JShortMarker Function(
            ffi.Pointer<JniEnv>,
            JObjectPtr,
            JClassPtr,
            JMethodIDPtr,
            ffi.Pointer<ffi.Void>,
          )>> CallNonvirtualShortMethodV;

  external ffi.Pointer<
      ffi.NativeFunction<
          JShortMarker Function(
            ffi.Pointer<JniEnv> env,
            JObjectPtr obj,
            JClassPtr clazz,
            JMethodIDPtr methodID,
            ffi.Pointer<JValue> args,
          )>> CallNonvirtualShortMethodA;

  external ffi.Pointer<
      ffi.NativeFunction<
          JIntMarker Function(
            ffi.Pointer<JniEnv> env,
            JObjectPtr obj,
            JClassPtr clazz,
            JMethodIDPtr methodID,
          )>> CallNonvirtualIntMethod;

  external ffi.Pointer<
      ffi.NativeFunction<
          JIntMarker Function(
            ffi.Pointer<JniEnv>,
            JObjectPtr,
            JClassPtr,
            JMethodIDPtr,
            ffi.Pointer<ffi.Void>,
          )>> CallNonvirtualIntMethodV;

  external ffi.Pointer<
      ffi.NativeFunction<
          JIntMarker Function(
            ffi.Pointer<JniEnv> env,
            JObjectPtr obj,
            JClassPtr clazz,
            JMethodIDPtr methodID,
            ffi.Pointer<JValue> args,
          )>> CallNonvirtualIntMethodA;

  external ffi.Pointer<
      ffi.NativeFunction<
          JLongMarker Function(
            ffi.Pointer<JniEnv> env,
            JObjectPtr obj,
            JClassPtr clazz,
            JMethodIDPtr methodID,
          )>> CallNonvirtualLongMethod;

  external ffi.Pointer<
      ffi.NativeFunction<
          JLongMarker Function(
            ffi.Pointer<JniEnv>,
            JObjectPtr,
            JClassPtr,
            JMethodIDPtr,
            ffi.Pointer<ffi.Void>,
          )>> CallNonvirtualLongMethodV;

  external ffi.Pointer<
      ffi.NativeFunction<
          JLongMarker Function(
            ffi.Pointer<JniEnv> env,
            JObjectPtr obj,
            JClassPtr clazz,
            JMethodIDPtr methodID,
            ffi.Pointer<JValue> args,
          )>> CallNonvirtualLongMethodA;

  external ffi.Pointer<
      ffi.NativeFunction<
          JFloatMarker Function(
            ffi.Pointer<JniEnv> env,
            JObjectPtr obj,
            JClassPtr clazz,
            JMethodIDPtr methodID,
          )>> CallNonvirtualFloatMethod;

  external ffi.Pointer<
      ffi.NativeFunction<
          JFloatMarker Function(
            ffi.Pointer<JniEnv>,
            JObjectPtr,
            JClassPtr,
            JMethodIDPtr,
            ffi.Pointer<ffi.Void>,
          )>> CallNonvirtualFloatMethodV;

  external ffi.Pointer<
      ffi.NativeFunction<
          JFloatMarker Function(
            ffi.Pointer<JniEnv> env,
            JObjectPtr obj,
            JClassPtr clazz,
            JMethodIDPtr methodID,
            ffi.Pointer<JValue> args,
          )>> CallNonvirtualFloatMethodA;

  external ffi.Pointer<
      ffi.NativeFunction<
          JDoubleMarker Function(
            ffi.Pointer<JniEnv> env,
            JObjectPtr obj,
            JClassPtr clazz,
            JMethodIDPtr methodID,
          )>> CallNonvirtualDoubleMethod;

  external ffi.Pointer<
      ffi.NativeFunction<
          JDoubleMarker Function(
            ffi.Pointer<JniEnv>,
            JObjectPtr,
            JClassPtr,
            JMethodIDPtr,
            ffi.Pointer<ffi.Void>,
          )>> CallNonvirtualDoubleMethodV;

  external ffi.Pointer<
      ffi.NativeFunction<
          JDoubleMarker Function(
            ffi.Pointer<JniEnv> env,
            JObjectPtr obj,
            JClassPtr clazz,
            JMethodIDPtr methodID,
            ffi.Pointer<JValue> args,
          )>> CallNonvirtualDoubleMethodA;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Pointer<JniEnv> env,
            JObjectPtr obj,
            JClassPtr clazz,
            JMethodIDPtr methodID,
          )>> CallNonvirtualVoidMethod;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Pointer<JniEnv>,
            JObjectPtr,
            JClassPtr,
            JMethodIDPtr,
            ffi.Pointer<ffi.Void>,
          )>> CallNonvirtualVoidMethodV;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Pointer<JniEnv> env,
            JObjectPtr obj,
            JClassPtr clazz,
            JMethodIDPtr methodID,
            ffi.Pointer<JValue> args,
          )>> CallNonvirtualVoidMethodA;

  external ffi.Pointer<
      ffi.NativeFunction<
          JFieldIDPtr Function(
            ffi.Pointer<JniEnv> env,
            JClassPtr clazz,
            ffi.Pointer<ffi.Char> name,
            ffi.Pointer<ffi.Char> sig,
          )>> GetFieldID;

  external ffi.Pointer<
      ffi.NativeFunction<
          JObjectPtr Function(
            ffi.Pointer<JniEnv> env,
            JObjectPtr obj,
            JFieldIDPtr fieldID,
          )>> GetObjectField;

  external ffi.Pointer<
      ffi.NativeFunction<
          JBooleanMarker Function(
            ffi.Pointer<JniEnv> env,
            JObjectPtr obj,
            JFieldIDPtr fieldID,
          )>> GetBooleanField;

  external ffi.Pointer<
      ffi.NativeFunction<
          JByteMarker Function(
            ffi.Pointer<JniEnv> env,
            JObjectPtr obj,
            JFieldIDPtr fieldID,
          )>> GetByteField;

  external ffi.Pointer<
      ffi.NativeFunction<
          JCharMarker Function(
            ffi.Pointer<JniEnv> env,
            JObjectPtr obj,
            JFieldIDPtr fieldID,
          )>> GetCharField;

  external ffi.Pointer<
      ffi.NativeFunction<
          JShortMarker Function(
            ffi.Pointer<JniEnv> env,
            JObjectPtr obj,
            JFieldIDPtr fieldID,
          )>> GetShortField;

  external ffi.Pointer<
      ffi.NativeFunction<
          JIntMarker Function(
            ffi.Pointer<JniEnv> env,
            JObjectPtr obj,
            JFieldIDPtr fieldID,
          )>> GetIntField;

  external ffi.Pointer<
      ffi.NativeFunction<
          JLongMarker Function(
            ffi.Pointer<JniEnv> env,
            JObjectPtr obj,
            JFieldIDPtr fieldID,
          )>> GetLongField;

  external ffi.Pointer<
      ffi.NativeFunction<
          JFloatMarker Function(
            ffi.Pointer<JniEnv> env,
            JObjectPtr obj,
            JFieldIDPtr fieldID,
          )>> GetFloatField;

  external ffi.Pointer<
      ffi.NativeFunction<
          JDoubleMarker Function(
            ffi.Pointer<JniEnv> env,
            JObjectPtr obj,
            JFieldIDPtr fieldID,
          )>> GetDoubleField;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Pointer<JniEnv> env,
            JObjectPtr obj,
            JFieldIDPtr fieldID,
            JObjectPtr val,
          )>> SetObjectField;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Pointer<JniEnv> env,
            JObjectPtr obj,
            JFieldIDPtr fieldID,
            JBooleanMarker val,
          )>> SetBooleanField;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Pointer<JniEnv> env,
            JObjectPtr obj,
            JFieldIDPtr fieldID,
            JByteMarker val,
          )>> SetByteField;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Pointer<JniEnv> env,
            JObjectPtr obj,
            JFieldIDPtr fieldID,
            JCharMarker val,
          )>> SetCharField;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Pointer<JniEnv> env,
            JObjectPtr obj,
            JFieldIDPtr fieldID,
            JShortMarker val,
          )>> SetShortField;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Pointer<JniEnv> env,
            JObjectPtr obj,
            JFieldIDPtr fieldID,
            JIntMarker val,
          )>> SetIntField;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Pointer<JniEnv> env,
            JObjectPtr obj,
            JFieldIDPtr fieldID,
            JLongMarker val,
          )>> SetLongField;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Pointer<JniEnv> env,
            JObjectPtr obj,
            JFieldIDPtr fieldID,
            JFloatMarker val,
          )>> SetFloatField;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Pointer<JniEnv> env,
            JObjectPtr obj,
            JFieldIDPtr fieldID,
            JDoubleMarker val,
          )>> SetDoubleField;

  external ffi.Pointer<
      ffi.NativeFunction<
          JMethodIDPtr Function(
            ffi.Pointer<JniEnv> env,
            JClassPtr clazz,
            ffi.Pointer<ffi.Char> name,
            ffi.Pointer<ffi.Char> sig,
          )>> GetStaticMethodID;

  external ffi.Pointer<
      ffi.NativeFunction<
          JObjectPtr Function(
            ffi.Pointer<JniEnv> env,
            JClassPtr clazz,
            JMethodIDPtr methodID,
          )>> CallStaticObjectMethod;

  external ffi.Pointer<
      ffi.NativeFunction<
          JObjectPtr Function(
            ffi.Pointer<JniEnv>,
            JClassPtr,
            JMethodIDPtr,
            ffi.Pointer<ffi.Void>,
          )>> CallStaticObjectMethodV;

  external ffi.Pointer<
      ffi.NativeFunction<
          JObjectPtr Function(
            ffi.Pointer<JniEnv> env,
            JClassPtr clazz,
            JMethodIDPtr methodID,
            ffi.Pointer<JValue> args,
          )>> CallStaticObjectMethodA;

  external ffi.Pointer<
      ffi.NativeFunction<
          JBooleanMarker Function(
            ffi.Pointer<JniEnv> env,
            JClassPtr clazz,
            JMethodIDPtr methodID,
          )>> CallStaticBooleanMethod;

  external ffi.Pointer<
      ffi.NativeFunction<
          JBooleanMarker Function(
            ffi.Pointer<JniEnv>,
            JClassPtr,
            JMethodIDPtr,
            ffi.Pointer<ffi.Void>,
          )>> CallStaticBooleanMethodV;

  external ffi.Pointer<
      ffi.NativeFunction<
          JBooleanMarker Function(
            ffi.Pointer<JniEnv> env,
            JClassPtr clazz,
            JMethodIDPtr methodID,
            ffi.Pointer<JValue> args,
          )>> CallStaticBooleanMethodA;

  external ffi.Pointer<
      ffi.NativeFunction<
          JByteMarker Function(
            ffi.Pointer<JniEnv> env,
            JClassPtr clazz,
            JMethodIDPtr methodID,
          )>> CallStaticByteMethod;

  external ffi.Pointer<
      ffi.NativeFunction<
          JByteMarker Function(
            ffi.Pointer<JniEnv>,
            JClassPtr,
            JMethodIDPtr,
            ffi.Pointer<ffi.Void>,
          )>> CallStaticByteMethodV;

  external ffi.Pointer<
      ffi.NativeFunction<
          JByteMarker Function(
            ffi.Pointer<JniEnv> env,
            JClassPtr clazz,
            JMethodIDPtr methodID,
            ffi.Pointer<JValue> args,
          )>> CallStaticByteMethodA;

  external ffi.Pointer<
      ffi.NativeFunction<
          JCharMarker Function(
            ffi.Pointer<JniEnv> env,
            JClassPtr clazz,
            JMethodIDPtr methodID,
          )>> CallStaticCharMethod;

  external ffi.Pointer<
      ffi.NativeFunction<
          JCharMarker Function(
            ffi.Pointer<JniEnv>,
            JClassPtr,
            JMethodIDPtr,
            ffi.Pointer<ffi.Void>,
          )>> CallStaticCharMethodV;

  external ffi.Pointer<
      ffi.NativeFunction<
          JCharMarker Function(
            ffi.Pointer<JniEnv> env,
            JClassPtr clazz,
            JMethodIDPtr methodID,
            ffi.Pointer<JValue> args,
          )>> CallStaticCharMethodA;

  external ffi.Pointer<
      ffi.NativeFunction<
          JShortMarker Function(
            ffi.Pointer<JniEnv> env,
            JClassPtr clazz,
            JMethodIDPtr methodID,
          )>> CallStaticShortMethod;

  external ffi.Pointer<
      ffi.NativeFunction<
          JShortMarker Function(
            ffi.Pointer<JniEnv>,
            JClassPtr,
            JMethodIDPtr,
            ffi.Pointer<ffi.Void>,
          )>> CallStaticShortMethodV;

  external ffi.Pointer<
      ffi.NativeFunction<
          JShortMarker Function(
            ffi.Pointer<JniEnv> env,
            JClassPtr clazz,
            JMethodIDPtr methodID,
            ffi.Pointer<JValue> args,
          )>> CallStaticShortMethodA;

  external ffi.Pointer<
      ffi.NativeFunction<
          JIntMarker Function(
            ffi.Pointer<JniEnv> env,
            JClassPtr clazz,
            JMethodIDPtr methodID,
          )>> CallStaticIntMethod;

  external ffi.Pointer<
      ffi.NativeFunction<
          JIntMarker Function(
            ffi.Pointer<JniEnv>,
            JClassPtr,
            JMethodIDPtr,
            ffi.Pointer<ffi.Void>,
          )>> CallStaticIntMethodV;

  external ffi.Pointer<
      ffi.NativeFunction<
          JIntMarker Function(
            ffi.Pointer<JniEnv> env,
            JClassPtr clazz,
            JMethodIDPtr methodID,
            ffi.Pointer<JValue> args,
          )>> CallStaticIntMethodA;

  external ffi.Pointer<
      ffi.NativeFunction<
          JLongMarker Function(
            ffi.Pointer<JniEnv> env,
            JClassPtr clazz,
            JMethodIDPtr methodID,
          )>> CallStaticLongMethod;

  external ffi.Pointer<
      ffi.NativeFunction<
          JLongMarker Function(
            ffi.Pointer<JniEnv>,
            JClassPtr,
            JMethodIDPtr,
            ffi.Pointer<ffi.Void>,
          )>> CallStaticLongMethodV;

  external ffi.Pointer<
      ffi.NativeFunction<
          JLongMarker Function(
            ffi.Pointer<JniEnv> env,
            JClassPtr clazz,
            JMethodIDPtr methodID,
            ffi.Pointer<JValue> args,
          )>> CallStaticLongMethodA;

  external ffi.Pointer<
      ffi.NativeFunction<
          JFloatMarker Function(
            ffi.Pointer<JniEnv> env,
            JClassPtr clazz,
            JMethodIDPtr methodID,
          )>> CallStaticFloatMethod;

  external ffi.Pointer<
      ffi.NativeFunction<
          JFloatMarker Function(
            ffi.Pointer<JniEnv>,
            JClassPtr,
            JMethodIDPtr,
            ffi.Pointer<ffi.Void>,
          )>> CallStaticFloatMethodV;

  external ffi.Pointer<
      ffi.NativeFunction<
          JFloatMarker Function(
            ffi.Pointer<JniEnv> env,
            JClassPtr clazz,
            JMethodIDPtr methodID,
            ffi.Pointer<JValue> args,
          )>> CallStaticFloatMethodA;

  external ffi.Pointer<
      ffi.NativeFunction<
          JDoubleMarker Function(
            ffi.Pointer<JniEnv> env,
            JClassPtr clazz,
            JMethodIDPtr methodID,
          )>> CallStaticDoubleMethod;

  external ffi.Pointer<
      ffi.NativeFunction<
          JDoubleMarker Function(
            ffi.Pointer<JniEnv>,
            JClassPtr,
            JMethodIDPtr,
            ffi.Pointer<ffi.Void>,
          )>> CallStaticDoubleMethodV;

  external ffi.Pointer<
      ffi.NativeFunction<
          JDoubleMarker Function(
            ffi.Pointer<JniEnv> env,
            JClassPtr clazz,
            JMethodIDPtr methodID,
            ffi.Pointer<JValue> args,
          )>> CallStaticDoubleMethodA;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Pointer<JniEnv> env,
            JClassPtr clazz,
            JMethodIDPtr methodID,
          )>> CallStaticVoidMethod;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Pointer<JniEnv>,
            JClassPtr,
            JMethodIDPtr,
            ffi.Pointer<ffi.Void>,
          )>> CallStaticVoidMethodV;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Pointer<JniEnv> env,
            JClassPtr clazz,
            JMethodIDPtr methodID,
            ffi.Pointer<JValue> args,
          )>> CallStaticVoidMethodA;

  external ffi.Pointer<
      ffi.NativeFunction<
          JFieldIDPtr Function(
            ffi.Pointer<JniEnv> env,
            JClassPtr clazz,
            ffi.Pointer<ffi.Char> name,
            ffi.Pointer<ffi.Char> sig,
          )>> GetStaticFieldID;

  external ffi.Pointer<
      ffi.NativeFunction<
          JObjectPtr Function(
            ffi.Pointer<JniEnv> env,
            JClassPtr clazz,
            JFieldIDPtr fieldID,
          )>> GetStaticObjectField;

  external ffi.Pointer<
      ffi.NativeFunction<
          JBooleanMarker Function(
            ffi.Pointer<JniEnv> env,
            JClassPtr clazz,
            JFieldIDPtr fieldID,
          )>> GetStaticBooleanField;

  external ffi.Pointer<
      ffi.NativeFunction<
          JByteMarker Function(
            ffi.Pointer<JniEnv> env,
            JClassPtr clazz,
            JFieldIDPtr fieldID,
          )>> GetStaticByteField;

  external ffi.Pointer<
      ffi.NativeFunction<
          JCharMarker Function(
            ffi.Pointer<JniEnv> env,
            JClassPtr clazz,
            JFieldIDPtr fieldID,
          )>> GetStaticCharField;

  external ffi.Pointer<
      ffi.NativeFunction<
          JShortMarker Function(
            ffi.Pointer<JniEnv> env,
            JClassPtr clazz,
            JFieldIDPtr fieldID,
          )>> GetStaticShortField;

  external ffi.Pointer<
      ffi.NativeFunction<
          JIntMarker Function(
            ffi.Pointer<JniEnv> env,
            JClassPtr clazz,
            JFieldIDPtr fieldID,
          )>> GetStaticIntField;

  external ffi.Pointer<
      ffi.NativeFunction<
          JLongMarker Function(
            ffi.Pointer<JniEnv> env,
            JClassPtr clazz,
            JFieldIDPtr fieldID,
          )>> GetStaticLongField;

  external ffi.Pointer<
      ffi.NativeFunction<
          JFloatMarker Function(
            ffi.Pointer<JniEnv> env,
            JClassPtr clazz,
            JFieldIDPtr fieldID,
          )>> GetStaticFloatField;

  external ffi.Pointer<
      ffi.NativeFunction<
          JDoubleMarker Function(
            ffi.Pointer<JniEnv> env,
            JClassPtr clazz,
            JFieldIDPtr fieldID,
          )>> GetStaticDoubleField;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Pointer<JniEnv> env,
            JClassPtr clazz,
            JFieldIDPtr fieldID,
            JObjectPtr val,
          )>> SetStaticObjectField;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Pointer<JniEnv> env,
            JClassPtr clazz,
            JFieldIDPtr fieldID,
            JBooleanMarker val,
          )>> SetStaticBooleanField;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Pointer<JniEnv> env,
            JClassPtr clazz,
            JFieldIDPtr fieldID,
            JByteMarker val,
          )>> SetStaticByteField;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Pointer<JniEnv> env,
            JClassPtr clazz,
            JFieldIDPtr fieldID,
            JCharMarker val,
          )>> SetStaticCharField;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Pointer<JniEnv> env,
            JClassPtr clazz,
            JFieldIDPtr fieldID,
            JShortMarker val,
          )>> SetStaticShortField;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Pointer<JniEnv> env,
            JClassPtr clazz,
            JFieldIDPtr fieldID,
            JIntMarker val,
          )>> SetStaticIntField;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Pointer<JniEnv> env,
            JClassPtr clazz,
            JFieldIDPtr fieldID,
            JLongMarker val,
          )>> SetStaticLongField;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Pointer<JniEnv> env,
            JClassPtr clazz,
            JFieldIDPtr fieldID,
            JFloatMarker val,
          )>> SetStaticFloatField;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Pointer<JniEnv> env,
            JClassPtr clazz,
            JFieldIDPtr fieldID,
            JDoubleMarker val,
          )>> SetStaticDoubleField;

  external ffi.Pointer<
      ffi.NativeFunction<
          JStringPtr Function(
            ffi.Pointer<JniEnv> env,
            ffi.Pointer<JCharMarker> unicodeChars,
            JSizeMarker len,
          )>> NewString;

  external ffi.Pointer<
          ffi.NativeFunction<
              JSizeMarker Function(ffi.Pointer<JniEnv> env, JStringPtr string)>>
      GetStringLength;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Pointer<JCharMarker> Function(
            ffi.Pointer<JniEnv> env,
            JStringPtr string,
            ffi.Pointer<JBooleanMarker> isCopy,
          )>> GetStringChars;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Pointer<JniEnv> env,
            JStringPtr string,
            ffi.Pointer<JCharMarker> isCopy,
          )>> ReleaseStringChars;

  external ffi.Pointer<
          ffi.NativeFunction<
              JStringPtr Function(
                  ffi.Pointer<JniEnv> env, ffi.Pointer<ffi.Char> bytes)>>
      NewStringUTF;

  external ffi.Pointer<
          ffi.NativeFunction<
              JSizeMarker Function(ffi.Pointer<JniEnv> env, JStringPtr string)>>
      GetStringUTFLength;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Pointer<ffi.Char> Function(
            ffi.Pointer<JniEnv> env,
            JStringPtr string,
            ffi.Pointer<JBooleanMarker> isCopy,
          )>> GetStringUTFChars;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Pointer<JniEnv> env,
            JStringPtr string,
            ffi.Pointer<ffi.Char> utf,
          )>> ReleaseStringUTFChars;

  external ffi.Pointer<
          ffi.NativeFunction<
              JSizeMarker Function(ffi.Pointer<JniEnv> env, JArrayPtr array)>>
      GetArrayLength;

  external ffi.Pointer<
      ffi.NativeFunction<
          JObjectArrayPtr Function(
            ffi.Pointer<JniEnv> env,
            JSizeMarker length,
            JClassPtr elementClass,
            JObjectPtr initialElement,
          )>> NewObjectArray;

  external ffi.Pointer<
      ffi.NativeFunction<
          JObjectPtr Function(
            ffi.Pointer<JniEnv> env,
            JObjectArrayPtr array,
            JSizeMarker index,
          )>> GetObjectArrayElement;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Pointer<JniEnv> env,
            JObjectArrayPtr array,
            JSizeMarker index,
            JObjectPtr val,
          )>> SetObjectArrayElement;

  external ffi.Pointer<
      ffi.NativeFunction<
          JBooleanArrayPtr Function(
              ffi.Pointer<JniEnv> env, JSizeMarker length)>> NewBooleanArray;

  external ffi.Pointer<
      ffi.NativeFunction<
          JByteArrayPtr Function(
              ffi.Pointer<JniEnv> env, JSizeMarker length)>> NewByteArray;

  external ffi.Pointer<
      ffi.NativeFunction<
          JCharArrayPtr Function(
              ffi.Pointer<JniEnv> env, JSizeMarker length)>> NewCharArray;

  external ffi.Pointer<
      ffi.NativeFunction<
          JShortArrayPtr Function(
              ffi.Pointer<JniEnv> env, JSizeMarker length)>> NewShortArray;

  external ffi.Pointer<
      ffi.NativeFunction<
          JIntArrayPtr Function(
              ffi.Pointer<JniEnv> env, JSizeMarker length)>> NewIntArray;

  external ffi.Pointer<
      ffi.NativeFunction<
          JLongArrayPtr Function(
              ffi.Pointer<JniEnv> env, JSizeMarker length)>> NewLongArray;

  external ffi.Pointer<
      ffi.NativeFunction<
          JFloatArrayPtr Function(
              ffi.Pointer<JniEnv> env, JSizeMarker length)>> NewFloatArray;

  external ffi.Pointer<
      ffi.NativeFunction<
          JDoubleArrayPtr Function(
              ffi.Pointer<JniEnv> env, JSizeMarker length)>> NewDoubleArray;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Pointer<JBooleanMarker> Function(
            ffi.Pointer<JniEnv> env,
            JBooleanArrayPtr array,
            ffi.Pointer<JBooleanMarker> isCopy,
          )>> GetBooleanArrayElements;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Pointer<JByteMarker> Function(
            ffi.Pointer<JniEnv> env,
            JByteArrayPtr array,
            ffi.Pointer<JBooleanMarker> isCopy,
          )>> GetByteArrayElements;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Pointer<JCharMarker> Function(
            ffi.Pointer<JniEnv> env,
            JCharArrayPtr array,
            ffi.Pointer<JBooleanMarker> isCopy,
          )>> GetCharArrayElements;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Pointer<JShortMarker> Function(
            ffi.Pointer<JniEnv> env,
            JShortArrayPtr array,
            ffi.Pointer<JBooleanMarker> isCopy,
          )>> GetShortArrayElements;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Pointer<JIntMarker> Function(
            ffi.Pointer<JniEnv> env,
            JIntArrayPtr array,
            ffi.Pointer<JBooleanMarker> isCopy,
          )>> GetIntArrayElements;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Pointer<JLongMarker> Function(
            ffi.Pointer<JniEnv> env,
            JLongArrayPtr array,
            ffi.Pointer<JBooleanMarker> isCopy,
          )>> GetLongArrayElements;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Pointer<JFloatMarker> Function(
            ffi.Pointer<JniEnv> env,
            JFloatArrayPtr array,
            ffi.Pointer<JBooleanMarker> isCopy,
          )>> GetFloatArrayElements;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Pointer<JDoubleMarker> Function(
            ffi.Pointer<JniEnv> env,
            JDoubleArrayPtr array,
            ffi.Pointer<JBooleanMarker> isCopy,
          )>> GetDoubleArrayElements;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Pointer<JniEnv> env,
            JBooleanArrayPtr array,
            ffi.Pointer<JBooleanMarker> elems,
            JIntMarker mode,
          )>> ReleaseBooleanArrayElements;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Pointer<JniEnv> env,
            JByteArrayPtr array,
            ffi.Pointer<JByteMarker> elems,
            JIntMarker mode,
          )>> ReleaseByteArrayElements;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Pointer<JniEnv> env,
            JCharArrayPtr array,
            ffi.Pointer<JCharMarker> elems,
            JIntMarker mode,
          )>> ReleaseCharArrayElements;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Pointer<JniEnv> env,
            JShortArrayPtr array,
            ffi.Pointer<JShortMarker> elems,
            JIntMarker mode,
          )>> ReleaseShortArrayElements;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Pointer<JniEnv> env,
            JIntArrayPtr array,
            ffi.Pointer<JIntMarker> elems,
            JIntMarker mode,
          )>> ReleaseIntArrayElements;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Pointer<JniEnv> env,
            JLongArrayPtr array,
            ffi.Pointer<JLongMarker> elems,
            JIntMarker mode,
          )>> ReleaseLongArrayElements;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Pointer<JniEnv> env,
            JFloatArrayPtr array,
            ffi.Pointer<JFloatMarker> elems,
            JIntMarker mode,
          )>> ReleaseFloatArrayElements;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Pointer<JniEnv> env,
            JDoubleArrayPtr array,
            ffi.Pointer<JDoubleMarker> elems,
            JIntMarker mode,
          )>> ReleaseDoubleArrayElements;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Pointer<JniEnv> env,
            JBooleanArrayPtr array,
            JSizeMarker start,
            JSizeMarker len,
            ffi.Pointer<JBooleanMarker> buf,
          )>> GetBooleanArrayRegion;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Pointer<JniEnv> env,
            JByteArrayPtr array,
            JSizeMarker start,
            JSizeMarker len,
            ffi.Pointer<JByteMarker> buf,
          )>> GetByteArrayRegion;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Pointer<JniEnv> env,
            JCharArrayPtr array,
            JSizeMarker start,
            JSizeMarker len,
            ffi.Pointer<JCharMarker> buf,
          )>> GetCharArrayRegion;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Pointer<JniEnv> env,
            JShortArrayPtr array,
            JSizeMarker start,
            JSizeMarker len,
            ffi.Pointer<JShortMarker> buf,
          )>> GetShortArrayRegion;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Pointer<JniEnv> env,
            JIntArrayPtr array,
            JSizeMarker start,
            JSizeMarker len,
            ffi.Pointer<JIntMarker> buf,
          )>> GetIntArrayRegion;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Pointer<JniEnv> env,
            JLongArrayPtr array,
            JSizeMarker start,
            JSizeMarker len,
            ffi.Pointer<JLongMarker> buf,
          )>> GetLongArrayRegion;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Pointer<JniEnv> env,
            JFloatArrayPtr array,
            JSizeMarker start,
            JSizeMarker len,
            ffi.Pointer<JFloatMarker> buf,
          )>> GetFloatArrayRegion;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Pointer<JniEnv> env,
            JDoubleArrayPtr array,
            JSizeMarker start,
            JSizeMarker len,
            ffi.Pointer<JDoubleMarker> buf,
          )>> GetDoubleArrayRegion;

  /// spec shows these without const; some jni.h do, some don't
  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Pointer<JniEnv> env,
            JBooleanArrayPtr array,
            JSizeMarker start,
            JSizeMarker len,
            ffi.Pointer<JBooleanMarker> buf,
          )>> SetBooleanArrayRegion;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Pointer<JniEnv> env,
            JByteArrayPtr array,
            JSizeMarker start,
            JSizeMarker len,
            ffi.Pointer<JByteMarker> buf,
          )>> SetByteArrayRegion;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Pointer<JniEnv> env,
            JCharArrayPtr array,
            JSizeMarker start,
            JSizeMarker len,
            ffi.Pointer<JCharMarker> buf,
          )>> SetCharArrayRegion;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Pointer<JniEnv> env,
            JShortArrayPtr array,
            JSizeMarker start,
            JSizeMarker len,
            ffi.Pointer<JShortMarker> buf,
          )>> SetShortArrayRegion;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Pointer<JniEnv> env,
            JIntArrayPtr array,
            JSizeMarker start,
            JSizeMarker len,
            ffi.Pointer<JIntMarker> buf,
          )>> SetIntArrayRegion;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Pointer<JniEnv> env,
            JLongArrayPtr array,
            JSizeMarker start,
            JSizeMarker len,
            ffi.Pointer<JLongMarker> buf,
          )>> SetLongArrayRegion;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Pointer<JniEnv> env,
            JFloatArrayPtr array,
            JSizeMarker start,
            JSizeMarker len,
            ffi.Pointer<JFloatMarker> buf,
          )>> SetFloatArrayRegion;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Pointer<JniEnv> env,
            JDoubleArrayPtr array,
            JSizeMarker start,
            JSizeMarker len,
            ffi.Pointer<JDoubleMarker> buf,
          )>> SetDoubleArrayRegion;

  external ffi.Pointer<
      ffi.NativeFunction<
          JIntMarker Function(
            ffi.Pointer<JniEnv> env,
            JClassPtr clazz,
            ffi.Pointer<JNINativeMethod> methods,
            JIntMarker nMethods,
          )>> RegisterNatives;

  external ffi.Pointer<
          ffi.NativeFunction<
              JIntMarker Function(ffi.Pointer<JniEnv> env, JClassPtr clazz)>>
      UnregisterNatives;

  external ffi.Pointer<
          ffi.NativeFunction<
              JIntMarker Function(ffi.Pointer<JniEnv> env, JObjectPtr obj)>>
      MonitorEnter;

  external ffi.Pointer<
          ffi.NativeFunction<
              JIntMarker Function(ffi.Pointer<JniEnv> env, JObjectPtr obj)>>
      MonitorExit;

  external ffi.Pointer<
      ffi.NativeFunction<
          JIntMarker Function(
            ffi.Pointer<JniEnv> env,
            ffi.Pointer<ffi.Pointer<JavaVM>> vm,
          )>> GetJavaVM;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Pointer<JniEnv> env,
            JStringPtr str,
            JSizeMarker start,
            JSizeMarker len,
            ffi.Pointer<JCharMarker> buf,
          )>> GetStringRegion;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Pointer<JniEnv> env,
            JStringPtr str,
            JSizeMarker start,
            JSizeMarker len,
            ffi.Pointer<ffi.Char> buf,
          )>> GetStringUTFRegion;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Pointer<ffi.Void> Function(
            ffi.Pointer<JniEnv> env,
            JArrayPtr array,
            ffi.Pointer<JBooleanMarker> isCopy,
          )>> GetPrimitiveArrayCritical;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Pointer<JniEnv> env,
            JArrayPtr array,
            ffi.Pointer<ffi.Void> carray,
            JIntMarker mode,
          )>> ReleasePrimitiveArrayCritical;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Pointer<JCharMarker> Function(
            ffi.Pointer<JniEnv> env,
            JStringPtr str,
            ffi.Pointer<JBooleanMarker> isCopy,
          )>> GetStringCritical;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Pointer<JniEnv> env,
            JStringPtr str,
            ffi.Pointer<JCharMarker> carray,
          )>> ReleaseStringCritical;

  external ffi.Pointer<
          ffi.NativeFunction<
              JWeakPtr Function(ffi.Pointer<JniEnv> env, JObjectPtr obj)>>
      NewWeakGlobalRef;

  external ffi.Pointer<
          ffi.NativeFunction<
              ffi.Void Function(ffi.Pointer<JniEnv> env, JWeakPtr obj)>>
      DeleteWeakGlobalRef;

  external ffi.Pointer<
          ffi.NativeFunction<JBooleanMarker Function(ffi.Pointer<JniEnv> env)>>
      ExceptionCheck;

  external ffi.Pointer<
      ffi.NativeFunction<
          JObjectPtr Function(
            ffi.Pointer<JniEnv> env,
            ffi.Pointer<ffi.Void> address,
            JLongMarker capacity,
          )>> NewDirectByteBuffer;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Pointer<ffi.Void> Function(
              ffi.Pointer<JniEnv> env, JObjectPtr buf)>> GetDirectBufferAddress;

  external ffi.Pointer<
          ffi.NativeFunction<
              JLongMarker Function(ffi.Pointer<JniEnv> env, JObjectPtr buf)>>
      GetDirectBufferCapacity;

  /// added in JNI 1.6
  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.UnsignedInt Function(
              ffi.Pointer<JniEnv> env, JObjectPtr obj)>> GetObjectRefType;
}

typedef JniEnv$1 = ffi.Pointer<JNINativeInterface>;

/// JNI invocation interface.
final class JNIInvokeInterface extends ffi.Struct {
  external ffi.Pointer<ffi.Void> reserved0;

  external ffi.Pointer<ffi.Void> reserved1;

  external ffi.Pointer<ffi.Void> reserved2;

  external ffi
      .Pointer<ffi.NativeFunction<JIntMarker Function(ffi.Pointer<JavaVM> vm)>>
      DestroyJavaVM;

  external ffi.Pointer<
      ffi.NativeFunction<
          JIntMarker Function(
            ffi.Pointer<JavaVM> vm,
            ffi.Pointer<ffi.Pointer<JniEnv$1>> p_env,
            ffi.Pointer<ffi.Void> thr_args,
          )>> AttachCurrentThread;

  external ffi
      .Pointer<ffi.NativeFunction<JIntMarker Function(ffi.Pointer<JavaVM> vm)>>
      DetachCurrentThread;

  external ffi.Pointer<
      ffi.NativeFunction<
          JIntMarker Function(
            ffi.Pointer<JavaVM> vm,
            ffi.Pointer<ffi.Pointer<ffi.Void>> p_env,
            JIntMarker version,
          )>> GetEnv;

  external ffi.Pointer<
      ffi.NativeFunction<
          JIntMarker Function(
            ffi.Pointer<JavaVM> vm,
            ffi.Pointer<ffi.Pointer<JniEnv$1>> p_env,
            ffi.Pointer<ffi.Void> thr_args,
          )>> AttachCurrentThreadAsDaemon;
}

typedef JavaVM$1 = ffi.Pointer<JNIInvokeInterface>;

/// JNI 1.2+ initialization.  (As of 1.6, the pre-1.2 structures are no
/// longer supported.)
final class JavaVMOption extends ffi.Struct {
  external ffi.Pointer<ffi.Char> optionString;

  external ffi.Pointer<ffi.Void> extraInfo;
}

final class JavaVMInitArgs extends ffi.Struct {
  /// use JNI_VERSION_1_2 or later
  @JIntMarker()
  external int version;

  @JIntMarker()
  external int nOptions;

  external ffi.Pointer<JavaVMOption> options;

  @JBooleanMarker()
  external int ignoreUnrecognized;
}

final class Dart_FinalizableHandle_ extends ffi.Opaque {}

typedef Dart_FinalizableHandle = ffi.Pointer<Dart_FinalizableHandle_>;

final class GlobalJniEnvStruct extends ffi.Struct {
  external ffi.Pointer<ffi.Void> reserved0;

  external ffi.Pointer<ffi.Void> reserved1;

  external ffi.Pointer<ffi.Void> reserved2;

  external ffi.Pointer<ffi.Void> reserved3;

  external ffi.Pointer<ffi.NativeFunction<JniResult Function()>> GetVersion;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniClassLookupResult Function(
            ffi.Pointer<ffi.Char> name,
            JObjectPtr loader,
            ffi.Pointer<JByteMarker> buf,
            JSizeMarker bufLen,
          )>> DefineClass;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniClassLookupResult Function(ffi.Pointer<ffi.Char> name)>> FindClass;

  external ffi
      .Pointer<ffi.NativeFunction<JniPointerResult Function(JObjectPtr method)>>
      FromReflectedMethod;

  external ffi
      .Pointer<ffi.NativeFunction<JniPointerResult Function(JObjectPtr field)>>
      FromReflectedField;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniResult Function(
            JClassPtr cls,
            JMethodIDPtr methodId,
            JBooleanMarker isStatic,
          )>> ToReflectedMethod;

  external ffi.Pointer<
          ffi.NativeFunction<JniClassLookupResult Function(JClassPtr clazz)>>
      GetSuperclass;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(JClassPtr clazz1, JClassPtr clazz2)>>
      IsAssignableFrom;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniResult Function(
            JClassPtr cls,
            JFieldIDPtr fieldID,
            JBooleanMarker isStatic,
          )>> ToReflectedField;

  external ffi
      .Pointer<ffi.NativeFunction<JniResult Function(JThrowablePtr obj)>> Throw;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniResult Function(
              JClassPtr clazz, ffi.Pointer<ffi.Char> message)>> ThrowNew;

  external ffi.Pointer<ffi.NativeFunction<JniResult Function()>>
      ExceptionOccurred;

  external ffi.Pointer<ffi.NativeFunction<JThrowablePtr Function()>>
      ExceptionDescribe;

  external ffi.Pointer<ffi.NativeFunction<JThrowablePtr Function()>>
      ExceptionClear;

  external ffi.Pointer<
          ffi.NativeFunction<JThrowablePtr Function(ffi.Pointer<ffi.Char> msg)>>
      FatalError;

  external ffi
      .Pointer<ffi.NativeFunction<JniResult Function(JIntMarker capacity)>>
      PushLocalFrame;

  external ffi
      .Pointer<ffi.NativeFunction<JniResult Function(JObjectPtr result)>>
      PopLocalFrame;

  external ffi.Pointer<ffi.NativeFunction<JniResult Function(JObjectPtr obj)>>
      NewGlobalRef;

  external ffi
      .Pointer<ffi.NativeFunction<JThrowablePtr Function(JObjectPtr globalRef)>>
      DeleteGlobalRef;

  external ffi
      .Pointer<ffi.NativeFunction<JThrowablePtr Function(JObjectPtr localRef)>>
      DeleteLocalRef;

  external ffi.Pointer<
          ffi
          .NativeFunction<JniResult Function(JObjectPtr ref1, JObjectPtr ref2)>>
      IsSameObject;

  external ffi.Pointer<ffi.NativeFunction<JniResult Function(JObjectPtr obj)>>
      NewLocalRef;

  external ffi
      .Pointer<ffi.NativeFunction<JniResult Function(JIntMarker capacity)>>
      EnsureLocalCapacity;

  external ffi.Pointer<ffi.NativeFunction<JniResult Function(JClassPtr clazz)>>
      AllocObject;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(JClassPtr clazz, JMethodIDPtr methodID)>>
      NewObject;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniResult Function(
              JClassPtr, JMethodIDPtr, ffi.Pointer<ffi.Void>)>> NewObjectV;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniResult Function(
            JClassPtr clazz,
            JMethodIDPtr methodID,
            ffi.Pointer<JValue> args,
          )>> NewObjectA;

  external ffi.Pointer<
          ffi.NativeFunction<JniClassLookupResult Function(JObjectPtr obj)>>
      GetObjectClass;

  external ffi.Pointer<
          ffi
          .NativeFunction<JniResult Function(JObjectPtr obj, JClassPtr clazz)>>
      IsInstanceOf;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniPointerResult Function(
            JClassPtr clazz,
            ffi.Pointer<ffi.Char> name,
            ffi.Pointer<ffi.Char> sig,
          )>> GetMethodID;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(JObjectPtr obj, JMethodIDPtr methodID)>>
      CallObjectMethod;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(
                  JObjectPtr, JMethodIDPtr, ffi.Pointer<ffi.Void>)>>
      CallObjectMethodV;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniResult Function(
            JObjectPtr obj,
            JMethodIDPtr methodID,
            ffi.Pointer<JValue> args,
          )>> CallObjectMethodA;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(JObjectPtr obj, JMethodIDPtr methodID)>>
      CallBooleanMethod;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(
                  JObjectPtr, JMethodIDPtr, ffi.Pointer<ffi.Void>)>>
      CallBooleanMethodV;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniResult Function(
            JObjectPtr obj,
            JMethodIDPtr methodId,
            ffi.Pointer<JValue> args,
          )>> CallBooleanMethodA;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(JObjectPtr obj, JMethodIDPtr methodID)>>
      CallByteMethod;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(
                  JObjectPtr, JMethodIDPtr, ffi.Pointer<ffi.Void>)>>
      CallByteMethodV;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniResult Function(
            JObjectPtr obj,
            JMethodIDPtr methodID,
            ffi.Pointer<JValue> args,
          )>> CallByteMethodA;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(JObjectPtr obj, JMethodIDPtr methodID)>>
      CallCharMethod;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(
                  JObjectPtr, JMethodIDPtr, ffi.Pointer<ffi.Void>)>>
      CallCharMethodV;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniResult Function(
            JObjectPtr obj,
            JMethodIDPtr methodID,
            ffi.Pointer<JValue> args,
          )>> CallCharMethodA;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(JObjectPtr obj, JMethodIDPtr methodID)>>
      CallShortMethod;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(
                  JObjectPtr, JMethodIDPtr, ffi.Pointer<ffi.Void>)>>
      CallShortMethodV;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniResult Function(
            JObjectPtr obj,
            JMethodIDPtr methodID,
            ffi.Pointer<JValue> args,
          )>> CallShortMethodA;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(JObjectPtr obj, JMethodIDPtr methodID)>>
      CallIntMethod;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniResult Function(
              JObjectPtr, JMethodIDPtr, ffi.Pointer<ffi.Void>)>> CallIntMethodV;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniResult Function(
            JObjectPtr obj,
            JMethodIDPtr methodID,
            ffi.Pointer<JValue> args,
          )>> CallIntMethodA;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(JObjectPtr obj, JMethodIDPtr methodID)>>
      CallLongMethod;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(
                  JObjectPtr, JMethodIDPtr, ffi.Pointer<ffi.Void>)>>
      CallLongMethodV;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniResult Function(
            JObjectPtr obj,
            JMethodIDPtr methodID,
            ffi.Pointer<JValue> args,
          )>> CallLongMethodA;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(JObjectPtr obj, JMethodIDPtr methodID)>>
      CallFloatMethod;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(
                  JObjectPtr, JMethodIDPtr, ffi.Pointer<ffi.Void>)>>
      CallFloatMethodV;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniResult Function(
            JObjectPtr obj,
            JMethodIDPtr methodID,
            ffi.Pointer<JValue> args,
          )>> CallFloatMethodA;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(JObjectPtr obj, JMethodIDPtr methodID)>>
      CallDoubleMethod;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(
                  JObjectPtr, JMethodIDPtr, ffi.Pointer<ffi.Void>)>>
      CallDoubleMethodV;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniResult Function(
            JObjectPtr obj,
            JMethodIDPtr methodID,
            ffi.Pointer<JValue> args,
          )>> CallDoubleMethodA;

  external ffi.Pointer<
          ffi.NativeFunction<
              JThrowablePtr Function(JObjectPtr obj, JMethodIDPtr methodID)>>
      CallVoidMethod;

  external ffi.Pointer<
          ffi.NativeFunction<
              JThrowablePtr Function(
                  JObjectPtr, JMethodIDPtr, ffi.Pointer<ffi.Void>)>>
      CallVoidMethodV;

  external ffi.Pointer<
      ffi.NativeFunction<
          JThrowablePtr Function(
            JObjectPtr obj,
            JMethodIDPtr methodID,
            ffi.Pointer<JValue> args,
          )>> CallVoidMethodA;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(
                  JObjectPtr obj, JClassPtr clazz, JMethodIDPtr methodID)>>
      CallNonvirtualObjectMethod;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniResult Function(
            JObjectPtr,
            JClassPtr,
            JMethodIDPtr,
            ffi.Pointer<ffi.Void>,
          )>> CallNonvirtualObjectMethodV;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniResult Function(
            JObjectPtr obj,
            JClassPtr clazz,
            JMethodIDPtr methodID,
            ffi.Pointer<JValue> args,
          )>> CallNonvirtualObjectMethodA;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(
                  JObjectPtr obj, JClassPtr clazz, JMethodIDPtr methodID)>>
      CallNonvirtualBooleanMethod;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniResult Function(
            JObjectPtr,
            JClassPtr,
            JMethodIDPtr,
            ffi.Pointer<ffi.Void>,
          )>> CallNonvirtualBooleanMethodV;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniResult Function(
            JObjectPtr obj,
            JClassPtr clazz,
            JMethodIDPtr methodID,
            ffi.Pointer<JValue> args,
          )>> CallNonvirtualBooleanMethodA;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(
                  JObjectPtr obj, JClassPtr clazz, JMethodIDPtr methodID)>>
      CallNonvirtualByteMethod;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniResult Function(
            JObjectPtr,
            JClassPtr,
            JMethodIDPtr,
            ffi.Pointer<ffi.Void>,
          )>> CallNonvirtualByteMethodV;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniResult Function(
            JObjectPtr obj,
            JClassPtr clazz,
            JMethodIDPtr methodID,
            ffi.Pointer<JValue> args,
          )>> CallNonvirtualByteMethodA;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(
                  JObjectPtr obj, JClassPtr clazz, JMethodIDPtr methodID)>>
      CallNonvirtualCharMethod;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniResult Function(
            JObjectPtr,
            JClassPtr,
            JMethodIDPtr,
            ffi.Pointer<ffi.Void>,
          )>> CallNonvirtualCharMethodV;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniResult Function(
            JObjectPtr obj,
            JClassPtr clazz,
            JMethodIDPtr methodID,
            ffi.Pointer<JValue> args,
          )>> CallNonvirtualCharMethodA;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(
                  JObjectPtr obj, JClassPtr clazz, JMethodIDPtr methodID)>>
      CallNonvirtualShortMethod;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniResult Function(
            JObjectPtr,
            JClassPtr,
            JMethodIDPtr,
            ffi.Pointer<ffi.Void>,
          )>> CallNonvirtualShortMethodV;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniResult Function(
            JObjectPtr obj,
            JClassPtr clazz,
            JMethodIDPtr methodID,
            ffi.Pointer<JValue> args,
          )>> CallNonvirtualShortMethodA;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(
                  JObjectPtr obj, JClassPtr clazz, JMethodIDPtr methodID)>>
      CallNonvirtualIntMethod;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniResult Function(
            JObjectPtr,
            JClassPtr,
            JMethodIDPtr,
            ffi.Pointer<ffi.Void>,
          )>> CallNonvirtualIntMethodV;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniResult Function(
            JObjectPtr obj,
            JClassPtr clazz,
            JMethodIDPtr methodID,
            ffi.Pointer<JValue> args,
          )>> CallNonvirtualIntMethodA;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(
                  JObjectPtr obj, JClassPtr clazz, JMethodIDPtr methodID)>>
      CallNonvirtualLongMethod;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniResult Function(
            JObjectPtr,
            JClassPtr,
            JMethodIDPtr,
            ffi.Pointer<ffi.Void>,
          )>> CallNonvirtualLongMethodV;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniResult Function(
            JObjectPtr obj,
            JClassPtr clazz,
            JMethodIDPtr methodID,
            ffi.Pointer<JValue> args,
          )>> CallNonvirtualLongMethodA;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(
                  JObjectPtr obj, JClassPtr clazz, JMethodIDPtr methodID)>>
      CallNonvirtualFloatMethod;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniResult Function(
            JObjectPtr,
            JClassPtr,
            JMethodIDPtr,
            ffi.Pointer<ffi.Void>,
          )>> CallNonvirtualFloatMethodV;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniResult Function(
            JObjectPtr obj,
            JClassPtr clazz,
            JMethodIDPtr methodID,
            ffi.Pointer<JValue> args,
          )>> CallNonvirtualFloatMethodA;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(
                  JObjectPtr obj, JClassPtr clazz, JMethodIDPtr methodID)>>
      CallNonvirtualDoubleMethod;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniResult Function(
            JObjectPtr,
            JClassPtr,
            JMethodIDPtr,
            ffi.Pointer<ffi.Void>,
          )>> CallNonvirtualDoubleMethodV;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniResult Function(
            JObjectPtr obj,
            JClassPtr clazz,
            JMethodIDPtr methodID,
            ffi.Pointer<JValue> args,
          )>> CallNonvirtualDoubleMethodA;

  external ffi.Pointer<
      ffi.NativeFunction<
          JThrowablePtr Function(
            JObjectPtr obj,
            JClassPtr clazz,
            JMethodIDPtr methodID,
          )>> CallNonvirtualVoidMethod;

  external ffi.Pointer<
      ffi.NativeFunction<
          JThrowablePtr Function(
            JObjectPtr,
            JClassPtr,
            JMethodIDPtr,
            ffi.Pointer<ffi.Void>,
          )>> CallNonvirtualVoidMethodV;

  external ffi.Pointer<
      ffi.NativeFunction<
          JThrowablePtr Function(
            JObjectPtr obj,
            JClassPtr clazz,
            JMethodIDPtr methodID,
            ffi.Pointer<JValue> args,
          )>> CallNonvirtualVoidMethodA;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniPointerResult Function(
            JClassPtr clazz,
            ffi.Pointer<ffi.Char> name,
            ffi.Pointer<ffi.Char> sig,
          )>> GetFieldID;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(JObjectPtr obj, JFieldIDPtr fieldID)>>
      GetObjectField;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(JObjectPtr obj, JFieldIDPtr fieldID)>>
      GetBooleanField;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(JObjectPtr obj, JFieldIDPtr fieldID)>>
      GetByteField;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(JObjectPtr obj, JFieldIDPtr fieldID)>>
      GetCharField;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(JObjectPtr obj, JFieldIDPtr fieldID)>>
      GetShortField;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniResult Function(JObjectPtr obj, JFieldIDPtr fieldID)>> GetIntField;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(JObjectPtr obj, JFieldIDPtr fieldID)>>
      GetLongField;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(JObjectPtr obj, JFieldIDPtr fieldID)>>
      GetFloatField;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(JObjectPtr obj, JFieldIDPtr fieldID)>>
      GetDoubleField;

  external ffi.Pointer<
      ffi.NativeFunction<
          JThrowablePtr Function(
            JObjectPtr obj,
            JFieldIDPtr fieldID,
            JObjectPtr val,
          )>> SetObjectField;

  external ffi.Pointer<
      ffi.NativeFunction<
          JThrowablePtr Function(
            JObjectPtr obj,
            JFieldIDPtr fieldID,
            JBooleanMarker val,
          )>> SetBooleanField;

  external ffi.Pointer<
      ffi.NativeFunction<
          JThrowablePtr Function(
            JObjectPtr obj,
            JFieldIDPtr fieldID,
            JByteMarker val,
          )>> SetByteField;

  external ffi.Pointer<
      ffi.NativeFunction<
          JThrowablePtr Function(
            JObjectPtr obj,
            JFieldIDPtr fieldID,
            JCharMarker val,
          )>> SetCharField;

  external ffi.Pointer<
      ffi.NativeFunction<
          JThrowablePtr Function(
            JObjectPtr obj,
            JFieldIDPtr fieldID,
            JShortMarker val,
          )>> SetShortField;

  external ffi.Pointer<
      ffi.NativeFunction<
          JThrowablePtr Function(
            JObjectPtr obj,
            JFieldIDPtr fieldID,
            JIntMarker val,
          )>> SetIntField;

  external ffi.Pointer<
      ffi.NativeFunction<
          JThrowablePtr Function(
            JObjectPtr obj,
            JFieldIDPtr fieldID,
            JLongMarker val,
          )>> SetLongField;

  external ffi.Pointer<
      ffi.NativeFunction<
          JThrowablePtr Function(
            JObjectPtr obj,
            JFieldIDPtr fieldID,
            JFloatMarker val,
          )>> SetFloatField;

  external ffi.Pointer<
      ffi.NativeFunction<
          JThrowablePtr Function(
            JObjectPtr obj,
            JFieldIDPtr fieldID,
            JDoubleMarker val,
          )>> SetDoubleField;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniPointerResult Function(
            JClassPtr clazz,
            ffi.Pointer<ffi.Char> name,
            ffi.Pointer<ffi.Char> sig,
          )>> GetStaticMethodID;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(JClassPtr clazz, JMethodIDPtr methodID)>>
      CallStaticObjectMethod;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(
                  JClassPtr, JMethodIDPtr, ffi.Pointer<ffi.Void>)>>
      CallStaticObjectMethodV;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniResult Function(
            JClassPtr clazz,
            JMethodIDPtr methodID,
            ffi.Pointer<JValue> args,
          )>> CallStaticObjectMethodA;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(JClassPtr clazz, JMethodIDPtr methodID)>>
      CallStaticBooleanMethod;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(
                  JClassPtr, JMethodIDPtr, ffi.Pointer<ffi.Void>)>>
      CallStaticBooleanMethodV;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniResult Function(
            JClassPtr clazz,
            JMethodIDPtr methodID,
            ffi.Pointer<JValue> args,
          )>> CallStaticBooleanMethodA;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(JClassPtr clazz, JMethodIDPtr methodID)>>
      CallStaticByteMethod;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(
                  JClassPtr, JMethodIDPtr, ffi.Pointer<ffi.Void>)>>
      CallStaticByteMethodV;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniResult Function(
            JClassPtr clazz,
            JMethodIDPtr methodID,
            ffi.Pointer<JValue> args,
          )>> CallStaticByteMethodA;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(JClassPtr clazz, JMethodIDPtr methodID)>>
      CallStaticCharMethod;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(
                  JClassPtr, JMethodIDPtr, ffi.Pointer<ffi.Void>)>>
      CallStaticCharMethodV;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniResult Function(
            JClassPtr clazz,
            JMethodIDPtr methodID,
            ffi.Pointer<JValue> args,
          )>> CallStaticCharMethodA;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(JClassPtr clazz, JMethodIDPtr methodID)>>
      CallStaticShortMethod;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(
                  JClassPtr, JMethodIDPtr, ffi.Pointer<ffi.Void>)>>
      CallStaticShortMethodV;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniResult Function(
            JClassPtr clazz,
            JMethodIDPtr methodID,
            ffi.Pointer<JValue> args,
          )>> CallStaticShortMethodA;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(JClassPtr clazz, JMethodIDPtr methodID)>>
      CallStaticIntMethod;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(
                  JClassPtr, JMethodIDPtr, ffi.Pointer<ffi.Void>)>>
      CallStaticIntMethodV;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniResult Function(
            JClassPtr clazz,
            JMethodIDPtr methodID,
            ffi.Pointer<JValue> args,
          )>> CallStaticIntMethodA;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(JClassPtr clazz, JMethodIDPtr methodID)>>
      CallStaticLongMethod;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(
                  JClassPtr, JMethodIDPtr, ffi.Pointer<ffi.Void>)>>
      CallStaticLongMethodV;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniResult Function(
            JClassPtr clazz,
            JMethodIDPtr methodID,
            ffi.Pointer<JValue> args,
          )>> CallStaticLongMethodA;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(JClassPtr clazz, JMethodIDPtr methodID)>>
      CallStaticFloatMethod;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(
                  JClassPtr, JMethodIDPtr, ffi.Pointer<ffi.Void>)>>
      CallStaticFloatMethodV;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniResult Function(
            JClassPtr clazz,
            JMethodIDPtr methodID,
            ffi.Pointer<JValue> args,
          )>> CallStaticFloatMethodA;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(JClassPtr clazz, JMethodIDPtr methodID)>>
      CallStaticDoubleMethod;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(
                  JClassPtr, JMethodIDPtr, ffi.Pointer<ffi.Void>)>>
      CallStaticDoubleMethodV;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniResult Function(
            JClassPtr clazz,
            JMethodIDPtr methodID,
            ffi.Pointer<JValue> args,
          )>> CallStaticDoubleMethodA;

  external ffi.Pointer<
          ffi.NativeFunction<
              JThrowablePtr Function(JClassPtr clazz, JMethodIDPtr methodID)>>
      CallStaticVoidMethod;

  external ffi.Pointer<
          ffi.NativeFunction<
              JThrowablePtr Function(
                  JClassPtr, JMethodIDPtr, ffi.Pointer<ffi.Void>)>>
      CallStaticVoidMethodV;

  external ffi.Pointer<
      ffi.NativeFunction<
          JThrowablePtr Function(
            JClassPtr clazz,
            JMethodIDPtr methodID,
            ffi.Pointer<JValue> args,
          )>> CallStaticVoidMethodA;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniPointerResult Function(
            JClassPtr clazz,
            ffi.Pointer<ffi.Char> name,
            ffi.Pointer<ffi.Char> sig,
          )>> GetStaticFieldID;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(JClassPtr clazz, JFieldIDPtr fieldID)>>
      GetStaticObjectField;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(JClassPtr clazz, JFieldIDPtr fieldID)>>
      GetStaticBooleanField;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(JClassPtr clazz, JFieldIDPtr fieldID)>>
      GetStaticByteField;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(JClassPtr clazz, JFieldIDPtr fieldID)>>
      GetStaticCharField;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(JClassPtr clazz, JFieldIDPtr fieldID)>>
      GetStaticShortField;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(JClassPtr clazz, JFieldIDPtr fieldID)>>
      GetStaticIntField;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(JClassPtr clazz, JFieldIDPtr fieldID)>>
      GetStaticLongField;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(JClassPtr clazz, JFieldIDPtr fieldID)>>
      GetStaticFloatField;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(JClassPtr clazz, JFieldIDPtr fieldID)>>
      GetStaticDoubleField;

  external ffi.Pointer<
      ffi.NativeFunction<
          JThrowablePtr Function(
            JClassPtr clazz,
            JFieldIDPtr fieldID,
            JObjectPtr val,
          )>> SetStaticObjectField;

  external ffi.Pointer<
      ffi.NativeFunction<
          JThrowablePtr Function(
            JClassPtr clazz,
            JFieldIDPtr fieldID,
            JBooleanMarker val,
          )>> SetStaticBooleanField;

  external ffi.Pointer<
      ffi.NativeFunction<
          JThrowablePtr Function(
            JClassPtr clazz,
            JFieldIDPtr fieldID,
            JByteMarker val,
          )>> SetStaticByteField;

  external ffi.Pointer<
      ffi.NativeFunction<
          JThrowablePtr Function(
            JClassPtr clazz,
            JFieldIDPtr fieldID,
            JCharMarker val,
          )>> SetStaticCharField;

  external ffi.Pointer<
      ffi.NativeFunction<
          JThrowablePtr Function(
            JClassPtr clazz,
            JFieldIDPtr fieldID,
            JShortMarker val,
          )>> SetStaticShortField;

  external ffi.Pointer<
      ffi.NativeFunction<
          JThrowablePtr Function(
            JClassPtr clazz,
            JFieldIDPtr fieldID,
            JIntMarker val,
          )>> SetStaticIntField;

  external ffi.Pointer<
      ffi.NativeFunction<
          JThrowablePtr Function(
            JClassPtr clazz,
            JFieldIDPtr fieldID,
            JLongMarker val,
          )>> SetStaticLongField;

  external ffi.Pointer<
      ffi.NativeFunction<
          JThrowablePtr Function(
            JClassPtr clazz,
            JFieldIDPtr fieldID,
            JFloatMarker val,
          )>> SetStaticFloatField;

  external ffi.Pointer<
      ffi.NativeFunction<
          JThrowablePtr Function(
            JClassPtr clazz,
            JFieldIDPtr fieldID,
            JDoubleMarker val,
          )>> SetStaticDoubleField;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(
                  ffi.Pointer<JCharMarker> unicodeChars, JSizeMarker len)>>
      NewString;

  external ffi
      .Pointer<ffi.NativeFunction<JniResult Function(JStringPtr string)>>
      GetStringLength;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniPointerResult Function(
            JStringPtr string,
            ffi.Pointer<JBooleanMarker> isCopy,
          )>> GetStringChars;

  external ffi.Pointer<
          ffi.NativeFunction<
              JThrowablePtr Function(
                  JStringPtr string, ffi.Pointer<JCharMarker> isCopy)>>
      ReleaseStringChars;

  external ffi.Pointer<
          ffi.NativeFunction<JniResult Function(ffi.Pointer<ffi.Char> bytes)>>
      NewStringUTF;

  external ffi
      .Pointer<ffi.NativeFunction<JniResult Function(JStringPtr string)>>
      GetStringUTFLength;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniPointerResult Function(
            JStringPtr string,
            ffi.Pointer<JBooleanMarker> isCopy,
          )>> GetStringUTFChars;

  external ffi.Pointer<
          ffi.NativeFunction<
              JThrowablePtr Function(
                  JStringPtr string, ffi.Pointer<ffi.Char> utf)>>
      ReleaseStringUTFChars;

  external ffi.Pointer<ffi.NativeFunction<JniResult Function(JArrayPtr array)>>
      GetArrayLength;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniResult Function(
            JSizeMarker length,
            JClassPtr elementClass,
            JObjectPtr initialElement,
          )>> NewObjectArray;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(JObjectArrayPtr array, JSizeMarker index)>>
      GetObjectArrayElement;

  external ffi.Pointer<
      ffi.NativeFunction<
          JThrowablePtr Function(
            JObjectArrayPtr array,
            JSizeMarker index,
            JObjectPtr val,
          )>> SetObjectArrayElement;

  external ffi
      .Pointer<ffi.NativeFunction<JniResult Function(JSizeMarker length)>>
      NewBooleanArray;

  external ffi
      .Pointer<ffi.NativeFunction<JniResult Function(JSizeMarker length)>>
      NewByteArray;

  external ffi
      .Pointer<ffi.NativeFunction<JniResult Function(JSizeMarker length)>>
      NewCharArray;

  external ffi
      .Pointer<ffi.NativeFunction<JniResult Function(JSizeMarker length)>>
      NewShortArray;

  external ffi
      .Pointer<ffi.NativeFunction<JniResult Function(JSizeMarker length)>>
      NewIntArray;

  external ffi
      .Pointer<ffi.NativeFunction<JniResult Function(JSizeMarker length)>>
      NewLongArray;

  external ffi
      .Pointer<ffi.NativeFunction<JniResult Function(JSizeMarker length)>>
      NewFloatArray;

  external ffi
      .Pointer<ffi.NativeFunction<JniResult Function(JSizeMarker length)>>
      NewDoubleArray;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniPointerResult Function(
            JBooleanArrayPtr array,
            ffi.Pointer<JBooleanMarker> isCopy,
          )>> GetBooleanArrayElements;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniPointerResult Function(
            JByteArrayPtr array,
            ffi.Pointer<JBooleanMarker> isCopy,
          )>> GetByteArrayElements;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniPointerResult Function(
            JCharArrayPtr array,
            ffi.Pointer<JBooleanMarker> isCopy,
          )>> GetCharArrayElements;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniPointerResult Function(
            JShortArrayPtr array,
            ffi.Pointer<JBooleanMarker> isCopy,
          )>> GetShortArrayElements;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniPointerResult Function(
            JIntArrayPtr array,
            ffi.Pointer<JBooleanMarker> isCopy,
          )>> GetIntArrayElements;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniPointerResult Function(
            JLongArrayPtr array,
            ffi.Pointer<JBooleanMarker> isCopy,
          )>> GetLongArrayElements;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniPointerResult Function(
            JFloatArrayPtr array,
            ffi.Pointer<JBooleanMarker> isCopy,
          )>> GetFloatArrayElements;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniPointerResult Function(
            JDoubleArrayPtr array,
            ffi.Pointer<JBooleanMarker> isCopy,
          )>> GetDoubleArrayElements;

  external ffi.Pointer<
      ffi.NativeFunction<
          JThrowablePtr Function(
            JBooleanArrayPtr array,
            ffi.Pointer<JBooleanMarker> elems,
            JIntMarker mode,
          )>> ReleaseBooleanArrayElements;

  external ffi.Pointer<
      ffi.NativeFunction<
          JThrowablePtr Function(
            JByteArrayPtr array,
            ffi.Pointer<JByteMarker> elems,
            JIntMarker mode,
          )>> ReleaseByteArrayElements;

  external ffi.Pointer<
      ffi.NativeFunction<
          JThrowablePtr Function(
            JCharArrayPtr array,
            ffi.Pointer<JCharMarker> elems,
            JIntMarker mode,
          )>> ReleaseCharArrayElements;

  external ffi.Pointer<
      ffi.NativeFunction<
          JThrowablePtr Function(
            JShortArrayPtr array,
            ffi.Pointer<JShortMarker> elems,
            JIntMarker mode,
          )>> ReleaseShortArrayElements;

  external ffi.Pointer<
      ffi.NativeFunction<
          JThrowablePtr Function(
            JIntArrayPtr array,
            ffi.Pointer<JIntMarker> elems,
            JIntMarker mode,
          )>> ReleaseIntArrayElements;

  external ffi.Pointer<
      ffi.NativeFunction<
          JThrowablePtr Function(
            JLongArrayPtr array,
            ffi.Pointer<JLongMarker> elems,
            JIntMarker mode,
          )>> ReleaseLongArrayElements;

  external ffi.Pointer<
      ffi.NativeFunction<
          JThrowablePtr Function(
            JFloatArrayPtr array,
            ffi.Pointer<JFloatMarker> elems,
            JIntMarker mode,
          )>> ReleaseFloatArrayElements;

  external ffi.Pointer<
      ffi.NativeFunction<
          JThrowablePtr Function(
            JDoubleArrayPtr array,
            ffi.Pointer<JDoubleMarker> elems,
            JIntMarker mode,
          )>> ReleaseDoubleArrayElements;

  external ffi.Pointer<
      ffi.NativeFunction<
          JThrowablePtr Function(
            JBooleanArrayPtr array,
            JSizeMarker start,
            JSizeMarker len,
            ffi.Pointer<JBooleanMarker> buf,
          )>> GetBooleanArrayRegion;

  external ffi.Pointer<
      ffi.NativeFunction<
          JThrowablePtr Function(
            JByteArrayPtr array,
            JSizeMarker start,
            JSizeMarker len,
            ffi.Pointer<JByteMarker> buf,
          )>> GetByteArrayRegion;

  external ffi.Pointer<
      ffi.NativeFunction<
          JThrowablePtr Function(
            JCharArrayPtr array,
            JSizeMarker start,
            JSizeMarker len,
            ffi.Pointer<JCharMarker> buf,
          )>> GetCharArrayRegion;

  external ffi.Pointer<
      ffi.NativeFunction<
          JThrowablePtr Function(
            JShortArrayPtr array,
            JSizeMarker start,
            JSizeMarker len,
            ffi.Pointer<JShortMarker> buf,
          )>> GetShortArrayRegion;

  external ffi.Pointer<
      ffi.NativeFunction<
          JThrowablePtr Function(
            JIntArrayPtr array,
            JSizeMarker start,
            JSizeMarker len,
            ffi.Pointer<JIntMarker> buf,
          )>> GetIntArrayRegion;

  external ffi.Pointer<
      ffi.NativeFunction<
          JThrowablePtr Function(
            JLongArrayPtr array,
            JSizeMarker start,
            JSizeMarker len,
            ffi.Pointer<JLongMarker> buf,
          )>> GetLongArrayRegion;

  external ffi.Pointer<
      ffi.NativeFunction<
          JThrowablePtr Function(
            JFloatArrayPtr array,
            JSizeMarker start,
            JSizeMarker len,
            ffi.Pointer<JFloatMarker> buf,
          )>> GetFloatArrayRegion;

  external ffi.Pointer<
      ffi.NativeFunction<
          JThrowablePtr Function(
            JDoubleArrayPtr array,
            JSizeMarker start,
            JSizeMarker len,
            ffi.Pointer<JDoubleMarker> buf,
          )>> GetDoubleArrayRegion;

  external ffi.Pointer<
      ffi.NativeFunction<
          JThrowablePtr Function(
            JBooleanArrayPtr array,
            JSizeMarker start,
            JSizeMarker len,
            ffi.Pointer<JBooleanMarker> buf,
          )>> SetBooleanArrayRegion;

  external ffi.Pointer<
      ffi.NativeFunction<
          JThrowablePtr Function(
            JByteArrayPtr array,
            JSizeMarker start,
            JSizeMarker len,
            ffi.Pointer<JByteMarker> buf,
          )>> SetByteArrayRegion;

  external ffi.Pointer<
      ffi.NativeFunction<
          JThrowablePtr Function(
            JCharArrayPtr array,
            JSizeMarker start,
            JSizeMarker len,
            ffi.Pointer<JCharMarker> buf,
          )>> SetCharArrayRegion;

  external ffi.Pointer<
      ffi.NativeFunction<
          JThrowablePtr Function(
            JShortArrayPtr array,
            JSizeMarker start,
            JSizeMarker len,
            ffi.Pointer<JShortMarker> buf,
          )>> SetShortArrayRegion;

  external ffi.Pointer<
      ffi.NativeFunction<
          JThrowablePtr Function(
            JIntArrayPtr array,
            JSizeMarker start,
            JSizeMarker len,
            ffi.Pointer<JIntMarker> buf,
          )>> SetIntArrayRegion;

  external ffi.Pointer<
      ffi.NativeFunction<
          JThrowablePtr Function(
            JLongArrayPtr array,
            JSizeMarker start,
            JSizeMarker len,
            ffi.Pointer<JLongMarker> buf,
          )>> SetLongArrayRegion;

  external ffi.Pointer<
      ffi.NativeFunction<
          JThrowablePtr Function(
            JFloatArrayPtr array,
            JSizeMarker start,
            JSizeMarker len,
            ffi.Pointer<JFloatMarker> buf,
          )>> SetFloatArrayRegion;

  external ffi.Pointer<
      ffi.NativeFunction<
          JThrowablePtr Function(
            JDoubleArrayPtr array,
            JSizeMarker start,
            JSizeMarker len,
            ffi.Pointer<JDoubleMarker> buf,
          )>> SetDoubleArrayRegion;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniResult Function(
            JClassPtr clazz,
            ffi.Pointer<JNINativeMethod> methods,
            JIntMarker nMethods,
          )>> RegisterNatives;

  external ffi.Pointer<ffi.NativeFunction<JniResult Function(JClassPtr clazz)>>
      UnregisterNatives;

  external ffi.Pointer<ffi.NativeFunction<JniResult Function(JObjectPtr obj)>>
      MonitorEnter;

  external ffi.Pointer<ffi.NativeFunction<JniResult Function(JObjectPtr obj)>>
      MonitorExit;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniResult Function(ffi.Pointer<ffi.Pointer<JavaVM$1>> vm)>> GetJavaVM;

  external ffi.Pointer<
      ffi.NativeFunction<
          JThrowablePtr Function(
            JStringPtr str,
            JSizeMarker start,
            JSizeMarker len,
            ffi.Pointer<JCharMarker> buf,
          )>> GetStringRegion;

  external ffi.Pointer<
      ffi.NativeFunction<
          JThrowablePtr Function(
            JStringPtr str,
            JSizeMarker start,
            JSizeMarker len,
            ffi.Pointer<ffi.Char> buf,
          )>> GetStringUTFRegion;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniPointerResult Function(
            JArrayPtr array,
            ffi.Pointer<JBooleanMarker> isCopy,
          )>> GetPrimitiveArrayCritical;

  external ffi.Pointer<
      ffi.NativeFunction<
          JThrowablePtr Function(
            JArrayPtr array,
            ffi.Pointer<ffi.Void> carray,
            JIntMarker mode,
          )>> ReleasePrimitiveArrayCritical;

  external ffi.Pointer<
      ffi.NativeFunction<
          JniPointerResult Function(
            JStringPtr str,
            ffi.Pointer<JBooleanMarker> isCopy,
          )>> GetStringCritical;

  external ffi.Pointer<
          ffi.NativeFunction<
              JThrowablePtr Function(
                  JStringPtr str, ffi.Pointer<JCharMarker> carray)>>
      ReleaseStringCritical;

  external ffi.Pointer<ffi.NativeFunction<JniResult Function(JObjectPtr obj)>>
      NewWeakGlobalRef;

  external ffi.Pointer<ffi.NativeFunction<JThrowablePtr Function(JWeakPtr obj)>>
      DeleteWeakGlobalRef;

  external ffi.Pointer<ffi.NativeFunction<JniResult Function()>> ExceptionCheck;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(
                  ffi.Pointer<ffi.Void> address, JLongMarker capacity)>>
      NewDirectByteBuffer;

  external ffi
      .Pointer<ffi.NativeFunction<JniPointerResult Function(JObjectPtr buf)>>
      GetDirectBufferAddress;

  external ffi.Pointer<ffi.NativeFunction<JniResult Function(JObjectPtr buf)>>
      GetDirectBufferCapacity;

  external ffi.Pointer<ffi.NativeFunction<JniResult Function(JObjectPtr obj)>>
      GetObjectRefType;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(JBooleanArrayPtr array, JSizeMarker index)>>
      GetBooleanArrayElement;

  external ffi.Pointer<
      ffi.NativeFunction<
          JThrowablePtr Function(
            JBooleanArrayPtr array,
            JSizeMarker index,
            JBooleanMarker element,
          )>> SetBooleanArrayElement;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(JByteArrayPtr array, JSizeMarker index)>>
      GetByteArrayElement;

  external ffi.Pointer<
      ffi.NativeFunction<
          JThrowablePtr Function(
            JByteArrayPtr array,
            JSizeMarker index,
            JByteMarker element,
          )>> SetByteArrayElement;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(JCharArrayPtr array, JSizeMarker index)>>
      GetCharArrayElement;

  external ffi.Pointer<
      ffi.NativeFunction<
          JThrowablePtr Function(
            JCharArrayPtr array,
            JSizeMarker index,
            JCharMarker element,
          )>> SetCharArrayElement;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(JShortArrayPtr array, JSizeMarker index)>>
      GetShortArrayElement;

  external ffi.Pointer<
      ffi.NativeFunction<
          JThrowablePtr Function(
            JShortArrayPtr array,
            JSizeMarker index,
            JShortMarker element,
          )>> SetShortArrayElement;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(JIntArrayPtr array, JSizeMarker index)>>
      GetIntArrayElement;

  external ffi.Pointer<
      ffi.NativeFunction<
          JThrowablePtr Function(
            JIntArrayPtr array,
            JSizeMarker index,
            JIntMarker element,
          )>> SetIntArrayElement;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(JLongArrayPtr array, JSizeMarker index)>>
      GetLongArrayElement;

  external ffi.Pointer<
      ffi.NativeFunction<
          JThrowablePtr Function(
            JLongArrayPtr array,
            JSizeMarker index,
            JLongMarker element,
          )>> SetLongArrayElement;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(JFloatArrayPtr array, JSizeMarker index)>>
      GetFloatArrayElement;

  external ffi.Pointer<
      ffi.NativeFunction<
          JThrowablePtr Function(
            JFloatArrayPtr array,
            JSizeMarker index,
            JFloatMarker element,
          )>> SetFloatArrayElement;

  external ffi.Pointer<
          ffi.NativeFunction<
              JniResult Function(JDoubleArrayPtr array, JSizeMarker index)>>
      GetDoubleArrayElement;

  external ffi.Pointer<
      ffi.NativeFunction<
          JThrowablePtr Function(
            JDoubleArrayPtr array,
            JSizeMarker index,
            JDoubleMarker element,
          )>> SetDoubleArrayElement;
}
