const List<String> kKeyClasses = [
  'Response',
  'Request',
  'Type',
  'Query',
  'Body',
  'Method',
  'Uri',
  'List',
];

const kBasicTypes = [
  'string',
  'int',
  'integer',
  'double',
  'float',
  'bool',
  'boolean',
  'num',
  'Object',
  'String',
  kMap,
];

const kBasicSwaggerTypes = [...kBasicTypes, 'number'];

const kMap = 'Map';
const kMapStringDynamic = 'Map<String,dynamic>';
const kRequired = 'required';

const kChopperService = 'ChopperService';
const kChopperApi = 'ChopperApi';
const kResponse = 'Response';
const kRequestBody = 'RequestBody';
const kFutureResponse = 'Future<chopper.Response>';
const kString = 'string';
const kInteger = 'integer';
const kInt64 = 'int64';
const kNum = 'num';
const kUndefinedParameter = 'undefinedParameter';

const kIntegerTypes = [kInteger, kInt64, kNum];

const kResponses = '/responses/';

//Request types
const kPath = 'path';
const kOptionalBody = 'optionalBody';
const kFormData = 'formData';
const kMultipart = 'multipart';
const kIncludeNullQueryVars = 'includeNullQueryVars';
const kDateTimeFormat = 'date-time';
const kFactoryConverter = 'factoryConverter';
const kDeprecatedAnnotation = '@deprecated';

const kDefaultBodyParameter = 'Object';
const kField = 'Field';
const kRequestTypeOptions = 'options';
const kAdditionalProperties = 'additionalProperties';

const successDescriptions = ['Success', 'OK', 'default response'];

const kBasicTypesMap = <String, String>{
  'integer': 'int',
  'int': 'int',
  'int32': 'int',
  'int64': 'num',
  'boolean': 'bool',
  'bool': 'bool',
  'string': 'String',
  'number': 'num',
  'object': 'Object',
  'file': 'List<int>',
  'num': 'num',
};

const kObject = 'object';
const kBinary = 'binary';
const kHeader = 'header';
const kCookie = 'cookie';
const kArray = 'array';
const kEnum = 'enum';
const kBody = 'body';
const kQuery = 'query';
const kPartFile = 'partFile';
const kPart = 'part';

const kDateTimeType = 'DateTime';

const kDynamic = 'dynamic';

const supportedRequestTypes = ['get', 'post', 'put', 'delete', 'head', 'patch'];

const kEnumNames = 'x-enumNames';
const kEnumVarnames = 'x-enum-varnames';
const kIsNullable = 'x-nullable';
const kNullable = 'nullable';
const kUrlencoded = 'urlencoded';

const kServiceHeader = '''
// **************************************************************************
// SwaggerChopperGenerator
// **************************************************************************
  ''';

const kSwaggerMetaData = 'SwaggerMetaData';
const kSwaggerMetaDataParameter = 'swaggerMetaData';
