// Copyright 2013 The Flutter Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// Autogenerated from Pigeon (v26.1.0), do not edit directly.
// See also: https://pub.dev/packages/pigeon

import Foundation

#if os(iOS)
  import Flutter
#elseif os(macOS)
  import FlutterMacOS
#else
  #error("Unsupported platform.")
#endif

/// Error class for passing custom error details to Dart side.
final class PigeonError: Error {
  let code: String
  let message: String?
  let details: Sendable?

  init(code: String, message: String?, details: Sendable?) {
    self.code = code
    self.message = message
    self.details = details
  }

  var localizedDescription: String {
    return
      "PigeonError(code: \(code), message: \(message ?? "<nil>"), details: \(details ?? "<nil>")"
  }
}

private func wrapResult(_ result: Any?) -> [Any?] {
  return [result]
}

private func wrapError(_ error: Any) -> [Any?] {
  if let pigeonError = error as? PigeonError {
    return [
      pigeonError.code,
      pigeonError.message,
      pigeonError.details,
    ]
  }
  if let flutterError = error as? FlutterError {
    return [
      flutterError.code,
      flutterError.message,
      flutterError.details,
    ]
  }
  return [
    "\(error)",
    "\(type(of: error))",
    "Stacktrace: \(Thread.callStackSymbols)",
  ]
}

private func isNullish(_ value: Any?) -> Bool {
  return value is NSNull || value == nil
}

private func nilOrValue<T>(_ value: Any?) -> T? {
  if value is NSNull { return nil }
  return value as! T?
}

func deepEqualsmessages(_ lhs: Any?, _ rhs: Any?) -> Bool {
  let cleanLhs = nilOrValue(lhs) as Any?
  let cleanRhs = nilOrValue(rhs) as Any?
  switch (cleanLhs, cleanRhs) {
  case (nil, nil):
    return true

  case (nil, _), (_, nil):
    return false

  case is (Void, Void):
    return true

  case let (cleanLhsHashable, cleanRhsHashable) as (AnyHashable, AnyHashable):
    return cleanLhsHashable == cleanRhsHashable

  case let (cleanLhsArray, cleanRhsArray) as ([Any?], [Any?]):
    guard cleanLhsArray.count == cleanRhsArray.count else { return false }
    for (index, element) in cleanLhsArray.enumerated() {
      if !deepEqualsmessages(element, cleanRhsArray[index]) {
        return false
      }
    }
    return true

  case let (cleanLhsDictionary, cleanRhsDictionary) as ([AnyHashable: Any?], [AnyHashable: Any?]):
    guard cleanLhsDictionary.count == cleanRhsDictionary.count else { return false }
    for (key, cleanLhsValue) in cleanLhsDictionary {
      guard cleanRhsDictionary.index(forKey: key) != nil else { return false }
      if !deepEqualsmessages(cleanLhsValue, cleanRhsDictionary[key]!) {
        return false
      }
    }
    return true

  default:
    // Any other type shouldn't be able to be used with pigeon. File an issue if you find this to be untrue.
    return false
  }
}

func deepHashmessages(value: Any?, hasher: inout Hasher) {
  if let valueList = value as? [AnyHashable] {
    for item in valueList { deepHashmessages(value: item, hasher: &hasher) }
    return
  }

  if let valueDict = value as? [AnyHashable: AnyHashable] {
    for key in valueDict.keys {
      hasher.combine(key)
      deepHashmessages(value: valueDict[key]!, hasher: &hasher)
    }
    return
  }

  if let hashableValue = value as? AnyHashable {
    hasher.combine(hashableValue.hashValue)
  }

  return hasher.combine(String(describing: value))
}

/// Possible outcomes of an authentication attempt.
enum AuthResult: Int {
  /// The user authenticated successfully.
  case success = 0
  /// Native UI needed to be displayed, but couldn't be.
  case uiUnavailable = 1
  case appCancel = 2
  case systemCancel = 3
  case userCancel = 4
  case biometryDisconnected = 5
  case biometryLockout = 6
  case biometryNotAvailable = 7
  case biometryNotEnrolled = 8
  case biometryNotPaired = 9
  case authenticationFailed = 10
  case invalidContext = 11
  case invalidDimensions = 12
  case notInteractive = 13
  case passcodeNotSet = 14
  case userFallback = 15
  /// An error other than the expected types occurred.
  case unknownError = 16
}

/// Pigeon equivalent of the subset of BiometricType used by iOS.
enum AuthBiometric: Int {
  case face = 0
  case fingerprint = 1
}

/// Pigeon version of IOSAuthMessages, plus the authorization reason.
///
/// See auth_messages_ios.dart for details.
///
/// Generated class from Pigeon that represents data sent in messages.
struct AuthStrings: Hashable {
  var reason: String
  var cancelButton: String
  var localizedFallbackTitle: String? = nil

  // swift-format-ignore: AlwaysUseLowerCamelCase
  static func fromList(_ pigeonVar_list: [Any?]) -> AuthStrings? {
    let reason = pigeonVar_list[0] as! String
    let cancelButton = pigeonVar_list[1] as! String
    let localizedFallbackTitle: String? = nilOrValue(pigeonVar_list[2])

    return AuthStrings(
      reason: reason,
      cancelButton: cancelButton,
      localizedFallbackTitle: localizedFallbackTitle
    )
  }
  func toList() -> [Any?] {
    return [
      reason,
      cancelButton,
      localizedFallbackTitle,
    ]
  }
  static func == (lhs: AuthStrings, rhs: AuthStrings) -> Bool {
    return deepEqualsmessages(lhs.toList(), rhs.toList())
  }
  func hash(into hasher: inout Hasher) {
    deepHashmessages(value: toList(), hasher: &hasher)
  }
}

/// Generated class from Pigeon that represents data sent in messages.
struct AuthOptions: Hashable {
  var biometricOnly: Bool
  var sticky: Bool

  // swift-format-ignore: AlwaysUseLowerCamelCase
  static func fromList(_ pigeonVar_list: [Any?]) -> AuthOptions? {
    let biometricOnly = pigeonVar_list[0] as! Bool
    let sticky = pigeonVar_list[1] as! Bool

    return AuthOptions(
      biometricOnly: biometricOnly,
      sticky: sticky
    )
  }
  func toList() -> [Any?] {
    return [
      biometricOnly,
      sticky,
    ]
  }
  static func == (lhs: AuthOptions, rhs: AuthOptions) -> Bool {
    return deepEqualsmessages(lhs.toList(), rhs.toList())
  }
  func hash(into hasher: inout Hasher) {
    deepHashmessages(value: toList(), hasher: &hasher)
  }
}

/// Generated class from Pigeon that represents data sent in messages.
struct AuthResultDetails: Hashable {
  /// The result of authenticating.
  var result: AuthResult
  /// A system-provided error message, if any.
  var errorMessage: String? = nil
  /// System-provided error details, if any.
  var errorDetails: String? = nil

  // swift-format-ignore: AlwaysUseLowerCamelCase
  static func fromList(_ pigeonVar_list: [Any?]) -> AuthResultDetails? {
    let result = pigeonVar_list[0] as! AuthResult
    let errorMessage: String? = nilOrValue(pigeonVar_list[1])
    let errorDetails: String? = nilOrValue(pigeonVar_list[2])

    return AuthResultDetails(
      result: result,
      errorMessage: errorMessage,
      errorDetails: errorDetails
    )
  }
  func toList() -> [Any?] {
    return [
      result,
      errorMessage,
      errorDetails,
    ]
  }
  static func == (lhs: AuthResultDetails, rhs: AuthResultDetails) -> Bool {
    return deepEqualsmessages(lhs.toList(), rhs.toList())
  }
  func hash(into hasher: inout Hasher) {
    deepHashmessages(value: toList(), hasher: &hasher)
  }
}

private class MessagesPigeonCodecReader: FlutterStandardReader {
  override func readValue(ofType type: UInt8) -> Any? {
    switch type {
    case 129:
      let enumResultAsInt: Int? = nilOrValue(self.readValue() as! Int?)
      if let enumResultAsInt = enumResultAsInt {
        return AuthResult(rawValue: enumResultAsInt)
      }
      return nil
    case 130:
      let enumResultAsInt: Int? = nilOrValue(self.readValue() as! Int?)
      if let enumResultAsInt = enumResultAsInt {
        return AuthBiometric(rawValue: enumResultAsInt)
      }
      return nil
    case 131:
      return AuthStrings.fromList(self.readValue() as! [Any?])
    case 132:
      return AuthOptions.fromList(self.readValue() as! [Any?])
    case 133:
      return AuthResultDetails.fromList(self.readValue() as! [Any?])
    default:
      return super.readValue(ofType: type)
    }
  }
}

private class MessagesPigeonCodecWriter: FlutterStandardWriter {
  override func writeValue(_ value: Any) {
    if let value = value as? AuthResult {
      super.writeByte(129)
      super.writeValue(value.rawValue)
    } else if let value = value as? AuthBiometric {
      super.writeByte(130)
      super.writeValue(value.rawValue)
    } else if let value = value as? AuthStrings {
      super.writeByte(131)
      super.writeValue(value.toList())
    } else if let value = value as? AuthOptions {
      super.writeByte(132)
      super.writeValue(value.toList())
    } else if let value = value as? AuthResultDetails {
      super.writeByte(133)
      super.writeValue(value.toList())
    } else {
      super.writeValue(value)
    }
  }
}

private class MessagesPigeonCodecReaderWriter: FlutterStandardReaderWriter {
  override func reader(with data: Data) -> FlutterStandardReader {
    return MessagesPigeonCodecReader(data: data)
  }

  override func writer(with data: NSMutableData) -> FlutterStandardWriter {
    return MessagesPigeonCodecWriter(data: data)
  }
}

class MessagesPigeonCodec: FlutterStandardMessageCodec, @unchecked Sendable {
  static let shared = MessagesPigeonCodec(readerWriter: MessagesPigeonCodecReaderWriter())
}

/// Generated protocol from Pigeon that represents a handler of messages from Flutter.
protocol LocalAuthApi {
  /// Returns true if this device supports authentication.
  func isDeviceSupported() throws -> Bool
  /// Returns true if this device can support biometric authentication, whether
  /// any biometrics are enrolled or not.
  func deviceCanSupportBiometrics() throws -> Bool
  /// Returns the biometric types that are enrolled, and can thus be used
  /// without additional setup.
  func getEnrolledBiometrics() throws -> [AuthBiometric]
  /// Attempts to authenticate the user with the provided [options], and using
  /// [strings] for any UI.
  func authenticate(
    options: AuthOptions, strings: AuthStrings,
    completion: @escaping (Result<AuthResultDetails, Error>) -> Void)
}

/// Generated setup class from Pigeon to handle messages through the `binaryMessenger`.
class LocalAuthApiSetup {
  static var codec: FlutterStandardMessageCodec { MessagesPigeonCodec.shared }
  /// Sets up an instance of `LocalAuthApi` to handle messages through the `binaryMessenger`.
  static func setUp(
    binaryMessenger: FlutterBinaryMessenger, api: LocalAuthApi?, messageChannelSuffix: String = ""
  ) {
    let channelSuffix = messageChannelSuffix.count > 0 ? ".\(messageChannelSuffix)" : ""
    /// Returns true if this device supports authentication.
    let isDeviceSupportedChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.local_auth_darwin.LocalAuthApi.isDeviceSupported\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      isDeviceSupportedChannel.setMessageHandler { _, reply in
        do {
          let result = try api.isDeviceSupported()
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      isDeviceSupportedChannel.setMessageHandler(nil)
    }
    /// Returns true if this device can support biometric authentication, whether
    /// any biometrics are enrolled or not.
    let deviceCanSupportBiometricsChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.local_auth_darwin.LocalAuthApi.deviceCanSupportBiometrics\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      deviceCanSupportBiometricsChannel.setMessageHandler { _, reply in
        do {
          let result = try api.deviceCanSupportBiometrics()
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      deviceCanSupportBiometricsChannel.setMessageHandler(nil)
    }
    /// Returns the biometric types that are enrolled, and can thus be used
    /// without additional setup.
    let getEnrolledBiometricsChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.local_auth_darwin.LocalAuthApi.getEnrolledBiometrics\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      getEnrolledBiometricsChannel.setMessageHandler { _, reply in
        do {
          let result = try api.getEnrolledBiometrics()
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      getEnrolledBiometricsChannel.setMessageHandler(nil)
    }
    /// Attempts to authenticate the user with the provided [options], and using
    /// [strings] for any UI.
    let authenticateChannel = FlutterBasicMessageChannel(
      name: "dev.flutter.pigeon.local_auth_darwin.LocalAuthApi.authenticate\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      authenticateChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let optionsArg = args[0] as! AuthOptions
        let stringsArg = args[1] as! AuthStrings
        api.authenticate(options: optionsArg, strings: stringsArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      authenticateChannel.setMessageHandler(nil)
    }
  }
}
