// Copyright 2013 The Flutter Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// Autogenerated from Pigeon (v24.2.0), do not edit directly.
// See also: https://pub.dev/packages/pigeon

package io.flutter.plugins.imagepicker;

import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.CLASS;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.plugin.common.BasicMessageChannel;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.MessageCodec;
import io.flutter.plugin.common.StandardMessageCodec;
import java.io.ByteArrayOutputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** Generated class from Pigeon. */
@SuppressWarnings({"unused", "unchecked", "CodeBlock2Expr", "RedundantSuppression", "serial"})
public class Messages {

  /** Error class for passing custom error details to Flutter via a thrown PlatformException. */
  public static class FlutterError extends RuntimeException {

    /** The error code. */
    public final String code;

    /** The error details. Must be a datatype supported by the api codec. */
    public final Object details;

    public FlutterError(@NonNull String code, @Nullable String message, @Nullable Object details) {
      super(message);
      this.code = code;
      this.details = details;
    }
  }

  @NonNull
  protected static ArrayList<Object> wrapError(@NonNull Throwable exception) {
    ArrayList<Object> errorList = new ArrayList<>(3);
    if (exception instanceof FlutterError) {
      FlutterError error = (FlutterError) exception;
      errorList.add(error.code);
      errorList.add(error.getMessage());
      errorList.add(error.details);
    } else {
      errorList.add(exception.toString());
      errorList.add(exception.getClass().getSimpleName());
      errorList.add(
          "Cause: " + exception.getCause() + ", Stacktrace: " + Log.getStackTraceString(exception));
    }
    return errorList;
  }

  @Target(METHOD)
  @Retention(CLASS)
  @interface CanIgnoreReturnValue {}

  public enum SourceCamera {
    REAR(0),
    FRONT(1);

    final int index;

    SourceCamera(final int index) {
      this.index = index;
    }
  }

  public enum SourceType {
    CAMERA(0),
    GALLERY(1);

    final int index;

    SourceType(final int index) {
      this.index = index;
    }
  }

  public enum CacheRetrievalType {
    IMAGE(0),
    VIDEO(1);

    final int index;

    CacheRetrievalType(final int index) {
      this.index = index;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class GeneralOptions {
    private @NonNull Boolean allowMultiple;

    public @NonNull Boolean getAllowMultiple() {
      return allowMultiple;
    }

    public void setAllowMultiple(@NonNull Boolean setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"allowMultiple\" is null.");
      }
      this.allowMultiple = setterArg;
    }

    private @NonNull Boolean usePhotoPicker;

    public @NonNull Boolean getUsePhotoPicker() {
      return usePhotoPicker;
    }

    public void setUsePhotoPicker(@NonNull Boolean setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"usePhotoPicker\" is null.");
      }
      this.usePhotoPicker = setterArg;
    }

    private @Nullable Long limit;

    public @Nullable Long getLimit() {
      return limit;
    }

    public void setLimit(@Nullable Long setterArg) {
      this.limit = setterArg;
    }

    /** Constructor is non-public to enforce null safety; use Builder. */
    GeneralOptions() {}

    @Override
    public boolean equals(Object o) {
      if (this == o) {
        return true;
      }
      if (o == null || getClass() != o.getClass()) {
        return false;
      }
      GeneralOptions that = (GeneralOptions) o;
      return allowMultiple.equals(that.allowMultiple)
          && usePhotoPicker.equals(that.usePhotoPicker)
          && Objects.equals(limit, that.limit);
    }

    @Override
    public int hashCode() {
      return Objects.hash(allowMultiple, usePhotoPicker, limit);
    }

    public static final class Builder {

      private @Nullable Boolean allowMultiple;

      @CanIgnoreReturnValue
      public @NonNull Builder setAllowMultiple(@NonNull Boolean setterArg) {
        this.allowMultiple = setterArg;
        return this;
      }

      private @Nullable Boolean usePhotoPicker;

      @CanIgnoreReturnValue
      public @NonNull Builder setUsePhotoPicker(@NonNull Boolean setterArg) {
        this.usePhotoPicker = setterArg;
        return this;
      }

      private @Nullable Long limit;

      @CanIgnoreReturnValue
      public @NonNull Builder setLimit(@Nullable Long setterArg) {
        this.limit = setterArg;
        return this;
      }

      public @NonNull GeneralOptions build() {
        GeneralOptions pigeonReturn = new GeneralOptions();
        pigeonReturn.setAllowMultiple(allowMultiple);
        pigeonReturn.setUsePhotoPicker(usePhotoPicker);
        pigeonReturn.setLimit(limit);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<>(3);
      toListResult.add(allowMultiple);
      toListResult.add(usePhotoPicker);
      toListResult.add(limit);
      return toListResult;
    }

    static @NonNull GeneralOptions fromList(@NonNull ArrayList<Object> pigeonVar_list) {
      GeneralOptions pigeonResult = new GeneralOptions();
      Object allowMultiple = pigeonVar_list.get(0);
      pigeonResult.setAllowMultiple((Boolean) allowMultiple);
      Object usePhotoPicker = pigeonVar_list.get(1);
      pigeonResult.setUsePhotoPicker((Boolean) usePhotoPicker);
      Object limit = pigeonVar_list.get(2);
      pigeonResult.setLimit((Long) limit);
      return pigeonResult;
    }
  }

  /**
   * Options for image selection and output.
   *
   * <p>Generated class from Pigeon that represents data sent in messages.
   */
  public static final class ImageSelectionOptions {
    /** If set, the max width that the image should be resized to fit in. */
    private @Nullable Double maxWidth;

    public @Nullable Double getMaxWidth() {
      return maxWidth;
    }

    public void setMaxWidth(@Nullable Double setterArg) {
      this.maxWidth = setterArg;
    }

    /** If set, the max height that the image should be resized to fit in. */
    private @Nullable Double maxHeight;

    public @Nullable Double getMaxHeight() {
      return maxHeight;
    }

    public void setMaxHeight(@Nullable Double setterArg) {
      this.maxHeight = setterArg;
    }

    /**
     * The quality of the output image, from 0-100.
     *
     * <p>100 indicates original quality.
     */
    private @NonNull Long quality;

    public @NonNull Long getQuality() {
      return quality;
    }

    public void setQuality(@NonNull Long setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"quality\" is null.");
      }
      this.quality = setterArg;
    }

    /** Constructor is non-public to enforce null safety; use Builder. */
    ImageSelectionOptions() {}

    @Override
    public boolean equals(Object o) {
      if (this == o) {
        return true;
      }
      if (o == null || getClass() != o.getClass()) {
        return false;
      }
      ImageSelectionOptions that = (ImageSelectionOptions) o;
      return Objects.equals(maxWidth, that.maxWidth)
          && Objects.equals(maxHeight, that.maxHeight)
          && quality.equals(that.quality);
    }

    @Override
    public int hashCode() {
      return Objects.hash(maxWidth, maxHeight, quality);
    }

    public static final class Builder {

      private @Nullable Double maxWidth;

      @CanIgnoreReturnValue
      public @NonNull Builder setMaxWidth(@Nullable Double setterArg) {
        this.maxWidth = setterArg;
        return this;
      }

      private @Nullable Double maxHeight;

      @CanIgnoreReturnValue
      public @NonNull Builder setMaxHeight(@Nullable Double setterArg) {
        this.maxHeight = setterArg;
        return this;
      }

      private @Nullable Long quality;

      @CanIgnoreReturnValue
      public @NonNull Builder setQuality(@NonNull Long setterArg) {
        this.quality = setterArg;
        return this;
      }

      public @NonNull ImageSelectionOptions build() {
        ImageSelectionOptions pigeonReturn = new ImageSelectionOptions();
        pigeonReturn.setMaxWidth(maxWidth);
        pigeonReturn.setMaxHeight(maxHeight);
        pigeonReturn.setQuality(quality);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<>(3);
      toListResult.add(maxWidth);
      toListResult.add(maxHeight);
      toListResult.add(quality);
      return toListResult;
    }

    static @NonNull ImageSelectionOptions fromList(@NonNull ArrayList<Object> pigeonVar_list) {
      ImageSelectionOptions pigeonResult = new ImageSelectionOptions();
      Object maxWidth = pigeonVar_list.get(0);
      pigeonResult.setMaxWidth((Double) maxWidth);
      Object maxHeight = pigeonVar_list.get(1);
      pigeonResult.setMaxHeight((Double) maxHeight);
      Object quality = pigeonVar_list.get(2);
      pigeonResult.setQuality((Long) quality);
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class MediaSelectionOptions {
    private @NonNull ImageSelectionOptions imageSelectionOptions;

    public @NonNull ImageSelectionOptions getImageSelectionOptions() {
      return imageSelectionOptions;
    }

    public void setImageSelectionOptions(@NonNull ImageSelectionOptions setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"imageSelectionOptions\" is null.");
      }
      this.imageSelectionOptions = setterArg;
    }

    /** Constructor is non-public to enforce null safety; use Builder. */
    MediaSelectionOptions() {}

    @Override
    public boolean equals(Object o) {
      if (this == o) {
        return true;
      }
      if (o == null || getClass() != o.getClass()) {
        return false;
      }
      MediaSelectionOptions that = (MediaSelectionOptions) o;
      return imageSelectionOptions.equals(that.imageSelectionOptions);
    }

    @Override
    public int hashCode() {
      return Objects.hash(imageSelectionOptions);
    }

    public static final class Builder {

      private @Nullable ImageSelectionOptions imageSelectionOptions;

      @CanIgnoreReturnValue
      public @NonNull Builder setImageSelectionOptions(@NonNull ImageSelectionOptions setterArg) {
        this.imageSelectionOptions = setterArg;
        return this;
      }

      public @NonNull MediaSelectionOptions build() {
        MediaSelectionOptions pigeonReturn = new MediaSelectionOptions();
        pigeonReturn.setImageSelectionOptions(imageSelectionOptions);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<>(1);
      toListResult.add(imageSelectionOptions);
      return toListResult;
    }

    static @NonNull MediaSelectionOptions fromList(@NonNull ArrayList<Object> pigeonVar_list) {
      MediaSelectionOptions pigeonResult = new MediaSelectionOptions();
      Object imageSelectionOptions = pigeonVar_list.get(0);
      pigeonResult.setImageSelectionOptions((ImageSelectionOptions) imageSelectionOptions);
      return pigeonResult;
    }
  }

  /**
   * Options for image selection and output.
   *
   * <p>Generated class from Pigeon that represents data sent in messages.
   */
  public static final class VideoSelectionOptions {
    /** The maximum desired length for the video, in seconds. */
    private @Nullable Long maxDurationSeconds;

    public @Nullable Long getMaxDurationSeconds() {
      return maxDurationSeconds;
    }

    public void setMaxDurationSeconds(@Nullable Long setterArg) {
      this.maxDurationSeconds = setterArg;
    }

    @Override
    public boolean equals(Object o) {
      if (this == o) {
        return true;
      }
      if (o == null || getClass() != o.getClass()) {
        return false;
      }
      VideoSelectionOptions that = (VideoSelectionOptions) o;
      return Objects.equals(maxDurationSeconds, that.maxDurationSeconds);
    }

    @Override
    public int hashCode() {
      return Objects.hash(maxDurationSeconds);
    }

    public static final class Builder {

      private @Nullable Long maxDurationSeconds;

      @CanIgnoreReturnValue
      public @NonNull Builder setMaxDurationSeconds(@Nullable Long setterArg) {
        this.maxDurationSeconds = setterArg;
        return this;
      }

      public @NonNull VideoSelectionOptions build() {
        VideoSelectionOptions pigeonReturn = new VideoSelectionOptions();
        pigeonReturn.setMaxDurationSeconds(maxDurationSeconds);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<>(1);
      toListResult.add(maxDurationSeconds);
      return toListResult;
    }

    static @NonNull VideoSelectionOptions fromList(@NonNull ArrayList<Object> pigeonVar_list) {
      VideoSelectionOptions pigeonResult = new VideoSelectionOptions();
      Object maxDurationSeconds = pigeonVar_list.get(0);
      pigeonResult.setMaxDurationSeconds((Long) maxDurationSeconds);
      return pigeonResult;
    }
  }

  /**
   * Specification for the source of an image or video selection.
   *
   * <p>Generated class from Pigeon that represents data sent in messages.
   */
  public static final class SourceSpecification {
    private @NonNull SourceType type;

    public @NonNull SourceType getType() {
      return type;
    }

    public void setType(@NonNull SourceType setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"type\" is null.");
      }
      this.type = setterArg;
    }

    private @Nullable SourceCamera camera;

    public @Nullable SourceCamera getCamera() {
      return camera;
    }

    public void setCamera(@Nullable SourceCamera setterArg) {
      this.camera = setterArg;
    }

    /** Constructor is non-public to enforce null safety; use Builder. */
    SourceSpecification() {}

    @Override
    public boolean equals(Object o) {
      if (this == o) {
        return true;
      }
      if (o == null || getClass() != o.getClass()) {
        return false;
      }
      SourceSpecification that = (SourceSpecification) o;
      return type.equals(that.type) && Objects.equals(camera, that.camera);
    }

    @Override
    public int hashCode() {
      return Objects.hash(type, camera);
    }

    public static final class Builder {

      private @Nullable SourceType type;

      @CanIgnoreReturnValue
      public @NonNull Builder setType(@NonNull SourceType setterArg) {
        this.type = setterArg;
        return this;
      }

      private @Nullable SourceCamera camera;

      @CanIgnoreReturnValue
      public @NonNull Builder setCamera(@Nullable SourceCamera setterArg) {
        this.camera = setterArg;
        return this;
      }

      public @NonNull SourceSpecification build() {
        SourceSpecification pigeonReturn = new SourceSpecification();
        pigeonReturn.setType(type);
        pigeonReturn.setCamera(camera);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<>(2);
      toListResult.add(type);
      toListResult.add(camera);
      return toListResult;
    }

    static @NonNull SourceSpecification fromList(@NonNull ArrayList<Object> pigeonVar_list) {
      SourceSpecification pigeonResult = new SourceSpecification();
      Object type = pigeonVar_list.get(0);
      pigeonResult.setType((SourceType) type);
      Object camera = pigeonVar_list.get(1);
      pigeonResult.setCamera((SourceCamera) camera);
      return pigeonResult;
    }
  }

  /**
   * An error that occurred during lost result retrieval.
   *
   * <p>The data here maps to the `PlatformException` that will be created from it.
   *
   * <p>Generated class from Pigeon that represents data sent in messages.
   */
  public static final class CacheRetrievalError {
    private @NonNull String code;

    public @NonNull String getCode() {
      return code;
    }

    public void setCode(@NonNull String setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"code\" is null.");
      }
      this.code = setterArg;
    }

    private @Nullable String message;

    public @Nullable String getMessage() {
      return message;
    }

    public void setMessage(@Nullable String setterArg) {
      this.message = setterArg;
    }

    /** Constructor is non-public to enforce null safety; use Builder. */
    CacheRetrievalError() {}

    @Override
    public boolean equals(Object o) {
      if (this == o) {
        return true;
      }
      if (o == null || getClass() != o.getClass()) {
        return false;
      }
      CacheRetrievalError that = (CacheRetrievalError) o;
      return code.equals(that.code) && Objects.equals(message, that.message);
    }

    @Override
    public int hashCode() {
      return Objects.hash(code, message);
    }

    public static final class Builder {

      private @Nullable String code;

      @CanIgnoreReturnValue
      public @NonNull Builder setCode(@NonNull String setterArg) {
        this.code = setterArg;
        return this;
      }

      private @Nullable String message;

      @CanIgnoreReturnValue
      public @NonNull Builder setMessage(@Nullable String setterArg) {
        this.message = setterArg;
        return this;
      }

      public @NonNull CacheRetrievalError build() {
        CacheRetrievalError pigeonReturn = new CacheRetrievalError();
        pigeonReturn.setCode(code);
        pigeonReturn.setMessage(message);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<>(2);
      toListResult.add(code);
      toListResult.add(message);
      return toListResult;
    }

    static @NonNull CacheRetrievalError fromList(@NonNull ArrayList<Object> pigeonVar_list) {
      CacheRetrievalError pigeonResult = new CacheRetrievalError();
      Object code = pigeonVar_list.get(0);
      pigeonResult.setCode((String) code);
      Object message = pigeonVar_list.get(1);
      pigeonResult.setMessage((String) message);
      return pigeonResult;
    }
  }

  /**
   * The result of retrieving cached results from a previous run.
   *
   * <p>Generated class from Pigeon that represents data sent in messages.
   */
  public static final class CacheRetrievalResult {
    /** The type of the retrieved data. */
    private @NonNull CacheRetrievalType type;

    public @NonNull CacheRetrievalType getType() {
      return type;
    }

    public void setType(@NonNull CacheRetrievalType setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"type\" is null.");
      }
      this.type = setterArg;
    }

    /** The error from the last selection, if any. */
    private @Nullable CacheRetrievalError error;

    public @Nullable CacheRetrievalError getError() {
      return error;
    }

    public void setError(@Nullable CacheRetrievalError setterArg) {
      this.error = setterArg;
    }

    /** The results from the last selection, if any. */
    private @NonNull List<String> paths;

    public @NonNull List<String> getPaths() {
      return paths;
    }

    public void setPaths(@NonNull List<String> setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"paths\" is null.");
      }
      this.paths = setterArg;
    }

    /** Constructor is non-public to enforce null safety; use Builder. */
    CacheRetrievalResult() {}

    @Override
    public boolean equals(Object o) {
      if (this == o) {
        return true;
      }
      if (o == null || getClass() != o.getClass()) {
        return false;
      }
      CacheRetrievalResult that = (CacheRetrievalResult) o;
      return type.equals(that.type)
          && Objects.equals(error, that.error)
          && paths.equals(that.paths);
    }

    @Override
    public int hashCode() {
      return Objects.hash(type, error, paths);
    }

    public static final class Builder {

      private @Nullable CacheRetrievalType type;

      @CanIgnoreReturnValue
      public @NonNull Builder setType(@NonNull CacheRetrievalType setterArg) {
        this.type = setterArg;
        return this;
      }

      private @Nullable CacheRetrievalError error;

      @CanIgnoreReturnValue
      public @NonNull Builder setError(@Nullable CacheRetrievalError setterArg) {
        this.error = setterArg;
        return this;
      }

      private @Nullable List<String> paths;

      @CanIgnoreReturnValue
      public @NonNull Builder setPaths(@NonNull List<String> setterArg) {
        this.paths = setterArg;
        return this;
      }

      public @NonNull CacheRetrievalResult build() {
        CacheRetrievalResult pigeonReturn = new CacheRetrievalResult();
        pigeonReturn.setType(type);
        pigeonReturn.setError(error);
        pigeonReturn.setPaths(paths);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<>(3);
      toListResult.add(type);
      toListResult.add(error);
      toListResult.add(paths);
      return toListResult;
    }

    static @NonNull CacheRetrievalResult fromList(@NonNull ArrayList<Object> pigeonVar_list) {
      CacheRetrievalResult pigeonResult = new CacheRetrievalResult();
      Object type = pigeonVar_list.get(0);
      pigeonResult.setType((CacheRetrievalType) type);
      Object error = pigeonVar_list.get(1);
      pigeonResult.setError((CacheRetrievalError) error);
      Object paths = pigeonVar_list.get(2);
      pigeonResult.setPaths((List<String>) paths);
      return pigeonResult;
    }
  }

  private static class PigeonCodec extends StandardMessageCodec {
    public static final PigeonCodec INSTANCE = new PigeonCodec();

    private PigeonCodec() {}

    @Override
    protected Object readValueOfType(byte type, @NonNull ByteBuffer buffer) {
      switch (type) {
        case (byte) 129:
          {
            Object value = readValue(buffer);
            return value == null ? null : SourceCamera.values()[((Long) value).intValue()];
          }
        case (byte) 130:
          {
            Object value = readValue(buffer);
            return value == null ? null : SourceType.values()[((Long) value).intValue()];
          }
        case (byte) 131:
          {
            Object value = readValue(buffer);
            return value == null ? null : CacheRetrievalType.values()[((Long) value).intValue()];
          }
        case (byte) 132:
          return GeneralOptions.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 133:
          return ImageSelectionOptions.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 134:
          return MediaSelectionOptions.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 135:
          return VideoSelectionOptions.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 136:
          return SourceSpecification.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 137:
          return CacheRetrievalError.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 138:
          return CacheRetrievalResult.fromList((ArrayList<Object>) readValue(buffer));
        default:
          return super.readValueOfType(type, buffer);
      }
    }

    @Override
    protected void writeValue(@NonNull ByteArrayOutputStream stream, Object value) {
      if (value instanceof SourceCamera) {
        stream.write(129);
        writeValue(stream, value == null ? null : ((SourceCamera) value).index);
      } else if (value instanceof SourceType) {
        stream.write(130);
        writeValue(stream, value == null ? null : ((SourceType) value).index);
      } else if (value instanceof CacheRetrievalType) {
        stream.write(131);
        writeValue(stream, value == null ? null : ((CacheRetrievalType) value).index);
      } else if (value instanceof GeneralOptions) {
        stream.write(132);
        writeValue(stream, ((GeneralOptions) value).toList());
      } else if (value instanceof ImageSelectionOptions) {
        stream.write(133);
        writeValue(stream, ((ImageSelectionOptions) value).toList());
      } else if (value instanceof MediaSelectionOptions) {
        stream.write(134);
        writeValue(stream, ((MediaSelectionOptions) value).toList());
      } else if (value instanceof VideoSelectionOptions) {
        stream.write(135);
        writeValue(stream, ((VideoSelectionOptions) value).toList());
      } else if (value instanceof SourceSpecification) {
        stream.write(136);
        writeValue(stream, ((SourceSpecification) value).toList());
      } else if (value instanceof CacheRetrievalError) {
        stream.write(137);
        writeValue(stream, ((CacheRetrievalError) value).toList());
      } else if (value instanceof CacheRetrievalResult) {
        stream.write(138);
        writeValue(stream, ((CacheRetrievalResult) value).toList());
      } else {
        super.writeValue(stream, value);
      }
    }
  }

  /** Asynchronous error handling return type for non-nullable API method returns. */
  public interface Result<T> {
    /** Success case callback method for handling returns. */
    void success(@NonNull T result);

    /** Failure case callback method for handling errors. */
    void error(@NonNull Throwable error);
  }
  /** Asynchronous error handling return type for nullable API method returns. */
  public interface NullableResult<T> {
    /** Success case callback method for handling returns. */
    void success(@Nullable T result);

    /** Failure case callback method for handling errors. */
    void error(@NonNull Throwable error);
  }
  /** Asynchronous error handling return type for void API method returns. */
  public interface VoidResult {
    /** Success case callback method for handling returns. */
    void success();

    /** Failure case callback method for handling errors. */
    void error(@NonNull Throwable error);
  }
  /** Generated interface from Pigeon that represents a handler of messages from Flutter. */
  public interface ImagePickerApi {
    /** Selects images and returns their paths. */
    void pickImages(
        @NonNull SourceSpecification source,
        @NonNull ImageSelectionOptions options,
        @NonNull GeneralOptions generalOptions,
        @NonNull Result<List<String>> result);
    /** Selects video and returns their paths. */
    void pickVideos(
        @NonNull SourceSpecification source,
        @NonNull VideoSelectionOptions options,
        @NonNull GeneralOptions generalOptions,
        @NonNull Result<List<String>> result);
    /** Selects images and videos and returns their paths. */
    void pickMedia(
        @NonNull MediaSelectionOptions mediaSelectionOptions,
        @NonNull GeneralOptions generalOptions,
        @NonNull Result<List<String>> result);
    /** Returns results from a previous app session, if any. */
    @Nullable
    CacheRetrievalResult retrieveLostResults();

    /** The codec used by ImagePickerApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return PigeonCodec.INSTANCE;
    }
    /** Sets up an instance of `ImagePickerApi` to handle messages through the `binaryMessenger`. */
    static void setUp(@NonNull BinaryMessenger binaryMessenger, @Nullable ImagePickerApi api) {
      setUp(binaryMessenger, "", api);
    }

    static void setUp(
        @NonNull BinaryMessenger binaryMessenger,
        @NonNull String messageChannelSuffix,
        @Nullable ImagePickerApi api) {
      messageChannelSuffix = messageChannelSuffix.isEmpty() ? "" : "." + messageChannelSuffix;
      BinaryMessenger.TaskQueue taskQueue = binaryMessenger.makeBackgroundTaskQueue();
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.image_picker_android.ImagePickerApi.pickImages"
                    + messageChannelSuffix,
                getCodec(),
                taskQueue);
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                SourceSpecification sourceArg = (SourceSpecification) args.get(0);
                ImageSelectionOptions optionsArg = (ImageSelectionOptions) args.get(1);
                GeneralOptions generalOptionsArg = (GeneralOptions) args.get(2);
                Result<List<String>> resultCallback =
                    new Result<List<String>>() {
                      public void success(List<String> result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.pickImages(sourceArg, optionsArg, generalOptionsArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.image_picker_android.ImagePickerApi.pickVideos"
                    + messageChannelSuffix,
                getCodec(),
                taskQueue);
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                SourceSpecification sourceArg = (SourceSpecification) args.get(0);
                VideoSelectionOptions optionsArg = (VideoSelectionOptions) args.get(1);
                GeneralOptions generalOptionsArg = (GeneralOptions) args.get(2);
                Result<List<String>> resultCallback =
                    new Result<List<String>>() {
                      public void success(List<String> result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.pickVideos(sourceArg, optionsArg, generalOptionsArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.image_picker_android.ImagePickerApi.pickMedia"
                    + messageChannelSuffix,
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                MediaSelectionOptions mediaSelectionOptionsArg =
                    (MediaSelectionOptions) args.get(0);
                GeneralOptions generalOptionsArg = (GeneralOptions) args.get(1);
                Result<List<String>> resultCallback =
                    new Result<List<String>>() {
                      public void success(List<String> result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.pickMedia(mediaSelectionOptionsArg, generalOptionsArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.image_picker_android.ImagePickerApi.retrieveLostResults"
                    + messageChannelSuffix,
                getCodec(),
                taskQueue);
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                try {
                  CacheRetrievalResult output = api.retrieveLostResults();
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }
}
