// Copyright (c) 2014, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source is governed by a
// BSD-style license that can be found in the LICENSE file

/// "Horizontal Tab" control character, common name.
const int $tab = 0x09;

/// "Line feed" control character.
const int $lf = 0x0A;

/// "Vertical Tab" control character.
const int $vt = 0x0B;

/// "Form feed" control character.
const int $ff = 0x0C;

/// "Carriage return" control character.
const int $cr = 0x0D;

/// Space character.
const int $space = 0x20;

/// Character `!`.
const int $exclamation = 0x21;

/// Character `"`.
const int $quote = 0x22;

/// Character `"`.
const int $double_quote = 0x22; // ignore: constant_identifier_names

/// Character `#`.
const int $hash = 0x23;

/// Character `$`.
const int $dollar = 0x24;

/// Character `%`.
const int $percent = 0x25;

/// Character `&`.
const int $ampersand = 0x26;

/// Character `'`.
const int $apostrophe = 0x27;

/// Character `(`.
const int $lparen = 0x28;

/// Character `)`.
const int $rparen = 0x29;

/// Character `*`.
const int $asterisk = 0x2A;

/// Character `+`.
const int $plus = 0x2B;

/// Character `,`.
const int $comma = 0x2C;

/// Character `-`.
const int $dash = 0x2D;

/// Character `.`.
const int $dot = 0x2E;

/// Character `/`.
const int $slash = 0x2F;

/// Character `:`.
const int $colon = 0x3A;

/// Character `;`.
const int $semicolon = 0x3B;

/// Character `<`.
const int $lt = 0x3C;

/// Character `=`.
const int $equal = 0x3D;

/// Character `>`.
const int $gt = 0x3E;

/// Character `?`.
const int $question = 0x3F;

/// Character `@`.
const int $at = 0x40;

/// Character `[`.
const int $lbracket = 0x5B;

/// Character `\`.
const int $backslash = 0x5C;

/// Character `]`.
const int $rbracket = 0x5D;

/// Character `^`.
const int $caret = 0x5E;

/// Character `_`.
const int $underscore = 0x5F;

/// Character `` ` ``.
const int $backquote = 0x60;

/// Character `{`.
const int $lbrace = 0x7B;

/// Character `|`.
const int $pipe = 0x7C;

/// Character `|`.
const int $bar = 0x7C;

/// Character `}`.
const int $rbrace = 0x7D;

/// Character `~`.
const int $tilde = 0x7E;
