/*
 * Copyright (C) 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.content.om;

import android.os.Parcel;
import android.os.Parcelable;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

/**
 * A key used to uniquely identify a Runtime Resource Overlay (RRO).
 *
 * An overlay always belongs to a package and may optionally have a name associated with it.
 * The name helps uniquely identify a particular overlay within a package.
 * @hide
 */
/** @hide */
public class OverlayIdentifier implements Parcelable  {

    /**
     * Creates an identifier from a package and unique name within the package.
     *
     * @param packageName the package containing or owning the overlay
     * @param overlayName the unique name of the overlay within the package
     */
    public OverlayIdentifier(@NonNull String packageName, @Nullable String overlayName) {
        throw new RuntimeException("Stub!");
    }

    /**
     * Creates an identifier for an overlay without a name.
     *
     * @param packageName the package containing or owning the overlay
     */
    public OverlayIdentifier(@NonNull String packageName) {
        throw new RuntimeException("Stub!");
    }

    @Override
    public String toString() {
        throw new RuntimeException("Stub!");
    }

    /** @hide */
    public static OverlayIdentifier fromString(@NonNull String text) {
        throw new RuntimeException("Stub!");
    }



    // Code below generated by codegen v1.0.22.
    //
    // DO NOT MODIFY!
    // CHECKSTYLE:OFF Generated code
    //
    // To regenerate run:
    // $ codegen $ANDROID_BUILD_TOP/frameworks/base/core/java/android/content/om/OverlayIdentifier.java
    //
    // To exclude the generated code from IntelliJ auto-formatting enable (one-time):
    //   Settings > Editor > Code Style > Formatter Control
    //@formatter:off


    /**
     * Retrieves the package name containing or owning the overlay.
     */
    public @Nullable String getPackageName() {
        throw new RuntimeException("Stub!");
    }

    /**
     * Retrieves the unique name within the package of the overlay.
     */
    public @Nullable String getOverlayName() {
        throw new RuntimeException("Stub!");
    }

    @Override
    public boolean equals(@Nullable Object o) {
        throw new RuntimeException("Stub!");
    }

    @Override
    public int hashCode() {
        throw new RuntimeException("Stub!");
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        throw new RuntimeException("Stub!");
    }

    @Override
    public int describeContents() {
        throw new RuntimeException("Stub!");
    }

    /** @hide */
    @SuppressWarnings({"unchecked", "RedundantCast"})
    protected OverlayIdentifier(@NonNull Parcel in) {
        throw new RuntimeException("Stub!");
    }


    public static final @NonNull Parcelable.Creator<OverlayIdentifier> CREATOR
            = new Parcelable.Creator<OverlayIdentifier>() {
        @Override
        public OverlayIdentifier[] newArray(int size) {
            return new OverlayIdentifier[size];
        }

        @Override
        public OverlayIdentifier createFromParcel(@NonNull Parcel in) {
            return new OverlayIdentifier(in);
        }
    };

    @Deprecated
    private void __metadata() {}


    //@formatter:on
    // End of generated code

}