package com.dozingcatsoftware.vectorpinball.fields;

public class StarData {
    // From https://github.com/sky-map-team/stardroid/blob/master/tools/data/stardata_names.txt
    // Concatenated triples of declination (degrees), right ascension (degrees), magnitude.
    static final double[] STAR_DATA = {
            -16.71, 101.25, -1.43,
            -52.70,  96.00, -0.62,
            19.19, 213.90, -0.10,
            -60.84, 219.90,  0.01,
            38.78, 279.30,  0.03,
            -8.20,  78.60,  0.18,
            5.23, 114.90,  0.38,
            7.41,  88.80,  0.45,
            -57.24,  24.45,  0.45,
            -60.37, 210.90,  0.61,
            46.00,  79.20,  0.71,
            8.87, 297.75,  0.77,
            -63.10, 186.60,  0.77,
            16.51,  69.00,  0.85,
            46.01,  79.20,  0.96,
            -11.16, 201.30,  0.98,
            -26.43, 247.35,  1.06,
            28.03, 116.40,  1.14,
            -29.62, 344.40,  1.16,
            45.28, 310.35,  1.25,
            -59.69, 192.00,  1.25,
            -60.84, 219.90,  1.34,
            11.97, 152.10,  1.36,
            -28.97, 104.70,  1.50,
            -57.11, 187.80,  1.59,
            -37.10, 263.40,  1.62,
            6.35,  81.30,  1.64,
            28.61,  81.60,  1.65,
            -69.72, 138.30,  1.67,
            -1.20,  84.00,  1.69,
            -46.96, 332.10,  1.74,
            -1.94,  85.20,  1.74,
            -47.34, 122.40,  1.75,
            55.96, 193.50,  1.76,
            49.86,  51.15,  1.79,
            -34.38, 276.00,  1.79,
            61.75, 165.90,  1.81,
            -26.39, 107.10,  1.83,
            49.31, 206.85,  1.85,
            -59.51, 125.70,  1.86,
            -43.00, 264.30,  1.86,
            44.95,  89.85,  1.90,
            -69.03, 252.15,  1.91,
            16.40,  99.45,  1.93,
            -56.73, 306.45,  1.94,
            31.89, 113.70,  1.94,
            89.26,  37.95,  1.97,
            -17.96,  95.70,  1.98,
            -8.66, 141.90,  1.99,
            23.46,  31.80,  2.00,
            19.84, 154.95,  2.01,
            -54.71, 131.25,  2.02,
            -17.99,  10.95,  2.04,
            -26.30, 283.80,  2.05,
            35.62,  17.40,  2.05,
            -36.37, 211.65,  2.06,
            29.09,   2.10,  2.07,
            -46.88, 340.65,  2.07,
            -9.67,  87.00,  2.07,
            74.16, 222.75,  2.07,
            12.56, 263.70,  2.08,
            40.96,  47.10,  2.09,
            42.33,  30.90,  2.10,
            14.57, 177.30,  2.14,
            60.72,  14.25,  2.15,
            -48.96, 190.35,  2.20,
            -59.28, 139.20,  2.21,
            -40.00, 120.90,  2.21,
            26.71, 233.70,  2.22,
            40.26, 305.55,  2.23,
            -43.43, 136.95,  2.23,
            51.49, 269.10,  2.24,
            56.54,  10.20,  2.24,
            54.93, 201.00,  2.25,
            -0.30,  82.95,  2.25,
            59.15,   2.25,  2.27,
            -53.47, 204.90,  2.29,
            -34.29, 252.60,  2.29,
            -22.62, 240.15,  2.29,
            -47.39, 220.50,  2.30,
            -42.16, 218.85,  2.33,
            27.07, 221.25,  2.35,
            56.38, 165.45,  2.37,
            9.88, 326.10,  2.38,
            -39.03, 265.65,  2.39,
            -42.31,   6.60,  2.40,
            53.69, 178.50,  2.41,
            62.59, 319.65,  2.44,
            28.08, 345.90,  2.44,
            33.97, 311.55,  2.45,
            -29.30, 111.00,  2.45,
            -55.01, 140.55,  2.47,
            15.21, 346.20,  2.49,
            -10.57, 249.30,  2.54,
            4.09,  45.60,  2.54,
            -47.29, 208.95,  2.55,
            -19.81, 241.35,  2.56,
            20.52, 168.60,  2.56,
            -17.82,  83.25,  2.58,
            -17.54, 183.90,  2.58,
            -50.72, 182.10,  2.58,
            -29.88, 285.60,  2.60,
            -9.38, 229.20,  2.61,
            20.81,  28.65,  2.64,
            6.43, 236.10,  2.64,
            37.21,  90.00,  2.65,
            -34.07,  84.90,  2.65,
            -23.40, 188.55,  2.65,
            60.24,  21.45,  2.66,
            -43.13, 224.70,  2.68,
            18.40, 208.65,  2.68,
            33.17,  74.25,  2.69,
            -69.14, 189.30,  2.69,
            -49.42, 161.70,  2.69,
            -37.30, 262.65,  2.70,
            -37.10, 109.35,  2.71,
            10.61, 296.55,  2.72,
            -29.83, 275.25,  2.72,
            -3.69, 243.60,  2.73,
            61.51, 246.00,  2.74,
            -64.39, 160.80,  2.74,
            -36.71, 200.10,  2.75,
            -16.04, 222.75,  2.75,
            -5.91,  83.85,  2.75,
            4.57, 265.80,  2.76,
            21.49, 247.50,  2.78,
            14.39, 258.60,  2.78,
            -5.09,  76.95,  2.79,
            52.30, 262.65,  2.79,
            -58.75, 183.75,  2.79,
            -41.17, 233.85,  2.80,
            -77.26,   6.45,  2.80,
            -20.76,  82.05,  2.81,
            -28.22, 249.00,  2.82,
            -25.42, 277.05,  2.82,
            -24.30, 121.95,  2.83,
            15.18,   3.30,  2.83,
            31.88,  58.50,  2.84,
            -63.43, 238.80,  2.84,
            -55.53, 261.30,  2.84,
            -49.88, 262.95,  2.84,
            10.96, 195.60,  2.85,
            24.11,  56.85,  2.85,
            31.89, 113.70,  2.85,
            45.13, 296.25,  2.86,
            -61.57,  29.70,  2.86,
            22.51,  95.70,  2.87,
            -68.68, 229.80,  2.87,
            -16.13, 326.70,  2.87,
            -60.26, 334.65,  2.87,
            -21.02, 287.40,  2.88,
            -40.30,  44.55,  2.88,
            -26.11, 239.70,  2.89,
            38.32, 193.95,  2.89,
            8.29, 111.75,  2.89,
            -5.57, 322.95,  2.90,
            -25.59, 245.25,  2.90,
            40.01,  59.40,  2.90,
            53.51,  46.20,  2.91,
            31.60, 250.35,  2.91,
            -65.07, 146.85,  2.92,
            30.22, 340.80,  2.93,
            -50.61, 102.45,  2.94,
            -16.52, 187.50,  2.94,
            -0.32, 331.50,  2.95,
            -13.51,  59.55,  2.97,
            21.14,  84.45,  2.97,
            23.77, 146.40,  2.97,
            -30.42, 271.50,  2.98,
            -23.17, 199.80,  2.99,
            13.86, 286.35,  2.99,
            -40.13, 266.85,  2.99,
            34.99,  32.40,  3.00,
            -37.36, 328.50,  3.00,
            71.83, 230.25,  3.00,
            -38.05, 252.90,  3.00,
            44.50, 167.40,  3.00,
            47.79,  55.80,  3.01,
            -15.73, 257.55,  3.02,
            -23.83, 105.75,  3.02,
            -30.06,  95.10,  3.02,
            -22.62, 182.55,  3.02,
            43.82,  75.45,  3.03,
            38.31, 217.95,  3.04,
            -68.11, 191.55,  3.04,
            -14.78, 305.25,  3.05,
            27.96, 292.65,  3.05,
            25.13, 100.95,  3.06,
            41.50, 155.55,  3.06,
            67.66, 288.15,  3.07,
            -36.76, 274.35,  3.10,
            -63.02, 174.00,  3.11,
            5.95, 133.80,  3.11,
            -47.29, 309.45,  3.11,
            -16.19, 162.45,  3.11,
            -55.99, 254.70,  3.12,
            -35.77,  87.75,  3.12,
            -42.10, 224.85,  3.13,
            24.84, 258.75,  3.14,
            34.39, 140.25,  3.14,
            48.04, 134.85,  3.14,
            36.81, 258.75,  3.16,
            -57.03, 142.80,  3.16,
            65.71, 257.25,  3.17,
            51.68, 143.25,  3.17,
            -26.99, 281.40,  3.17,
            -43.20,  99.45,  3.17,
            41.23,  76.65,  3.18,
            -22.37,  76.35,  3.19,
            -37.04, 267.45,  3.19,
            -64.97, 220.65,  3.19,
            9.38, 254.40,  3.19,
            6.96,  72.45,  3.19,
            77.63, 354.90,  3.21,
            30.23, 318.30,  3.21,
            -40.65, 230.40,  3.22,
            70.56, 322.20,  3.23,
            -0.82, 302.85,  3.24,
            -4.69, 244.65,  3.24,
            -43.30, 112.35,  3.25,
            -25.28, 226.05,  3.25,
            32.69, 284.70,  3.25,
            -2.90, 275.40,  3.26,
            -74.24,  56.85,  3.26,
            -15.82, 343.65,  3.27,
            -26.68, 211.65,  3.27,
            -25.00, 260.55,  3.27,
            30.86,   9.90,  3.27,
            -61.94, 102.00,  3.27,
            -70.04, 153.45,  3.29,
            58.97, 231.30,  3.29,
            -16.21,  78.30,  3.29,
            -55.05,  68.55,  3.30,
            57.03, 183.90,  3.30,
            -61.69, 157.95,  3.30,
            22.51,  93.75,  3.31,
            -56.38, 261.30,  3.31,
            38.84,  46.35,  3.32,
            -46.72,  16.50,  3.32,
            -9.77, 269.70,  3.32,
            -27.67, 286.80,  3.32,
            15.43, 168.60,  3.33,
            -43.24, 258.00,  3.33,
            -62.47,  63.60,  3.33,
            -24.86, 117.30,  3.34,
            60.72, 127.50,  3.35,
            63.67,  28.65,  3.35,
            -2.40,  81.15,  3.35,
            12.90, 101.25,  3.36,
            3.11, 291.30,  3.36,
            -0.60, 203.70,  3.37,
            -44.69, 230.70,  3.37,
            6.42, 131.70,  3.38,
            9.93,  83.85,  3.39,
            3.40, 193.95,  3.39,
            -61.33, 154.20,  3.39,
            58.20, 332.70,  3.39,
            15.87,  67.20,  3.40,
            -15.73, 257.55,  3.40,
            -41.69, 207.45,  3.41,
            -43.32,  22.05,  3.41,
            -52.10, 228.00,  3.41,
            12.49,  60.15,  3.41,
            10.83, 340.35,  3.41,
            29.58,  28.20,  3.42,
            -66.20, 311.25,  3.42,
            27.72, 266.55,  3.42,
            -38.40, 240.00,  3.42,
            -58.97, 137.70,  3.43,
            23.42, 154.20,  3.43,
            -4.88, 286.50,  3.43,
            61.84, 311.25,  3.43,
            -10.18,  17.10,  3.45,
            42.91, 154.20,  3.45,
            57.82,  12.30,  3.45,
            -52.98, 119.25,  3.46,
            33.32, 228.90,  3.46,
            -1.45, 190.35,  3.46,
            -42.47, 207.45,  3.47,
            38.92, 250.65,  3.48,
            -51.32, 342.15,  3.48,
            16.76, 151.80,  3.48,
            24.60, 342.45,  3.48,
            33.09, 169.65,  3.49,
            -27.93, 105.45,  3.49,
            40.39, 225.45,  3.49,
            -15.94,  25.95,  3.49,
            -45.97, 276.75,  3.49,
            66.20, 342.45,  3.50,
            -32.51, 102.45,  3.50,
            19.49, 299.70,  3.51,
            -21.11, 284.40,  3.52,
            -1.45, 190.35,  3.52,
            33.36, 282.45,  3.52,
            -54.57, 149.25,  3.52,
            9.89, 145.35,  3.52,
            -9.77,  55.80,  3.53,
            19.18,  67.20,  3.53,
            21.98, 110.10,  3.53,
            6.20, 332.55,  3.53,
            9.19, 124.20,  3.53,
            -15.40, 264.45,  3.54,
            -3.43, 237.45,  3.54,
            -31.86, 173.25,  3.54,
            -14.82,  86.70,  3.55,
            -33.80,  64.50,  3.55,
            -46.06, 214.80,  3.55,
            -8.82,   4.80,  3.56,
            -38.02, 253.05,  3.56,
            -51.51,  34.20,  3.56,
            3.24,  40.80,  3.56,
            -14.78, 169.80,  3.56,
            -66.18, 302.10,  3.56,
            -36.26, 230.40,  3.57,
            30.37, 217.95,  3.57,
            47.16, 135.90,  3.57,
            72.73, 275.25,  3.57,
            24.40, 116.10,  3.57,
            -12.54, 304.50,  3.58,
            -22.45,  86.10,  3.58,
            16.54, 109.50,  3.58,
            48.63,  24.45,  3.59,
            -6.84,  79.35,  3.59,
            -60.40, 185.40,  3.59,
            -60.68, 262.80,  3.60,
            -52.92, 130.05,  3.60,
            33.96, 103.20,  3.60,
            -8.18,  21.00,  3.60,
            -28.14, 234.30,  3.60,
            -64.72, 266.40,  3.61,
            -71.55, 195.60,  3.61,
            -12.35, 152.70,  3.61,
            9.03,  51.15,  3.61,
            27.26,  42.45,  3.61,
            1.77, 177.60,  3.61,
            24.05,  57.30,  3.62,
            15.35,  22.80,  3.62,
            -37.97, 116.25,  3.62,
            -42.36, 253.65,  3.62,
            42.33, 345.45,  3.62,
            -66.73, 176.40,  3.63,
            14.60, 309.45,  3.64,
            15.42, 236.55,  3.65,
            -50.09, 271.65,  3.65,
            -0.02, 337.20,  3.65,
            15.63,  64.95,  3.65,
            29.11, 231.90,  3.66,
            -29.78, 234.60,  3.66,
            63.06, 142.95,  3.67,
            64.38, 211.05,  3.67,
            -58.45, 313.65,  3.67,
            5.61,  72.75,  3.68,
            -21.17, 347.40,  3.68,
            -33.19, 130.95,  3.68,
            -16.66, 325.05,  3.68,
            18.53, 296.85,  3.68,
            41.08,  75.60,  3.69,
            47.78, 176.55,  3.69,
            -62.51, 146.25,  3.69,
            53.90,   9.30,  3.69,
            -21.76,  49.95,  3.70,
            29.25, 269.40,  3.70,
            3.28, 349.35,  3.70,
            -51.61,  28.95,  3.70,
            4.48, 237.75,  3.71,
            2.44,  73.50,  3.71,
            -40.58, 118.05,  3.71,
            24.11,  56.25,  3.72,
            6.41, 298.80,  3.72,
            54.28,  89.85,  3.72,
            -14.17,  89.10,  3.72,
            43.93, 316.20,  3.72,
            9.56, 271.80,  3.73,
            56.87, 268.35,  3.73,
            -7.58, 343.20,  3.73,
            9.73,  51.75,  3.73,
            1.89, 221.55,  3.73,
            -9.46,  53.25,  3.73,
            19.15, 245.55,  3.74,
            -10.33,  27.90,  3.74,
            -47.10, 136.05,  3.75,
            -77.39, 325.35,  3.75,
            2.71, 267.00,  3.75,
            -62.49,  83.40,  3.76,
            -20.88,  87.90,  3.76,
            -66.14, 126.45,  3.76,
            -7.03,  97.20,  3.76,
            50.28, 337.80,  3.76,
            25.35, 331.80,  3.76,
            51.73, 292.50,  3.76,
            -2.60,  84.75,  3.77,
            55.90,  42.60,  3.77,
            -59.04, 252.45,  3.77,
            -21.74, 286.20,  3.77,
            42.58,  56.25,  3.77,
            -22.41, 321.60,  3.77,
            -46.65, 130.20,  3.77,
            15.91, 309.90,  3.77,
            17.54,  65.70,  3.77,
            13.73, 220.35,  3.78,
            -58.85, 163.35,  3.78,
            27.80, 111.45,  3.78,
            59.04, 147.75,  3.78,
            -9.50, 311.85,  3.78,
            -70.50, 107.25,  3.78,
            34.22, 163.35,  3.79,
            44.86,  47.40,  3.79,
            46.74, 303.45,  3.80,
            10.54, 233.70,  3.80,
            -26.80, 114.75,  3.80,
            53.37, 289.35,  3.80,
            -30.56,  68.85,  3.81,
            -58.74, 156.90,  3.81,
            26.30, 235.65,  3.81,
            46.46, 354.45,  3.82,
            38.04, 318.75,  3.82,
            46.01, 264.90,  3.82,
            1.98, 247.80,  3.82,
            2.76,  30.45,  3.82,
            69.33, 172.80,  3.82,
            36.80, 139.65,  3.82,
            -16.84, 156.45,  3.83,
            -79.04, 222.00,  3.83,
            -42.10, 209.55,  3.83,
            15.96,  67.20,  3.84,
            32.29,  56.10,  3.84,
            -48.23, 159.30,  3.84,
            -1.39, 335.40,  3.84,
            9.31, 158.25,  3.84,
            28.76, 271.95,  3.84,
            -72.13, 188.10,  3.84,
            -60.64, 133.80,  3.84,
            -21.06, 273.45,  3.84,
            70.27, 297.00,  3.84,
            21.77, 275.85,  3.85,
            69.79, 188.40,  3.85,
            -33.44,  95.55,  3.85,
            -8.24, 278.85,  3.85,
            -42.29,  63.45,  3.85,
            -64.81,  56.10,  3.85,
            -42.12, 153.75,  3.85,
            15.66, 239.10,  3.85,
            -51.07,  86.85,  3.85,
            -48.54, 189.45,  3.85,
            -35.47,  82.80,  3.86,
            -63.69, 243.90,  3.86,
            38.50,  14.25,  3.86,
            37.25, 269.10,  3.86,
            -44.80, 209.70,  3.87,
            -29.21, 239.25,  3.87,
            24.37,  56.40,  3.87,
            -46.04, 131.55,  3.87,
            1.01, 298.05,  3.87,
            19.29,  28.35,  3.88,
            26.01, 148.20,  3.88,
            -5.66, 220.80,  3.88,
            -45.25, 347.55,  3.88,
            -48.74, 228.00,  3.88,
            -45.75,   2.40,  3.88,
            -0.67, 184.95,  3.89,
            -78.90, 248.40,  3.89,
            -24.18, 103.50,  3.89,
            2.32, 138.60,  3.89,
            -8.90,  44.10,  3.89,
            35.08, 299.10,  3.89,
            -39.41, 202.80,  3.90,
            -14.79, 233.85,  3.90,
            -1.14, 144.90,  3.90,
            -54.49, 170.25,  3.90,
            46.31, 244.95,  3.91,
            -3.91, 126.45,  3.91,
            -50.23, 187.05,  3.91,
            -14.30,  69.60,  3.91,
            5.99,  60.75,  3.91,
            -47.05, 226.35,  3.91,
            30.93, 255.00,  3.92,
            5.25, 318.90,  3.92,
            -72.61, 115.50,  3.93,
            -58.98, 167.10,  3.93,
            52.76,  43.50,  3.93,
            -49.07,  22.80,  3.93,
            -17.85, 290.40,  3.93,
            -3.35,  69.15,  3.93,
            2.93, 270.15,  3.93,
            -20.67, 241.65,  3.93,
            18.15, 131.10,  3.94,
            -43.68,   6.60,  3.94,
            -28.95, 115.95,  3.94,
            41.17, 314.25,  3.94,
            -55.25,  17.10,  3.94,
            -9.55, 115.35,  3.94,
            54.92, 201.00,  3.95,
            -28.99,  48.00,  3.95,
            72.42,  30.90,  3.95,
            -19.26,  99.15,  3.96,
            -40.62, 291.00,  3.96,
            -62.32, 137.85,  3.96,
            47.71, 303.90,  3.96,
            -44.46, 290.70,  3.96,
            23.57, 341.70,  3.96,
            -42.82,  89.85,  3.96,
            47.71,  62.10,  3.96,
            -20.10, 350.70,  3.96,
            -72.91, 300.15,  3.97,
            -52.37, 182.85,  3.97,
            -34.02,  66.00,  3.97,
            -43.50, 337.35,  3.97,
            39.15,  87.90,  3.97,
            -35.31, 130.05,  3.97,
            -67.96, 109.20,  3.97,
            -33.63, 237.75,  3.97,
            45.59, 323.55,  3.98,
            35.79,  59.70,  3.98,
            -58.24, 349.35,  3.99,
            -21.08,  30.00,  3.99,
            -6.27,  93.75,  3.99,
            10.53, 171.00,  4.00,
            -19.46, 243.00,  4.00,
            -74.03, 156.15,  4.00,
            20.57, 106.05,  4.01,
            54.99, 201.30,  4.01,
            50.69,  25.95,  4.01,
            -37.79, 220.50,  4.01,
            -66.40, 135.60,  4.01,
            -26.77, 108.75,  4.01,
            58.56, 240.45,  4.01,
            30.37, 307.35,  4.01,
            -71.43, 280.80,  4.01,
            -3.25,  71.40,  4.01,
            -50.16, 244.95,  4.02,
            -5.74, 285.45,  4.02,
            -24.73, 182.10,  4.02,
            15.07, 284.85,  4.02,
            -27.71, 132.60,  4.02,
            -57.18, 193.65,  4.03,
            28.76, 131.70,  4.03,
            60.44,  75.90,  4.03,
            33.85,  34.35,  4.03,
            6.86, 359.85,  4.03,
            11.30, 308.25,  4.03,
            6.53, 176.40,  4.04,
            -0.12, 338.85,  4.04,
            -6.84,  63.00,  4.04,
            49.61,  47.25,  4.05,
            -13.59, 342.45,  4.05,
            15.80, 207.30,  4.05,
            -49.43, 219.45,  4.05,
            -37.89, 215.10,  4.05,
            6.03, 170.25,  4.05,
            -17.68, 171.15,  4.06,
            -64.00, 184.65,  4.06,
            13.51,  74.10,  4.06,
            -67.96, 184.35,  4.06,
            -35.17, 220.95,  4.06,
            -42.65, 131.10,  4.06,
            26.90, 114.00,  4.06,
            51.85, 216.30,  4.06,
            -53.16, 254.85,  4.06,
            58.42, 337.35,  4.07,
            -76.92, 124.65,  4.07,
            -58.80, 229.35,  4.07,
            -45.28, 227.25,  4.07,
            19.80, 320.55,  4.08,
            -23.62,  45.60,  4.08,
            -68.66,  35.40,  4.08,
            -59.23, 143.55,  4.08,
            -12.04, 103.50,  4.08,
            0.33,  39.90,  4.08,
            -6.00, 214.05,  4.08,
            -18.30, 165.00,  4.08,
            43.95, 283.80,  4.08,
            -17.23, 316.50,  4.08,
            24.27,  11.85,  4.08,
            41.41,  24.15,  4.09,
            18.14, 237.15,  4.09,
            9.29,  84.30,  4.09,
            -49.07, 277.20,  4.10,
            -46.37, 117.30,  4.10,
            -39.34, 287.55,  4.10,
            -78.61, 158.85,  4.11,
            -15.63, 105.90,  4.11,
            -42.99, 129.45,  4.11,
            -37.90, 287.40,  4.11,
            -52.75, 345.15,  4.11,
            41.78, 135.15,  4.11,
            -39.86,  40.20,  4.11,
            -61.18, 176.70,  4.11,
            -66.32, 234.15,  4.11,
            -14.85, 147.90,  4.11,
            -40.47, 142.65,  4.12,
            48.41,  63.75,  4.12,
            -43.75, 337.50,  4.12,
            -26.92, 312.90,  4.12,
            -41.87, 298.80,  4.12,
            9.65,  90.60,  4.12,
            -68.27,  39.90,  4.12,
            -81.38, 341.55,  4.13,
            -16.73, 238.50,  4.13,
            -7.81,  81.00,  4.13,
            8.73, 181.35,  4.13,
            49.23,  41.10,  4.13,
            20.21,  97.20,  4.13,
            -25.27, 311.55,  4.13,
            5.63, 355.05,  4.13,
            23.95,  56.55,  4.14,
            5.70, 129.45,  4.14,
            37.75, 334.05,  4.14,
            12.94,  52.65,  4.14,
            31.36, 233.25,  4.14,
            26.88, 239.40,  4.14,
            25.65, 326.10,  4.14,
            37.15, 260.85,  4.15,
            -0.49, 108.00,  4.15,
            44.33, 355.05,  4.15,
            -64.61, 181.65,  4.15,
            23.26,  91.05,  4.16,
            -36.20,  57.30,  4.17,
            -24.18, 261.60,  4.17,
            62.93,   8.25,  4.17,
            -7.78, 334.20,  4.17,
            31.78, 112.35,  4.18,
            46.09, 214.05,  4.18,
            -10.27, 213.15,  4.18,
            -35.26, 249.15,  4.18,
            -27.04, 340.20,  4.18,
            20.55, 281.40,  4.19,
            57.04, 333.75,  4.19,
            12.17, 341.70,  4.19,
            -34.45, 207.30,  4.19,
            -22.88, 119.25,  4.20,
            5.95,  82.65,  4.20,
            -32.54, 343.95,  4.20,
            36.71, 156.90,  4.20,
            42.44, 248.55,  4.20,
            2.50, 271.35,  4.21,
            82.04, 251.55,  4.21,
            59.94,  52.20,  4.21,
            22.29,  66.30,  4.21,
            62.99, 307.35,  4.21,
            -36.80, 241.65,  4.22,
            -65.37, 321.60,  4.22,
            -18.46, 246.75,  4.22,
            -48.10, 118.35,  4.22,
            -64.88,   4.95,  4.22,
            -23.25,  56.70,  4.22,
            38.32,  42.60,  4.22,
            -62.19, 283.05,  4.22,
            71.34, 275.25,  4.22,
            39.39, 319.35,  4.22,
            -4.75, 281.85,  4.22,
            30.72, 311.40,  4.22,
            36.90, 283.65,  4.22,
            -6.05, 348.60,  4.22,
            -9.09, 348.90,  4.22,
            49.31, 326.70,  4.23,
            -33.04, 206.40,  4.23,
            44.93, 242.25,  4.23,
            1.54, 210.45,  4.23,
            28.88, 115.80,  4.23,
            58.78, 325.95,  4.23,
            -77.52, 250.80,  4.23,
            -12.88, 265.35,  4.24,
            -47.70,  36.75,  4.24,
            -13.86,  41.10,  4.24,
            -79.31, 184.65,  4.24,
            -34.70, 247.80,  4.24,
            86.26,  17.25,  4.24,
            50.35,  61.65,  4.25,
            -8.75,  77.25,  4.25,
            43.19, 125.70,  4.25,
            61.12, 326.40,  4.25,
            10.16,  68.85,  4.25,
            -51.49,  64.05,  4.25,
            41.26,  69.15,  4.25,
            75.70, 216.90,  4.25,
            -40.18, 193.35,  4.26,
            47.24,  17.40,  4.26,
            27.88, 198.00,  4.26,
            64.63, 330.90,  4.26,
            -21.63,  53.40,  4.26,
            66.34,  73.50,  4.26,
            -43.07,  49.95,  4.26,
            21.60, 270.45,  4.26,
            11.86, 134.55,  4.26,
            -38.63, 264.15,  4.26,
            9.16,  26.40,  4.26,
            6.38, 352.05,  4.27,
            10.11,  41.25,  4.27,
            8.89,  63.90,  4.27,
            7.89,  15.75,  4.27,
            41.36, 188.40,  4.27,
            12.51,  69.60,  4.27,
            -44.80, 290.85,  4.27,
            -47.88, 229.65,  4.27,
            22.96,  70.50,  4.27,
            16.12, 311.70,  4.27,
            -49.91, 196.80,  4.27,
            56.57, 303.30,  4.28,
            0.40,  54.15,  4.28,
            -31.07, 156.75,  4.28,
            81.33, 144.30,  4.28,
            22.81,  66.60,  4.28,
            -43.52, 346.65,  4.28,
            33.18, 332.55,  4.28,
            -29.87, 261.90,  4.28,
            -16.83, 320.55,  4.28,
            77.79, 235.95,  4.29,
            -13.87, 331.65,  4.29,
            -16.61, 247.80,  4.29,
            -33.91, 178.20,  4.29,
            43.27, 354.60,  4.29,
            -32.35, 337.95,  4.29,
            -13.18,  79.95,  4.29,
            -55.60, 159.90,  4.29,
            -16.20, 187.95,  4.30,
            -29.36,  14.70,  4.30,
            -63.79, 177.45,  4.30,
            3.40, 130.80,  4.30,
            -56.39, 215.10,  4.30,
            17.93,  66.30,  4.30,
            8.46,  37.05,  4.30,
            45.94,  90.00,  4.30,
            -0.82, 174.30,  4.30,
            -37.62,  57.15,  4.30,
            -12.51, 304.35,  4.30,
            24.47,  56.25,  4.30,
            24.75, 163.95,  4.30,
            -83.67, 216.75,  4.31,
            -20.87, 241.80,  4.31,
            -59.76, 130.20,  4.31,
            -1.11, 309.60,  4.31,
            37.38, 231.15,  4.31,
            -13.55, 131.55,  4.32,
            -19.67,  70.05,  4.32,
            -12.85, 260.25,  4.32,
            -63.31, 180.75,  4.32,
            29.50,  93.90,  4.32,
            22.97, 142.95,  4.32,
            -32.99, 207.90,  4.32,
            48.19,  54.15,  4.32,
            -43.58, 222.90,  4.32,
            18.59,  83.10,  4.32,
            8.93, 112.05,  4.33,
            31.54, 169.50,  4.33,
            -63.67, 272.10,  4.33,
            -45.38, 216.60,  4.33,
            36.06, 274.95,  4.33,
            -48.94, 193.35,  4.33,
            -77.48, 125.10,  4.34,
            -23.42,  97.95,  4.34,
            -65.74,  86.25,  4.34,
            29.31,   9.60,  4.34,
            17.35, 326.10,  4.34,
            -45.60, 210.45,  4.34,
            4.14, 261.60,  4.34,
            -57.54, 139.05,  4.34,
            33.72,   9.15,  4.34,
            18.18, 281.70,  4.34,
            -49.36, 144.15,  4.34,
            -42.57, 234.45,  4.34,
            37.61, 281.25,  4.34,
            55.15,  17.70,  4.34,
            47.71, 337.35,  4.34,
            38.13, 289.05,  4.35,
            -33.03, 326.25,  4.35,
            -61.49, 275.85,  4.35,
            -30.15, 229.50,  4.35,
            -52.98,  98.70,  4.35,
            8.90,  72.60,  4.35,
            28.27, 186.75,  4.35,
            19.73,  47.85,  4.35,
            86.59, 263.10,  4.35,
            -68.62, 121.95,  4.35,
            5.84, 132.15,  4.35,
            58.42, 104.25,  4.35,
            -35.28,  89.40,  4.36,
            -41.18, 211.50,  4.36,
            -1.29, 294.15,  4.36,
            -62.96,   7.95,  4.36,
            48.00,  52.65,  4.36,
            -12.94,  78.30,  4.36,
            22.08,  61.20,  4.36,
            -2.98, 122.10,  4.36,
            8.85,  33.30,  4.36,
            -57.46,  10.80,  4.36,
            -17.05, 104.10,  4.36,
            -5.45,  73.20,  4.36,
            -24.95, 109.65,  4.37,
            -42.23, 165.00,  4.37,
            -6.01,   0.45,  4.37,
            -35.14,  94.20,  4.37,
            20.81, 272.25,  4.37,
            -35.28, 300.00,  4.37,
            77.71, 302.25,  4.38,
            -37.82, 353.25,  4.38,
            -20.64, 351.45,  4.38,
            -5.54, 197.55,  4.38,
            65.53,  57.45,  4.39,
            10.17, 253.50,  4.39,
            2.33, 120.60,  4.39,
            -46.30,  28.35,  4.39,
            17.48, 295.20,  4.39,
            9.49,  83.70,  4.39,
            2.09, 225.75,  4.39,
            18.01, 295.05,  4.39,
            10.00, 151.95,  4.39,
            4.59,  96.00,  4.39,
            -25.94, 117.00,  4.40,
            -54.99, 329.55,  4.40,
            20.28,  88.65,  4.40,
            -67.23, 284.25,  4.40,
            -19.25, 122.25,  4.40,
            23.42,  14.25,  4.40,
            34.90, 319.50,  4.41,
            26.11, 262.65,  4.41,
            -53.62, 102.45,  4.41,
            -39.51, 215.70,  4.41,
            30.25, 107.85,  4.41,
            -9.18, 349.50,  4.41,
            75.39, 346.95,  4.41,
            -32.53, 349.65,  4.41,
            -21.11, 260.25,  4.41,
            30.19, 269.70,  4.41,
            14.77,  91.95,  4.42,
            -40.35, 123.45,  4.42,
            -44.64, 108.45,  4.42,
            1.31, 270.45,  4.42,
            52.23, 335.85,  4.42,
            23.40, 351.30,  4.42,
            -18.24,  99.45,  4.42,
            20.18, 165.60,  4.42,
            -27.96, 222.60,  4.42,
            -26.35, 108.60,  4.42,
            32.19, 306.00,  4.43,
            -5.03, 312.00,  4.43,
            -27.71, 300.60,  4.43,
            15.07, 310.80,  4.43,
            53.75,  74.25,  4.43,
            -7.64,  63.75,  4.43,
            7.35, 236.55,  4.43,
            -12.10,  56.55,  4.43,
            39.15, 288.45,  4.43,
            24.67, 292.20,  4.44,
            -50.46, 218.10,  4.44,
            7.59,  12.15,  4.44,
            -59.30,  64.05,  4.44,
            59.01,  94.95,  4.44,
            -39.62, 122.85,  4.44,
            -41.86,  70.20,  4.44,
            -18.93,   3.60,  4.44,
            -41.25, 135.00,  4.45,
            5.49,  25.35,  4.45,
            -57.56, 158.85,  4.45,
            -32.41,  42.30,  4.45,
            -36.66, 124.65,  4.45,
            3.34, 129.75,  4.45,
            -80.54, 161.40,  4.45,
            -11.87,  78.00,  4.45,
            -3.65, 169.20,  4.45,
            -21.47, 248.10,  4.45,
            7.38, 293.55,  4.45,
            -22.30, 113.55,  4.45,
            14.21,  93.00,  4.45,
            73.36, 288.90,  4.45,
            -2.95,  58.50,  4.46,
            -47.55, 246.75,  4.46,
            29.74, 218.70,  4.46,
            -18.57,  41.25,  4.46,
            -50.66, 181.95,  4.46,
            2.86,  78.30,  4.46,
            67.40,  37.20,  4.46,
            29.05,  50.10,  4.47,
            -49.24, 119.55,  4.47,
            -72.60, 136.35,  4.47,
            7.33,  98.25,  4.47,
            -39.54, 331.50,  4.47,
            1.71,  74.70,  4.47,
            -32.58,  97.05,  4.47,
            -45.17, 177.75,  4.47,
            26.18, 141.15,  4.47,
            52.05, 143.70,  4.47,
            35.24, 151.80,  4.48,
            -0.37, 151.95,  4.48,
            15.62,  66.60,  4.48,
            51.60, 137.25,  4.48,
            -22.83, 167.85,  4.48,
            50.22, 294.15,  4.48,
            -46.76, 108.15,  4.48,
            2.41, 102.00,  4.48,
            -14.54, 355.65,  4.48,
            -20.04, 246.00,  4.48,
            -62.16,  60.15,  4.48,
            -23.74, 346.65,  4.48,
            48.28,  11.25,  4.48,
            -59.32, 230.85,  4.48,
            3.82, 345.90,  4.48,
            -29.77,  68.40,  4.49,
            -65.58, 360.00,  4.49,
            -25.01, 316.80,  4.49,
            -4.35, 224.25,  4.49,
            13.23, 100.95,  4.49,
            70.91,  30.45,  4.49,
            -38.86, 118.20,  4.49,
            1.78, 355.50,  4.49,
            16.42, 220.20,  4.49,
            -56.17,  87.45,  4.50,
            -11.37, 317.40,  4.50,
            -32.99, 332.10,  4.50,
            4.12,  84.75,  4.50,
            44.28, 340.20,  4.50,
            17.46, 206.85,  4.50,
            27.81, 303.90,  4.50,
            -32.88, 343.20,  4.50,
            -21.81, 322.20,  4.50,
            -56.04, 155.25,  4.50,
            -53.45, 319.95,  4.50,
            -56.77, 131.70,  4.50,
            20.22, 177.00,  4.50,
            39.71, 333.45,  4.50,
            30.09,  17.85,  4.51,
            -51.92, 310.95,  4.51,
            -61.33, 144.90,  4.51,
            -35.95, 142.35,  4.51,
            57.58, 311.40,  4.51,
            36.79,   4.65,  4.51,
            19.67, 235.35,  4.51,
            -19.47, 324.30,  4.51,
            57.50, 358.65,  4.51,
            39.18,  87.30,  4.51,
            -64.97, 336.90,  4.51,
            67.87, 300.75,  4.51,
            -13.37, 214.80,  4.52,
            23.64, 322.50,  4.52,
            49.41, 348.15,  4.52,
            29.25,  42.00,  4.52,
            26.95, 226.05,  4.52,
            -15.96, 290.40,  4.52,
            -64.54, 201.00,  4.52,
            -45.95, 272.85,  4.52,
            -60.99, 200.70,  4.52,
            43.12, 337.65,  4.52,
            51.79, 213.30,  4.53,
            -34.97, 114.30,  4.53,
            -3.07,  90.00,  4.53,
            -27.83, 266.85,  4.53,
            -62.97,   7.95,  4.53,
            -5.09, 261.60,  4.53,
            41.08,  12.45,  4.53,
            36.49, 311.85,  4.53,
            -1.18, 142.95,  4.54,
            36.40, 143.55,  4.54,
            -27.17, 299.25,  4.54,
            -19.79, 228.00,  4.54,
            -22.96,  98.70,  4.54,
            -36.86, 230.85,  4.54,
            33.37,  79.50,  4.54,
            12.76, 352.35,  4.54,
            9.41, 346.80,  4.54,
            -35.48,  76.05,  4.55,
            54.06, 148.05,  4.55,
            76.98, 105.00,  4.55,
            46.54, 335.25,  4.55,
            -44.96, 234.00,  4.55,
            -24.17, 245.10,  4.55,
            49.48, 336.15,  4.55,
            58.88,  52.50,  4.55,
            -17.34,   0.90,  4.55,
            -28.46, 271.95,  4.55,
            71.31, 325.50,  4.55,
            12.01, 112.50,  4.55,
            -46.51, 263.85,  4.56,
            23.10, 168.75,  4.56,
            -61.40,  59.70,  4.56,
            35.06,  42.90,  4.56,
            27.61,  88.35,  4.56,
            47.65, 316.65,  4.56,
            38.45, 136.65,  4.56,
            -45.22, 216.60,  4.56,
            69.83, 143.55,  4.56,
            -40.50, 287.10,  4.57,
            14.03, 246.30,  4.57,
            24.08, 298.35,  4.57,
            22.65, 283.65,  4.57,
            -40.27,  54.30,  4.57,
            -23.45, 246.45,  4.57,
            -46.55, 147.90,  4.58,
            -4.84,  83.85,  4.58,
            -27.93, 243.15,  4.58,
            -8.12, 264.45,  4.58,
            27.10, 313.05,  4.58,
            -59.92, 198.00,  4.58,
            23.74, 350.10,  4.58,
            64.72, 207.90,  4.58,
            72.15, 265.50,  4.58,
            -60.57, 160.95,  4.58,
            -37.31,  55.65,  4.59,
            -46.09,  10.35,  4.59,
            26.07, 237.45,  4.59,
            -55.03, 154.95,  4.59,
            -60.32, 168.15,  4.59,
            -28.13, 357.30,  4.59,
            -24.88, 294.15,  4.59,
            -25.33, 238.35,  4.59,
            39.61, 281.10,  4.59,
            71.33,  57.60,  4.59,
            64.33, 130.05,  4.59,
            3.10,  81.75,  4.59,
            -37.14, 164.25,  4.60,
            -13.06, 151.35,  4.60,
            16.96, 221.25,  4.60,
            65.71, 290.10,  4.60,
            50.30,  64.50,  4.60,
            -2.77, 142.35,  4.60,
            -38.73, 231.30,  4.60,
            -10.06, 233.55,  4.61,
            -5.71,   1.35,  4.61,
            -18.40, 120.00,  4.61,
            42.45, 238.20,  4.61,
            38.68,   4.20,  4.61,
            39.61,  47.85,  4.61,
            3.19,  28.35,  4.61,
            49.21, 111.75,  4.61,
            35.25, 308.55,  4.61,
            -42.31, 278.40,  4.62,
            -7.30,  82.95,  4.62,
            21.59,  75.75,  4.62,
            59.18,  14.10,  4.62,
            -54.26, 173.70,  4.62,
            -59.15, 193.65,  4.62,
            4.20, 284.10,  4.62,
            -56.49, 191.55,  4.62,
            7.34, 166.20,  4.62,
            -62.42, 166.65,  4.62,
            -8.37, 246.90,  4.62,
            -25.86, 136.95,  4.62,
            -3.69, 270.15,  4.62,
            -37.41, 138.90,  4.62,
            -24.02,  60.00,  4.62,
            65.93, 224.40,  4.63,
            21.34,  44.85,  4.63,
            -62.28, 277.80,  4.63,
            -7.23, 130.95,  4.63,
            -28.41, 115.95,  4.63,
            -39.99, 189.90,  4.63,
            54.68, 205.20,  4.63,
            -49.61, 118.20,  4.63,
            -25.75, 237.75,  4.63,
            59.39, 282.75,  4.63,
            25.14, 359.40,  4.63,
            -57.77, 240.90,  4.63,
            -44.66, 235.35,  4.64,
            51.55, 339.30,  4.64,
            10.15,  73.65,  4.64,
            20.14,  91.05,  4.64,
            8.73, 271.80,  4.64,
            36.64, 234.90,  4.64,
            14.67, 308.85,  4.64,
            0.34, 291.60,  4.64,
            -24.61,  58.50,  4.64,
            -51.43, 206.70,  4.64,
            -10.78, 252.45,  4.64,
            37.29, 259.35,  4.64,
            50.05, 346.05,  4.64,
            -36.73, 109.65,  4.65,
            -28.37, 113.85,  4.65,
            14.84,  68.40,  4.65,
            -63.09,  88.50,  4.65,
            -30.96, 112.65,  4.65,
            -40.47, 142.65,  4.65,
            6.61, 180.15,  4.65,
            27.71,  40.80,  4.65,
            -49.23, 240.75,  4.65,
            -57.64, 156.90,  4.65,
            15.40,  76.20,  4.65,
            -70.54, 136.35,  4.66,
            -8.00, 189.75,  4.66,
            -27.88, 109.20,  4.66,
            -20.14, 103.95,  4.66,
            -8.93, 275.85,  4.66,
            9.90, 100.20,  4.66,
            -34.41, 234.90,  4.66,
            -29.58, 271.20,  4.66,
            43.19, 163.50,  4.66,
            -48.81, 190.65,  4.66,
            -27.04, 274.50,  4.66,
            21.47, 130.80,  4.66,
            27.75, 300.30,  4.66,
            21.03,  17.85,  4.66,
            40.48,  63.75,  4.67,
            16.75, 270.00,  4.67,
            39.67, 281.10,  4.67,
            -32.26, 315.30,  4.67,
            63.51, 137.70,  4.67,
            -14.57, 277.35,  4.67,
            17.65, 123.00,  4.67,
            -10.69,  27.45,  4.67,
            15.92,  69.75,  4.67,
            49.51,  52.35,  4.67,
            -14.94,  91.50,  4.67,
            24.58,  18.45,  4.67,
            39.66,  44.70,  4.68,
            -78.70, 245.10,  4.68,
            59.23,  23.55,  4.68,
            -29.30,  31.05,  4.68,
            -52.72, 134.10,  4.68,
            4.65, 144.60,  4.68,
            -67.65,  28.80,  4.68,
            -6.26, 202.95,  4.68,
            -18.83, 340.95,  4.68,
            -7.85, 324.45,  4.68,
            31.98, 159.75,  4.68,
            30.15, 294.90,  4.68,
            8.04, 150.00,  4.68,
            69.67, 293.10,  4.68,
            49.02, 203.55,  4.68,
            -1.39, 120.30,  4.69,
            -56.78, 330.75,  4.69,
            -42.62, 353.70,  4.69,
            -47.08, 117.15,  4.69,
            -59.18, 159.75,  4.69,
            14.71,  66.60,  4.69,
            51.19, 325.50,  4.69,
            -60.98, 191.40,  4.69,
            -25.36, 114.60,  4.69,
            -20.91, 353.25,  4.70,
            -26.30, 298.95,  4.70,
            -9.05, 280.50,  4.70,
            10.13, 317.55,  4.70,
            -21.24,  80.10,  4.70,
            -9.80, 174.15,  4.70,
            84.35, 343.65,  4.70,
            19.10, 222.90,  4.70,
            -42.36, 253.50,  4.70,
            -34.74, 175.05,  4.70,
            -1.09,  82.50,  4.71,
            -28.83, 140.85,  4.71,
            8.46, 298.50,  4.71,
            -32.17, 319.50,  4.71,
            40.10,  79.80,  4.71,
            -57.47,  76.35,  4.71,
            -18.35, 176.25,  4.71,
            -63.69, 209.40,  4.71,
            14.25,  73.20,  4.71,
            8.91,  45.00,  4.71,
            -25.97, 140.40,  4.71,
            -48.46, 196.50,  4.71,
            32.19,  83.25,  4.71,
            -62.94,  52.35,  4.71,
            -0.45, 259.20,  4.72,
            33.80, 156.45,  4.72,
            -45.17, 241.65,  4.72,
            46.04, 240.75,  4.72,
            17.79, 185.25,  4.72,
            37.31,  87.75,  4.72,
            40.57, 199.35,  4.72,
            40.43, 158.25,  4.72,
            -63.17, 181.05,  4.72,
            -22.34, 141.90,  4.72,
            -54.97,  92.55,  4.72,
            -18.87, 325.65,  4.72,
            -0.38,  80.40,  4.72,
            -71.99, 157.65,  4.72,
            68.13,  21.45,  4.72,
            -12.93, 122.85,  4.72,
            -2.48, 165.45,  4.73,
            36.49, 242.25,  4.73,
            -8.98, 313.20,  4.73,
            50.28,  36.45,  4.73,
            -42.99, 122.85,  4.73,
            65.65,  49.95,  4.74,
            -5.08,  52.65,  4.74,
            20.98, 237.75,  4.74,
            -47.32, 130.35,  4.74,
            -45.49, 354.45,  4.74,
            27.26,  19.80,  4.74,
            -15.24,  37.95,  4.74,
            -53.44, 212.55,  4.74,
            54.52,   7.95,  4.74,
            -42.89,  39.90,  4.74,
            34.45, 292.95,  4.74,
            13.18, 103.65,  4.74,
            47.52, 315.00,  4.74,
            67.63, 135.60,  4.74,
            -18.31, 199.65,  4.74,
            -42.09, 285.75,  4.74,
            -23.82, 270.00,  4.74,
            -2.16, 330.90,  4.74,
            -31.93, 208.35,  4.75,
            51.37, 214.05,  4.75,
            -48.27, 108.60,  4.75,
            -60.58, 308.85,  4.75,
            68.11, 349.65,  4.75,
            -19.68, 235.50,  4.75,
            -34.71, 235.65,  4.75,
            -15.97, 201.90,  4.75,
            -66.81, 177.00,  4.75,
            62.08, 324.45,  4.76,
            -67.77, 260.55,  4.76,
            1.86,  88.05,  4.76,
            34.44, 207.90,  4.76,
            -75.07,  42.60,  4.76,
            25.47, 346.80,  4.76,
            -61.30, 122.25,  4.76,
            21.39, 289.05,  4.76,
            -30.33, 119.40,  4.76,
            17.41, 194.70,  4.76,
            38.19, 169.80,  4.76,
            -21.00,  42.75,  4.76,
            -58.46, 215.70,  4.76,
            -23.59, 145.35,  4.76,
            -48.80,   7.80,  4.76,
            51.56, 186.00,  4.76,
            -64.47, 160.50,  4.76,
            69.32,  94.65,  4.76,
            57.05, 278.10,  4.77,
            -10.61,  11.10,  4.77,
            -49.42, 265.05,  4.77,
            -12.76, 305.10,  4.77,
            56.71,  46.35,  4.77,
            -3.00, 172.65,  4.77,
            -37.94, 300.90,  4.77,
            -11.97, 139.95,  4.77,
            38.03, 304.50,  4.77,
            -9.54, 193.65,  4.77,
            8.04, 101.85,  4.77,
            83.15, 341.85,  4.77,
            -45.19, 215.25,  4.78,
            -35.90, 123.30,  4.78,
            -40.09, 267.60,  4.78,
            -12.54,  75.00,  4.78,
            63.35,  56.55,  4.78,
            -1.14,  13.20,  4.78,
            -64.87, 281.40,  4.78,
            4.70, 336.90,  4.78,
            -77.07,   0.45,  4.78,
            28.74, 326.10,  4.78,
            37.86,  32.10,  4.78,
            -27.75, 215.70,  4.78,
            51.51, 122.10,  4.78,
            25.85, 185.70,  4.78,
            16.19,  67.65,  4.78,
            -6.00,  83.70,  4.78,
            -17.81, 307.20,  4.78,
            5.47, 199.35,  4.78,
            -23.96, 262.80,  4.78,
            28.33, 335.40,  4.78,
            72.34, 332.40,  4.79,
            -25.12, 247.50,  4.79,
            -62.40, 140.25,  4.79,
            -48.49, 125.70,  4.79,
            35.66, 237.75,  4.79,
            25.59, 303.75,  4.79,
            -31.70, 267.30,  4.79,
            20.21,   3.60,  4.79,
            -67.89, 198.75,  4.79,
            -41.35, 333.90,  4.79,
            36.70,  73.20,  4.79,
            23.60,  29.55,  4.79,
            4.37, 270.00,  4.79,
            -9.56, 140.10,  4.80,
            50.51,  10.50,  4.80,
            -28.61, 244.50,  4.80,
            -40.81, 320.25,  4.80,
            -7.17,  75.30,  4.80,
            46.50,  65.40,  4.80,
            29.31, 340.50,  4.80,
            46.82, 303.30,  4.80,
            25.01, 225.60,  4.80,
            27.62, 196.80,  4.80,
            42.49,  99.90,  4.80,
            1.38, 336.30,  4.80,
            31.54, 169.50,  4.80,
            26.53, 220.80,  4.80,
            35.51, 214.50,  4.80,
            68.76, 264.30,  4.80,
            22.63, 188.70,  4.80,
            17.44,  66.00,  4.80,
            -8.82,  48.90,  4.80,
            77.55, 212.25,  4.80,
            -7.21,  84.75,  4.80,
            44.39, 313.35,  4.80,
            -63.96, 161.10,  4.80,
            33.10, 259.35,  4.80,
            19.47, 154.95,  4.81,
            39.62, 143.70,  4.81,
            -20.54, 276.30,  4.81,
            -63.57, 120.15,  4.81,
            -10.86, 171.15,  4.81,
            -67.19,  78.45,  4.81,
            21.20, 309.60,  4.81,
            46.11, 312.30,  4.81,
            15.60,  77.40,  4.81,
            -34.89,  79.35,  4.81,
            25.95,  89.55,  4.81,
            -47.39,  29.25,  4.82,
            71.30, 283.65,  4.82,
            12.21, 335.40,  4.82,
            -51.45, 186.60,  4.82,
            49.02, 349.50,  4.82,
            61.12,  13.20,  4.82,
            38.48,  78.30,  4.82,
            65.56, 276.45,  4.82,
            -20.22, 103.35,  4.82,
            -10.68, 337.65,  4.82,
            -17.82, 355.50,  4.82,
            3.37,  49.80,  4.82,
            -14.15,  99.75,  4.82,
            22.80, 240.60,  4.82,
            1.03, 245.55,  4.82,
            -41.65, 155.55,  4.82,
            36.29, 204.30,  4.82,
            -4.22, 255.30,  4.82,
            45.98, 252.30,  4.82,
            -14.52, 113.40,  4.82,
            -67.62,  41.40,  4.83,
            41.88, 247.20,  4.83,
            -39.66, 107.25,  4.83,
            -5.85, 284.25,  4.83,
            -37.11, 284.70,  4.83,
            -23.32, 109.20,  4.83,
            54.02, 139.05,  4.83,
            58.97,  13.80,  4.83,
            -44.50, 228.15,  4.83,
            45.41,  21.90,  4.83,
            -49.53, 195.90,  4.83,
            -33.05, 125.40,  4.83,
            25.09, 212.55,  4.83,
            -2.23, 217.05,  4.83,
            -34.12, 256.20,  4.83,
            -53.11, 130.65,  4.83,
            26.66, 281.55,  4.83,
            44.23,  33.30,  4.84,
            55.98, 157.65,  4.84,
            -53.50, 341.40,  4.84,
            9.26,  63.45,  4.84,
            64.59, 250.20,  4.84,
            3.62, 165.15,  4.84,
            -58.01, 128.85,  4.84,
            -41.41, 340.80,  4.84,
            -11.37, 241.05,  4.84,
            67.13, 137.55,  4.84,
            -26.20, 299.70,  4.84,
            11.49, 248.10,  4.84,
            6.14,  22.50,  4.84,
            16.31, 214.95,  4.84,
            16.53,  85.35,  4.84,
            -38.31, 114.90,  4.84,
            8.26, 176.25,  4.84,
            59.42, 346.65,  4.84,
            56.78, 251.25,  4.85,
            -63.61, 229.35,  4.85,
            3.38, 275.25,  4.85,
            -51.81, 152.25,  4.85,
            74.39,  48.00,  4.85,
            -23.02, 112.50,  4.85,
            34.22,  49.65,  4.85,
            -37.80, 198.00,  4.85,
            -44.34, 269.25,  4.85,
            -52.94, 284.55,  4.85,
            -22.51,  49.65,  4.86,
            -66.78, 199.35,  4.86,
            -35.64, 281.10,  4.86,
            5.06, 331.35,  4.86,
            55.17, 263.10,  4.86,
            8.45, 215.85,  4.86,
            -33.01,   7.05,  4.86,
            48.93, 249.75,  4.86,
            -29.56, 129.90,  4.86,
            -25.26, 288.90,  4.86,
            -44.05, 248.55,  4.86,
            -22.74, 283.50,  4.86,
            59.44, 101.55,  4.86,
            8.16, 220.35,  4.86,
            75.71, 158.70,  4.86,
            -61.53, 309.45,  4.86,
            30.89, 245.55,  4.86,
            -21.68, 265.80,  4.87,
            -15.94, 130.50,  4.87,
            45.53,  20.55,  4.87,
            -27.41, 159.30,  4.87,
            -19.76, 296.55,  4.87,
            34.22,  34.20,  4.87,
            5.59,  39.00,  4.87,
            -45.18, 108.30,  4.87,
            21.04,  48.75,  4.87,
            -27.68, 133.95,  4.87,
            -25.93, 148.50,  4.87,
            -37.06, 286.65,  4.87,
            -10.26,  63.60,  4.87,
            -64.38, 161.70,  4.87,
            38.53, 323.70,  4.87,
            -8.28, 280.95,  4.88,
            -24.56, 109.65,  4.88,
            30.79, 195.00,  4.88,
            -3.56, 359.70,  4.88,
            -78.22, 179.85,  4.88,
            -41.72, 269.40,  4.88,
            -48.10, 293.85,  4.88,
            -18.95, 289.35,  4.88,
            21.94,  81.90,  4.88,
            10.24, 190.50,  4.88,
            58.65, 356.70,  4.88,
            24.57,  87.30,  4.88,
            -33.80,  88.35,  4.88,
            -12.29,  36.45,  4.88,
            55.75, 359.70,  4.88,
            -15.47,   2.85,  4.89,
            -65.21, 177.90,  4.89,
            12.65,  87.45,  4.89,
            1.85,  81.15,  4.89,
            58.55, 352.50,  4.89,
            65.13, 253.95,  4.89,
            -13.38, 159.45,  4.89,
            18.51, 116.55,  4.89,
            39.05, 339.75,  4.89,
            -81.01, 214.50,  4.89,
            -33.78, 312.45,  4.89,
            37.35, 296.10,  4.89,
            21.25, 193.35,  4.89,
            34.58, 114.75,  4.89,
            55.18, 263.10,  4.89,
            12.74, 256.35,  4.89,
            -53.72, 157.80,  4.89,
            37.49,  72.45,  4.89,
            45.09, 104.40,  4.90,
            -40.50, 176.70,  4.90,
            1.47,  85.65,  4.90,
            -46.23, 312.30,  4.90,
            -14.60,  21.45,  4.90,
            -19.80, 241.35,  4.90,
            22.61, 297.75,  4.90,
            50.97,  12.15,  4.90,
            -34.00, 192.60,  4.90,
            -38.60, 240.90,  4.90,
            -2.55, 309.15,  4.91,
            -31.52, 228.60,  4.91,
            -70.08, 247.05,  4.91,
            -59.69, 190.50,  4.91,
            -2.89, 307.35,  4.91,
            -8.52, 225.30,  4.91,
            -0.04,  67.95,  4.91,
            8.82, 343.80,  4.91,
            37.18, 203.70,  4.91,
            -61.98, 338.25,  4.91,
            -2.94,  94.95,  4.91,
            39.32, 107.85,  4.91,
            -20.05,  75.30,  4.91,
            -16.88, 159.60,  4.91,
            -4.24, 107.55,  4.91,
            52.44, 298.95,  4.91,
            27.27, 186.60,  4.92,
            -22.53,  29.10,  4.92,
            -49.58, 105.90,  4.92,
            -43.42, 271.65,  4.92,
            21.26, 207.45,  4.92,
            -59.10, 198.60,  4.92,
            82.41, 112.80,  4.92,
            -16.48,  91.20,  4.92,
            50.71, 283.35,  4.92,
            49.29,  96.15,  4.92,
            -45.91, 277.95,  4.92,
            3.66, 203.55,  4.92,
            25.27, 311.25,  4.92,
            -10.60,  90.45,  4.92,
            21.96, 275.10,  4.92,
            40.19,  40.50,  4.92,
            -38.57, 138.90,  4.92,
            -35.19, 221.25,  4.92,
            -32.55, 332.55,  4.92,
            -10.32, 231.00,  4.92,
            23.95, 184.05,  4.93,
            -29.26, 173.10,  4.93,
            -10.06, 243.00,  4.93,
            -7.03, 294.15,  4.93,
            -2.30, 222.75,  4.93,
            -52.53, 113.85,  4.93,
            -52.88, 301.80,  4.93,
            58.71, 115.80,  4.93,
            -41.99,  62.70,  4.93,
            -23.92, 145.50,  4.93,
            20.58,  64.35,  4.93,
            36.81, 303.60,  4.93,
            -62.09, 175.20,  4.93,
            27.54, 192.90,  4.93,
            24.87, 226.80,  4.93,
            29.36, 355.95,  4.93,
            -3.68, 120.00,  4.93,
            -59.23, 134.25,  4.93,
            36.84, 302.40,  4.93,
            37.89,  74.85,  4.93,
            -16.30, 212.70,  4.93,
            34.37, 311.85,  4.93,
            56.37, 195.15,  4.93,
            -7.73, 349.20,  4.93,
            34.57,  65.10,  4.93,
            -19.01, 148.65,  4.94,
            32.15, 285.00,  4.94,
            40.15, 198.45,  4.94,
            15.20, 303.60,  4.94,
            35.18,  44.70,  4.94,
    };
}
