package com.dimowner.audiorecorder.app.moverecords

import com.dimowner.audiorecorder.app.formatRecordInformation
import com.dimowner.audiorecorder.app.settings.SettingsMapper
import com.dimowner.audiorecorder.data.database.Record

fun recordToMoveRecordsItem(settingsMapper: SettingsMapper, item: Record): MoveRecordsItem {
	return MoveRecordsItem(
		item.id,
		item.name,
		formatRecordInformation(settingsMapper, item.format, item.sampleRate, item.size)
	)
}

fun recordsToMoveRecordsItems(settingsMapper: SettingsMapper, items: List<Record>): List<MoveRecordsItem> {
	return items.map { recordToMoveRecordsItem(settingsMapper, it) }
}
