package com.dessalines.thumbkey.utils

import com.dessalines.thumbkey.keyboards.KB_AR_THUMBKEY_LEVANT
import com.dessalines.thumbkey.keyboards.KB_BG_MESSAGEASE_PHONETIC_SYMBOLS
import com.dessalines.thumbkey.keyboards.KB_BG_THUMBKEY_SYMBOLS
import com.dessalines.thumbkey.keyboards.KB_BR_FR_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_BR_FR_THUMBKEY_COMPOSE
import com.dessalines.thumbkey.keyboards.KB_BR_FR_THUMBKEY_V3
import com.dessalines.thumbkey.keyboards.KB_BY_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_BY_THUMBKEY_SYMBOLS
import com.dessalines.thumbkey.keyboards.KB_CA_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_CZ_MESSAGEASE_PROGRAMMING
import com.dessalines.thumbkey.keyboards.KB_DA_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_DA_THUMBKEY_MULTILINGUAL
import com.dessalines.thumbkey.keyboards.KB_DE_MESSAGEASE
import com.dessalines.thumbkey.keyboards.KB_DE_MESSAGEASE_INVERTED_NUMPAD
import com.dessalines.thumbkey.keyboards.KB_DE_MESSAGEASE_LEFT
import com.dessalines.thumbkey.keyboards.KB_DE_MESSAGEASE_LEFT_INVERTED_NUMPAD
import com.dessalines.thumbkey.keyboards.KB_DE_MESSAGEASE_SYMBOLS
import com.dessalines.thumbkey.keyboards.KB_DE_NORDIC_MESSAGEASE
import com.dessalines.thumbkey.keyboards.KB_DE_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_DE_THUMBKEY_MULTILINGUAL
import com.dessalines.thumbkey.keyboards.KB_DE_THUMBKEY_SYMBOLS
import com.dessalines.thumbkey.keyboards.KB_DE_THUMBKEY_SYMNUM
import com.dessalines.thumbkey.keyboards.KB_DE_THUMBKEY_WORDS
import com.dessalines.thumbkey.keyboards.KB_DE_TYPESPLIT
import com.dessalines.thumbkey.keyboards.KB_DE_TYPESPLIT_IMPROVED
import com.dessalines.thumbkey.keyboards.KB_ENLV_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_EN_COLUMNAR
import com.dessalines.thumbkey.keyboards.KB_EN_COLUMNAR_QUICK
import com.dessalines.thumbkey.keyboards.KB_EN_CZ_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_EN_DA_THUMBKEY_SYMBOLS
import com.dessalines.thumbkey.keyboards.KB_EN_DE_NL_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_EN_DE_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_EN_DE_THUMBKEY_AE
import com.dessalines.thumbkey.keyboards.KB_EN_DE_THUMBKEY_V2
import com.dessalines.thumbkey.keyboards.KB_EN_DOUBLE_SYMBOLS
import com.dessalines.thumbkey.keyboards.KB_EN_DVORAK_WIDE
import com.dessalines.thumbkey.keyboards.KB_EN_DVORAK_WIDE_COMPOSE
import com.dessalines.thumbkey.keyboards.KB_EN_EE_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_EN_EO_MESSAGEASE_SYMBOLS
import com.dessalines.thumbkey.keyboards.KB_EN_EO_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_EN_ES_CA_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_EN_ES_CA_TWO_HANDS
import com.dessalines.thumbkey.keyboards.KB_EN_FR_MESSAGEASE_SYMBOLS
import com.dessalines.thumbkey.keyboards.KB_EN_HR_MESSAGEASE
import com.dessalines.thumbkey.keyboards.KB_EN_HYPER
import com.dessalines.thumbkey.keyboards.KB_EN_HYPER_SPACE
import com.dessalines.thumbkey.keyboards.KB_EN_IT_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_EN_LA_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_EN_MESSAGEASE
import com.dessalines.thumbkey.keyboards.KB_EN_MESSAGEASE_COMPOSE
import com.dessalines.thumbkey.keyboards.KB_EN_MESSAGEASE_LEFT
import com.dessalines.thumbkey.keyboards.KB_EN_MESSAGEASE_LEFT_SYMBOLS
import com.dessalines.thumbkey.keyboards.KB_EN_MESSAGEASE_SYMBOLS
import com.dessalines.thumbkey.keyboards.KB_EN_MESSAGEASE_SYMBOLS_MODIFIERS
import com.dessalines.thumbkey.keyboards.KB_EN_MESSAGEASE_SYMBOLS_TWO_HANDS
import com.dessalines.thumbkey.keyboards.KB_EN_MESSAGEASE_TWO_HANDS
import com.dessalines.thumbkey.keyboards.KB_EN_MESSAGEASE_WRITER
import com.dessalines.thumbkey.keyboards.KB_EN_MI_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_EN_MI_THUMBKEY_SYMBOLS
import com.dessalines.thumbkey.keyboards.KB_EN_NL_TYPESPLIT
import com.dessalines.thumbkey.keyboards.KB_EN_NO_MESSAGEASE_SYMBOLS
import com.dessalines.thumbkey.keyboards.KB_EN_NO_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_EN_NO_TYPESPLIT
import com.dessalines.thumbkey.keyboards.KB_EN_PH_MESSAGEASE
import com.dessalines.thumbkey.keyboards.KB_EN_PL_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_EN_QBASED
import com.dessalines.thumbkey.keyboards.KB_EN_QBASED_LEFT
import com.dessalines.thumbkey.keyboards.KB_EN_QWERTEASE
import com.dessalines.thumbkey.keyboards.KB_EN_QWERTEASE_TWO_HANDS
import com.dessalines.thumbkey.keyboards.KB_EN_QWERTYFOUR
import com.dessalines.thumbkey.keyboards.KB_EN_QWERTYFOUR_COMPOSE
import com.dessalines.thumbkey.keyboards.KB_EN_RO_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_EN_RSINOA
import com.dessalines.thumbkey.keyboards.KB_EN_SK_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_EN_SV_THUMBKEY_PROGRAMMING
import com.dessalines.thumbkey.keyboards.KB_EN_SYMBOLS_NUMBERS_ARROWS_TWO_HANDS
import com.dessalines.thumbkey.keyboards.KB_EN_SYMBOLS_NUMBERS_ARROWS_TWO_HANDS_COMPACT
import com.dessalines.thumbkey.keyboards.KB_EN_SYMBOLS_NUMBERS_TWO_HANDS
import com.dessalines.thumbkey.keyboards.KB_EN_SYMBOLS_TWO_HANDS
import com.dessalines.thumbkey.keyboards.KB_EN_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_EN_THUMBKEY_COMPOSE
import com.dessalines.thumbkey.keyboards.KB_EN_THUMBKEY_FLIPPED_NUMPAD
import com.dessalines.thumbkey.keyboards.KB_EN_THUMBKEY_PROGRAMMING
import com.dessalines.thumbkey.keyboards.KB_EN_THUMBKEY_PROGRAMMING_EXPANDED
import com.dessalines.thumbkey.keyboards.KB_EN_THUMBKEY_PROGRAMMING_WIDE
import com.dessalines.thumbkey.keyboards.KB_EN_THUMBKEY_SYMBOLS
import com.dessalines.thumbkey.keyboards.KB_EN_THUMBKEY_WIDE
import com.dessalines.thumbkey.keyboards.KB_EN_THUMBKEY_WORDS
import com.dessalines.thumbkey.keyboards.KB_EN_THUMBKEY_WORDS_SYMBOLS
import com.dessalines.thumbkey.keyboards.KB_EN_THUMBKEY_WORDS_SYMBOLS_DUAL
import com.dessalines.thumbkey.keyboards.KB_EN_THUMBKEY_WRITER
import com.dessalines.thumbkey.keyboards.KB_EN_TWO_HANDS
import com.dessalines.thumbkey.keyboards.KB_EN_TYPESPLIT
import com.dessalines.thumbkey.keyboards.KB_EN_TYPESPLIT_PROGRAMMING
import com.dessalines.thumbkey.keyboards.KB_EN_TYPESPLIT_SHORT
import com.dessalines.thumbkey.keyboards.KB_EO_CYRILLIC_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_EO_EN_DE_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_ES_CA_MESSAGEASE
import com.dessalines.thumbkey.keyboards.KB_ES_CA_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_ES_EO_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_ES_MESSAGEASE
import com.dessalines.thumbkey.keyboards.KB_ES_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_ES_THUMBKEY_SYMBOLS
import com.dessalines.thumbkey.keyboards.KB_ES_TYPESPLIT
import com.dessalines.thumbkey.keyboards.KB_EUROPE_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_EU_ES_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_EU_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_FA_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_FA_THUMBKEY_SAMSUNG
import com.dessalines.thumbkey.keyboards.KB_FI_EE_MESSAGEASE_SYMBOLS
import com.dessalines.thumbkey.keyboards.KB_FI_MESSAGEASE
import com.dessalines.thumbkey.keyboards.KB_FI_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_FI_THUMBKEY_WIDE
import com.dessalines.thumbkey.keyboards.KB_FI_TYPESPLIT
import com.dessalines.thumbkey.keyboards.KB_FR_EN_FRAPPE_FLUIDE_V1
import com.dessalines.thumbkey.keyboards.KB_FR_MESSAGEASE
import com.dessalines.thumbkey.keyboards.KB_FR_THUMBKEY_V1
import com.dessalines.thumbkey.keyboards.KB_FR_THUMBKEY_V2
import com.dessalines.thumbkey.keyboards.KB_FR_THUMBKEY_V3
import com.dessalines.thumbkey.keyboards.KB_FR_TYPESPLIT
import com.dessalines.thumbkey.keyboards.KB_GLAGOLITIC_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_GRNORM_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_GRNORM_THUMBKEY_SYMBOLS
import com.dessalines.thumbkey.keyboards.KB_GR_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_HE_MESSAGEASE
import com.dessalines.thumbkey.keyboards.KB_HE_MESSAGEASE_SYMBOLS
import com.dessalines.thumbkey.keyboards.KB_HE_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_HI_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_HI_THUMBKEY_EXTENDED
import com.dessalines.thumbkey.keyboards.KB_HR_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_HR_THUMBKEY_SYMBOLS
import com.dessalines.thumbkey.keyboards.KB_HR_TWO_HANDS
import com.dessalines.thumbkey.keyboards.KB_HU_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_HU_TYPESPLIT
import com.dessalines.thumbkey.keyboards.KB_ID_THUMBKEY_SYMBOLS_NUMBERS_V1
import com.dessalines.thumbkey.keyboards.KB_ID_THUMBKEY_SYMBOLS_V1
import com.dessalines.thumbkey.keyboards.KB_ID_THUMBKEY_SYMBOLS_V2
import com.dessalines.thumbkey.keyboards.KB_IT_MESSAGEASE
import com.dessalines.thumbkey.keyboards.KB_IT_MESSAGEASE_SYMBOLS
import com.dessalines.thumbkey.keyboards.KB_IT_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_IT_TYPESPLIT
import com.dessalines.thumbkey.keyboards.KB_JA_HIRAGANA_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_JA_HIRAGANA_TYPESPLIT
import com.dessalines.thumbkey.keyboards.KB_JA_KANA_STANDARD
import com.dessalines.thumbkey.keyboards.KB_JA_KANA_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_JA_KATAKANA_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_JA_KATAKANA_TYPESPLIT
import com.dessalines.thumbkey.keyboards.KB_KA_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_KN_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_KR_ONETHUMB
import com.dessalines.thumbkey.keyboards.KB_KR_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_KR_TYPESPLIT
import com.dessalines.thumbkey.keyboards.KB_KZ_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_LT_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_LV_LTG_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_MATH_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_MY_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_NL_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_NL_TYPESPLIT
import com.dessalines.thumbkey.keyboards.KB_NO_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_NO_THUMBKEY_DATADRIVEN
import com.dessalines.thumbkey.keyboards.KB_PL_MESSAGEASE
import com.dessalines.thumbkey.keyboards.KB_PL_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_PL_TYPESPLIT_SYMBOLS_V1
import com.dessalines.thumbkey.keyboards.KB_PL_TYPESPLIT_SYMBOLS_V2
import com.dessalines.thumbkey.keyboards.KB_PL_TYPESPLIT_V1
import com.dessalines.thumbkey.keyboards.KB_PL_TYPESPLIT_V2
import com.dessalines.thumbkey.keyboards.KB_PT_DVORAK_WIDE
import com.dessalines.thumbkey.keyboards.KB_PT_EN_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_PT_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_PT_TYPESPLIT
import com.dessalines.thumbkey.keyboards.KB_RU_ARTI
import com.dessalines.thumbkey.keyboards.KB_RU_HYPER
import com.dessalines.thumbkey.keyboards.KB_RU_MESSAGEASE
import com.dessalines.thumbkey.keyboards.KB_RU_MESSAGEASE_SYMBOLS
import com.dessalines.thumbkey.keyboards.KB_RU_MESSAGEASE_WRITER
import com.dessalines.thumbkey.keyboards.KB_RU_MESSAGE_OWL
import com.dessalines.thumbkey.keyboards.KB_RU_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_RU_THUMBKEY_SYMBOLS
import com.dessalines.thumbkey.keyboards.KB_RU_THUMBKEY_WRITER
import com.dessalines.thumbkey.keyboards.KB_SCANDINAVIAN_MESSAGEASE
import com.dessalines.thumbkey.keyboards.KB_SK_THUMBKEY_V1
import com.dessalines.thumbkey.keyboards.KB_SK_THUMBKEY_V2
import com.dessalines.thumbkey.keyboards.KB_SK_THUMBKEY_V3
import com.dessalines.thumbkey.keyboards.KB_SL_MESSAGEASE_SYMBOLS
import com.dessalines.thumbkey.keyboards.KB_SRLATN_EN_DE_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_SRLATN_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_SR_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_SV_MESSAGEASE
import com.dessalines.thumbkey.keyboards.KB_SV_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_T9
import com.dessalines.thumbkey.keyboards.KB_TH_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_TH_THUMBKEY_KHAM_CHUEAM
import com.dessalines.thumbkey.keyboards.KB_TOK_SITELEN_THUMBKEY_EMOJI
import com.dessalines.thumbkey.keyboards.KB_TOK_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_TR_ARTI
import com.dessalines.thumbkey.keyboards.KB_TR_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_TR_TYPESPLIT
import com.dessalines.thumbkey.keyboards.KB_UK_BY_RU_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_UK_MESSAGEASE_SYMBOLS
import com.dessalines.thumbkey.keyboards.KB_UK_RU_MESSAGEASE_SYMBOLS
import com.dessalines.thumbkey.keyboards.KB_UK_THUMBKEY
import com.dessalines.thumbkey.keyboards.KB_VN_THUMBKEY

// Make sure new keyboards are added AT THE END of this list, and have a higher index.
// DO NOT put them in the middle of the list!
enum class KeyboardLayout(
    val keyboardDefinition: KeyboardDefinition,
) {
    ENThumbKey(KB_EN_THUMBKEY), // "english thumb-key"
    ENThumbKeyProgramming(KB_EN_THUMBKEY_PROGRAMMING), // "english thumb-key programming"
    DEThumbKey(KB_DE_THUMBKEY), // deutsch thumb-key
    DAThumbKey(KB_DA_THUMBKEY), // dansk thumb-key
    ESThumbKey(KB_ES_THUMBKEY), // español thumb-key
    EUThumbKey(KB_EU_THUMBKEY), // euskara thumb-key
    FAThumbKey(KB_FA_THUMBKEY), // فارسی thumb-key
    FIThumbKey(KB_FI_THUMBKEY), // suomi thumb-key
    FRThumbKeyV1(KB_FR_THUMBKEY_V1), // français thumb-key v1
    ITThumbKey(KB_IT_THUMBKEY), // italiano thumb-key
    NLThumbKey(KB_NL_THUMBKEY), // nederlands thumb-key
    PLThumbKey(KB_PL_THUMBKEY), // polski thumb-key
    PTThumbKey(KB_PT_THUMBKEY), // português thumb-key
    RUThumbKey(KB_RU_THUMBKEY), // русский thumb-key
    UKThumbKey(KB_UK_THUMBKEY), // українська thumb-key
    ENMessagEase(KB_EN_MESSAGEASE), // english messagease
    ENMessagEaseSymbols(KB_EN_MESSAGEASE_SYMBOLS), // english messagease symbols
    HEMessagEase(KB_HE_MESSAGEASE), // עברית messagease
    RUThumbKeySymbols(KB_RU_THUMBKEY_SYMBOLS), // русский thumb-key symbols
    BYThumbKey(KB_BY_THUMBKEY), // беларуская thumb-key
    BYThumbKeySymbols(KB_BY_THUMBKEY_SYMBOLS), // беларуская з сімваламі thumb-key
    ENThumbKeySymbols(KB_EN_THUMBKEY_SYMBOLS), // english thumb-key symbols
    FIThumbKeyWide(KB_FI_THUMBKEY_WIDE), // suomi thumb-key wide
    DEMessagEase(KB_DE_MESSAGEASE), // deutsch messagease
    NOThumbKey(KB_NO_THUMBKEY), // norsk thumb-key
    DEThumbKeyMultiLingual(KB_DE_THUMBKEY_MULTILINGUAL), // deutsch multilingual thumb-key
    KAThumbKey(KB_KA_THUMBKEY), // kartuli ena thumb-key
    IDThumbKeySymbolsV1(KB_ID_THUMBKEY_SYMBOLS_V1), // bahasa indonesia thumb-key symbols v1
    FRMessagEase(KB_FR_MESSAGEASE), // français messagease
    RUMessagEaseSymbols(KB_RU_MESSAGEASE_SYMBOLS), // русский messagease symbols
    T9(KB_T9), // T9
    JAHiraganaThumbKey(KB_JA_HIRAGANA_THUMBKEY), // japanese hiragana thumb-key
    JAKatakanaThumbKey(KB_JA_KATAKANA_THUMBKEY), // japanese katakana thumb-key
    FRThumbKeyV2(KB_FR_THUMBKEY_V2), // français thumb-key v2
    SVThumbKey(KB_SV_THUMBKEY), // svenska thumb-key
    TRThumbKey(KB_TR_THUMBKEY), // türkçe thumb-key
    ENTypeSplit(KB_EN_TYPESPLIT), // english type-split
    ESTypeSplit(KB_ES_TYPESPLIT), // español type-split
    DETypeSplit(KB_DE_TYPESPLIT), // deutsch type-split
    FRTypeSplit(KB_FR_TYPESPLIT), // français type-split
    ITTypeSplit(KB_IT_TYPESPLIT), // italiano type-split
    PTTypeSplit(KB_PT_TYPESPLIT), // português type-split
    PLTypeSplitV2(KB_PL_TYPESPLIT_V2), // polski type-split v2
    ENTwoHands(KB_EN_TWO_HANDS), // english two-hands
    ENThumbKeyProgrammingWide(KB_EN_THUMBKEY_PROGRAMMING_WIDE), // english thumb-key programming wide
    HUThumbKey(KB_HU_THUMBKEY), // magyar thumb-key
    ESEOThumbKey(KB_ES_EO_THUMBKEY), // español esperanto thumb-key
    ITMessagEase(KB_IT_MESSAGEASE), // italiano messagease
    ENSKThumbKey(KB_EN_SK_THUMBKEY), // english slovenčina thumb-key
    HEThumbKey(KB_HE_THUMBKEY), // עברית thumb-key
    EOENDEThumbKey(KB_EO_EN_DE_THUMBKEY), // esperanto english deutsch thumb-key
    GRThumbKey(KB_GR_THUMBKEY), // ελληνικά thumb-key
    ENCZThumbKey(KB_EN_CZ_THUMBKEY), // english čeština thumb-key
    ESMessagEase(KB_ES_MESSAGEASE), // español messagease
    RUMessagEase(KB_RU_MESSAGEASE), // русский messagease
    BGThumbKeySymbols(KB_BG_THUMBKEY_SYMBOLS), // български със символи thumb-key
    HRTwoHands(KB_HR_TWO_HANDS), // hrvatski two-hands
    HRThumbKey(KB_HR_THUMBKEY), // hrvatski thumb-key
    HRThumbKeySymbols(KB_HR_THUMBKEY_SYMBOLS), // hrvatski thumb-key symbols
    FITypeSplit(KB_FI_TYPESPLIT), // suomi type-split
    LVLTGThumbKey(KB_LV_LTG_THUMBKEY), // latviešu valoda thumb-key
    LTThumbKey(KB_LT_THUMBKEY), // lietuvių kalba thumb-key
    IDThumbKeySymbolsV2(KB_ID_THUMBKEY_SYMBOLS_V2), // bahasa indonesia thumb-key symbols v2
    IDThumbKeySymbolsNumbers(KB_ID_THUMBKEY_SYMBOLS_NUMBERS_V1), // bahasa indonesia thumb-key symbols-numbers v1
    ESCAThumbKey(KB_ES_CA_THUMBKEY), // español català thumb-key
    ENITThumbKey(KB_EN_IT_THUMBKEY), // english italiano thumb-key
    ENEOMessagEaseSymbols(KB_EN_EO_MESSAGEASE_SYMBOLS), // english esperanto messagease symbols
    UKRUMessagEaseSymbols(KB_UK_RU_MESSAGEASE_SYMBOLS), // українська русский messagease symbols
    DEMessagEaseSymbols(KB_DE_MESSAGEASE_SYMBOLS), // deutsch symbols messagease
    CAThumbKey(KB_CA_THUMBKEY), // canadian aboriginal syllabic thumb-key
    MATHThumbKey(KB_MATH_THUMBKEY), // math thumb-key
    ENEEThumbKey(KB_EN_EE_THUMBKEY), // english eegbe thumb-key
    SKThumbKeyV1(KB_SK_THUMBKEY_V1), // slovenčina thumb-key v1
    ENNOTypeSplit(KB_EN_NO_TYPESPLIT), // english norsk type-split
    ENThumbKeyCompose(KB_EN_THUMBKEY_COMPOSE), // english thumb-key compose
    ENNOThumbKey(KB_EN_NO_THUMBKEY), // english norsk thumb-key
    ENSymbolsTwoHands(KB_EN_SYMBOLS_TWO_HANDS), // english symbols two-hands
    ENSymbolsNumbersTwoHands(KB_EN_SYMBOLS_NUMBERS_TWO_HANDS), // english symbols-numbers two-hands
    JAHiraganaTypeSplit(KB_JA_HIRAGANA_TYPESPLIT), // japanese hiragana type-split
    JAKatakanaTypeSplit(KB_JA_KATAKANA_TYPESPLIT), // japanese katakana type-split
    EUESThumbKey(KB_EU_ES_THUMBKEY), // euskara español thumb-key
    ENQwertyFour(KB_EN_QWERTYFOUR), // english qwertyfour
    KZThumbKey(KB_KZ_THUMBKEY), // қазақша thumb-key
    ENMIThumbKey(KB_EN_MI_THUMBKEY), // english te reo māori thumb-key
    ENMIThumbKeySymbols(KB_EN_MI_THUMBKEY_SYMBOLS), // english te reo māori symbols thumb-key
    ESCAMessagEase(KB_ES_CA_MESSAGEASE), // español català messagease
    SVMessagEase(KB_SV_MESSAGEASE), // svenska messagease
    ENDoubleSymbols(KB_EN_DOUBLE_SYMBOLS), // english double symbols
    FIMessagEase(KB_FI_MESSAGEASE), // suomi messagease
    ENDAThumbKeySymbols(KB_EN_DA_THUMBKEY_SYMBOLS), // english dansk thumb-key symbols
    FIEEMessagEase(KB_FI_EE_MESSAGEASE_SYMBOLS), // suomi eesti messagease
    ENPLThumbkey(KB_EN_PL_THUMBKEY), // english polski thumb-key
    BGMessagEasePhoneticSymbols(KB_BG_MESSAGEASE_PHONETIC_SYMBOLS), // bulgarian messagease phonetic symbols
    UKMessagEaseSymbols(KB_UK_MESSAGEASE_SYMBOLS), // українська messagease symbols
    ENFRMessagEaseSymbols(KB_EN_FR_MESSAGEASE_SYMBOLS), // english français messagease symbols
    HEMessagEaseSymbols(KB_HE_MESSAGEASE_SYMBOLS), // עברית messagease symbols
    ENNOMessagEaseSymbols(KB_EN_NO_MESSAGEASE_SYMBOLS), // english norsk messagease symbols
    SLMessagEaseSymbols(KB_SL_MESSAGEASE_SYMBOLS), // slovenščina messagease symbols
    ENMessagEaseLeft(KB_EN_MESSAGEASE_LEFT), // english messagease left-handed
    ENMessagEaseLeftSymbols(KB_EN_MESSAGEASE_LEFT_SYMBOLS), // english messagease left-handed symbols
    ENEOThumbKey(KB_EN_EO_THUMBKEY), // english esperanto thumb-key
    ENPHMessagEase(KB_EN_PH_MESSAGEASE), // english wikang tagalog messagease
    EOCyrillicThumbKey(KB_EO_CYRILLIC_THUMBKEY), // esperanto cyrillic thumb-key
    HUTypeSplit(KB_HU_TYPESPLIT), // magyar type-split
    ENROThumbKey(KB_EN_RO_THUMBKEY), // english română thumb-key
    ENLAThumbKey(KB_EN_LA_THUMBKEY), // english latina thumb-key
    NLTypeSplit(KB_NL_TYPESPLIT), // nederlands type-split
    PLMessagEase(KB_PL_MESSAGEASE), // polski messagease
    ENMessagEaseCompose(KB_EN_MESSAGEASE_COMPOSE), // english messagease compose
    BRFRThumbKey(KB_BR_FR_THUMBKEY), // brezhoneg français thumb-key
    ENMessagEaseTwoHands(KB_EN_MESSAGEASE_TWO_HANDS), // english messagease two-hands
    ENDEThumbKey(KB_EN_DE_THUMBKEY), // english deutsch thumb-key
    ENHRMessagEase(KB_EN_HR_MESSAGEASE), // english hrvatski messagease
    CZMessagEaseProgramming(KB_CZ_MESSAGEASE_PROGRAMMING), // čeština messagease programming
    ENDEThumbKeyV2(KB_EN_DE_THUMBKEY_V2), // english deutsch thumb-key v2
    ENESCAThumbKey(KB_EN_ES_CA_THUMBKEY), // english español català thumb-key
    DENordicMessagEase(KB_DE_NORDIC_MESSAGEASE), // deutsch messagease +åæø
    VNThumbKey(KB_VN_THUMBKEY), // tiếng việt thumb-key
    TOKThumbKey(KB_TOK_THUMBKEY), // toki pona thumb-key
    TOKSitelenThumbKeyEmoji(KB_TOK_SITELEN_THUMBKEY_EMOJI), // toki pona sitelen thumb-key emoji
    PLTypeSplitSymbolsV2(KB_PL_TYPESPLIT_SYMBOLS_V2), // polski symbols type-split v2
    SKThumbKeyV2(KB_SK_THUMBKEY_V2), // slovenčina thumb-key v2
    ITMessagEaseSymbols(KB_IT_MESSAGEASE_SYMBOLS), // italiano messagease symbols
    ENQwertease(KB_EN_QWERTEASE), // english qwertease
    ENQwerteaseTwoHands(KB_EN_QWERTEASE_TWO_HANDS), // english qwertease two-hands
    ENThumbKeyWide(KB_EN_THUMBKEY_WIDE), // english thumb-key wide
    ENQBased(KB_EN_QBASED), // english qbased
    ENQBasedLeft(KB_EN_QBASED_LEFT), // english qbased left-handed
    DEThumbkeySymbols(KB_DE_THUMBKEY_SYMBOLS), // deutsch thumb-key symbols
    ENQwertyFourCompose(KB_EN_QWERTYFOUR_COMPOSE), // english qwertyfour compose
    ENThumbKeyWriter(KB_EN_THUMBKEY_WRITER), // english thumb-key writer
    JAKanaThumbKey(KB_JA_KANA_THUMBKEY), // japanese kana thumb-key
    FAThumbKeySamsung(KB_FA_THUMBKEY_SAMSUNG), // فارسی thumb-key samsung
    DEENThumbkeyAE(KB_EN_DE_THUMBKEY_AE), // english deutsch thumb-key +æ
    SKThumbKeyV3(KB_SK_THUMBKEY_V3), // slovenčina thumb-key v3
    EuropeThumbkey(KB_EUROPE_THUMBKEY), // european thumb-key
    ENMessagEaseSymbolsTwoHands(KB_EN_MESSAGEASE_SYMBOLS_TWO_HANDS), // english messagease symbols two-hands
    RUThumbKeyWriter(KB_RU_THUMBKEY_WRITER), // русский writer thumb-key
    ENMessagEaseWriter(KB_EN_MESSAGEASE_WRITER), // english messagease writer
    RUMessagEaseWriter(KB_RU_MESSAGEASE_WRITER), // русский messagease writer
    ENSVThumbKeyProgramming(KB_EN_SV_THUMBKEY_PROGRAMMING), // english svenska thumb-key programming
    ESThumbKeySymbols(KB_ES_THUMBKEY_SYMBOLS), // español thumb-key symbols
    ENThumbKeyWords(KB_EN_THUMBKEY_WORDS), // english thumb-key words
    ENDENLThumbKey(KB_EN_DE_NL_THUMBKEY), // english deutsch nederlands thumb-key
    ENRsinoa(KB_EN_RSINOA), // english rsinoa
    ENTypeSplitShort(KB_EN_TYPESPLIT_SHORT), // english type-split short
    PLTypeSplitV1(KB_PL_TYPESPLIT_V1), // polski type-split v1
    PLTypeSplitSymbolsV1(KB_PL_TYPESPLIT_SYMBOLS_V1), // polski symbols type-split v1
    GlagoliticThumbkey(KB_GLAGOLITIC_THUMBKEY), // ⰳⰾⰰⰳⱁⰾⰻⱌⰰ thumb-key
    ENColumnar(KB_EN_COLUMNAR), // english qwerty-columnar
    ENColumnarQuick(KB_EN_COLUMNAR_QUICK), // english qwerty-columnar quick
    UKBYRUThumbKey(KB_UK_BY_RU_THUMBKEY), // українська беларуская русский thumb-key
    PTENThumbKey(KB_PT_EN_THUMBKEY), // português english thumb-key
    ENThumbKeyProgrammingExpanded(KB_EN_THUMBKEY_PROGRAMMING_EXPANDED), // english thumb-key programming expanded
    HIThumbKey(KB_HI_THUMBKEY), // हिन्दी thumb-key
    ENNLTypeSplit(KB_EN_NL_TYPESPLIT), // english nederlands type-split
    HIThumbKeyExtended(KB_HI_THUMBKEY_EXTENDED), // हिन्दी thumb-key extended
    FRThumbKeyV3(KB_FR_THUMBKEY_V3), // français thumb-key v3
    DEThumbkeySymNum(KB_DE_THUMBKEY_SYMNUM), // deutsch thumb-key symnum
    TRTypeSplit(KB_TR_TYPESPLIT), // türkçe type-split
    ENDvorakWide(KB_EN_DVORAK_WIDE), // english dvorak wide
    ENDvorakWideCompose(KB_EN_DVORAK_WIDE_COMPOSE), // english dvorak wide compose
    ENMessagEaseSymbolsModifiers(KB_EN_MESSAGEASE_SYMBOLS_MODIFIERS), // english messagease symbols modifiers
    ARThumbKeyLevant(KB_AR_THUMBKEY_LEVANT), // عربية شامية thumb-key
    PTDvorakWide(KB_PT_DVORAK_WIDE), // português dvorak wide
    BRFRThumbKeyCompose(KB_BR_FR_THUMBKEY_COMPOSE), // brezhoneg français thumb-key compose
    ENHyper(KB_EN_HYPER), // english hyper
    ENThumbKeyWordsSymbols(KB_EN_THUMBKEY_WORDS_SYMBOLS), // english thumb-key words symbols
    ENHyperSpace(KB_EN_HYPER_SPACE), // english hyper space
    EnTypeSplitProgramming(KB_EN_TYPESPLIT_PROGRAMMING), // english type-split programming
    ENSymbolsNumbersArrowsTwoHands(KB_EN_SYMBOLS_NUMBERS_ARROWS_TWO_HANDS), // english symbols-numbers-arrows two-hands
    BRFRThumbKeyV3(KB_BR_FR_THUMBKEY_V3), // brezhoneg français thumb-key v3
    ENESCAENTwoHands(KB_EN_ES_CA_TWO_HANDS), // english español català two-hands
    DEThumbKeyWords(KB_DE_THUMBKEY_WORDS), // deutsch thumb-key words
    RUMessageOwl(KB_RU_MESSAGE_OWL), // русский owl
    DETypeSplitImproved(KB_DE_TYPESPLIT_IMPROVED), // deutsch type-split improved
    ENThumbkeyFlippedNumpad(KB_EN_THUMBKEY_FLIPPED_NUMPAD), // english thumb-key with a flipped numpad layout
    GRThumbKeyNormal(KB_GRNORM_THUMBKEY), // ελληνικά normal thumb-key
    GRNormThumbKeySymbols(KB_GRNORM_THUMBKEY_SYMBOLS), // ελληνικά thumb-key symbols
    DEMessageEaseInvertedNumpad(KB_DE_MESSAGEASE_INVERTED_NUMPAD), // deutsch messagease, inverted numpad
    DEMessagEaseLeft(KB_DE_MESSAGEASE_LEFT), // deutsch messagease left-handed
    DEMessagEaseLeftInvertedNumpad(KB_DE_MESSAGEASE_LEFT_INVERTED_NUMPAD), // deutsch messagease left-handed, inverted numpad
    TRArti(KB_TR_ARTI), // türkçe artı çok
    SRThumbKey(KB_SR_THUMBKEY), // српски / srpski thumb-key
    SRLatnThumbKey(KB_SRLATN_THUMBKEY), // srpski (latinica) thumb-key
    SRLatnEnDeThumbKey(KB_SRLATN_EN_DE_THUMBKEY), // srpski (latinica) engleski nemački thumb-key
    FRENFrappeFluideV1(KB_FR_EN_FRAPPE_FLUIDE_V1), // français frappefluide (fr+en) v1
    ENThumbKeyWordsSymbolsDual(KB_EN_THUMBKEY_WORDS_SYMBOLS_DUAL), // english thumb-key words symbols dual
    RUArti(KB_RU_ARTI), // русский плюс много
    DAThumbKeyMultiLingual(KB_DA_THUMBKEY_MULTILINGUAL), // dansk thumb-key
    ENSymbolsNumbersArrowsTwoHandsCompact(
        KB_EN_SYMBOLS_NUMBERS_ARROWS_TWO_HANDS_COMPACT,
    ), // english symbols-numbers-arrows two-hands compact
    ENLVThumbKey(KB_ENLV_THUMBKEY), // latviešu valoda english thumb-key
    KRTypeSplit(KB_KR_TYPESPLIT), // 한국어 type-split
    KRThumbKey(KB_KR_THUMBKEY), // 한국어 thumb-key
    RUHyper(KB_RU_HYPER), // русский hyper
    MYThumbKey(KB_MY_THUMBKEY), // myanmar thumb-key
    JAKanaStandard(KB_JA_KANA_STANDARD), // japanese standard kana keyboard
    KNThumbKey(KB_KN_THUMBKEY), // ಕನ್ನಡ thumb-key
    THThumbKey(KB_TH_THUMBKEY), // ภาษาไทย thai thumb-key
    THThumbKeyKhamChueam(KB_TH_THUMBKEY_KHAM_CHUEAM), // ภาษาไทย thai thumb-key คำเชื่อม",
    NOThumbKeyDataDriven(KB_NO_THUMBKEY_DATADRIVEN), // norsk thumb-key datadrevet
    KROneThumb(KB_KR_ONETHUMB), // 한국어 one-thumb
    ScandinavianMessagEase(KB_SCANDINAVIAN_MESSAGEASE), // scandinavian messagease
}
