## What's Changed in 5.0.12

- Adding a fast toggle for hiding letters. by @dessalines in [#1706](https://github.com/dessalines/thumb-key/pull/1706)
- Adding norsk data driven layout. by @dessalines in [#1705](https://github.com/dessalines/thumb-key/pull/1705)
- add keyboard name comments by @Toldry in [#1693](https://github.com/dessalines/thumb-key/pull/1693)
- Add Thai language by @sarchar in [#1700](https://github.com/dessalines/thumb-key/pull/1700)
- add more key actions by @Toldry in [#1692](https://github.com/dessalines/thumb-key/pull/1692)
- Add kannada language. by @dessalines in [#1691](https://github.com/dessalines/thumb-key/pull/1691)
- fix numeric wide underscore by @Toldry in [#1690](https://github.com/dessalines/thumb-key/pull/1690)
- Add instructions on spacebar word swiping to readme. by @dessalines in [#1689](https://github.com/dessalines/thumb-key/pull/1689)
- Using resources.getString by @dessalines in [#1688](https://github.com/dessalines/thumb-key/pull/1688)
- add ToggleABCMode key action by @Toldry in [#1677](https://github.com/dessalines/thumb-key/pull/1677)

## New Contributors

- @sarchar made their first contribution in [#1700](https://github.com/dessalines/thumb-key/pull/1700)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/5.0.11...5.0.12

## What's Changed in 5.0.11

- Use jauderho prettier image. by @dessalines in [#1672](https://github.com/dessalines/thumb-key/pull/1672)
- Add spacebar bottom left and right swipes for previous and next word. by @dessalines in [#1670](https://github.com/dessalines/thumb-key/pull/1670)
- Fixing autocapitalize after multi-tap bug. by @dessalines in [#1671](https://github.com/dessalines/thumb-key/pull/1671)
- Don't bother writing fastlane changelog. by @dessalines in [#1669](https://github.com/dessalines/thumb-key/pull/1669)
- fix: follow title format for FAThumbKey.kt by @pxeemo in [#1667](https://github.com/dessalines/thumb-key/pull/1667)
- Fix fastlane changelog by @dessalines in [#1664](https://github.com/dessalines/thumb-key/pull/1664)
- Update RUHyper.kt by @bjarjfff in [#1646](https://github.com/dessalines/thumb-key/pull/1646)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/5.0.10...5.0.11

## What's Changed in 5.0.10

- Fixed kana cycle: tsu -> sokuon -> zu by @DeBestTrap in [#1640](https://github.com/dessalines/thumb-key/pull/1640)
- fix: korean composition breaking when switching layouts by @uranium-boy in [#1636](https://github.com/dessalines/thumb-key/pull/1636)
- Add back `gh` to français frappefluide by @jiquiame in [#1639](https://github.com/dessalines/thumb-key/pull/1639)
- Updates English Thumb-Key Programmer Expanded to use default special keys; adds custom numeric layout by @Hate9 in [#1634](https://github.com/dessalines/thumb-key/pull/1634)
- Standard japanese keyboard by @K0baU in [#1630](https://github.com/dessalines/thumb-key/pull/1630)
- add Wurstfinger as related project by @cl445 in [#1632](https://github.com/dessalines/thumb-key/pull/1632)
- Fixed incorrect swipetype in center key on KRThumbKey by @Hate9 in [#1621](https://github.com/dessalines/thumb-key/pull/1621)
- Update RUHyper.kt by @bjarjfff in [#1616](https://github.com/dessalines/thumb-key/pull/1616)

## New Contributors

- @DeBestTrap made their first contribution in [#1640](https://github.com/dessalines/thumb-key/pull/1640)
- @cl445 made their first contribution in [#1632](https://github.com/dessalines/thumb-key/pull/1632)
- @bjarjfff made their first contribution in [#1616](https://github.com/dessalines/thumb-key/pull/1616)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/5.0.9...5.0.10

## What's Changed in 5.0.9

- Adding a few keyboards. by @dessalines in [#1611](https://github.com/dessalines/thumb-key/pull/1611)
- Update FRENFrappeFluideV1: Better spot for backtick, on main layer by @jiquiame in [#1598](https://github.com/dessalines/thumb-key/pull/1598)
- Update FRENFrappeFluideV1: Add ff and gh by @jiquiame in [#1594](https://github.com/dessalines/thumb-key/pull/1594)
- Update FRENFrappeFluideV1: Add # to principal layer in [#1590](https://github.com/dessalines/thumb-key/pull/1590)
- switch language resets to main by @Toldry in [#1586](https://github.com/dessalines/thumb-key/pull/1586)

## New Contributors

- @jiquiame made their first contribution in [#1598](https://github.com/dessalines/thumb-key/pull/1598)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/5.0.8...5.0.9

## What's Changed in 5.0.8

- Add `ch` to frenfrappefluidev1 in [#1584](https://github.com/dessalines/thumb-key/pull/1584)
- Adds Korean Thumb-Key layout by @Hate9 in [#1575](https://github.com/dessalines/thumb-key/pull/1575)
- Update fren frappefluide v1 : move delete_word in [#1570](https://github.com/dessalines/thumb-key/pull/1570)
- Update FREN_frappefluide_v1 in [#1550](https://github.com/dessalines/thumb-key/pull/1550)
- ENMessagEaseSymbolsModifiers: Add "up" and "down" keys by @federvieh in [#1560](https://github.com/dessalines/thumb-key/pull/1560)
- CommonKeys: Add return programming key item by @federvieh in [#1561](https://github.com/dessalines/thumb-key/pull/1561)
- Key modifications: Fix NPE if ctrled/alted are empty by @federvieh in [#1552](https://github.com/dessalines/thumb-key/pull/1552)

## New Contributors

- @federvieh made their first contribution in [#1560](https://github.com/dessalines/thumb-key/pull/1560)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/5.0.7...5.0.8

## What's Changed in 5.0.7

- Add Korean layout and custom input processor implementation by @uranium-boy in [#1534](https://github.com/dessalines/thumb-key/pull/1534)
- Update README.md by @jwkwshjsjsj
- Verify apk fingerprint. by @dessalines in [#1528](https://github.com/dessalines/thumb-key/pull/1528)
- English based Latvian keyboard by @HX3A in [#1522](https://github.com/dessalines/thumb-key/pull/1522)
- downgrade agp version (closes #1514) by @pohmelie in [#1521](https://github.com/dessalines/thumb-key/pull/1521)
- add top bottom action keys to documentation by @pohmelie in [#1520](https://github.com/dessalines/thumb-key/pull/1520)

## New Contributors

- @uranium-boy made their first contribution in [#1534](https://github.com/dessalines/thumb-key/pull/1534)
- @jwkwshjsjsj made their first contribution
- @HX3A made their first contribution in [#1522](https://github.com/dessalines/thumb-key/pull/1522)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/5.0.6...5.0.7

## What's Changed in 5.0.6

- add top bottom key actions (closes #1418) by @pohmelie in [#1512](https://github.com/dessalines/thumb-key/pull/1512)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/5.0.5...5.0.6

## What's Changed in 5.0.5

- adds new layout: english twohands symbols numbers arrows compact. by @bklaase in [#1507](https://github.com/dessalines/thumb-key/pull/1507)
- Remove mention of the deprecated moving cursor up or down lines from the README by @JulienVig in [#1506](https://github.com/dessalines/thumb-key/pull/1506)
- Add option to disable fullscreen editor by @jm355 in [#1499](https://github.com/dessalines/thumb-key/pull/1499)

## New Contributors

- @JulienVig made their first contribution in [#1506](https://github.com/dessalines/thumb-key/pull/1506)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/5.0.4...5.0.5

## What's Changed in 5.0.4

- limfjorden's PR by @dessalines in [#1496](https://github.com/dessalines/thumb-key/pull/1496)
- add "show toast on layout switch" option by @pohmelie in [#1495](https://github.com/dessalines/thumb-key/pull/1495)
- feat: Add swipeReturn to key mods by @Toldry in [#1493](https://github.com/dessalines/thumb-key/pull/1493)
- add extensionDefinitionPrefix to key mods YAML by @Toldry in [#1492](https://github.com/dessalines/thumb-key/pull/1492)
- Update README.md by @Toldry in [#1490](https://github.com/dessalines/thumb-key/pull/1490)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/5.0.3...5.0.4

## What's Changed in 5.0.3

- Adding setting to ignore bottom padding. by @dessalines in [#1477](https://github.com/dessalines/thumb-key/pull/1477)
- Update README.md by @Toldry in [#1480](https://github.com/dessalines/thumb-key/pull/1480)
- Move migrations to own file. by @dessalines in [#1479](https://github.com/dessalines/thumb-key/pull/1479)
- Fix a few stringres param issues. by @dessalines in [#1478](https://github.com/dessalines/thumb-key/pull/1478)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/5.0.2...5.0.3

## What's Changed in 5.0.2

- Revert "Fix bottom padding for Android 15+ " by @dessalines in [#1465](https://github.com/dessalines/thumb-key/pull/1465)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/5.0.1...5.0.2

## What's Changed in 5.0.1

- Fix bottom padding for Android 15+ by @juschmitt in [#1463](https://github.com/dessalines/thumb-key/pull/1463)
- Fix navigation header back action by @alerque in [#1464](https://github.com/dessalines/thumb-key/pull/1464)
- Add RU adaption of 'türkçe artı çok' layout by @alerque in [#1460](https://github.com/dessalines/thumb-key/pull/1460)
- Accomodate lack of shifted support on numeric layouts by @alerque
- Adding alerque as a codeowner. by @dessalines in [#1459](https://github.com/dessalines/thumb-key/pull/1459)
- add `HideKeyboard` to readme by @pohmelie in [#1458](https://github.com/dessalines/thumb-key/pull/1458)
- Invert primary/secondary currency for TR vs. KZ use by @alerque
- Override key actions with thumb-key Russian letters by @alerque
- Shuffle symbols around on 'TR Artı' to accomodate Thumb Key Russian letters by @alerque
- Reduce error-prone duplicate symbols with copied and modified keys by @alerque
- Initialize Russian layout based on 'türkçe artı çok' by @alerque
- Add utility methods to keys for easier modification of existing layouts by @alerque

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/5.0.0...5.0.1

## What's Changed in 5.0.0

- add hide keyboard action by @pohmelie in [#1456](https://github.com/dessalines/thumb-key/pull/1456)
- Add option to automatically scale keyboard to screen width by @alerque in [#1424](https://github.com/dessalines/thumb-key/pull/1424)
- Setup auto-with calculations for new 'Dual' layout position by @alerque
- Add split keyboard layout to the position cycle by @jm355 in [#1443](https://github.com/dessalines/thumb-key/pull/1443)
- feat: add anchors to keyboard modifications by @Toldry in [#1452](https://github.com/dessalines/thumb-key/pull/1452)
- Address CoPilot review issues, improve function signatures by @alerque
- Overhaul migrations to avoid SQLite & Room limitations by @alerque
- Fix long press numeric key yaml by @jm355 in [#1453](https://github.com/dessalines/thumb-key/pull/1453)
- Add FRENFrappeFluideV1 in [#1450](https://github.com/dessalines/thumb-key/pull/1450)

## New Contributors

- @pohmelie made their first contribution in [#1456](https://github.com/dessalines/thumb-key/pull/1456)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/4.0.36...5.0.0

## What's Changed in 4.0.36

- Add Serbian language layouts, both Cyrillic and Latin scripts by @markokocic in [#1440](https://github.com/dessalines/thumb-key/pull/1440)
- Restore colon and semi-colon to TR+ keyboard by @alerque in [#1438](https://github.com/dessalines/thumb-key/pull/1438)
- Implement 3-row emoji picker for wide layout keyboards by @alerque in [#1422](https://github.com/dessalines/thumb-key/pull/1422)
- Make emoji keyboard row count automatic based on main layout by @alerque
- Implement 3-row emoji picker for wide layout keyboards by @alerque
- Deconflate size vs. width vs. height and save user input values by @alerque
- Add option to calculate key size based on available screen width by @alerque
- Small follow up tweaks to TR+ keyboard by @alerque in [#1421](https://github.com/dessalines/thumb-key/pull/1421)
- Add new TR+ keyboard with EN+TR language and typographic symbols by @alerque in [#1420](https://github.com/dessalines/thumb-key/pull/1420)
- ntfy message fix. by @dessalines in [#1419](https://github.com/dessalines/thumb-key/pull/1419)

## New Contributors

- @markokocic made their first contribution in [#1440](https://github.com/dessalines/thumb-key/pull/1440)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/4.0.35...4.0.36

## What's Changed in 4.0.35

- fix emoji picker ignoring navigationBars in Android 15 by @mruncreative in [#1413](https://github.com/dessalines/thumb-key/pull/1413)
- Added Keyboard: MessagEase German Left / Inverted Numpad by @beeh5 in [#1408](https://github.com/dessalines/thumb-key/pull/1408)

## New Contributors

- @beeh5 made their first contribution in [#1408](https://github.com/dessalines/thumb-key/pull/1408)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/4.0.34...4.0.35

## What's Changed in 4.0.34

- added combining marks example by @Toldry in [#1395](https://github.com/dessalines/thumb-key/pull/1395)
- Adjust Vietnamese layout to use correct tone marks by @3T1C in [#1391](https://github.com/dessalines/thumb-key/pull/1391)
- Adding android lint. by @dessalines in [#1390](https://github.com/dessalines/thumb-key/pull/1390)

## New Contributors

- @3T1C made their first contribution in [#1391](https://github.com/dessalines/thumb-key/pull/1391)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/4.0.33...4.0.34

## What's Changed in 4.0.33

- modify keys: support keyboards up to size 10x10 by @Toldry in [#1386](https://github.com/dessalines/thumb-key/pull/1386)
- feat: added `keyAction` to key mods by @Toldry in [#1385](https://github.com/dessalines/thumb-key/pull/1385)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/4.0.32...4.0.33

## What's Changed in 4.0.32

- Fix issue: key modifications screen shows error by @Toldry in [#1377](https://github.com/dessalines/thumb-key/pull/1377)
- Added greek keyboards with greek layout and greek character accents by @VMichailidis in [#1376](https://github.com/dessalines/thumb-key/pull/1376)

## New Contributors

- @VMichailidis made their first contribution in [#1376](https://github.com/dessalines/thumb-key/pull/1376)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/4.0.31...4.0.32

## What's Changed in 4.0.31

- Adding @Keep to fix key_mod data classes. by @dessalines in [#1375](https://github.com/dessalines/thumb-key/pull/1375)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/4.0.30...4.0.31

## What's Changed in 4.0.30

- Fixing key mods. by @dessalines in [#1374](https://github.com/dessalines/thumb-key/pull/1374)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/4.0.29...4.0.30

## What's Changed in 4.0.29

- Using lets instead of null and empty checks. by @dessalines in [#1369](https://github.com/dessalines/thumb-key/pull/1369)
- feature/key_modifications by @Toldry in [#1364](https://github.com/dessalines/thumb-key/pull/1364)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/4.0.28...4.0.29

## What's Changed in 4.0.28

- added flipped numpad layout for EN thumbkey by @axolotl-being in [#1363](https://github.com/dessalines/thumb-key/pull/1363)
- Adding DE_TYPESPLIT_IMPROVED. by @dessalines in [#1360](https://github.com/dessalines/thumb-key/pull/1360)
- fixed Hebrew final letters by @Toldry in [#1349](https://github.com/dessalines/thumb-key/pull/1349)

## New Contributors

- @axolotl-being made their first contribution in [#1363](https://github.com/dessalines/thumb-key/pull/1363)
- @Toldry made their first contribution in [#1349](https://github.com/dessalines/thumb-key/pull/1349)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/4.0.27...4.0.28

## What's Changed in 4.0.27

- Update Hyper's symbol layer with small changes by @luminespire in [#1340](https://github.com/dessalines/thumb-key/pull/1340)
- feat: add owl-layout by @owl-from-hogvarts in [#1337](https://github.com/dessalines/thumb-key/pull/1337)
- Translated using Weblate (Arabic) by @weblate
- Translated using Weblate (Polish) by @weblate
- Translated using Weblate (Turkish) by @weblate
- Translated using Weblate (Slovak) by @weblate
- Translated using Weblate (Japanese) by @weblate
- Translated using Weblate (Chinese (Simplified Han script)) by @weblate
- Translated using Weblate (Ukrainian) by @weblate
- Translated using Weblate (Russian) by @weblate
- Translated using Weblate (Italian) by @weblate
- Translated using Weblate (French) by @weblate
- Translated using Weblate (Persian) by @weblate
- Translated using Weblate (Spanish) by @weblate
- Translated using Weblate (German) by @weblate
- Translated using Weblate (Danish) by @weblate
- Translated using Weblate (Breton) by @weblate
- Translated using Weblate (Bulgarian) by @weblate
- Added translation using Weblate (Arabic) by @williampiti
- Translated using Weblate (Japanese) by @williampiti
- Translated using Weblate (Japanese) by @williampiti
- Translated using Weblate (Polish) by @e-michalak
- Translated using Weblate (Japanese) by @williampiti

## New Contributors

- @owl-from-hogvarts made their first contribution in [#1337](https://github.com/dessalines/thumb-key/pull/1337)
- @williampiti made their first contribution
- @e-michalak made their first contribution

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/4.0.26...4.0.27

## What's Changed in 4.0.26

- ENMessagEaseSymbolsModifiers: Enter & Tab by @W-Bosman in [#1331](https://github.com/dessalines/thumb-key/pull/1331)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/4.0.25...4.0.26

## What's Changed in 4.0.25

- Add turkish locale. by @dessalines
- A few code fixes. by @dessalines in [#1313](https://github.com/dessalines/thumb-key/pull/1313)
- Adding DE_THUMBKEY_WORDS layout. by @dessalines in [#1312](https://github.com/dessalines/thumb-key/pull/1312)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/4.0.24...4.0.25

## What's Changed in 4.0.24

- Toki Pona keyboard improvments by @nfd9001 in [#1308](https://github.com/dessalines/thumb-key/pull/1308)
- Smart Quotes „“ Tested by @mruncreative in [#1309](https://github.com/dessalines/thumb-key/pull/1309)
- Add ENESCATwoHands layout by @josereyesjrz in [#1301](https://github.com/dessalines/thumb-key/pull/1301)

## New Contributors

- @nfd9001 made their first contribution in [#1308](https://github.com/dessalines/thumb-key/pull/1308)
- @mruncreative made their first contribution in [#1309](https://github.com/dessalines/thumb-key/pull/1309)
- @josereyesjrz made their first contribution in [#1301](https://github.com/dessalines/thumb-key/pull/1301)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/4.0.23...4.0.24

## What's Changed in 4.0.23

- Update Hyper symbol layer and punctuation by @luminespire in [#1293](https://github.com/dessalines/thumb-key/pull/1293)
- Update old br-fr keyboards and create a new BRFRThumbKeyV3 by @zeecho in [#1290](https://github.com/dessalines/thumb-key/pull/1290)
- Draft: use minSwipeLength setting for DragReturn and Circular detection by @stfstf123 in [#1244](https://github.com/dessalines/thumb-key/pull/1244)

## New Contributors

- @stfstf123 made their first contribution in [#1244](https://github.com/dessalines/thumb-key/pull/1244)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/4.0.22...4.0.23

## What's Changed in 4.0.22

- Add voice input option to README.md by @jm355 in [#1286](https://github.com/dessalines/thumb-key/pull/1286)
- Update ENThumbKeyWordsSymbols.kt by @jm355 in [#1282](https://github.com/dessalines/thumb-key/pull/1282)
- Slightly loosen password field definition for disabling animations by @bklaase in [#1280](https://github.com/dessalines/thumb-key/pull/1280)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/4.0.21...4.0.22

## What's Changed in 4.0.21

- adds variant layout: English Twohanded with symbols, numbers, and arrows by @bklaase in [#1278](https://github.com/dessalines/thumb-key/pull/1278)
- Add "I'll" autocapitalizer for word layout by @jm355 in [#1275](https://github.com/dessalines/thumb-key/pull/1275)
- neon theme make purple slightly brighter. by @bklaase in [#1276](https://github.com/dessalines/thumb-key/pull/1276)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/4.0.20...4.0.21

## What's Changed in 4.0.20

- Slight tweaks to en typesplit programming layout by @bklaase in [#1274](https://github.com/dessalines/thumb-key/pull/1274)
- add English Typesplit layout, optimized for programming by @bklaase in [#1272](https://github.com/dessalines/thumb-key/pull/1272)
- add hyper space and minor fixes to hyper by @luminespire in [#1268](https://github.com/dessalines/thumb-key/pull/1268)
- Add layout with words and common symbols by @jm355 in [#1262](https://github.com/dessalines/thumb-key/pull/1262)
- Update README.md to include other voice input option (transcribro) by @jm355 in [#1263](https://github.com/dessalines/thumb-key/pull/1263)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/4.0.19...4.0.20

## What's Changed in 4.0.19

- add hyper layout by @luminespire in [#1260](https://github.com/dessalines/thumb-key/pull/1260)

## New Contributors

- @luminespire made their first contribution in [#1260](https://github.com/dessalines/thumb-key/pull/1260)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/4.0.18...4.0.19

## What's Changed in 4.0.18

- Theme/neon -> slightly mute purple to better fit android app palettes by @bklaase in [#1259](https://github.com/dessalines/thumb-key/pull/1259)
- Add Neon theme(s) by @bklaase in [#1258](https://github.com/dessalines/thumb-key/pull/1258)
- Skipping weblate updates for git cliff. by @dessalines
- Adding more weblate share to readme. by @dessalines in [#1246](https://github.com/dessalines/thumb-key/pull/1246)
- Use svg badge by @dessalines
- Adding weblate translations url. by @dessalines in [#1242](https://github.com/dessalines/thumb-key/pull/1242)

## New Contributors

- @bklaase made their first contribution in [#1259](https://github.com/dessalines/thumb-key/pull/1259)
- @weblate made their first contribution in [#1247](https://github.com/dessalines/thumb-key/pull/1247)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/4.0.17...4.0.18

## What's Changed in 4.0.17

- Relatively large change to JAKanaThumbKey.kt by @K0baU in [#1241](https://github.com/dessalines/thumb-key/pull/1241)
- Add Breton translation by @zeecho in [#1240](https://github.com/dessalines/thumb-key/pull/1240)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/4.0.16...4.0.17

## What's Changed in 4.0.16

- Fix ´ compose in dvorak Shifted by @lyluqo in [#1238](https://github.com/dessalines/thumb-key/pull/1238)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/4.0.15...4.0.16

## What's Changed in 4.0.15

- Layout portuguese dvorak wide by @lyluqo in [#1234](https://github.com/dessalines/thumb-key/pull/1234)
- Add Tab, Esc in dvorak-wide by @lyluqo in [#1232](https://github.com/dessalines/thumb-key/pull/1232)
- Add Breton French compose keyboard by @zeecho in [#1231](https://github.com/dessalines/thumb-key/pull/1231)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/4.0.14...4.0.15

## What's Changed in 4.0.14

- Update NumericWide ° \* # by @lyluqo in [#1227](https://github.com/dessalines/thumb-key/pull/1227)
- Fix swipe types of NumericWide by @lyluqo in [#1226](https://github.com/dessalines/thumb-key/pull/1226)
- Fix dvorak compose ´ by @lyluqo in [#1225](https://github.com/dessalines/thumb-key/pull/1225)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/4.0.13...4.0.14

## What's Changed in 4.0.13

- Adding Arabic levant thumbkey keyboard. by @dessalines in [#1224](https://github.com/dessalines/thumb-key/pull/1224)
- Support for CTRL&ALT modified keyboards. ENMessagEaseSymbolsModified. by @W-Bosman in [#1220](https://github.com/dessalines/thumb-key/pull/1220)

## New Contributors

- @W-Bosman made their first contribution in [#1220](https://github.com/dessalines/thumb-key/pull/1220)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/4.0.12...4.0.13

## What's Changed in 4.0.12

- Adding fastlane generation. by @dessalines in [#1219](https://github.com/dessalines/thumb-key/pull/1219)
- Using a center-aligned app bar. by @dessalines in [#1217](https://github.com/dessalines/thumb-key/pull/1217)
- Fixing icon dep. by @dessalines in [#1214](https://github.com/dessalines/thumb-key/pull/1214)
- Add Layout english dvorak wide compose by @lyluqo in [#1213](https://github.com/dessalines/thumb-key/pull/1213)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/4.0.11...4.0.12

## What's Changed in 4.0.11

- Moving undo/redo to bottom left and bottom right swipes. by @dessalines in [#1210](https://github.com/dessalines/thumb-key/pull/1210)
- Update NumericWide by @lyluqo in [#1211](https://github.com/dessalines/thumb-key/pull/1211)
- Add some missing keys on the shifted layout and ! on numeric ? swipeReturn by @Raghnarok in [#1207](https://github.com/dessalines/thumb-key/pull/1207)

## New Contributors

- @lyluqo made their first contribution in [#1211](https://github.com/dessalines/thumb-key/pull/1211)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/4.0.10...4.0.11

## What's Changed in 4.0.10

- Added Dvorak style wide keyboard by @iacobo in [#1201](https://github.com/dessalines/thumb-key/pull/1201)
- TR spit fix by @ganyuss in [#1205](https://github.com/dessalines/thumb-key/pull/1205)
- Add RLM and LRM control characters to Hebrew keyboard by @roihershberg in [#1202](https://github.com/dessalines/thumb-key/pull/1202)
- Add TR split layout by @ganyuss in [#1197](https://github.com/dessalines/thumb-key/pull/1197)
- Add ShiftAndCapsLock by @K0baU in [#1188](https://github.com/dessalines/thumb-key/pull/1188)

## New Contributors

- @iacobo made their first contribution in [#1201](https://github.com/dessalines/thumb-key/pull/1201)
- @ganyuss made their first contribution in [#1205](https://github.com/dessalines/thumb-key/pull/1205)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/4.0.9...4.0.10

## What's Changed in 4.0.9

- Fix keyboard overlapping navigation bar on Android 15 by @juschmitt in [#1190](https://github.com/dessalines/thumb-key/pull/1190)
- Fix Layout deutsch english + Æ (#1064) by @havky in [#1189](https://github.com/dessalines/thumb-key/pull/1189)

## New Contributors

- @juschmitt made their first contribution in [#1190](https://github.com/dessalines/thumb-key/pull/1190)
- @havky made their first contribution in [#1189](https://github.com/dessalines/thumb-key/pull/1189)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/4.0.8...4.0.9

## What's Changed in 4.0.8

- Reverting delete key hacks. by @dessalines in [#1183](https://github.com/dessalines/thumb-key/pull/1183)
- Adding DE_THUMBKEY_SYMNUM by @dessalines in [#1182](https://github.com/dessalines/thumb-key/pull/1182)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/4.0.7...4.0.8

## What's Changed in 4.0.7

- Upgrading compile sdk. by @dessalines in [#1175](https://github.com/dessalines/thumb-key/pull/1175)
- Update FRThumbKeyV1 to add dots, quotation marks and some letters by @terrylaire in [#1174](https://github.com/dessalines/thumb-key/pull/1174)
- Handle emoji correctly when deleting text by @gitterrost4 in [#1169](https://github.com/dessalines/thumb-key/pull/1169)
- Revert "Update kotlin monorepo to v2.1.0" by @dessalines in [#1166](https://github.com/dessalines/thumb-key/pull/1166)

## New Contributors

- @terrylaire made their first contribution in [#1174](https://github.com/dessalines/thumb-key/pull/1174)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/4.0.6...4.0.7

## What's Changed in 4.0.6

- Improvements for French language by @salsifis in [#1161](https://github.com/dessalines/thumb-key/pull/1161)
- Make the backspace key remove text directly instead of sending a DEL keycode by @gitterrost4 in [#1162](https://github.com/dessalines/thumb-key/pull/1162)

## New Contributors

- @salsifis made their first contribution in [#1161](https://github.com/dessalines/thumb-key/pull/1161)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/4.0.5...4.0.6

## What's Changed in 4.0.5

- Add some swipeReturn actions to the french ThumbKey v2 layout by @Raghnarok in [#1160](https://github.com/dessalines/thumb-key/pull/1160)
- Swipe-returning on a ghost key will now trigger the action of the ghost key by @gitterrost4 in [#1158](https://github.com/dessalines/thumb-key/pull/1158)
- Swipe improvement for drag-return and circle-drag motions by @gitterrost4 in [#1156](https://github.com/dessalines/thumb-key/pull/1156)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/4.0.4...4.0.5

## What's Changed in 4.0.4

- Fix #1128 – Add two symbols to FRThumbKeyV2 layout by @Raghnarok in [#1153](https://github.com/dessalines/thumb-key/pull/1153)

## New Contributors

- @Raghnarok made their first contribution in [#1153](https://github.com/dessalines/thumb-key/pull/1153)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/4.0.3...4.0.4

## What's Changed in 4.0.3

- Hindi layout 2 by @dessalines in [#1142](https://github.com/dessalines/thumb-key/pull/1142)
- Keep spacebar consistent when shifted by @harmtemolder in [#1141](https://github.com/dessalines/thumb-key/pull/1141)
- add english nederlands typesplit layout by @renboe in [#1139](https://github.com/dessalines/thumb-key/pull/1139)
- Switches number keys in expanded developer layout to all use secondary color by @Hate9 in [#1138](https://github.com/dessalines/thumb-key/pull/1138)
- Adding Hindi Layout. by @dessalines in [#1131](https://github.com/dessalines/thumb-key/pull/1131)

## New Contributors

- @renboe made their first contribution in [#1139](https://github.com/dessalines/thumb-key/pull/1139)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/4.0.2...4.0.3

## What's Changed in 4.0.2

- Adds "english thumb-key programming expanded" layout by @Hate9 in [#1129](https://github.com/dessalines/thumb-key/pull/1129)

## New Contributors

- @Hate9 made their first contribution in [#1129](https://github.com/dessalines/thumb-key/pull/1129)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/4.0.1...4.0.2

## What's Changed in 4.0.0

- Convert gradle to kotlin by @dessalines in [#1124](https://github.com/dessalines/thumb-key/pull/1124)
- Add more actions for changing keyboard position by @iliazeus in [#1117](https://github.com/dessalines/thumb-key/pull/1117)
- Improve keyboard description DSL by @iliazeus in [#1115](https://github.com/dessalines/thumb-key/pull/1115)
- Changing renovate to every weekend. by @dessalines in [#1112](https://github.com/dessalines/thumb-key/pull/1112)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/3.4.16...4.0.0

## What's Changed in 3.4.16

- reset multi-tap state after one second delay by @iliazeus in [#1106](https://github.com/dessalines/thumb-key/pull/1106)
- Re-add leading space before composed opening double quote by @shtrom in [#1108](https://github.com/dessalines/thumb-key/pull/1108)
- Tweak nederlands type-split by @harmtemolder in [#1107](https://github.com/dessalines/thumb-key/pull/1107)

## New Contributors

- @iliazeus made their first contribution in [#1106](https://github.com/dessalines/thumb-key/pull/1106)
- @harmtemolder made their first contribution in [#1107](https://github.com/dessalines/thumb-key/pull/1107)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/3.4.15...3.4.16

## What's Changed in 3.4.15

- Re-organizing backup and restore into its own screen. by @dessalines in [#1100](https://github.com/dessalines/thumb-key/pull/1100)
- Adding portuguese + english thumbkey layout. by @dessalines in [#1096](https://github.com/dessalines/thumb-key/pull/1096)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/3.4.14...3.4.15

## What's Changed in 3.4.14

- Adding database exporting and importing. by @dessalines in [#1094](https://github.com/dessalines/thumb-key/pull/1094)
- Fixed ESCAMessagEase.kt by @co00co in [#1093](https://github.com/dessalines/thumb-key/pull/1093)

## New Contributors

- @co00co made their first contribution in [#1093](https://github.com/dessalines/thumb-key/pull/1093)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/3.4.13...3.4.14

## What's Changed in 3.4.13

- Updating git cliff. by @dessalines in [#1091](https://github.com/dessalines/thumb-key/pull/1091)
- Add UK+BY+RU ThumbKey layout by @josemam in [#1089](https://github.com/dessalines/thumb-key/pull/1089)

## New Contributors

- @josemam made their first contribution in [#1089](https://github.com/dessalines/thumb-key/pull/1089)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/3.4.12...3.4.13

## What's Changed in 3.4.12

- Add compose keys (caron, breve), quote sign toggle by @mpice-mn in [#1086](https://github.com/dessalines/thumb-key/pull/1086)
- Add renovate more often. by @dessalines in [#1084](https://github.com/dessalines/thumb-key/pull/1084)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/3.4.11...3.4.12

## What's Changed in 3.4.11

- Add QWERTY-Columnar layouts by @SED4906 in [#1075](https://github.com/dessalines/thumb-key/pull/1075)
- Add glagolitic layout by @adiee5 in [#1074](https://github.com/dessalines/thumb-key/pull/1074)

## New Contributors

- @SED4906 made their first contribution in [#1075](https://github.com/dessalines/thumb-key/pull/1075)
- @adiee5 made their first contribution in [#1074](https://github.com/dessalines/thumb-key/pull/1074)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/3.4.10...3.4.11

## What's Changed in 3.4.10

- Add spaces after toki pona words. by @dessalines in [#1072](https://github.com/dessalines/thumb-key/pull/1072)
- Add old polish type-split layouts back by @kkard2 in [#1070](https://github.com/dessalines/thumb-key/pull/1070)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/3.4.9...3.4.10

## What's Changed in 3.4.9

- English TypeSplit Short layout by @ChrisLHall in [#1069](https://github.com/dessalines/thumb-key/pull/1069)
- Update Danish translation by @Limfjorden in [#1067](https://github.com/dessalines/thumb-key/pull/1067)

## New Contributors

- @ChrisLHall made their first contribution in [#1069](https://github.com/dessalines/thumb-key/pull/1069)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/3.4.8...3.4.9

## What's Changed in 3.4.8

- Change duplicate : to tab in ENNOMessagEaseSymbols by @afreakk in [#1066](https://github.com/dessalines/thumb-key/pull/1066)
- update to new best layout by @lrvideckis in [#1063](https://github.com/dessalines/thumb-key/pull/1063)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/3.4.7...3.4.8

## What's Changed in 3.4.7

- Rsinoa layout by @lrvideckis in [#1057](https://github.com/dessalines/thumb-key/pull/1057)
- Adding CONTRIBUTING.md by @dessalines in [#1062](https://github.com/dessalines/thumb-key/pull/1062)

## New Contributors

- @lrvideckis made their first contribution in [#1057](https://github.com/dessalines/thumb-key/pull/1057)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/3.4.6...3.4.7

## What's Changed in 3.4.6

- New Layout EN / DE / NL incl new Numerical Layout by @freekvdmeer in [#1045](https://github.com/dessalines/thumb-key/pull/1045)
- Type split improvements by @h67ma in [#1054](https://github.com/dessalines/thumb-key/pull/1054)

## New Contributors

- @freekvdmeer made their first contribution in [#1045](https://github.com/dessalines/thumb-key/pull/1045)
- @h67ma made their first contribution in [#1054](https://github.com/dessalines/thumb-key/pull/1054)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/3.4.5...3.4.6

## What's Changed in 3.4.5

- Adding EN Thumbkey Words. by @dessalines in [#1039](https://github.com/dessalines/thumb-key/pull/1039)
- Added ES thumb-key symbols layout by @DiegoLpVn in [#1035](https://github.com/dessalines/thumb-key/pull/1035)

## New Contributors

- @DiegoLpVn made their first contribution in [#1035](https://github.com/dessalines/thumb-key/pull/1035)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/3.4.4...3.4.5

## What's Changed in 3.4.4

- add hyphen `-` to the first layer of FRThumbKeyV2.kt by @foldfree in [#1031](https://github.com/dessalines/thumb-key/pull/1031)
- Adding en + sv + programmer layout. by @dessalines in [#1030](https://github.com/dessalines/thumb-key/pull/1030)

## New Contributors

- @foldfree made their first contribution in [#1031](https://github.com/dessalines/thumb-key/pull/1031)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/3.4.3...3.4.4

## What's Changed in 3.4.3

- Added üÜ and ßẞ to DEMessagEaseNordic.kt, shifted ßẞ correctly in german keyboards by @MarvinBaral in [#1028](https://github.com/dessalines/thumb-key/pull/1028)

## New Contributors

- @MarvinBaral made their first contribution in [#1028](https://github.com/dessalines/thumb-key/pull/1028)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/3.4.2...3.4.3

## What's Changed in 3.4.2

- Show emoji key while in Shift mode in Programmer Wide layout by @kidhanis in [#1018](https://github.com/dessalines/thumb-key/pull/1018)

## New Contributors

- @kidhanis made their first contribution in [#1018](https://github.com/dessalines/thumb-key/pull/1018)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/3.4.1...3.4.2

## What's Changed in 3.4.1

- En/Ru MessagEasy Writer layouts by @Defrobe in [#1015](https://github.com/dessalines/thumb-key/pull/1015)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/3.4.0...3.4.1

## What's Changed in 3.4.0

- #702 Rewrite titles of layouts to `[languages] [base] [qualifiers] [version]` by @mpsijm in [#1007](https://github.com/dessalines/thumb-key/pull/1007)
- Create RUThumbKeyWriter.kt by @Defrobe in [#1005](https://github.com/dessalines/thumb-key/pull/1005)
- Swipe-and-return gesture to capitalize words on EN Writer layout by @Defrobe in [#1004](https://github.com/dessalines/thumb-key/pull/1004)

## New Contributors

- @Defrobe made their first contribution in [#1005](https://github.com/dessalines/thumb-key/pull/1005)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/3.3.6...3.4.0

## What's Changed in 3.3.6

- Fix european keyboard name. by @dessalines
- Add layout: English MessagEase two-hands symbols by @mpsijm in [#1002](https://github.com/dessalines/thumb-key/pull/1002)
- ESThumbKey.kt exclamation and question mark by @ZePotente in [#1001](https://github.com/dessalines/thumb-key/pull/1001)

## New Contributors

- @ZePotente made their first contribution in [#1001](https://github.com/dessalines/thumb-key/pull/1001)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/3.3.5...3.3.6

## What's Changed in 3.3.5

- European Thumb-Key layout by @marekjm in [#998](https://github.com/dessalines/thumb-key/pull/998)
- Adding simplified slovak layout, slovak thumbkey v3. by @dessalines in [#996](https://github.com/dessalines/thumb-key/pull/996)
- Adding renovate automerge. by @dessalines

## New Contributors

- @marekjm made their first contribution in [#998](https://github.com/dessalines/thumb-key/pull/998)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/3.3.4...3.3.5

## What's Changed in 3.3.4

- Adding DE + EN + AE keyboard. by @dessalines in [#991](https://github.com/dessalines/thumb-key/pull/991)
- Adding screen transitions. by @dessalines in [#990](https://github.com/dessalines/thumb-key/pull/990)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/3.3.3...3.3.4

## What's Changed in 3.3.3

- Farsi/Persian for Samsung devices by @Tirbod in [#984](https://github.com/dessalines/thumb-key/pull/984)
- Merge hiragana and katakana by @K0baU in [#985](https://github.com/dessalines/thumb-key/pull/985)
- Farsi/Persian Spacebar Multi-taps by @Tirbod in [#983](https://github.com/dessalines/thumb-key/pull/983)

## New Contributors

- @Tirbod made their first contribution in [#984](https://github.com/dessalines/thumb-key/pull/984)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/3.3.2...3.3.3

## What's Changed in 3.3.2

- Fixed swipetype on EN Writer keyboard by @locrianz in [#977](https://github.com/dessalines/thumb-key/pull/977)
- Fixed EN Writer keyboard by @locrianz in [#975](https://github.com/dessalines/thumb-key/pull/975)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/3.3.1...3.3.2

## What's Changed in 3.3.1

- Added ENThumbKeyWriter layout by @locrianz in [#970](https://github.com/dessalines/thumb-key/pull/970)
- Added swipe-and-return gesture to capitalize words (#964) by @gitterrost4 in [#966](https://github.com/dessalines/thumb-key/pull/966)
- Adding dependenciesInfo for f-droid builds by @dessalines in [#965](https://github.com/dessalines/thumb-key/pull/965)

## New Contributors

- @locrianz made their first contribution in [#970](https://github.com/dessalines/thumb-key/pull/970)
- @gitterrost4 made their first contribution in [#966](https://github.com/dessalines/thumb-key/pull/966)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/3.3.0...3.3.1

## What's Changed in 3.3.0

- Added ghost key functionality. by @matthew-sirman in [#961](https://github.com/dessalines/thumb-key/pull/961)
- Add composed qwertyfour layout by @sirlan-ff00ff in [#962](https://github.com/dessalines/thumb-key/pull/962)

## New Contributors

- @matthew-sirman made their first contribution in [#961](https://github.com/dessalines/thumb-key/pull/961)
- @sirlan-ff00ff made their first contribution in [#962](https://github.com/dessalines/thumb-key/pull/962)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/3.2.6...3.3.0

## What's Changed in 3.2.6

- MessageEase layouts: use numerics from MessageEase too by @gmelikov in [#960](https://github.com/dessalines/thumb-key/pull/960)
- RUMessagEaseSymbols: use messagease numerics by @gmelikov in [#959](https://github.com/dessalines/thumb-key/pull/959)

## New Contributors

- @gmelikov made their first contribution in [#960](https://github.com/dessalines/thumb-key/pull/960)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/3.2.5...3.2.6

## What's Changed in 3.2.5

- Ignoring build.sh by @dessalines
- Revert "Hebrew: added shifted layer using final letters" by @dessalines in [#958](https://github.com/dessalines/thumb-key/pull/958)
- Removing renovate from git cliff by @dessalines in [#954](https://github.com/dessalines/thumb-key/pull/954)
- Update layout english deutsch thumb-key v2 to fix #868 by @roomfullofcommits in [#955](https://github.com/dessalines/thumb-key/pull/955)

## New Contributors

- @roomfullofcommits made their first contribution in [#955](https://github.com/dessalines/thumb-key/pull/955)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/3.2.4...3.2.5

## What's Changed in 3.2.4

- Increasing gradle memory. by @dessalines
- Per-app language preference by @pxeemo in [#947](https://github.com/dessalines/thumb-key/pull/947)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/3.2.3...3.2.4

## What's Changed in 3.2.3

- Hebrew: added shifted layer using final letters by @yehoshuapw in [#944](https://github.com/dessalines/thumb-key/pull/944)
- DEThumbKey keyboard: Fixes exclamation mark. by @sphh in [#941](https://github.com/dessalines/thumb-key/pull/941)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/3.2.2...3.2.3

## What's Changed in 3.2.2

- Force LTR KeyboardScreen by @pxeemo in [#940](https://github.com/dessalines/thumb-key/pull/940)
- add DEThumbkeySymbols by @Ingegneus in [#939](https://github.com/dessalines/thumb-key/pull/939)
- Add letter K to "Italiano type-split" keyboard by @DvCCC66 in [#938](https://github.com/dessalines/thumb-key/pull/938)
- Fix "latest version" links in issue forms by @Nixill in [#936](https://github.com/dessalines/thumb-key/pull/936)

## New Contributors

- @Ingegneus made their first contribution in [#939](https://github.com/dessalines/thumb-key/pull/939)
- @DvCCC66 made their first contribution in [#938](https://github.com/dessalines/thumb-key/pull/938)
- @Nixill made their first contribution in [#936](https://github.com/dessalines/thumb-key/pull/936)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/3.2.1...3.2.2

## What's Changed in 3.2.1

- Adding a few more compose-boms. by @dessalines in [#934](https://github.com/dessalines/thumb-key/pull/934)
- Fix errors in CZProgrammerMessagEase by @ondrachwiedziuk in [#932](https://github.com/dessalines/thumb-key/pull/932)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/3.2.0...3.2.1

## What's Changed in 3.2.0

- Forgot another change. by @dessalines
- Removing unused strings. by @dessalines
- Tweak circular drag and drag-and-return gestures (fixes #926) by @glm4610 in [#928](https://github.com/dessalines/thumb-key/pull/928)
- Removing some unused strings. by @dessalines in [#929](https://github.com/dessalines/thumb-key/pull/929)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/3.1.9...3.2.0

## What's Changed in 3.1.9

- Enable strong skipping. by @dessalines in [#925](https://github.com/dessalines/thumb-key/pull/925)
- Removing renovate schedule. by @dessalines in [#923](https://github.com/dessalines/thumb-key/pull/923)
- Upgrading to 2.0.0 compiler. by @dessalines in [#922](https://github.com/dessalines/thumb-key/pull/922)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/3.1.8...3.1.9

## What's Changed in 3.1.8

- Revert "Update plugin org.jetbrains.kotlin.android to v2" by @dessalines in [#921](https://github.com/dessalines/thumb-key/pull/921)
- Make cursor movement detection index-based (fixes #881) by @glm4610 in [#917](https://github.com/dessalines/thumb-key/pull/917)
- Fix #304 (take two): In Utils.autoCapitalizeCheck, use input type of current editor by @mpsijm in [#909](https://github.com/dessalines/thumb-key/pull/909)
- Fixing donation line. by @dessalines in [#906](https://github.com/dessalines/thumb-key/pull/906)
- Add QBased a qwerty based keyboard by @WrennWhitlock in [#905](https://github.com/dessalines/thumb-key/pull/905)

## New Contributors

- @WrennWhitlock made their first contribution in [#905](https://github.com/dessalines/thumb-key/pull/905)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/3.1.7...3.1.8

## What's Changed in 3.1.7

- Tweak circular drag detection algorithm (fixes #894) by @glm4610 in [#904](https://github.com/dessalines/thumb-key/pull/904)
- Adding renovate. by @dessalines
- Improves symbols in main DEThumbKey keyboard. by @sphh in [#892](https://github.com/dessalines/thumb-key/pull/892)

## New Contributors

- @renovate[bot] made their first contribution in [#897](https://github.com/dessalines/thumb-key/pull/897)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/3.1.6...3.1.7

## What's Changed in 3.1.6

- Fix #304: Improve Utils.autoCapitalizeCheck by @mpsijm in [#890](https://github.com/dessalines/thumb-key/pull/890)
- Wide version of ThumbKey by @randomguy3 in [#889](https://github.com/dessalines/thumb-key/pull/889)

## New Contributors

- @randomguy3 made their first contribution in [#889](https://github.com/dessalines/thumb-key/pull/889)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/3.1.5...3.1.6

## What's Changed in 3.1.5

- Revert compose in DEMessagEaseSymbols layout by @Crandel in [#888](https://github.com/dessalines/thumb-key/pull/888)
- German thumbkey symbols `:` and `"` (Closes #882 #883) by @sphh in [#886](https://github.com/dessalines/thumb-key/pull/886)
- Add RLM character to FAThumbKey by @pxeemo in [#880](https://github.com/dessalines/thumb-key/pull/880)

## New Contributors

- @sphh made their first contribution in [#886](https://github.com/dessalines/thumb-key/pull/886)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/3.1.4...3.1.5

## What's Changed in 3.1.4

- Don't show animations for password fields. Fixes #800 by @dessalines in [#879](https://github.com/dessalines/thumb-key/pull/879)
- Simplify key width code. Fixes #643 by @dessalines in [#878](https://github.com/dessalines/thumb-key/pull/878)
- Cleaning up imports. by @dessalines in [#877](https://github.com/dessalines/thumb-key/pull/877)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/3.1.3...3.1.4

## What's Changed in 3.1.3

- Fixes and improvements in br-fr layout by @zeecho in [#875](https://github.com/dessalines/thumb-key/pull/875)
- Update ENQwertEase.kt by @Lysalana in [#873](https://github.com/dessalines/thumb-key/pull/873)
- Update ENTwoHandsQwertEase.kt by @Lysalana in [#874](https://github.com/dessalines/thumb-key/pull/874)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/3.1.2...3.1.3

## What's Changed in 3.1.2

- Two-hands QwertEase by @Lysalana in [#871](https://github.com/dessalines/thumb-key/pull/871)
- Create ENQwertEase.kt by @Lysalana in [#870](https://github.com/dessalines/thumb-key/pull/870)
- Updated numeric keyboard for "italiano messagease" by @DrOliver94 in [#864](https://github.com/dessalines/thumb-key/pull/864)
- Adding IT messagease symbols by @DrOliver94 in [#866](https://github.com/dessalines/thumb-key/pull/866)
- Move qu in spanish split keyboard by @Eloitor in [#860](https://github.com/dessalines/thumb-key/pull/860)

## New Contributors

- @DrOliver94 made their first contribution in [#864](https://github.com/dessalines/thumb-key/pull/864)
- @Eloitor made their first contribution in [#860](https://github.com/dessalines/thumb-key/pull/860)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/3.1.1...3.1.2

## What's Changed in 3.1.1

- Making haptic feedback use KEYBOARD_TAP constant. Fixes #862 by @dessalines in [#863](https://github.com/dessalines/thumb-key/pull/863)
- Fix crash when using Japanese thumb-key (fixes #858) by @glm4610 in [#861](https://github.com/dessalines/thumb-key/pull/861)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/3.1.0...3.1.1

## What's Changed in 3.1.0

- Upgrading deps. by @dessalines in [#857](https://github.com/dessalines/thumb-key/pull/857)
- Adding slovak v2 keyboard. Fixes #151 by @dessalines in [#856](https://github.com/dessalines/thumb-key/pull/856)
- Implement Drag-and-return & Circular drag by @feathecutie in [#854](https://github.com/dessalines/thumb-key/pull/854)
- Fix swipe direction and update Capital keyboard for EN_HR by @ssaric in [#853](https://github.com/dessalines/thumb-key/pull/853)
- Fixing bottom offset slider. by @dessalines in [#852](https://github.com/dessalines/thumb-key/pull/852)
- Add PLTypeSplitSymbols by @kkard2 in [#851](https://github.com/dessalines/thumb-key/pull/851)

## New Contributors

- @feathecutie made their first contribution in [#854](https://github.com/dessalines/thumb-key/pull/854)
- @kkard2 made their first contribution in [#851](https://github.com/dessalines/thumb-key/pull/851)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/3.0.0...3.1.0

## What's Changed in 3.0.0

- Fixing black-screen on startup. by @dessalines in [#850](https://github.com/dessalines/thumb-key/pull/850)
- Adding toki pona and sitelen emoji keyboards. by @dessalines in [#849](https://github.com/dessalines/thumb-key/pull/849)
- Simplifying KeyC default. by @dessalines in [#848](https://github.com/dessalines/thumb-key/pull/848)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/2.7.6...3.0.0

## What's Changed in 2.7.6

- Upgrade deps 27 by @dessalines in [#846](https://github.com/dessalines/thumb-key/pull/846)
- Fixes to the Eng-Esp-Cat thumbkey layout by @Norgus in [#845](https://github.com/dessalines/thumb-key/pull/845)
- Update composing and add it to DEMessagEaseSymbols by @mensogulo in [#844](https://github.com/dessalines/thumb-key/pull/844)
- Correct default French MessagEase layout (#830) by @glm4610 in [#840](https://github.com/dessalines/thumb-key/pull/840)
- Fixing vietnamese keyboard name. by @dessalines in [#842](https://github.com/dessalines/thumb-key/pull/842)

## New Contributors

- @glm4610 made their first contribution in [#840](https://github.com/dessalines/thumb-key/pull/840)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/2.7.5...2.7.6

## What's Changed in 2.7.5

- Vn thumbkey by @dessalines in [#837](https://github.com/dessalines/thumb-key/pull/837)
- Add German+ÅÆØ compatibility layout with MessageEase by @RolKau in [#832](https://github.com/dessalines/thumb-key/pull/832)
- Add breve supersign to compose layout by @mensogulo in [#836](https://github.com/dessalines/thumb-key/pull/836)

## New Contributors

- @RolKau made their first contribution in [#832](https://github.com/dessalines/thumb-key/pull/832)
- @mensogulo made their first contribution in [#836](https://github.com/dessalines/thumb-key/pull/836)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/2.7.4...2.7.5

## What's Changed in 2.7.4

- New Keyboard layout English Spanish Catalan by @Norgus in [#826](https://github.com/dessalines/thumb-key/pull/826)
- Fix add layout instructions. by @dessalines in [#828](https://github.com/dessalines/thumb-key/pull/828)
- He messag ease symbols add qmark by @BoredGeo in [#825](https://github.com/dessalines/thumb-key/pull/825)
- Fix some errors in CZProgrammerMessagEase by @ondrachwiedziuk in [#827](https://github.com/dessalines/thumb-key/pull/827)
- Removing cardano, this was never used. by @dessalines in [#824](https://github.com/dessalines/thumb-key/pull/824)

## New Contributors

- @Norgus made their first contribution in [#826](https://github.com/dessalines/thumb-key/pull/826)
- @BoredGeo made their first contribution in [#825](https://github.com/dessalines/thumb-key/pull/825)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/2.7.3...2.7.4

## What's Changed in 2.7.3

- added standart english layout with german umlauts by @philipp8101 in [#818](https://github.com/dessalines/thumb-key/pull/818)
- Add CZ programmer Messagease keyboard layout by @ondrachwiedziuk in [#821](https://github.com/dessalines/thumb-key/pull/821)
- Add EN HR MessageEase Variant by @ssaric in [#823](https://github.com/dessalines/thumb-key/pull/823)
- Upgrading deps. by @dessalines in [#819](https://github.com/dessalines/thumb-key/pull/819)

## New Contributors

- @philipp8101 made their first contribution in [#818](https://github.com/dessalines/thumb-key/pull/818)
- @ondrachwiedziuk made their first contribution in [#821](https://github.com/dessalines/thumb-key/pull/821)
- @ssaric made their first contribution in [#823](https://github.com/dessalines/thumb-key/pull/823)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/2.7.2...2.7.3

## What's Changed in 2.7.2

- Fixing woodpecker. by @dessalines in [#816](https://github.com/dessalines/thumb-key/pull/816)
- Update symbols for ukrainian-only messagease layout by @Meetoul in [#814](https://github.com/dessalines/thumb-key/pull/814)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/2.7.1...2.7.2

## What's Changed in 2.7.1

- Upgrading deps. by @dessalines in [#813](https://github.com/dessalines/thumb-key/pull/813)
- English Deutsch ThumbKey Layout by @queer-coding in [#810](https://github.com/dessalines/thumb-key/pull/810)
- Adding en_twohands_messagease. Fixes #806 by @dessalines in [#808](https://github.com/dessalines/thumb-key/pull/808)
- Numeric keyboard update to ENPHMessagEase.kt by @Lysalana in [#807](https://github.com/dessalines/thumb-key/pull/807)

## New Contributors

- @queer-coding made their first contribution in [#810](https://github.com/dessalines/thumb-key/pull/810)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/2.7.0...2.7.1

## What's Changed in 2.7.0

- Move to another preferences library, upgrade deps. by @dessalines in [#804](https://github.com/dessalines/thumb-key/pull/804)
- Update Russian translation by @ligurio in [#801](https://github.com/dessalines/thumb-key/pull/801)
- Added MessagEase Keyboard Tips section to README.md per comment in #745. by @frederickjh in [#799](https://github.com/dessalines/thumb-key/pull/799)

## New Contributors

- @frederickjh made their first contribution in [#799](https://github.com/dessalines/thumb-key/pull/799)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/2.6.25...2.7.0

## What's Changed in 2.6.25

- Add Chinese Simplified Translation by @WeiguangTWK in [#794](https://github.com/dessalines/thumb-key/pull/794)
- Use dakuten key for more characters by @K0baU in [#797](https://github.com/dessalines/thumb-key/pull/797)
- Update EO/EN/DE layout to make shift/capslock behavior match other layouts by @slashdevslashurandom in [#795](https://github.com/dessalines/thumb-key/pull/795)
- Add Breton French keyboard by @zeecho in [#793](https://github.com/dessalines/thumb-key/pull/793)

## New Contributors

- @WeiguangTWK made their first contribution in [#794](https://github.com/dessalines/thumb-key/pull/794)
- @slashdevslashurandom made their first contribution in [#795](https://github.com/dessalines/thumb-key/pull/795)
- @zeecho made their first contribution in [#793](https://github.com/dessalines/thumb-key/pull/793)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/2.6.24...2.6.25

## What's Changed in 2.6.24

- Fixing corner size. Fixes #789 by @dessalines in [#791](https://github.com/dessalines/thumb-key/pull/791)
- Update quotes and numbers on BG ME Phonetic Symbols by @pavlov-p in [#787](https://github.com/dessalines/thumb-key/pull/787)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/2.6.23...2.6.24

## What's Changed in 2.6.23

- Still working on upgrading deps. by @dessalines in [#785](https://github.com/dessalines/thumb-key/pull/785)
- Add english composed messagease based on the symbols variant by @shtrom in [#786](https://github.com/dessalines/thumb-key/pull/786)
- Fix dakuten and handakuten not composing by @LortalHost in [#782](https://github.com/dessalines/thumb-key/pull/782)
- Fix generate changelog script. by @dessalines in [#784](https://github.com/dessalines/thumb-key/pull/784)
- Update the tag pattern for changelog generation by @orhun in [#781](https://github.com/dessalines/thumb-key/pull/781)
- Space before ponctuation for French spacebar multitap. Fixes #291. by @soupirs in [#780](https://github.com/dessalines/thumb-key/pull/780)
- Fixing various mistakes in Polish messagease layout. by @zworek in [#778](https://github.com/dessalines/thumb-key/pull/778)

## New Contributors

- @shtrom made their first contribution in [#786](https://github.com/dessalines/thumb-key/pull/786)
- @LortalHost made their first contribution in [#782](https://github.com/dessalines/thumb-key/pull/782)
- @orhun made their first contribution in [#781](https://github.com/dessalines/thumb-key/pull/781)
- @zworek made their first contribution in [#778](https://github.com/dessalines/thumb-key/pull/778)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/2.6.22...2.6.23

## What's Changed in 2.6.22

- Fixing pl_messagease numeric spacebar. by @dessalines in [#777](https://github.com/dessalines/thumb-key/pull/777)
- Add Polish MessagEase layout by @Blackweather in [#774](https://github.com/dessalines/thumb-key/pull/774)
- Adding NL Typesplit. Fixes #775 by @dessalines in [#776](https://github.com/dessalines/thumb-key/pull/776)

## New Contributors

- @Blackweather made their first contribution in [#774](https://github.com/dessalines/thumb-key/pull/774)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/2.6.21...2.6.22

## What's Changed in 2.6.21

- Create english latina thumb-key in [#773](https://github.com/dessalines/thumb-key/pull/773)
- Rename MessageEase to MessagEase. Fixes #769 by @dessalines in [#771](https://github.com/dessalines/thumb-key/pull/771)
- Improved Hungarian Type-split swipemaps by @KnockoffFeline in [#770](https://github.com/dessalines/thumb-key/pull/770)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/2.6.20...2.6.21

## What's Changed in 2.6.20

- Remove up down spacebar swipes. Fixes #766 by @dessalines in [#768](https://github.com/dessalines/thumb-key/pull/768)
- Create english română thumb-key in [#767](https://github.com/dessalines/thumb-key/pull/767)
- Fixed Hungarian Type-split layout by @KnockoffFeline in [#764](https://github.com/dessalines/thumb-key/pull/764)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/2.6.19...2.6.20

## What's Changed in 2.6.19

- Update ENPHMessageEase.kt by @Lysalana in [#760](https://github.com/dessalines/thumb-key/pull/760)
- Added Hungarian Type-split layout by @KnockoffFeline in [#761](https://github.com/dessalines/thumb-key/pull/761)
- Feature/rework es me by @asdkant in [#762](https://github.com/dessalines/thumb-key/pull/762)
- Hebrew symbols messageease fixup by @yehoshuapw in [#753](https://github.com/dessalines/thumb-key/pull/753)
- Fix EOCyrillicThumbKey.kt by @imthehumanoid in [#750](https://github.com/dessalines/thumb-key/pull/750)
- Fixed English Esperanto keyboard layout by @imthehumanoid in [#749](https://github.com/dessalines/thumb-key/pull/749)

## New Contributors

- @Lysalana made their first contribution in [#760](https://github.com/dessalines/thumb-key/pull/760)
- @imthehumanoid made their first contribution in [#750](https://github.com/dessalines/thumb-key/pull/750)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/2.6.18...2.6.19

## What's Changed in 2.6.18

- [NLThumbKey] Accented letters didn't work yet and made them muted by @GuyKlaassen in [#742](https://github.com/dessalines/thumb-key/pull/742)
- Adding english tagalog messagease. Fixes #743 by @dessalines in [#747](https://github.com/dessalines/thumb-key/pull/747)
- Hebrew MessagEase symbols: remove shift by @yehoshuapw in [#738](https://github.com/dessalines/thumb-key/pull/738)
- Adding english esperanto thumb-key keyboard. Fixes #736 by @dessalines in [#739](https://github.com/dessalines/thumb-key/pull/739)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/2.6.17...2.6.18

## What's Changed in 2.6.17

- Fixing animations. Fixes #732 by @dessalines in [#735](https://github.com/dessalines/thumb-key/pull/735)
- Fixing layout names. Fixes #733 by @dessalines in [#734](https://github.com/dessalines/thumb-key/pull/734)
- Update Ukrainian translation by @Sestowner in [#730](https://github.com/dessalines/thumb-key/pull/730)
- MessagEase Hebrew: use MessagEase numeric by @yehoshuapw in [#731](https://github.com/dessalines/thumb-key/pull/731)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/2.6.16...2.6.17

## What's Changed in 2.6.16

- better swipe to delete word by @pxeemo in [#725](https://github.com/dessalines/thumb-key/pull/725)
- Implement non-square keys by @Zwyx in [#692](https://github.com/dessalines/thumb-key/pull/692)
- Use combine characters for dakuten/handakuten by @K0baU in [#721](https://github.com/dessalines/thumb-key/pull/721)
- Upgrading git cliff init. by @dessalines in [#729](https://github.com/dessalines/thumb-key/pull/729)
- Add accented e's to NLThumbKey.kt by @GuyKlaassen in [#727](https://github.com/dessalines/thumb-key/pull/727)
- MessagEase ES Numeric: add ¨, fix placing of < and > by @asdkant in [#722](https://github.com/dessalines/thumb-key/pull/722)

## New Contributors

- @GuyKlaassen made their first contribution in [#727](https://github.com/dessalines/thumb-key/pull/727)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/2.6.15...2.6.16

## What's Changed in 2.6.15

- CommonKeys.kt: Show swipes on NUMERIC_KEY_ITEM also on ABC_KEY_ITEM by @mpsijm in [#720](https://github.com/dessalines/thumb-key/pull/720)
- Add long-press actions to keys by @ShortCircuit908 in [#711](https://github.com/dessalines/thumb-key/pull/711)
- Fixes for English MessagEase keyboard by @mpsijm in [#719](https://github.com/dessalines/thumb-key/pull/719)
- Enhancements on issue forms by @asdkant in [#717](https://github.com/dessalines/thumb-key/pull/717)
- Adding RELEASES.md in assets folder. #400 by @dessalines in [#716](https://github.com/dessalines/thumb-key/pull/716)
- Add left handed EN messagease by @BlueDrink9 in [#696](https://github.com/dessalines/thumb-key/pull/696)
- Add Matrix-AMOLED theme by @BlueDrink9 in [#699](https://github.com/dessalines/thumb-key/pull/699)

## New Contributors

- @mpsijm made their first contribution in [#720](https://github.com/dessalines/thumb-key/pull/720)
- @ShortCircuit908 made their first contribution in [#711](https://github.com/dessalines/thumb-key/pull/711)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/2.6.14...2.6.15

## What's Changed in 2.6.14

- Remove need to manually index layouts by @BlueDrink9 in [#701](https://github.com/dessalines/thumb-key/pull/701)
- MessagEase fixes by @asdkant in [#709](https://github.com/dessalines/thumb-key/pull/709)
- Adding slovenscina symbols MessagEase. Fixes #706 by @dessalines in [#707](https://github.com/dessalines/thumb-key/pull/707)
- Added missing combine keys for french messageease keyboard by @yorikvanhavre in [#705](https://github.com/dessalines/thumb-key/pull/705)
- Use messagease symbol layout for messagease number board by @BlueDrink9 in [#695](https://github.com/dessalines/thumb-key/pull/695)
- Fixing comment for keyboard layout. by @dessalines in [#698](https://github.com/dessalines/thumb-key/pull/698)
- Me es layout by @asdkant in [#689](https://github.com/dessalines/thumb-key/pull/689)
- fix ENNOMessageEaseSymbols: wrong capitalization on Æ by @afreakk in [#694](https://github.com/dessalines/thumb-key/pull/694)
- Adding a few proguard rules fixes. by @dessalines in [#693](https://github.com/dessalines/thumb-key/pull/693)

## New Contributors

- @BlueDrink9 made their first contribution in [#701](https://github.com/dessalines/thumb-key/pull/701)
- @asdkant made their first contribution in [#709](https://github.com/dessalines/thumb-key/pull/709)
- @yorikvanhavre made their first contribution in [#705](https://github.com/dessalines/thumb-key/pull/705)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/2.6.13...2.6.14

## What's Changed in 2.6.13

- Added layout: english norwegian symbols messagease by @afreakk in [#686](https://github.com/dessalines/thumb-key/pull/686)
- Adding local pre-tag changelog generation. by @dessalines in [#688](https://github.com/dessalines/thumb-key/pull/688)
- Added adaptive icon. by @pxeemo in [#672](https://github.com/dessalines/thumb-key/pull/672)
- Update ENPLThumbKey.kt by @michal-h-s in [#674](https://github.com/dessalines/thumb-key/pull/674)
- Add additional prettier checks. by @dessalines in [#670](https://github.com/dessalines/thumb-key/pull/670)
- Adding release notes. by @dessalines

## New Contributors

- @afreakk made their first contribution in [#686](https://github.com/dessalines/thumb-key/pull/686)
- @michal-h-s made their first contribution in [#674](https://github.com/dessalines/thumb-key/pull/674)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/2.6.12...2.6.13

## What's Changed in 2.6.12

- Adding issue forms instead of markdown templates. Fixes #662 by @dessalines in [#669](https://github.com/dessalines/thumb-key/pull/669)
- hebrew messageease style layout with symbols by @yehoshuapw in [#667](https://github.com/dessalines/thumb-key/pull/667)
- Add layout for English and French by @Zwyx in [#665](https://github.com/dessalines/thumb-key/pull/665)
- Add ukrainian-only messagease symbols layout by @Meetoul in [#666](https://github.com/dessalines/thumb-key/pull/666)
- Adding release notes. by @dessalines

## New Contributors

- @yehoshuapw made their first contribution in [#667](https://github.com/dessalines/thumb-key/pull/667)
- @Zwyx made their first contribution in [#665](https://github.com/dessalines/thumb-key/pull/665)
- @Meetoul made their first contribution in [#666](https://github.com/dessalines/thumb-key/pull/666)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/2.6.11...2.6.12

## What's Changed in 2.6.11

- Add keyboard bg_phonetic_messagease by @pavlov-p in [#660](https://github.com/dessalines/thumb-key/pull/660)
- Adding english polski thumbkey keyboard. Fixes #654 by @dessalines in [#659](https://github.com/dessalines/thumb-key/pull/659)
- Finnish/Estonian messageease style layout by @Eemilp in [#639](https://github.com/dessalines/thumb-key/pull/639)
- Typos by @5atoshiNakamoto in [#644](https://github.com/dessalines/thumb-key/pull/644)
- Update strings.xml (typo) by @ligurio in [#638](https://github.com/dessalines/thumb-key/pull/638)
- show locale currency bottom-right to 1 in [#636](https://github.com/dessalines/thumb-key/pull/636)
- Adding release notes. by @dessalines

## New Contributors

- @pavlov-p made their first contribution in [#660](https://github.com/dessalines/thumb-key/pull/660)
- @Eemilp made their first contribution in [#639](https://github.com/dessalines/thumb-key/pull/639)
- @5atoshiNakamoto made their first contribution in [#644](https://github.com/dessalines/thumb-key/pull/644)
- @ligurio made their first contribution in [#638](https://github.com/dessalines/thumb-key/pull/638)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/2.6.10...2.6.11

## What's Changed in 2.6.10

- Update ITMessageEase.kt by @flauta in [#637](https://github.com/dessalines/thumb-key/pull/637)
- Fix 'å' shadowing 'unshift' in 'english dansk symbols thumb-key' by @max-baz in [#634](https://github.com/dessalines/thumb-key/pull/634)
- Add 'english dansk symbols thumb-key' by @max-baz in [#633](https://github.com/dessalines/thumb-key/pull/633)
- Adding release notes. by @dessalines

## New Contributors

- @max-baz made their first contribution in [#634](https://github.com/dessalines/thumb-key/pull/634)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/2.6.9...2.6.10

## What's Changed in 2.6.9

- Upgrading deps. by @dessalines in [#628](https://github.com/dessalines/thumb-key/pull/628)
- Fixing some cursor update issues for multitap. #242 by @dessalines in [#627](https://github.com/dessalines/thumb-key/pull/627)
- Add some missing arabic vowel phonemes. by @pxeemo in [#624](https://github.com/dessalines/thumb-key/pull/624)
- Add Ukrainian translation by @Sestowner in [#623](https://github.com/dessalines/thumb-key/pull/623)
- Adding release notes. by @dessalines

## New Contributors

- @Sestowner made their first contribution in [#623](https://github.com/dessalines/thumb-key/pull/623)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/2.6.8...2.6.9

## What's Changed in 2.6.8

- Upgrading kotlinter. by @dessalines in [#620](https://github.com/dessalines/thumb-key/pull/620)
- Fixing automirrored icons. by @dessalines in [#622](https://github.com/dessalines/thumb-key/pull/622)
- Fixing crash related to uppercase logic. by @dessalines in [#621](https://github.com/dessalines/thumb-key/pull/621)
- Request and handle cursor changes by @jm355 in [#613](https://github.com/dessalines/thumb-key/pull/613)
- Adding release notes. by @dessalines

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/2.6.7...2.6.8

## What's Changed in 2.6.7

- Updating version. by @dessalines
- Added Danish and Norwegian letters to DEThumbKeyMultiLingual.kt by @hcgraf in [#617](https://github.com/dessalines/thumb-key/pull/617)
- Finnish MessageEase layout by @sashaaaaaaaaa in [#619](https://github.com/dessalines/thumb-key/pull/619)
- Lowering icon size to 108dp by @dessalines in [#615](https://github.com/dessalines/thumb-key/pull/615)
- Adding release notes. by @dessalines

## New Contributors

- @hcgraf made their first contribution in [#617](https://github.com/dessalines/thumb-key/pull/617)
- @sashaaaaaaaaa made their first contribution in [#619](https://github.com/dessalines/thumb-key/pull/619)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/2.6.6...2.6.7

## What's Changed in 2.6.6

- Fix slide jumping after 1k characters. Fixes #566 by @dessalines in [#612](https://github.com/dessalines/thumb-key/pull/612)
- Scaling down uppercase letters. Fixes #109 by @dessalines in [#611](https://github.com/dessalines/thumb-key/pull/611)
- Added Italian translation by @flauta in [#610](https://github.com/dessalines/thumb-key/pull/610)
- Upgrading compose to 1.5.7 by @dessalines in [#609](https://github.com/dessalines/thumb-key/pull/609)
- double symbols prototype by @alensiljak in [#608](https://github.com/dessalines/thumb-key/pull/608)
- Adding svenska messageease. Fixes #601 by @dessalines in [#605](https://github.com/dessalines/thumb-key/pull/605)
- Update ITThumbKey.kt by @flauta in [#603](https://github.com/dessalines/thumb-key/pull/603)
- Adding release notes. by @dessalines

## New Contributors

- @alensiljak made their first contribution in [#608](https://github.com/dessalines/thumb-key/pull/608)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/2.6.5...2.6.6

## What's Changed in 2.6.5

- Adding ES_CA_MESSAGEEASE keyboard. by @dessalines in [#598](https://github.com/dessalines/thumb-key/pull/598)
- Update mathematical keyboard layout by @Kuna42 in [#594](https://github.com/dessalines/thumb-key/pull/594)
- Add Russian localization by @artemnefedov in [#595](https://github.com/dessalines/thumb-key/pull/595)
- Add layout English/Te Reo Māori. by @sslater11 in [#593](https://github.com/dessalines/thumb-key/pull/593)
- Adding release notes. by @dessalines

## New Contributors

- @artemnefedov made their first contribution in [#595](https://github.com/dessalines/thumb-key/pull/595)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/2.6.4...2.6.5

## What's Changed in 2.6.4

- Fix issues with Japanese TypeSplit layouts by @Phidica in [#590](https://github.com/dessalines/thumb-key/pull/590)
- Make sure DB is initialized before building routes. Fixes #589 by @dessalines in [#591](https://github.com/dessalines/thumb-key/pull/591)
- Upgrading deps. by @dessalines in [#588](https://github.com/dessalines/thumb-key/pull/588)
- Adding release notes. by @dessalines

## New Contributors

- @Phidica made their first contribution in [#590](https://github.com/dessalines/thumb-key/pull/590)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/2.6.3...2.6.4

## What's Changed in 2.6.3

- Dont hide numbers. Fixes #501 by @dessalines in [#584](https://github.com/dessalines/thumb-key/pull/584)
- Upgrading deps. by @dessalines in [#583](https://github.com/dessalines/thumb-key/pull/583)
- Increasing maximum bottom offset. Fixes #575 by @dessalines in [#582](https://github.com/dessalines/thumb-key/pull/582)
- Adding KZ keyboard. Fixes #579 by @dessalines in [#581](https://github.com/dessalines/thumb-key/pull/581)
- Add Persian (farsi) translation by @salif in [#580](https://github.com/dessalines/thumb-key/pull/580)
- Update HUThumbKey.kt by @KnockoffFeline in [#578](https://github.com/dessalines/thumb-key/pull/578)
- Adding release notes. by @dessalines

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/2.6.2...2.6.3

## What's Changed in 2.6.2

- Upgrading deps. by @dessalines in [#577](https://github.com/dessalines/thumb-key/pull/577)
- fixed autocapitalization by @Kommynct in [#572](https://github.com/dessalines/thumb-key/pull/572)
- Added qwerty-like layout by @Housies in [#569](https://github.com/dessalines/thumb-key/pull/569)
- Fixing HU swipetype. Fixes #565 by @dessalines in [#576](https://github.com/dessalines/thumb-key/pull/576)
- Add French translation by @soupirs in [#574](https://github.com/dessalines/thumb-key/pull/574)
- Adding release notes. by @dessalines

## New Contributors

- @Housies made their first contribution in [#569](https://github.com/dessalines/thumb-key/pull/569)
- @soupirs made their first contribution in [#574](https://github.com/dessalines/thumb-key/pull/574)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/2.6.1...2.6.2

## What's Changed in 2.6.1

- Fix EUESThumbKey layout by @zgll2022
- Upgrading deps, running new kotlinter. by @dessalines in [#564](https://github.com/dessalines/thumb-key/pull/564)
- Update ENEOMessageEaseSymbols.kt by @uxintro in [#561](https://github.com/dessalines/thumb-key/pull/561)
- Update Danish Loc by @Limfjorden in [#555](https://github.com/dessalines/thumb-key/pull/555)
- Update ITTypeSplit.kt by @flauta in [#558](https://github.com/dessalines/thumb-key/pull/558)
- fix apostrophe autocorrect in the other two-handed layouts by @Kommynct in [#553](https://github.com/dessalines/thumb-key/pull/553)
- Adding release notes. by @dessalines

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/2.6.0...2.6.1

## What's Changed in 2.6.0

- Add EU ES keyboard by @zgll2022 in [#551](https://github.com/dessalines/thumb-key/pull/551)
- AutoCapitalize "i\'" ("I'm" and "I'd") by @jm355 in [#534](https://github.com/dessalines/thumb-key/pull/534)
- Update ITTypeSplit.kt by @flauta in [#540](https://github.com/dessalines/thumb-key/pull/540)
- TypeSplit Japanese Hiragana/Katakana by @K0baU in [#541](https://github.com/dessalines/thumb-key/pull/541)
- Add spanish translation by @sguinetti in [#552](https://github.com/dessalines/thumb-key/pull/552)
- Add twohands symbols layout, fix twohands capitalization issues by @Kommynct in [#549](https://github.com/dessalines/thumb-key/pull/549)
- Add English-Norwegian Thumb-Key layout by @petlyh in [#547](https://github.com/dessalines/thumb-key/pull/547)
- Adding release notes. by @dessalines

## New Contributors

- @jm355 made their first contribution in [#534](https://github.com/dessalines/thumb-key/pull/534)
- @sguinetti made their first contribution in [#552](https://github.com/dessalines/thumb-key/pull/552)
- @petlyh made their first contribution in [#547](https://github.com/dessalines/thumb-key/pull/547)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/2.5.2...2.6.0

## What's Changed in 2.5.2

- Upping gradle wrapper jar. by @dessalines
- Upgrading gradle to 8.4 by @dessalines in [#544](https://github.com/dessalines/thumb-key/pull/544)
- Fixing DB warnings. by @dessalines in [#543](https://github.com/dessalines/thumb-key/pull/543)
- Redone Lithuanian layout by @MariusTrap in [#542](https://github.com/dessalines/thumb-key/pull/542)
- Update Danish Keyboard by @Limfjorden in [#537](https://github.com/dessalines/thumb-key/pull/537)
- Small issues with DEMessageEaseSymbols and UKRUMessageEaseSymbols layouts by @Crandel in [#535](https://github.com/dessalines/thumb-key/pull/535)
- Updating releases.md by @dessalines

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/2.5.1...2.5.2

## What's Changed in 2.5.1

- Upgrading deps. by @dessalines in [#532](https://github.com/dessalines/thumb-key/pull/532)
- Fixing keyboard names. Fixes #523 by @dessalines in [#526](https://github.com/dessalines/thumb-key/pull/526)
- Added emoji key to Type-Split layout. Fixes #432 by @sslater11 in [#524](https://github.com/dessalines/thumb-key/pull/524)
- Fix hungarian layout by @KnockoffFeline in [#525](https://github.com/dessalines/thumb-key/pull/525)
- Adding release notes. by @dessalines

## New Contributors

- @KnockoffFeline made their first contribution in [#525](https://github.com/dessalines/thumb-key/pull/525)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/2.5.0...2.5.1

## What's Changed in 2.5.0

- Added slide gestures to Type-Split layouts by @sslater11 in [#521](https://github.com/dessalines/thumb-key/pull/521)
- Updated readme with new features/settings by @sslater11 in [#522](https://github.com/dessalines/thumb-key/pull/522)
- Backspace swipe right to delete word and Slide gestures improvements by @sslater11 in [#439](https://github.com/dessalines/thumb-key/pull/439)
- EN Wide Programmer: Add four-way movement swipes by @Terrance in [#519](https://github.com/dessalines/thumb-key/pull/519)
- Running code analyzer for a few fixes. by @dessalines in [#517](https://github.com/dessalines/thumb-key/pull/517)
- Adding theming guide. Fixes #508 by @dessalines in [#516](https://github.com/dessalines/thumb-key/pull/516)
- Implement EN layout with composable keys by @mpice-mn in [#513](https://github.com/dessalines/thumb-key/pull/513)
- Add ancom theme by @Kommynct in [#509](https://github.com/dessalines/thumb-key/pull/509)
- fixing emoji picker inconsistancies, fixes #496 by @WadeWT in [#515](https://github.com/dessalines/thumb-key/pull/515)
- EN Programmer Wide: Restore wide numeric layout by @Terrance in [#514](https://github.com/dessalines/thumb-key/pull/514)
- Added FarsiNumeric.kt. by @pxeemo in [#511](https://github.com/dessalines/thumb-key/pull/511)
- Adding release notes. by @dessalines

## New Contributors

- @Terrance made their first contribution in [#519](https://github.com/dessalines/thumb-key/pull/519)
- @Kommynct made their first contribution in [#509](https://github.com/dessalines/thumb-key/pull/509)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/2.4.1...2.5.0

## What's Changed in 2.4.1

- Type Split English with Norwegian characters added by @henrikx in [#502](https://github.com/dessalines/thumb-key/pull/502)
- fix inconsistent layout naming by @KraXen72 in [#497](https://github.com/dessalines/thumb-key/pull/497)
- Adding keyboard PR instruction. by @dessalines in [#507](https://github.com/dessalines/thumb-key/pull/507)
- Fixing enter action. Fixes #136 by @dessalines in [#506](https://github.com/dessalines/thumb-key/pull/506)
- Fix en thumb-key programmers wide. Fixes #503 by @storvik in [#504](https://github.com/dessalines/thumb-key/pull/504)
- Adding release notes. by @dessalines

## New Contributors

- @henrikx made their first contribution in [#502](https://github.com/dessalines/thumb-key/pull/502)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/2.4.0...2.4.1

## What's Changed in 2.4.0

- Try to lower memory to fix CI. by @dessalines in [#493](https://github.com/dessalines/thumb-key/pull/493)
- Code cleanup: Getting rid of null asserts. by @dessalines in [#491](https://github.com/dessalines/thumb-key/pull/491)
- Adding slovak layout. Fixes #487 by @dessalines in [#490](https://github.com/dessalines/thumb-key/pull/490)
- Upgrading deps. by @dessalines in [#492](https://github.com/dessalines/thumb-key/pull/492)
- Fix keyborderwidth float by @dessalines in [#489](https://github.com/dessalines/thumb-key/pull/489)
- Add language specific autocapitalization. Fixes #429 by @storvik in [#484](https://github.com/dessalines/thumb-key/pull/484)
- Making the emoji screen work with the key customisation, fixes #483 by @WadeWT in [#485](https://github.com/dessalines/thumb-key/pull/485)
- Fixing slack and discord IME. Fixes #136 by @dessalines in [#486](https://github.com/dessalines/thumb-key/pull/486)
- Add Estonian language Thumb-key (eesti keel) by @Lastaapps in [#481](https://github.com/dessalines/thumb-key/pull/481)
- Add mathematical keyboard layout by @Kuna42 in [#482](https://github.com/dessalines/thumb-key/pull/482)
- Update ThumbKeyITv1.kt - added schwa and reversed-E by @flauta in [#479](https://github.com/dessalines/thumb-key/pull/479)
- High contrast themes - Fixes #477 by @WadeWT in [#478](https://github.com/dessalines/thumb-key/pull/478)
- Small fix on the canadian aboriginal keyboard by @CarolineHusky in [#476](https://github.com/dessalines/thumb-key/pull/476)
- Adding release notes. by @dessalines

## New Contributors

- @Kuna42 made their first contribution in [#482](https://github.com/dessalines/thumb-key/pull/482)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/2.3.0...2.4.0

## What's Changed in 2.3.0

- Key customisation by @WadeWT in [#473](https://github.com/dessalines/thumb-key/pull/473)
- Adding new theme by @WadeWT in [#475](https://github.com/dessalines/thumb-key/pull/475)
- More fixes to MessageEaseFR by @pulkomandy in [#474](https://github.com/dessalines/thumb-key/pull/474)
- Created layout for Canadian Aboriginal Syllabics by @CarolineHusky in [#472](https://github.com/dessalines/thumb-key/pull/472)
- Add UA-RU and DE keyboards with symbols by @Crandel in [#465](https://github.com/dessalines/thumb-key/pull/465)
- Adding a backdrop for the keyboard by @WadeWT in [#464](https://github.com/dessalines/thumb-key/pull/464)
- Use common spacebar in numeric keyboard by @cjparsons74 in [#463](https://github.com/dessalines/thumb-key/pull/463)
- Update MessageEaseENEOSymbols.kt by @uxintro in [#462](https://github.com/dessalines/thumb-key/pull/462)
- Fixing settings intent. by @dessalines in [#461](https://github.com/dessalines/thumb-key/pull/461)
- Adding release notes. by @dessalines

## New Contributors

- @WadeWT made their first contribution in [#473](https://github.com/dessalines/thumb-key/pull/473)
- @CarolineHusky made their first contribution in [#472](https://github.com/dessalines/thumb-key/pull/472)
- @Crandel made their first contribution in [#465](https://github.com/dessalines/thumb-key/pull/465)
- @cjparsons74 made their first contribution in [#463](https://github.com/dessalines/thumb-key/pull/463)
- @uxintro made their first contribution in [#462](https://github.com/dessalines/thumb-key/pull/462)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/2.2.0...2.3.0

## What's Changed in 2.2.0

- Upgrading version. by @dessalines
- Upgrading alorma dep. by @dessalines
- Refactoring settings. by @dessalines in [#460](https://github.com/dessalines/thumb-key/pull/460)
- Add messageease en eo symbols by @dessalines in [#458](https://github.com/dessalines/thumb-key/pull/458)
- Add voice input button to emoji key by @storvik in [#454](https://github.com/dessalines/thumb-key/pull/454)
- Upgrade deps 14 by @dessalines in [#459](https://github.com/dessalines/thumb-key/pull/459)
- Upgrading deps. by @dessalines in [#457](https://github.com/dessalines/thumb-key/pull/457)
- EnglishV4MultiIT keyboard layout by @yuroller in [#449](https://github.com/dessalines/thumb-key/pull/449)
- Add Emoji to Wide Layout by @thedroppedpocket in [#448](https://github.com/dessalines/thumb-key/pull/448)
- Adding release notes. by @dessalines

## New Contributors

- @yuroller made their first contribution in [#449](https://github.com/dessalines/thumb-key/pull/449)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/2.1.1...2.2.0

## What's Changed in 2.1.1

- Complete MessageEaseFR keyboard (main level) by @pulkomandy in [#435](https://github.com/dessalines/thumb-key/pull/435)
- Fix IDv1SN bug + renaming Indonesian layout sort problem by @Matyeyev in [#438](https://github.com/dessalines/thumb-key/pull/438)
- Better User Guide section in README by @KraXen72 in [#430](https://github.com/dessalines/thumb-key/pull/430)
- Updating releases.md by @dessalines

## New Contributors

- @pulkomandy made their first contribution in [#435](https://github.com/dessalines/thumb-key/pull/435)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/2.1.0...2.1.1

## What's Changed in 2.1.0

- Adding haptic feedback warning. Fixes #420 by @dessalines in [#428](https://github.com/dessalines/thumb-key/pull/428)
- Add slide selection and deletion by @storvik in [#424](https://github.com/dessalines/thumb-key/pull/424)
- Fixing markdown view colors to use M3 theme. Fixes #409 by @dessalines in [#427](https://github.com/dessalines/thumb-key/pull/427)
- Update and rename ThumbKeyESCAv1.kt to ThumbKeyESCAv2.kt by @PeuDenPau in [#423](https://github.com/dessalines/thumb-key/pull/423)
- Haptic and audible feedback on emoji key press + key border displayed properly. by @sslater11 in [#426](https://github.com/dessalines/thumb-key/pull/426)
- Adding release notes. by @dessalines

## New Contributors

- @PeuDenPau made their first contribution in [#423](https://github.com/dessalines/thumb-key/pull/423)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/2.0.0...2.1.0

## What's Changed in 2.0.0

- Adding spanish-catalan keyboard. Fixes #418 by @dessalines in [#419](https://github.com/dessalines/thumb-key/pull/419)
- Emoji Picker by @sslater11 in [#415](https://github.com/dessalines/thumb-key/pull/415)
- Add Indonesian Layout Symbols v1 with Number. by @Matyeyev in [#416](https://github.com/dessalines/thumb-key/pull/416)
- fix reset to defaults: slideEnabledState (fixes #407) by @nejni-marji in [#414](https://github.com/dessalines/thumb-key/pull/414)
- fix EnV4SK multiLayout shifted í (Í) being muted by @KraXen72 in [#413](https://github.com/dessalines/thumb-key/pull/413)
- Fixing some project errs. by @dessalines in [#408](https://github.com/dessalines/thumb-key/pull/408)
- Adding release notes. by @dessalines

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/1.15.0...2.0.0

## What's Changed in 1.15.0

- Update MessageEaseDE.kt by @Saturo78 in [#402](https://github.com/dessalines/thumb-key/pull/402)
- Fixing delete whole word. Fixes #398 by @dessalines in [#406](https://github.com/dessalines/thumb-key/pull/406)
- add the old idv1symbol to be v2. by @Matyeyev in [#405](https://github.com/dessalines/thumb-key/pull/405)
- Add support for moving cursor on spacebar slide. Fixes #91 by @storvik in [#401](https://github.com/dessalines/thumb-key/pull/401)
- Update MessageEaseIT.kt by @flauta in [#404](https://github.com/dessalines/thumb-key/pull/404)
- lithuanian layout by @MariusTrap in [#395](https://github.com/dessalines/thumb-key/pull/395)
- Adding release notes. by @dessalines

## New Contributors

- @Matyeyev made their first contribution in [#405](https://github.com/dessalines/thumb-key/pull/405)
- @MariusTrap made their first contribution in [#395](https://github.com/dessalines/thumb-key/pull/395)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/1.14.0...1.15.0

## What's Changed in 1.14.0

- Adding a changelog popup. Fixes #375 by @dessalines in [#394](https://github.com/dessalines/thumb-key/pull/394)
- Nulling icon descriptions. Fixes #382 by @dessalines in [#393](https://github.com/dessalines/thumb-key/pull/393)
- Upgrading deps. by @dessalines in [#392](https://github.com/dessalines/thumb-key/pull/392)
- Adding an IME switcher button. Fixes #380 by @dessalines in [#391](https://github.com/dessalines/thumb-key/pull/391)
- Add confirmation dialog before resetting to default settings by @storvik in [#390](https://github.com/dessalines/thumb-key/pull/390)
- Adding latvian LV+LTG. Fixes #388 by @dessalines in [#389](https://github.com/dessalines/thumb-key/pull/389)
- Added german translation by @0xfossman in [#387](https://github.com/dessalines/thumb-key/pull/387)
- Added Dracula Theme by @0xfossman in [#376](https://github.com/dessalines/thumb-key/pull/376)
- Update ThumbKeyUKv1.kt - fix Ґ and Д conflict by @plugnburn in [#385](https://github.com/dessalines/thumb-key/pull/385)
- Fixed missing and overlapping keys on CZ keyboard by @Michael36500 in [#386](https://github.com/dessalines/thumb-key/pull/386)
- Update MessageEaseDE.kt by @Saturo78 in [#384](https://github.com/dessalines/thumb-key/pull/384)
- fix: Czech keyboard - ě, č and Caps Lock by @Lastaapps in [#377](https://github.com/dessalines/thumb-key/pull/377)
- Adding release notes. by @dessalines

## New Contributors

- @storvik made their first contribution in [#390](https://github.com/dessalines/thumb-key/pull/390)
- @0xfossman made their first contribution in [#387](https://github.com/dessalines/thumb-key/pull/387)
- @plugnburn made their first contribution in [#385](https://github.com/dessalines/thumb-key/pull/385)
- @Saturo78 made their first contribution in [#384](https://github.com/dessalines/thumb-key/pull/384)
- @Lastaapps made their first contribution in [#377](https://github.com/dessalines/thumb-key/pull/377)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/1.13.0...1.14.0

## What's Changed in 1.13.0

- Upgrading deps. by @dessalines in [#374](https://github.com/dessalines/thumb-key/pull/374)
- Typesplit fi by @dessalines in [#373](https://github.com/dessalines/thumb-key/pull/373)
- make "hide letters" only hide letters, add new toggle "hide symbols" (fixes #299) by @nejni-marji in [#370](https://github.com/dessalines/thumb-key/pull/370)
- Adding croation layouts. Fixes #365 by @dessalines in [#372](https://github.com/dessalines/thumb-key/pull/372)
- Add Thumb-Key Bulgarian v1 with symbols by @salif in [#368](https://github.com/dessalines/thumb-key/pull/368)
- Update build.gradle buildtools version by @MV-GH in [#364](https://github.com/dessalines/thumb-key/pull/364)
- Update .woodpecker.yml by @MV-GH in [#363](https://github.com/dessalines/thumb-key/pull/363)
- Adding release notes. by @dessalines

## New Contributors

- @nejni-marji made their first contribution in [#370](https://github.com/dessalines/thumb-key/pull/370)
- @salif made their first contribution in [#368](https://github.com/dessalines/thumb-key/pull/368)
- @MV-GH made their first contribution in [#364](https://github.com/dessalines/thumb-key/pull/364)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/1.12.0...1.13.0

## What's Changed in 1.12.0

- Update TypeSplitESv1.1.kt by @racuna in [#361](https://github.com/dessalines/thumb-key/pull/361)
- Fix settings crash 1 by @dessalines in [#360](https://github.com/dessalines/thumb-key/pull/360)
- Upgrading deps. by @dessalines in [#358](https://github.com/dessalines/thumb-key/pull/358)
- Adding MessageEase RU. Fixes #356 by @dessalines in [#359](https://github.com/dessalines/thumb-key/pull/359)
- Add MessagEase spanish layout by @gmartineza in [#336](https://github.com/dessalines/thumb-key/pull/336)
- created czech layout by @Michael36500 in [#355](https://github.com/dessalines/thumb-key/pull/355)
- Added greek layout by @iByteABit256 in [#357](https://github.com/dessalines/thumb-key/pull/357)
- Adding thumbkey EO-EN-DE. Fixes #340 by @dessalines in [#348](https://github.com/dessalines/thumb-key/pull/348)
- Fixing woodpecker env vars. by @dessalines in [#347](https://github.com/dessalines/thumb-key/pull/347)
- Added Numeric layout for Two Hands by @Lavin-tom in [#342](https://github.com/dessalines/thumb-key/pull/342)
- Fix markdown in issue templates by @KraXen72 in [#346](https://github.com/dessalines/thumb-key/pull/346)
- Adding slow path checks to CI. by @dessalines in [#338](https://github.com/dessalines/thumb-key/pull/338)
- Updating releases.md by @dessalines

## New Contributors

- @racuna made their first contribution in [#361](https://github.com/dessalines/thumb-key/pull/361)
- @gmartineza made their first contribution in [#336](https://github.com/dessalines/thumb-key/pull/336)
- @Michael36500 made their first contribution in [#355](https://github.com/dessalines/thumb-key/pull/355)
- @iByteABit256 made their first contribution in [#357](https://github.com/dessalines/thumb-key/pull/357)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/1.11.0...1.12.0

## What's Changed in 1.11.0

- Add Hebrew layout based on letter position guidelines by @roihershberg in [#335](https://github.com/dessalines/thumb-key/pull/335)
- Numeric layout for type-split. by @mockballd in [#337](https://github.com/dessalines/thumb-key/pull/337)
- Add ENv4MultiLayout by @KraXen72 in [#327](https://github.com/dessalines/thumb-key/pull/327)
- Adding release notes. by @dessalines

## New Contributors

- @KraXen72 made their first contribution in [#327](https://github.com/dessalines/thumb-key/pull/327)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/1.10.0...1.11.0

## What's Changed in 1.10.0

- Add messageease it by @dessalines in [#333](https://github.com/dessalines/thumb-key/pull/333)
- Add spanish esperanto by @dessalines in [#332](https://github.com/dessalines/thumb-key/pull/332)
- Upgrading deps. by @dessalines in [#331](https://github.com/dessalines/thumb-key/pull/331)
- Adding hungarian layout. Fixes #325 by @dessalines in [#330](https://github.com/dessalines/thumb-key/pull/330)
- Updating releases.md by @dessalines

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/1.9.1...1.10.0

## What's Changed in 1.9.1

- まみむめも=>ゔ by @K0baU in [#326](https://github.com/dessalines/thumb-key/pull/326)
- Add single quote to MessageEase German by @meliache in [#323](https://github.com/dessalines/thumb-key/pull/323)
- Capital letters when layout changed by @niccokunzmann in [#322](https://github.com/dessalines/thumb-key/pull/322)
- Rectified issue of "TwoHands" layout by @Lavin-tom in [#313](https://github.com/dessalines/thumb-key/pull/313)

## New Contributors

- @meliache made their first contribution in [#323](https://github.com/dessalines/thumb-key/pull/323)
- @niccokunzmann made their first contribution in [#322](https://github.com/dessalines/thumb-key/pull/322)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/1.9.0...1.9.1

## What's Changed in 1.9.0

- Added wide layout by @thedroppedpocket in [#308](https://github.com/dessalines/thumb-key/pull/308)
- Added Two-Hands layout by @Lavin-tom in [#306](https://github.com/dessalines/thumb-key/pull/306)
- Adding release notes. by @dessalines

## New Contributors

- @thedroppedpocket made their first contribution in [#308](https://github.com/dessalines/thumb-key/pull/308)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/1.8.0...1.9.0

## What's Changed in 1.8.0

- Fix bug in deleteLastWord by @tbhno in [#305](https://github.com/dessalines/thumb-key/pull/305)
- New "Type-Split" layouts. by @mockballd in [#296](https://github.com/dessalines/thumb-key/pull/296)
- ThumbKeyFRv2: Fix key "U" writing "uU". by @mockballd in [#298](https://github.com/dessalines/thumb-key/pull/298)
- Updating releases.md by @dessalines

## New Contributors

- @tbhno made their first contribution in [#305](https://github.com/dessalines/thumb-key/pull/305)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/1.7.0...1.8.0

## What's Changed in 1.7.0

- Add debug mode. by @dessalines in [#294](https://github.com/dessalines/thumb-key/pull/294)
- New layout: "Four columns" (English). by @mockballd in [#292](https://github.com/dessalines/thumb-key/pull/292)
- Update ThumbKeyIDv1Symbols.kt by @awandepan in [#289](https://github.com/dessalines/thumb-key/pull/289)
- Fix swedish keyboard by @maxhambraeus in [#287](https://github.com/dessalines/thumb-key/pull/287)
- Update Danish translation and fix minor errors in the Danish keyboard by @Limfjorden in [#286](https://github.com/dessalines/thumb-key/pull/286)
- Adding release notes. by @dessalines

## New Contributors

- @maxhambraeus made their first contribution in [#287](https://github.com/dessalines/thumb-key/pull/287)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/1.6.1...1.7.0

## What's Changed in 1.6.1

- Fixing NO keyboard. Fixes #282 by @dessalines in [#285](https://github.com/dessalines/thumb-key/pull/285)
- Finishing adding turkish. by @dessalines
- Adding Turkish Keyboard by @dessalines in [#283](https://github.com/dessalines/thumb-key/pull/283)
- Update ThumbKeyITv1.kt - shortcuts for QU CH GH by @flauta in [#281](https://github.com/dessalines/thumb-key/pull/281)
- Adding Turkish Keyboard by @akurone
- Added blue color theme by @Lavin-tom in [#280](https://github.com/dessalines/thumb-key/pull/280)
- Update ThumbKeyJAv1Hiragana.kt by @K0baU in [#278](https://github.com/dessalines/thumb-key/pull/278)
- Adding Swedish keyboard. by @dessalines in [#277](https://github.com/dessalines/thumb-key/pull/277)
- Srcery color theme by @FranciscoTrigo in [#275](https://github.com/dessalines/thumb-key/pull/275)
- Fixing formatting. by @dessalines
- Update T9v1.kt by @FriedGrregg in [#273](https://github.com/dessalines/thumb-key/pull/273)
- Added missing "À" by @breversa in [#272](https://github.com/dessalines/thumb-key/pull/272)
- Adding release notes. by @dessalines

## New Contributors

- @flauta made their first contribution in [#281](https://github.com/dessalines/thumb-key/pull/281)
- @akurone made their first contribution
- @Lavin-tom made their first contribution in [#280](https://github.com/dessalines/thumb-key/pull/280)
- @FriedGrregg made their first contribution in [#273](https://github.com/dessalines/thumb-key/pull/273)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/1.6.0...1.6.1

## What's Changed in 1.6.0

- Fixing spacebar multitap reset. Fixes #242 by @dessalines in [#271](https://github.com/dessalines/thumb-key/pull/271)
- De multiling fix by @dessalines in [#270](https://github.com/dessalines/thumb-key/pull/270)
- Fix formatting issues. by @dessalines
- Update ThumbKeyDEv2MultiLingual.kt by @dessalines in [#250](https://github.com/dessalines/thumb-key/pull/250)
- Update ThumbKeyDEv2MultiLingual.kt by @Falcarragh
- Fr v2 breversa by @dessalines in [#269](https://github.com/dessalines/thumb-key/pull/269)
- Merge branch 'main' into fr_v2_breversa by @dessalines
- Ru four way by @dessalines in [#268](https://github.com/dessalines/thumb-key/pull/268)
- Fixing lint by @dessalines
- Fix the MessageEaseRUSymbols layout by removing FOUR_WAY_DIAGONAL by @dessalines in [#258](https://github.com/dessalines/thumb-key/pull/258)
- Fix the MessageEaseRUSymbols layout by removing FOUR_WAY_DIAGONAL by @last5bits
- Fixing lint, adding fr_v2 by @dessalines
- Hiragana by @dessalines in [#267](https://github.com/dessalines/thumb-key/pull/267)
- Merge branch 'main' into hiragana by @dessalines
- Fixing hiragana. by @dessalines
- Merge branch 'main' into hiragana by @dessalines
- Added Japanese kana(hiragana/katakana) by @dessalines in [#261](https://github.com/dessalines/thumb-key/pull/261)
- Create ThumbKeyJAv1Katakana.kt by @K0baU
- Update ThumbKeyJAv1Hiragana.kt by @K0baU
- Update ThumbKeyJAv1Hiragana.kt by @K0baU
- Update ThumbKeyJAv1Hiragana.kt by @K0baU
- Update ThumbKeyJAv1Hiragana.kt by @K0baU
- Update ThumbKeyJAv1Hiragana.kt by @K0baU
- Rename ThumbKeyJAv1.kt to ThumbKeyJAv1Hiragana.kt by @K0baU
- Create ThumbKeyJAv1.kt by @K0baU
- French keymap by @dessalines in [#257](https://github.com/dessalines/thumb-key/pull/257)
- T symbol fix by @dessalines in [#266](https://github.com/dessalines/thumb-key/pull/266)
- Merge branch 'main' into T_symbol_fix by @dessalines
- Add T9 keyboard. Fixes #263 by @dessalines in [#264](https://github.com/dessalines/thumb-key/pull/264)
- Upgrade deps. by @dessalines in [#265](https://github.com/dessalines/thumb-key/pull/265)
- Formatting by @dessalines
- Corrected "T" key with symbols by @dessalines in [#262](https://github.com/dessalines/thumb-key/pull/262)
- Upgrade deps. by @dessalines
- Corrected symbols for "T" by @FranciscoTrigo
- Fixed symbols in "T" key by @FranciscoTrigo
- Merge branch 'main' into main by @breversa
- Update MessageEaseFR.kt by @cosminribo in [#256](https://github.com/dessalines/thumb-key/pull/256)
- Adding release notes. by @dessalines

## New Contributors

- @FranciscoTrigo made their first contribution
- @K0baU made their first contribution
- @last5bits made their first contribution
- @cosminribo made their first contribution in [#256](https://github.com/dessalines/thumb-key/pull/256)
- @Falcarragh made their first contribution

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/1.5.0...1.6.0

## What's Changed in 1.5.0

- Adding French and Russian MessageEase Keyboards. by @dessalines in [#255](https://github.com/dessalines/thumb-key/pull/255)
- Update ThumbKeyIDv1Symbols.kt by @awandepan in [#248](https://github.com/dessalines/thumb-key/pull/248)

## New Contributors

- @awandepan made their first contribution in [#248](https://github.com/dessalines/thumb-key/pull/248)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/1.4.1...1.5.0

## What's Changed in 1.4.1

- Forgot to increment build version. by @dessalines
- Adding release notes. by @dessalines

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/1.4.0...1.4.1

## What's Changed in 1.4.0

- Upgrade deps by @dessalines in [#246](https://github.com/dessalines/thumb-key/pull/246)
- Adding indonesian keyboard. Fixes #241 by @dessalines in [#245](https://github.com/dessalines/thumb-key/pull/245)
- Better notify. by @dessalines
- Adding notify on all. by @dessalines
- Ka keyboard by @dessalines in [#244](https://github.com/dessalines/thumb-key/pull/244)
- Merge branch 'main' into ka_keyboard by @dessalines
- En symbols fixed by @dessalines in [#243](https://github.com/dessalines/thumb-key/pull/243)
- Fixing messageas symbols. by @dessalines
- MessageEaseENSymbols corrected in [#239](https://github.com/dessalines/thumb-key/pull/239)
- Modified symbols so that they match messageEase
- Finishing adding georgian keyboard. by @dessalines
- Add Georgian keyboard layout in [#240](https://github.com/dessalines/thumb-key/pull/240)
- Update ThumbKeyFRv2.kt by @breversa
- Update ThumbKeyFRv2.kt by @breversa
- Create ThumbKeyFRv2.kt by @breversa
- Adding release notes. by @dessalines

## New Contributors

- @breversa made their first contribution

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/1.3.0...1.4.0

## What's Changed in 1.3.0

- De multiling 2 by @dessalines in [#237](https://github.com/dessalines/thumb-key/pull/237)
- Adding Norwegian keyboard. Fixes #232 by @dessalines in [#236](https://github.com/dessalines/thumb-key/pull/236)
- Adding release notes. by @dessalines

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/1.2.0...1.3.0

## What's Changed in 1.2.0

- Adding messageease DE keyboard. Fixes #219 by @dessalines in [#230](https://github.com/dessalines/thumb-key/pull/230)
- Moving from arrays to lists. Running upgraded kotlinter by @dessalines in [#229](https://github.com/dessalines/thumb-key/pull/229)
- Adding google play link. by @dessalines in [#227](https://github.com/dessalines/thumb-key/pull/227)
- Adding a build CI. by @dessalines in [#225](https://github.com/dessalines/thumb-key/pull/225)
- Use four-way / two-way swipes where applicable by @mpice-mn in [#224](https://github.com/dessalines/thumb-key/pull/224)
- Fixing misnamed danish keyboard. by @dessalines in [#221](https://github.com/dessalines/thumb-key/pull/221)
- Revert changing indices and fix suomi v1 Wide index by @roihershberg in [#223](https://github.com/dessalines/thumb-key/pull/223)
- Fixed layouts indexes in Types.kt by @Chirikumbrah in [#222](https://github.com/dessalines/thumb-key/pull/222)
- Fixing misnamed danish keyboard. by @dessalines in [#220](https://github.com/dessalines/thumb-key/pull/220)
- Adding release notes. by @dessalines

## New Contributors

- @roihershberg made their first contribution in [#223](https://github.com/dessalines/thumb-key/pull/223)
- @Chirikumbrah made their first contribution in [#222](https://github.com/dessalines/thumb-key/pull/222)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/1.1.0...1.2.0

## What's Changed in 1.1.0

- Merge branch 'belarus_1' by @dessalines
- Adding to KeyboardModes, fixing some issues. by @dessalines
- Added belarusian layout, as well as some other changes :) in [#211](https://github.com/dessalines/thumb-key/pull/211)
- applied formatKotlin
- added keyboards to Types.kt
- removed ThumbKeyRUv1 layout
- changed '>' position to BOTTOM_RIGHT in Numeric.kt
- added belarusian layout with symbols
- added RU_V2 layout
- added RU_V2 layout with symbols
- added EN layout with symbols (simpler than layout for programmers)
- renamed variables for belarusian layout
- removed unnecessary '-' symbol in 'Numeric' and 'MessageEaseENSymbols'
- muted some symbols in 'ThumbKeyENv4Programmer.kt'
- muted symbols in 'MessageEaseENSymbols.kt'
- added belarusian layout :)
- Merge branch 'animations_1' by @dessalines
- Running format by @dessalines
- Smoother animation, notification on layout change and a bug fix by @sslater11 in [#218](https://github.com/dessalines/thumb-key/pull/218)
- Display the keyboard layout's name on screen when the user switches layouts. by @sslater11
- Fixed cursor moving to the wrong position when inserting text longer than 1 character. Fixes #216 by @sslater11
- feat: add four-way and two-way swipes by @mpice-mn in [#214](https://github.com/dessalines/thumb-key/pull/214)
- Adding wide finnish layout. Fixes #212 by @dessalines in [#215](https://github.com/dessalines/thumb-key/pull/215)
- Spanish fixes by @mpice-mn in [#209](https://github.com/dessalines/thumb-key/pull/209)
- Adding release notes. by @dessalines

## New Contributors

- @sslater11 made their first contribution in [#218](https://github.com/dessalines/thumb-key/pull/218)
- @mpice-mn made their first contribution in [#214](https://github.com/dessalines/thumb-key/pull/214)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/1.0.0...1.1.0

## What's Changed in 1.0.0

- Upgrading deps. by @dessalines in [#208](https://github.com/dessalines/thumb-key/pull/208)
- Merge branch 'autoshift_fix_1' by @dessalines
- Fix formatting. by @dessalines
- KeyAction.CommitText to better handle Shifted mode. by @mockballd in [#207](https://github.com/dessalines/thumb-key/pull/207)
- Comprehensive delimiter for deleting last word. by @mockballd in [#206](https://github.com/dessalines/thumb-key/pull/206)
- Fix Capital V in MessageEaseENSymbols.kt by @reneald in [#205](https://github.com/dessalines/thumb-key/pull/205)
- Adding release notes. by @dessalines

## New Contributors

- @mockballd made their first contribution in [#206](https://github.com/dessalines/thumb-key/pull/206)
- @reneald made their first contribution in [#205](https://github.com/dessalines/thumb-key/pull/205)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/0.0.14...1.0.0

## What's Changed in 0.0.14

- Adding a markdown check to CI. by @dessalines in [#202](https://github.com/dessalines/thumb-key/pull/202)
- Adding a swipe gesture to change keyboard position. Fixes #96 by @dessalines in [#203](https://github.com/dessalines/thumb-key/pull/203)
- Pexemo persian fixes by @dessalines in [#201](https://github.com/dessalines/thumb-key/pull/201)
- Formatting issues. by @dessalines
- Changed Persian layout by @dessalines in [#199](https://github.com/dessalines/thumb-key/pull/199)
- Custom programmers spacebar by @dessalines in [#200](https://github.com/dessalines/thumb-key/pull/200)
- Upgrading deps. by @dessalines in [#198](https://github.com/dessalines/thumb-key/pull/198)
- Change Persian layout by @pxeemo
- Changed z position by @morellik in [#193](https://github.com/dessalines/thumb-key/pull/193)
- Adding release notes. by @dessalines
- Merge branch 'layout_order_fix' by @dessalines

## New Contributors

- @pxeemo made their first contribution

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/0.0.13...0.0.14

## What's Changed in 0.0.13

- Removing comment. by @dessalines
- Fixing wrong layouts chosen after adding new ones. Fixes #167 by @dessalines
- Fixing wrong layouts chosen after adding new ones. Fixes #167 by @dessalines in [#188](https://github.com/dessalines/thumb-key/pull/188)
- Send apostrophe back where it came from 🔫 by @domportera in [#185](https://github.com/dessalines/thumb-key/pull/185)
- Disable spacebar multitap option by @dessalines in [#182](https://github.com/dessalines/thumb-key/pull/182)
- Add borderless keys option. Fixes #158 by @dessalines in [#181](https://github.com/dessalines/thumb-key/pull/181)
- Removed double capital F by @morellik in [#180](https://github.com/dessalines/thumb-key/pull/180)
- Adding codeowners. by @dessalines
- suggestion to add sterling symbol to numeric key 3 bottom left swipe by @scheckley in [#179](https://github.com/dessalines/thumb-key/pull/179)
- Adding release notes. by @dessalines

## New Contributors

- @scheckley made their first contribution in [#179](https://github.com/dessalines/thumb-key/pull/179)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/0.0.12...0.0.13

## What's Changed in 0.0.12

- Fix scrolling language selection. Fixes #130 by @dessalines in [#176](https://github.com/dessalines/thumb-key/pull/176)
- Add spanish layout. Fixes #142 by @dessalines in [#175](https://github.com/dessalines/thumb-key/pull/175)
- Adding polish layout. Fixes #173 by @dessalines in [#174](https://github.com/dessalines/thumb-key/pull/174)
- Merge branch 'domportera-main' by @dessalines
- Removing text from forward delete. Fixing formatting. by @dessalines
- programmer keyboard layout by @domportera in [#153](https://github.com/dessalines/thumb-key/pull/153)
- tweaks by @domportera
- Update issue templates by @dessalines
- Update issue templates by @dessalines
- programmer keyboard layout by @domportera
- Finish adding dutch layout. by @dessalines
- added dutch layout by @joerievers in [#166](https://github.com/dessalines/thumb-key/pull/166)
- Update ThumbKeyITv1.kt by @morellik in [#157](https://github.com/dessalines/thumb-key/pull/157)
- Update issue templates by @dessalines
- Update issue templates by @dessalines
- Release notes. by @dessalines

## New Contributors

- @joerievers made their first contribution in [#166](https://github.com/dessalines/thumb-key/pull/166)
- @domportera made their first contribution in [#153](https://github.com/dessalines/thumb-key/pull/153)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/0.0.11...0.0.12

## What's Changed in 0.0.11

- Upgrading deps. by @dessalines in [#145](https://github.com/dessalines/thumb-key/pull/145)
- Fixing a few caps issues. #132 by @dessalines in [#144](https://github.com/dessalines/thumb-key/pull/144)
- Adding messageease symbols keyboard. Fixes #106 by @dessalines in [#140](https://github.com/dessalines/thumb-key/pull/140)
- Merge branch 'Limfjorden-main' by @dessalines
- Adding some fixes. by @dessalines
- Create Danish keyboard file and add Danish translation by @dessalines in [#137](https://github.com/dessalines/thumb-key/pull/137)
- Added full Danish translation by @Limfjorden
- Create Danish keyboard file by @Limfjorden
- Add f-droid links. Fixes #8 by @dessalines in [#139](https://github.com/dessalines/thumb-key/pull/139)
- Updating releases.md by @dessalines

## New Contributors

- @Limfjorden made their first contribution

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/0.0.10...0.0.11

## What's Changed in 0.0.10

- Adding multiple default languages. Fixes #42 by @dessalines in [#123](https://github.com/dessalines/thumb-key/pull/123)
- Adding a capslock mode indicator. Fixes #97 by @dessalines in [#122](https://github.com/dessalines/thumb-key/pull/122)
- Hide letters by @dessalines in [#121](https://github.com/dessalines/thumb-key/pull/121)
- Adding french layout. Fixes #26 by @CastelJeremy in [#120](https://github.com/dessalines/thumb-key/pull/120)
- Adding release notes. by @dessalines

## New Contributors

- @CastelJeremy made their first contribution in [#120](https://github.com/dessalines/thumb-key/pull/120)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/0.0.9...0.0.10

## What's Changed in 0.0.9

- Update ThumbKeyITv1.kt by @morellik in [#119](https://github.com/dessalines/thumb-key/pull/119)
- Fix persian language typo. #110 by @dessalines
- Merge branch 'montdor-add_hebrew_keyboard' by @dessalines
- Finish adding hebrew layout. by @dessalines
- Adding hebrew (messagease style) layout in [#117](https://github.com/dessalines/thumb-key/pull/117)
- Adding release notes. by @dessalines

## New Contributors

- @ made their first contribution in [#117](https://github.com/dessalines/thumb-key/pull/117)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/0.0.8...0.0.9

## What's Changed in 0.0.8

- Upgrading deps by @dessalines in [#114](https://github.com/dessalines/thumb-key/pull/114)
- Adding farsi layout. Fixes #110 by @dessalines in [#113](https://github.com/dessalines/thumb-key/pull/113)
- A few fixes. by @dessalines
- Update ThumbKeyITv1.kt by @morellik in [#112](https://github.com/dessalines/thumb-key/pull/112)
- Adding copy and paste buttons. Fixes #98 by @dessalines in [#108](https://github.com/dessalines/thumb-key/pull/108)
- Merge branch 'zgll2022-main' by @dessalines
- Adding basque / euskara layout. by @dessalines
- Add basque layout by @zgll2022 in [#107](https://github.com/dessalines/thumb-key/pull/107)
- fixing accented vowels' location in Portuguese layout by @somehare in [#95](https://github.com/dessalines/thumb-key/pull/95)
- Updating releases.md by @dessalines

## New Contributors

- @morellik made their first contribution in [#112](https://github.com/dessalines/thumb-key/pull/112)
- @zgll2022 made their first contribution in [#107](https://github.com/dessalines/thumb-key/pull/107)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/0.0.7...0.0.8

## What's Changed in 0.0.7

- Upgrading version. by @dessalines
- Adding a caps lock mode. Autocapitalize off starts in lowercase. by @dessalines in [#93](https://github.com/dessalines/thumb-key/pull/93)
- Rename to match versioncode by @licaon-kter in [#92](https://github.com/dessalines/thumb-key/pull/92)
- Upgrading deps. by @dessalines in [#89](https://github.com/dessalines/thumb-key/pull/89)
- Various fixes to Russian and Ukrainian layouts by @DobriniaMerk in [#87](https://github.com/dessalines/thumb-key/pull/87)
- Fixed double Z and Position of "Ä" by @rickcrash in [#83](https://github.com/dessalines/thumb-key/pull/83)
- Updating releases.md by @dessalines

## New Contributors

- @licaon-kter made their first contribution in [#92](https://github.com/dessalines/thumb-key/pull/92)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/0.0.6...0.0.7

## What's Changed in 0.0.6

- Fixing newline / autocorrect glitch. Fixes #79 by @dessalines in [#81](https://github.com/dessalines/thumb-key/pull/81)
- Merge branch 'rickcrash-patch-2' by @dessalines
- A few fixes. by @dessalines
- Update ThumbKeyDEv1.kt by @rickcrash in [#80](https://github.com/dessalines/thumb-key/pull/80)
- Have settings tap go directly to look and feel. Fixes #70 by @dessalines in [#78](https://github.com/dessalines/thumb-key/pull/78)
- Adding woodpecker status badge. by @dessalines
- Adding more punctuation to spacebar multi-tap. by @dessalines in [#77](https://github.com/dessalines/thumb-key/pull/77)
- Adding woodpecker by @dessalines in [#74](https://github.com/dessalines/thumb-key/pull/74)
- Fix readme typo by @erjanmx in [#71](https://github.com/dessalines/thumb-key/pull/71)
- Adding german layout. Fixes #68 by @dessalines in [#69](https://github.com/dessalines/thumb-key/pull/69)
- Adding release notes. by @dessalines

## New Contributors

- @rickcrash made their first contribution in [#80](https://github.com/dessalines/thumb-key/pull/80)
- @erjanmx made their first contribution in [#71](https://github.com/dessalines/thumb-key/pull/71)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/0.0.5...0.0.6

## What's Changed in 0.0.5

- Fixing messageease keys by @dessalines in [#66](https://github.com/dessalines/thumb-key/pull/66)
- Swiping on the spacebar moves the cursor. Fixes #59 by @dessalines in [#63](https://github.com/dessalines/thumb-key/pull/63)
- Adding + to numeric keyboard. Fixes #60 by @dessalines in [#61](https://github.com/dessalines/thumb-key/pull/61)
- Extracting some common keys. by @dessalines in [#62](https://github.com/dessalines/thumb-key/pull/62)
- Adding internationalized strings. Fixes #31 by @dessalines in [#58](https://github.com/dessalines/thumb-key/pull/58)
- Correcting special characters location in Portuguese Layout by @somehare in [#57](https://github.com/dessalines/thumb-key/pull/57)
- Adding release notes. by @dessalines

## New Contributors

- @somehare made their first contribution in [#57](https://github.com/dessalines/thumb-key/pull/57)

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/0.0.4...0.0.5

## What's Changed in 0.0.4

- changed double 'г' to 'к' by @DobriniaMerk in [#56](https://github.com/dessalines/thumb-key/pull/56)
- Fixing substring crash for strange text fields. Fixes #45 by @dessalines in [#55](https://github.com/dessalines/thumb-key/pull/55)
- Adding portuguese language layout. Fixes #47 by @dessalines in [#54](https://github.com/dessalines/thumb-key/pull/54)
- Adding italian language layout. Fixes #52 by @dessalines in [#53](https://github.com/dessalines/thumb-key/pull/53)
- Merge branch 'anevaiopvn-main' by @dessalines
- Adding finnish language layout. Fixes #46 by @dessalines
- Finnish layout added by @dessalines in [#49](https://github.com/dessalines/thumb-key/pull/49)
- Added Finnish layout by @anevaiopvn
- Fixing link. by @dessalines
- Updating releases.md by @dessalines

## New Contributors

- @DobriniaMerk made their first contribution in [#56](https://github.com/dessalines/thumb-key/pull/56)
- @anevaiopvn made their first contribution

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/0.0.3...0.0.4

## What's Changed in 0.0.3

- Add russian and ukrainian layouts by @dessalines in [#41](https://github.com/dessalines/thumb-key/pull/41)
- Fix issue with IME padding. by @dessalines
- Adding a push up / bottom offset setting. Fixes #28 by @dessalines in [#40](https://github.com/dessalines/thumb-key/pull/40)
- Adding reset to defaults button. Fixes #27 by @dessalines in [#39](https://github.com/dessalines/thumb-key/pull/39)
- Fixing auto-capitalize after period. Fixes #32 by @dessalines in [#38](https://github.com/dessalines/thumb-key/pull/38)
- Remove gifs from readme. Double-tap correction. Fixes #33 by @dessalines in [#37](https://github.com/dessalines/thumb-key/pull/37)
- Fixing 2 links. by @dessalines
- Add izzyondroid link. by @dessalines
- Numeric mode input fix by @dessalines in [#24](https://github.com/dessalines/thumb-key/pull/24)
- Add new language help to readme by @dessalines in [#23](https://github.com/dessalines/thumb-key/pull/23)
- Adding release notes. by @dessalines

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/0.0.2...0.0.3

## What's Changed in 0.0.2

- Adding a minimum swipe length. Fixes #14 by @dessalines in [#22](https://github.com/dessalines/thumb-key/pull/22)
- Changing default space next tap action to comma. #18 by @dessalines in [#20](https://github.com/dessalines/thumb-key/pull/20)
- Swapping out \* for - , which is more common. Fixes #13 by @dessalines in [#19](https://github.com/dessalines/thumb-key/pull/19)
- Adding capitalize instructions. Fixes #16 by @dessalines
- Fixing fastlane full description. by @dessalines

**Full Changelog**: https://github.com/dessalines/thumb-key/compare/0.0.1...0.0.2

## What's Changed in 0.0.1

- Fix f-droid build issues. by @dessalines
- Adding fastlane by @dessalines
- Adding releases.md by @dessalines
- Fixing monkeytype link. by @dessalines
- Revert "More updates" by @dessalines
- More updates by @dessalines
- More updates by @dessalines
- More updates by @dessalines
- More updates by @dessalines
- More updates by @dessalines
- Trying another image. by @dessalines
- More updates by @dessalines
- Try using img tags by @dessalines
- Test to remove one image. by @dessalines
- More updates. by @dessalines
- More updates. by @dessalines
- Adding more to readme. by @dessalines
- Fixing image. by @dessalines
- Testing readme by @dessalines
- Adding png icon. by @dessalines
- Adding haptic feedback and tap sound settings. Fixes #12 by @dessalines
- A few minor fixes. by @dessalines
- Smarter swipe direction function. Fixes #11 by @dessalines
- Fixing IMEAction issues. Fixes #5 by @dessalines
- Fixing auto-capitalize by @dessalines
- Adding About page and Icon by @dessalines
- Adding goto settings. by @dessalines
- Adding settings. Fixes #1 by @dessalines
- Before starting to add room and settings. by @dessalines
- Reorganizing, adding thumbkey_v4 by @dessalines
- Running format by @dessalines
- Initial commit. by @dessalines

## New Contributors

- @dessalines made their first contribution

<!-- generated by git-cliff -->
