<div align="center">

![GitHub tag (latest SemVer)](https://img.shields.io/github/tag/dessalines/habit-maker.svg)
[![status-badge](https://woodpecker.join-lemmy.org/api/badges/dessalines/habit-maker/status.svg)](https://woodpecker.join-lemmy.org/dessalines/habit-maker)
[![GitHub issues](https://img.shields.io/github/issues-raw/dessalines/habit-maker.svg)](https://github.com/dessalines/habit-maker/issues)
[![License](https://img.shields.io/github/license/dessalines/habit-maker.svg)](LICENSE)
[![Translation status](https://hosted.weblate.org/widget/habit-maker/habit-maker/svg-badge.svg)](https://hosted.weblate.org/engage/habit-maker/)
![GitHub stars](https://img.shields.io/github/stars/dessalines/habit-maker?style=social)

</div>

<p align="center">
  <a href="https://github.com/dessalines/habit-maker" rel="noopener">
    <img width=200px height=200px src="https://raw.githubusercontent.com/dessalines/habit-maker/main/app/src/main/res/mipmap-xxxhdpi/ic_launcher_round.webp" alt="phone_screen" />
  </a>

 <h3 align="center"><a href="https://github.com/dessalines/habit-maker">Habit-Maker</a></h3>
  <p align="center">
    A reward-based habit tracker for android.
    <br />
    <br />
    <a href="https://github.com/dessalines/habit-maker/issues">Report Bug</a>
    ·
    <a href="https://github.com/dessalines/habit-maker/issues">Request Feature</a>
    ·
    <a href="https://github.com/dessalines/habit-maker/releases">Releases</a>
  </p>
  <p align="center">
    <a href="https://apt.izzysoft.de/fdroid/index/apk/com.dessalines.habitmaker"><img src="https://gitlab.com/IzzyOnDroid/repo/-/raw/master/assets/IzzyOnDroid.png" alt="Get it on IzzyOnDroid" height="80"></a>
    <a href="https://f-droid.org/packages/com.dessalines.habitmaker"><img src="https://fdroid.gitlab.io/artwork/badge/get-it-on.png" alt="Get it on F-Droid" height="80"></a>
    <a href="https://play.google.com/store/apps/details?id=com.dessalines.habitmaker"><img src="https://cdn.rawgit.com/steverichey/google-play-badge-svg/master/img/en_get.svg" height="80"></a>
    <a href="https://github.com/dessalines/habit-maker/releases/latest"><img src="https://raw.githubusercontent.com/andOTP/andOTP/master/assets/badges/get-it-on-github.png" height="80"></a>
  </p>
</p>

## About Habit-Maker

<p align="center">
  <img src="./fastlane/metadata/android/en-US/images/phoneScreenshots/1.jpg" width="250" alt="mobile_screen_1">
&nbsp; &nbsp; &nbsp; &nbsp;
  <img src="./fastlane/metadata/android/en-US/images/phoneScreenshots/2.jpg" width="250" alt="mobile_screen_2">
</p>

Have you found it difficult to build new habits? Habit-Maker uses rewards and encouragements to help get over initial willpower required to form new habits.

## Features

### Rewards

Habit-Maker game-ifies making habits by giving you rewards each time you check a habit. It shows the following progress metrics:

- Streaks - The # of days you've completed your habit in a row.
- Points - points for checking habits, with multipliers for continuing your streak.
- % progress to your [66-day-ingrained habit](https://www.ucl.ac.uk/news/2009/aug/how-long-does-it-take-form-habit).

### Encouragements

Studies have found that encouragements are [vital](https://jamesclear.com/three-steps-habit-change) to building new habits. Habit-Maker takes advantage of this by allowing you to create your own **custom encouragements.**

Before creating a habit, take a few minutes and think about _why_ you want to build this habit. What benefits will it bring you, and how your life will improve by doing it?

A good encouragement should have:

- An initial congratulations for completing the habit.
- A message tailored to you, about the benefits or reasons why you should continue.

Some examples of good encouragements:

| Activity                    | Encouragement                                                                                      |
| --------------------------- | -------------------------------------------------------------------------------------------------- |
| Brushing your teeth         | Great job! Your friends will like seeing your whiter teeth, and less coffee stains.                |
| Lifting weights for 10m     | Nice job! People will notice your better physique.                                                 |
| Learning a language for 10m | Excellent! You'll be able to talk to new people, and learn a new culture different from your own.  |
| Cardio for 10m              | Well done! Studies show you're going to live a lot longer!                                         |
| Meditating for 10m          | Nice! You're on your way to bettering the lives of those around you, by developing your awareness. |

### When and where?

[Studies have shown](https://pmc.ncbi.nlm.nih.gov/articles/PMC3505409/) that adding contextual cues can _greatly_ increase the chances that you continue a habit, so Habit-Maker has a special _when / where_ field to help. Some examples might be:

| Activity          | When / where                  |
| ----------------- | ----------------------------- |
| Meditate          | In my room, after breakfast   |
| Work out          | After work                    |
| Language learning | On my computer, before dinner |

### Completing a habit

Once a habit has been formed, its relatively easy to continue doing it, almost as if it were on auto-pilot. Research shows that ~40% of our daily activities are habits that don't require much (if any) willpower once they've been formed.

## Built With

- [Android Jetpack Compose](https://developer.android.com/jetpack/compose)
- [kizitonwose Calendar](https://github.com/kizitonwose/Calendar)
- [iSoron/uhabits](https://github.com/iSoron/uhabits) (For score calculations)

## Installation / Releases

- [Releases](https://github.com/dessalines/habit-maker/releases)
- [IzzyOnDroid](https://apt.izzysoft.de/fdroid/index/apk/com.dessalines.habitmaker)
- [F-Droid](https://f-droid.org/en/packages/com.dessalines.habitmaker/)
- [Google Play](https://play.google.com/store/apps/details?id=com.dessalines.habitmaker)

## Contributing

See [Contributing.md](CONTRIBUTING.md) for how to contribute.

Translations via [weblate](https://hosted.weblate.org/engage/habit-maker/):

[![Translation status](https://hosted.weblate.org/widget/habit-maker/habit-maker/multi-auto.svg)](https://hosted.weblate.org/engage/habit-maker/)

## Support / Donate

Habit-Maker will always remain free, open-source software. We've seen many open-source projects go unmaintained after a few years. **Recurring donations have proven to be the only way these projects can stay alive.**

Your donations directly support full-time development, and help keep this maintained. If you find yourself using habit-maker every day, consider donating:

- [Support me on Liberapay](https://liberapay.com/dessalines).
- [Support me Patreon](https://www.patreon.com/dessalines).

### Crypto

- bitcoin: `1Hefs7miXS5ff5Ck5xvmjKjXf5242KzRtK`
- ethereum: `0x400c96c96acbC6E7B3B43B1dc1BB446540a88A01`
- monero: `41taVyY6e1xApqKyMVDRVxJ76sPkfZhALLTjRvVKpaAh2pBd4wv9RgYj1tSPrx8wc6iE1uWUfjtQdTmTy2FGMeChGVKPQuV`

## Social / Contact

- [lemmy.ml/c/habitmaker](https://lemmy.ml/c/habitmaker)
- [Mastodon](https://mastodon.social/@dessalines)
- [Matrix chat](https://matrix.to/#/#habit-maker:matrix.org)

## Habit Resources

- [James clear - 3 steps habit change](https://jamesclear.com/three-steps-habit-change)
- [I got addicted to a habit app.](https://archive.ph/atmo6)
- [Develop good habits](https://www.developgoodhabits.com/build-habits/)
- [James clear - how to build a new habit](https://medium.com/the-blog-of-james-clear/how-to-build-a-new-habit-this-is-your-strategy-guide-79a7abd186a5)
- [CNN habit tips](https://www.cnn.com/2021/11/29/health/5-steps-habit-builder-wellness/index.html)

## Icons

[Work in progress icons created by Cap Cool - Flaticon](https://www.flaticon.com/free-icons/work-in-progress)
