<h1 align="center">
  <img src="images/page_keeper_logo.png" width="120" alt="EhViewer">
  <br>Shiori<br>
</h1>

<p align="center">
  <a href="https://github.com/DesarrolloAntonio/Shiori-Android-Client/actions">
    <img src="https://github.com/DesarrolloAntonio/Shiori-Android-Client/actions/workflows/ci.yml/badge.svg" alt="GitHub Actions">
  </a>
  <a href="https://github.com/DesarrolloAntonio/Shiori-Android-Client/blob/master/LICENSE">
    <img src="https://img.shields.io/github/license/DesarrolloAntonio/Shiori-Android-Client" alt="License">
  </a>
  <a href="https://github.com/DesarrolloAntonio/Shiori-Android-Client/releases">
    <img src="https://img.shields.io/github/v/release/DesarrolloAntonio/Shiori-Android-Client" alt="Release">
  </a>
  <a href="https://github.com/DesarrolloAntonio/Shiori-Android-Client/issues">
    <img src="https://img.shields.io/github/issues/DesarrolloAntonio/Shiori-Android-Client" alt="Issues">
  </a>
 <a href="https://github.com/DesarrolloAntonio/Shiori-Android-Client/commits">
    <img src="https://img.shields.io/github/commit-activity/m/DesarrolloAntonio/Shiori-Android-Client" alt="Commit Activity">
  </a>
</p>

<div align="center">
  <h3>
    <a href="#description">Description</a>
    <span> | </span>
    <a href="#screenshot">Screenshot</a>
    <span> | </span>
    <a href="#features">Features</a>
    <span> | </span>
    <a href="#technologies-used">Technologies Used</a>
    <span> | </span>
    <a href="#download">Download</a>
    <span> | </span>
    <a href="#license">License</a>
  </h3>
</div>

## Description
Shiori is an innovative bookmark management application that revolutionizes the way users save, organize, and access their favorite web pages. Built upon the robust [Shiori platform](https://github.com/go-shiori/shiori), Shiori offers a seamless experience across all devices.

## Screenshots
|                                                      |                                                      |                                                      |                                                      |
|:----------------------------------------------------:|:----------------------------------------------------:|:----------------------------------------------------:|:----------------------------------------------------:|
| ![Screenshot 1](images/screenshots/Screenshot_1.png) | ![Screenshot 2](images/screenshots/Screenshot_2.png) | ![Screenshot 3](images/screenshots/Screenshot_3.png) | ![Screenshot 4](images/screenshots/Screenshot_4.png) |
| ![Screenshot 5](images/screenshots/Screenshot_5.png) | ![Screenshot 6](images/screenshots/Screenshot_6.png) | ![Screenshot 7](images/screenshots/Screenshot_7.png) | ![Screenshot 8](images/screenshots/Screenshot_8.png) |


## Features
- **Save Pages Easily**: Instantly capture and access web pages at any time, even offline.
- **Superior Organization**: Custom labels, descriptions, and thumbnails for efficient bookmark sorting.
- **Cloud Synchronization**: Sync your bookmarks across all devices.
- **Intuitive Interface**: User-friendly navigation for a seamless experience.

## Technologies Used
Shiori is built using a variety of modern and robust technologies to ensure scalability, maintainability, and performance:
- **Clean Architecture**: Ensuring separation of concerns and modular design.
- **Dependency Injection (DI)**: For managing dependencies effectively.
- **Model-View-ViewModel (MVVM)**: For a responsive and powerful user interface.
- **Use Cases**: Defining clear business logic.
- **Repository Pattern**: For efficient data handling and abstraction.
- **Protobuf (Proto)**: For efficient data serialization.
- 
## Development Status ⚠️
Please note that Shiori is currently under development. While we strive to provide a stable experience, you may encounter bugs or incomplete features. We encourage users to:
- Report any issues you find on our [GitHub Issues page](https://github.com/DesarrolloAntonio/Shiori-Android-Client/issues)
- Be aware that some features might be unstable or work in progress
- Expect regular updates as we continue to improve the application

## Download

Shiori is available for download on various platforms:

<p>
  <a href="https://github.com/DesarrolloAntonio/Shiori-Android-Client/releases/latest">
    <img src="images/badge_github.png" alt="Get it on GitHub" height="80">
  </a>
  <a href="https://play.google.com/store/apps/details?id=com.desarrollodroide.pagekeeper">
    <img src="https://play.google.com/intl/en_us/badges/images/generic/en-play-badge.png" alt="Get Shiori on Google Play" height="80">
  </a>
  <a href="https://apt.izzysoft.de/fdroid/index/apk/com.desarrollodroide.pagekeeper">
    <img src="https://gitlab.com/IzzyOnDroid/repo/-/raw/master/assets/IzzyOnDroid.png" alt="Get Shiori on IzzyOnDroid" height="80">
  </a>
  <a href="https://f-droid.org/en/packages/com.desarrollodroide.pagekeeper">
    <img src="images/badge_fdroid.png" alt="Get it on F-Droid" height="80">
  </a>
</p>

## License
This project is licensed under the Apache License - see the [LICENSE](LICENSE) file for details.

