/*
 * Gogh, Vincent van; Almond Blossom; February 1890 - 1890
 */

package com.dergoogler.mmrl.ui.theme.color

import androidx.compose.material3.darkColorScheme
import androidx.compose.material3.lightColorScheme
import androidx.compose.ui.graphics.Color

private val primaryLight = Color(0xFF006970)
private val onPrimaryLight = Color(0xFFFFFFFF)
private val primaryContainerLight = Color(0xFF9DF0F8)
private val onPrimaryContainerLight = Color(0xFF002022)
private val secondaryLight = Color(0xFF4A6365)
private val onSecondaryLight = Color(0xFFFFFFFF)
private val secondaryContainerLight = Color(0xFFCCE8EA)
private val onSecondaryContainerLight = Color(0xFF051F21)
private val tertiaryLight = Color(0xFF505E7D)
private val onTertiaryLight = Color(0xFFFFFFFF)
private val tertiaryContainerLight = Color(0xFFD7E2FF)
private val onTertiaryContainerLight = Color(0xFF0A1B36)
private val errorLight = Color(0xFFBA1A1A)
private val onErrorLight = Color(0xFFFFFFFF)
private val errorContainerLight = Color(0xFFFFDAD6)
private val onErrorContainerLight = Color(0xFF410002)
private val backgroundLight = Color(0xFFF4FAFB)
private val onBackgroundLight = Color(0xFF161D1D)
private val surfaceLight = Color(0xFFF4FAFB)
private val onSurfaceLight = Color(0xFF161D1D)
private val surfaceVariantLight = Color(0xFFDAE4E5)
private val onSurfaceVariantLight = Color(0xFF3F4849)
private val outlineLight = Color(0xFF6F797A)
private val outlineVariantLight = Color(0xFFBEC8C9)
private val scrimLight = Color(0xFF000000)
private val inverseSurfaceLight = Color(0xFF2B3232)
private val inverseOnSurfaceLight = Color(0xFFECF2F2)
private val inversePrimaryLight = Color(0xFF80D4DC)
private val surfaceDimLight = Color(0xFFD5DBDC)
private val surfaceBrightLight = Color(0xFFF4FAFB)
private val surfaceContainerLowestLight = Color(0xFFFFFFFF)
private val surfaceContainerLowLight = Color(0xFFEFF5F5)
private val surfaceContainerLight = Color(0xFFE9EFEF)
private val surfaceContainerHighLight = Color(0xFFE3E9EA)
private val surfaceContainerHighestLight = Color(0xFFDEE4E4)

private val primaryDark = Color(0xFF80D4DC)
private val onPrimaryDark = Color(0xFF00363B)
private val primaryContainerDark = Color(0xFF004F55)
private val onPrimaryContainerDark = Color(0xFF9DF0F8)
private val secondaryDark = Color(0xFFB1CBCE)
private val onSecondaryDark = Color(0xFF1B3437)
private val secondaryContainerDark = Color(0xFF324B4D)
private val onSecondaryContainerDark = Color(0xFFCCE8EA)
private val tertiaryDark = Color(0xFFB7C7EA)
private val onTertiaryDark = Color(0xFF21304C)
private val tertiaryContainerDark = Color(0xFF384764)
private val onTertiaryContainerDark = Color(0xFFD7E2FF)
private val errorDark = Color(0xFFFFB4AB)
private val onErrorDark = Color(0xFF690005)
private val errorContainerDark = Color(0xFF93000A)
private val onErrorContainerDark = Color(0xFFFFDAD6)
private val backgroundDark = Color(0xFF0E1415)
private val onBackgroundDark = Color(0xFFDEE4E4)
private val surfaceDark = Color(0xFF0E1415)
private val onSurfaceDark = Color(0xFFDEE4E4)
private val surfaceVariantDark = Color(0xFF3F4849)
private val onSurfaceVariantDark = Color(0xFFBEC8C9)
private val outlineDark = Color(0xFF899393)
private val outlineVariantDark = Color(0xFF3F4849)
private val scrimDark = Color(0xFF000000)
private val inverseSurfaceDark = Color(0xFFDEE4E4)
private val inverseOnSurfaceDark = Color(0xFF2B3232)
private val inversePrimaryDark = Color(0xFF006970)
private val surfaceDimDark = Color(0xFF0E1415)
private val surfaceBrightDark = Color(0xFF343A3B)
private val surfaceContainerLowestDark = Color(0xFF090F10)
private val surfaceContainerLowDark = Color(0xFF161D1D)
private val surfaceContainerDark = Color(0xFF1A2121)
private val surfaceContainerHighDark = Color(0xFF252B2C)
private val surfaceContainerHighestDark = Color(0xFF303637)

val AlmondBlossomLightScheme =
    lightColorScheme(
        primary = primaryLight,
        onPrimary = onPrimaryLight,
        primaryContainer = primaryContainerLight,
        onPrimaryContainer = onPrimaryContainerLight,
        secondary = secondaryLight,
        onSecondary = onSecondaryLight,
        secondaryContainer = secondaryContainerLight,
        onSecondaryContainer = onSecondaryContainerLight,
        tertiary = tertiaryLight,
        onTertiary = onTertiaryLight,
        tertiaryContainer = tertiaryContainerLight,
        onTertiaryContainer = onTertiaryContainerLight,
        error = errorLight,
        onError = onErrorLight,
        errorContainer = errorContainerLight,
        onErrorContainer = onErrorContainerLight,
        background = backgroundLight,
        onBackground = onBackgroundLight,
        surface = surfaceLight,
        onSurface = onSurfaceLight,
        surfaceVariant = surfaceVariantLight,
        onSurfaceVariant = onSurfaceVariantLight,
        outline = outlineLight,
        outlineVariant = outlineVariantLight,
        scrim = scrimLight,
        inverseSurface = inverseSurfaceLight,
        inverseOnSurface = inverseOnSurfaceLight,
        inversePrimary = inversePrimaryLight,
        surfaceDim = surfaceDimLight,
        surfaceBright = surfaceBrightLight,
        surfaceContainerLowest = surfaceContainerLowestLight,
        surfaceContainerLow = surfaceContainerLowLight,
        surfaceContainer = surfaceContainerLight,
        surfaceContainerHigh = surfaceContainerHighLight,
        surfaceContainerHighest = surfaceContainerHighestLight,
    )

val AlmondBlossomDarkScheme =
    darkColorScheme(
        primary = primaryDark,
        onPrimary = onPrimaryDark,
        primaryContainer = primaryContainerDark,
        onPrimaryContainer = onPrimaryContainerDark,
        secondary = secondaryDark,
        onSecondary = onSecondaryDark,
        secondaryContainer = secondaryContainerDark,
        onSecondaryContainer = onSecondaryContainerDark,
        tertiary = tertiaryDark,
        onTertiary = onTertiaryDark,
        tertiaryContainer = tertiaryContainerDark,
        onTertiaryContainer = onTertiaryContainerDark,
        error = errorDark,
        onError = onErrorDark,
        errorContainer = errorContainerDark,
        onErrorContainer = onErrorContainerDark,
        background = backgroundDark,
        onBackground = onBackgroundDark,
        surface = surfaceDark,
        onSurface = onSurfaceDark,
        surfaceVariant = surfaceVariantDark,
        onSurfaceVariant = onSurfaceVariantDark,
        outline = outlineDark,
        outlineVariant = outlineVariantDark,
        scrim = scrimDark,
        inverseSurface = inverseSurfaceDark,
        inverseOnSurface = inverseOnSurfaceDark,
        inversePrimary = inversePrimaryDark,
        surfaceDim = surfaceDimDark,
        surfaceBright = surfaceBrightDark,
        surfaceContainerLowest = surfaceContainerLowestDark,
        surfaceContainerLow = surfaceContainerLowDark,
        surfaceContainer = surfaceContainerDark,
        surfaceContainerHigh = surfaceContainerHighDark,
        surfaceContainerHighest = surfaceContainerHighestDark,
    )
