package com.dergoogler.mmrl.platform.ksu

import android.system.Os

data class KernelVersion(
    val major: Int,
    val patchLevel: Int,
    val subLevel: Int,
) {
    override fun toString(): String = "$major.$patchLevel.$subLevel"

    fun isGKI(): Boolean {
        // kernel 6.x
        if (major > 5) {
            return true
        }

        // kernel 5.10.x
        if (major == 5) {
            return patchLevel >= 10
        }

        return false
    }

    companion object {
        fun parseVersion(version: String): KernelVersion {
            val find = "(\\d+)\\.(\\d+)\\.(\\d+)".toRegex().find(version)
            return if (find != null) {
                KernelVersion(
                    find.groupValues[1].toInt(),
                    find.groupValues[2].toInt(),
                    find.groupValues[3].toInt(),
                )
            } else {
                KernelVersion(-1, -1, -1)
            }
        }

        fun getKernelVersion(): KernelVersion {
            Os.uname().release.let {
                return parseVersion(it)
            }
        }
    }
}
