/*
 * Gogh, Vincent van; Wild Roses; April 1890 - May 1890
 */

package com.dergoogler.mmrl.ui.theme.color

import androidx.compose.material3.darkColorScheme
import androidx.compose.material3.lightColorScheme
import androidx.compose.ui.graphics.Color

private val primaryLight = Color(0xFF576422)
private val onPrimaryLight = Color(0xFFFFFFFF)
private val primaryContainerLight = Color(0xFFDAEB99)
private val onPrimaryContainerLight = Color(0xFF171E00)
private val secondaryLight = Color(0xFF5C6146)
private val onSecondaryLight = Color(0xFFFFFFFF)
private val secondaryContainerLight = Color(0xFFE1E6C3)
private val onSecondaryContainerLight = Color(0xFF191D08)
private val tertiaryLight = Color(0xFF3A665D)
private val onTertiaryLight = Color(0xFFFFFFFF)
private val tertiaryContainerLight = Color(0xFFBDECE0)
private val onTertiaryContainerLight = Color(0xFF00201B)
private val errorLight = Color(0xFFBA1A1A)
private val onErrorLight = Color(0xFFFFFFFF)
private val errorContainerLight = Color(0xFFFFDAD6)
private val onErrorContainerLight = Color(0xFF410002)
private val backgroundLight = Color(0xFFFBFAED)
private val onBackgroundLight = Color(0xFF1B1C15)
private val surfaceLight = Color(0xFFFBFAED)
private val onSurfaceLight = Color(0xFF1B1C15)
private val surfaceVariantLight = Color(0xFFE3E4D3)
private val onSurfaceVariantLight = Color(0xFF46483C)
private val outlineLight = Color(0xFF77786A)
private val outlineVariantLight = Color(0xFFC7C8B8)
private val scrimLight = Color(0xFF000000)
private val inverseSurfaceLight = Color(0xFF303129)
private val inverseOnSurfaceLight = Color(0xFFF2F1E5)
private val inversePrimaryLight = Color(0xFFBECE7F)
private val surfaceDimLight = Color(0xFFDBDBCE)
private val surfaceBrightLight = Color(0xFFFBFAED)
private val surfaceContainerLowestLight = Color(0xFFFFFFFF)
private val surfaceContainerLowLight = Color(0xFFF5F4E8)
private val surfaceContainerLight = Color(0xFFEFEEE2)
private val surfaceContainerHighLight = Color(0xFFEAE9DC)
private val surfaceContainerHighestLight = Color(0xFFE4E3D7)

private val primaryDark = Color(0xFFBECE7F)
private val onPrimaryDark = Color(0xFF2A3400)
private val primaryContainerDark = Color(0xFF3F4C0A)
private val onPrimaryContainerDark = Color(0xFFDAEB99)
private val secondaryDark = Color(0xFFC4CAA8)
private val onSecondaryDark = Color(0xFF2E331B)
private val secondaryContainerDark = Color(0xFF444930)
private val onSecondaryContainerDark = Color(0xFFE1E6C3)
private val tertiaryDark = Color(0xFFA1D0C4)
private val onTertiaryDark = Color(0xFF04372F)
private val tertiaryContainerDark = Color(0xFF214E46)
private val onTertiaryContainerDark = Color(0xFFBDECE0)
private val errorDark = Color(0xFFFFB4AB)
private val onErrorDark = Color(0xFF690005)
private val errorContainerDark = Color(0xFF93000A)
private val onErrorContainerDark = Color(0xFFFFDAD6)
private val backgroundDark = Color(0xFF13140D)
private val onBackgroundDark = Color(0xFFE4E3D7)
private val surfaceDark = Color(0xFF13140D)
private val onSurfaceDark = Color(0xFFE4E3D7)
private val surfaceVariantDark = Color(0xFF46483C)
private val onSurfaceVariantDark = Color(0xFFC7C8B8)
private val outlineDark = Color(0xFF919283)
private val outlineVariantDark = Color(0xFF46483C)
private val scrimDark = Color(0xFF000000)
private val inverseSurfaceDark = Color(0xFFE4E3D7)
private val inverseOnSurfaceDark = Color(0xFF303129)
private val inversePrimaryDark = Color(0xFF576422)
private val surfaceDimDark = Color(0xFF13140D)
private val surfaceBrightDark = Color(0xFF393A31)
private val surfaceContainerLowestDark = Color(0xFF0E0F08)
private val surfaceContainerLowDark = Color(0xFF1B1C15)
private val surfaceContainerDark = Color(0xFF1F2019)
private val surfaceContainerHighDark = Color(0xFF292B23)
private val surfaceContainerHighestDark = Color(0xFF34352D)

val WildRosesLightScheme = lightColorScheme(
    primary = primaryLight,
    onPrimary = onPrimaryLight,
    primaryContainer = primaryContainerLight,
    onPrimaryContainer = onPrimaryContainerLight,
    secondary = secondaryLight,
    onSecondary = onSecondaryLight,
    secondaryContainer = secondaryContainerLight,
    onSecondaryContainer = onSecondaryContainerLight,
    tertiary = tertiaryLight,
    onTertiary = onTertiaryLight,
    tertiaryContainer = tertiaryContainerLight,
    onTertiaryContainer = onTertiaryContainerLight,
    error = errorLight,
    onError = onErrorLight,
    errorContainer = errorContainerLight,
    onErrorContainer = onErrorContainerLight,
    background = backgroundLight,
    onBackground = onBackgroundLight,
    surface = surfaceLight,
    onSurface = onSurfaceLight,
    surfaceVariant = surfaceVariantLight,
    onSurfaceVariant = onSurfaceVariantLight,
    outline = outlineLight,
    outlineVariant = outlineVariantLight,
    scrim = scrimLight,
    inverseSurface = inverseSurfaceLight,
    inverseOnSurface = inverseOnSurfaceLight,
    inversePrimary = inversePrimaryLight,
    surfaceDim = surfaceDimLight,
    surfaceBright = surfaceBrightLight,
    surfaceContainerLowest = surfaceContainerLowestLight,
    surfaceContainerLow = surfaceContainerLowLight,
    surfaceContainer = surfaceContainerLight,
    surfaceContainerHigh = surfaceContainerHighLight,
    surfaceContainerHighest = surfaceContainerHighestLight,
)

val WildRosesDarkScheme = darkColorScheme(
    primary = primaryDark,
    onPrimary = onPrimaryDark,
    primaryContainer = primaryContainerDark,
    onPrimaryContainer = onPrimaryContainerDark,
    secondary = secondaryDark,
    onSecondary = onSecondaryDark,
    secondaryContainer = secondaryContainerDark,
    onSecondaryContainer = onSecondaryContainerDark,
    tertiary = tertiaryDark,
    onTertiary = onTertiaryDark,
    tertiaryContainer = tertiaryContainerDark,
    onTertiaryContainer = onTertiaryContainerDark,
    error = errorDark,
    onError = onErrorDark,
    errorContainer = errorContainerDark,
    onErrorContainer = onErrorContainerDark,
    background = backgroundDark,
    onBackground = onBackgroundDark,
    surface = surfaceDark,
    onSurface = onSurfaceDark,
    surfaceVariant = surfaceVariantDark,
    onSurfaceVariant = onSurfaceVariantDark,
    outline = outlineDark,
    outlineVariant = outlineVariantDark,
    scrim = scrimDark,
    inverseSurface = inverseSurfaceDark,
    inverseOnSurface = inverseOnSurfaceDark,
    inversePrimary = inversePrimaryDark,
    surfaceDim = surfaceDimDark,
    surfaceBright = surfaceBrightDark,
    surfaceContainerLowest = surfaceContainerLowestDark,
    surfaceContainerLow = surfaceContainerLowDark,
    surfaceContainer = surfaceContainerDark,
    surfaceContainerHigh = surfaceContainerHighDark,
    surfaceContainerHighest = surfaceContainerHighestDark,
)