/*
 * Monet, Claude; Cliff Walk at Pourville; 1882
 */

package com.dergoogler.mmrl.ui.theme.color

import androidx.compose.material3.darkColorScheme
import androidx.compose.material3.lightColorScheme
import androidx.compose.ui.graphics.Color

private val primaryLight = Color(0xFF1D6586)
private val onPrimaryLight = Color(0xFFFFFFFF)
private val primaryContainerLight = Color(0xFFC4E7FF)
private val onPrimaryContainerLight = Color(0xFF001E2C)
private val secondaryLight = Color(0xFF4E616D)
private val onSecondaryLight = Color(0xFFFFFFFF)
private val secondaryContainerLight = Color(0xFFD1E5F4)
private val onSecondaryContainerLight = Color(0xFF0A1E28)
private val tertiaryLight = Color(0xFF615A7D)
private val onTertiaryLight = Color(0xFFFFFFFF)
private val tertiaryContainerLight = Color(0xFFE7DEFF)
private val onTertiaryContainerLight = Color(0xFF1D1736)
private val errorLight = Color(0xFFBA1A1A)
private val onErrorLight = Color(0xFFFFFFFF)
private val errorContainerLight = Color(0xFFFFDAD6)
private val onErrorContainerLight = Color(0xFF410002)
private val backgroundLight = Color(0xFFF6FAFE)
private val onBackgroundLight = Color(0xFF181C1F)
private val surfaceLight = Color(0xFFF6FAFE)
private val onSurfaceLight = Color(0xFF181C1F)
private val surfaceVariantLight = Color(0xFFDDE3EA)
private val onSurfaceVariantLight = Color(0xFF41484D)
private val outlineLight = Color(0xFF71787E)
private val outlineVariantLight = Color(0xFFC0C7CD)
private val scrimLight = Color(0xFF000000)
private val inverseSurfaceLight = Color(0xFF2C3134)
private val inverseOnSurfaceLight = Color(0xFFEDF1F5)
private val inversePrimaryLight = Color(0xFF90CEF4)
private val surfaceDimLight = Color(0xFFD7DADF)
private val surfaceBrightLight = Color(0xFFF6FAFE)
private val surfaceContainerLowestLight = Color(0xFFFFFFFF)
private val surfaceContainerLowLight = Color(0xFFF0F4F8)
private val surfaceContainerLight = Color(0xFFEBEEF3)
private val surfaceContainerHighLight = Color(0xFFE5E8ED)
private val surfaceContainerHighestLight = Color(0xFFDFE3E7)

private val primaryDark = Color(0xFF90CEF4)
private val onPrimaryDark = Color(0xFF00344A)
private val primaryContainerDark = Color(0xFF004C69)
private val onPrimaryContainerDark = Color(0xFFC4E7FF)
private val secondaryDark = Color(0xFFB5C9D7)
private val onSecondaryDark = Color(0xFF20333E)
private val secondaryContainerDark = Color(0xFF374955)
private val onSecondaryContainerDark = Color(0xFFD1E5F4)
private val tertiaryDark = Color(0xFFCAC1E9)
private val onTertiaryDark = Color(0xFF322C4C)
private val tertiaryContainerDark = Color(0xFF494264)
private val onTertiaryContainerDark = Color(0xFFE7DEFF)
private val errorDark = Color(0xFFFFB4AB)
private val onErrorDark = Color(0xFF690005)
private val errorContainerDark = Color(0xFF93000A)
private val onErrorContainerDark = Color(0xFFFFDAD6)
private val backgroundDark = Color(0xFF0F1417)
private val onBackgroundDark = Color(0xFFDFE3E7)
private val surfaceDark = Color(0xFF0F1417)
private val onSurfaceDark = Color(0xFFDFE3E7)
private val surfaceVariantDark = Color(0xFF41484D)
private val onSurfaceVariantDark = Color(0xFFC0C7CD)
private val outlineDark = Color(0xFF8B9297)
private val outlineVariantDark = Color(0xFF41484D)
private val scrimDark = Color(0xFF000000)
private val inverseSurfaceDark = Color(0xFFDFE3E7)
private val inverseOnSurfaceDark = Color(0xFF2C3134)
private val inversePrimaryDark = Color(0xFF1D6586)
private val surfaceDimDark = Color(0xFF0F1417)
private val surfaceBrightDark = Color(0xFF353A3D)
private val surfaceContainerLowestDark = Color(0xFF0A0F12)
private val surfaceContainerLowDark = Color(0xFF181C1F)
private val surfaceContainerDark = Color(0xFF1C2023)
private val surfaceContainerHighDark = Color(0xFF262B2E)
private val surfaceContainerHighestDark = Color(0xFF313539)

val PourvilleLightScheme = lightColorScheme(
    primary = primaryLight,
    onPrimary = onPrimaryLight,
    primaryContainer = primaryContainerLight,
    onPrimaryContainer = onPrimaryContainerLight,
    secondary = secondaryLight,
    onSecondary = onSecondaryLight,
    secondaryContainer = secondaryContainerLight,
    onSecondaryContainer = onSecondaryContainerLight,
    tertiary = tertiaryLight,
    onTertiary = onTertiaryLight,
    tertiaryContainer = tertiaryContainerLight,
    onTertiaryContainer = onTertiaryContainerLight,
    error = errorLight,
    onError = onErrorLight,
    errorContainer = errorContainerLight,
    onErrorContainer = onErrorContainerLight,
    background = backgroundLight,
    onBackground = onBackgroundLight,
    surface = surfaceLight,
    onSurface = onSurfaceLight,
    surfaceVariant = surfaceVariantLight,
    onSurfaceVariant = onSurfaceVariantLight,
    outline = outlineLight,
    outlineVariant = outlineVariantLight,
    scrim = scrimLight,
    inverseSurface = inverseSurfaceLight,
    inverseOnSurface = inverseOnSurfaceLight,
    inversePrimary = inversePrimaryLight,
    surfaceDim = surfaceDimLight,
    surfaceBright = surfaceBrightLight,
    surfaceContainerLowest = surfaceContainerLowestLight,
    surfaceContainerLow = surfaceContainerLowLight,
    surfaceContainer = surfaceContainerLight,
    surfaceContainerHigh = surfaceContainerHighLight,
    surfaceContainerHighest = surfaceContainerHighestLight,
)

val PourvilleDarkScheme = darkColorScheme(
    primary = primaryDark,
    onPrimary = onPrimaryDark,
    primaryContainer = primaryContainerDark,
    onPrimaryContainer = onPrimaryContainerDark,
    secondary = secondaryDark,
    onSecondary = onSecondaryDark,
    secondaryContainer = secondaryContainerDark,
    onSecondaryContainer = onSecondaryContainerDark,
    tertiary = tertiaryDark,
    onTertiary = onTertiaryDark,
    tertiaryContainer = tertiaryContainerDark,
    onTertiaryContainer = onTertiaryContainerDark,
    error = errorDark,
    onError = onErrorDark,
    errorContainer = errorContainerDark,
    onErrorContainer = onErrorContainerDark,
    background = backgroundDark,
    onBackground = onBackgroundDark,
    surface = surfaceDark,
    onSurface = onSurfaceDark,
    surfaceVariant = surfaceVariantDark,
    onSurfaceVariant = onSurfaceVariantDark,
    outline = outlineDark,
    outlineVariant = outlineVariantDark,
    scrim = scrimDark,
    inverseSurface = inverseSurfaceDark,
    inverseOnSurface = inverseOnSurfaceDark,
    inversePrimary = inversePrimaryDark,
    surfaceDim = surfaceDimDark,
    surfaceBright = surfaceBrightDark,
    surfaceContainerLowest = surfaceContainerLowestDark,
    surfaceContainerLow = surfaceContainerLowDark,
    surfaceContainer = surfaceContainerDark,
    surfaceContainerHigh = surfaceContainerHighDark,
    surfaceContainerHighest = surfaceContainerHighestDark,
)