/*
 * Monet, Claude; Poppy Field in a Hollow near Giverny; 1885
 */

package com.dergoogler.mmrl.ui.theme.color

import androidx.compose.material3.darkColorScheme
import androidx.compose.material3.lightColorScheme
import androidx.compose.ui.graphics.Color

private val primaryLight = Color(0xFF046B5C)
private val onPrimaryLight = Color(0xFFFFFFFF)
private val primaryContainerLight = Color(0xFFA0F2DF)
private val onPrimaryContainerLight = Color(0xFF00201B)
private val secondaryLight = Color(0xFF4A635D)
private val onSecondaryLight = Color(0xFFFFFFFF)
private val secondaryContainerLight = Color(0xFFCDE8E0)
private val onSecondaryContainerLight = Color(0xFF06201B)
private val tertiaryLight = Color(0xFF436278)
private val onTertiaryLight = Color(0xFFFFFFFF)
private val tertiaryContainerLight = Color(0xFFC9E6FF)
private val onTertiaryContainerLight = Color(0xFF001E2F)
private val errorLight = Color(0xFFBA1A1A)
private val onErrorLight = Color(0xFFFFFFFF)
private val errorContainerLight = Color(0xFFFFDAD6)
private val onErrorContainerLight = Color(0xFF410002)
private val backgroundLight = Color(0xFFF5FBF7)
private val onBackgroundLight = Color(0xFF171D1B)
private val surfaceLight = Color(0xFFF5FBF7)
private val onSurfaceLight = Color(0xFF171D1B)
private val surfaceVariantLight = Color(0xFFDAE5E0)
private val onSurfaceVariantLight = Color(0xFF3F4946)
private val outlineLight = Color(0xFF6F7976)
private val outlineVariantLight = Color(0xFFBEC9C5)
private val scrimLight = Color(0xFF000000)
private val inverseSurfaceLight = Color(0xFF2B3230)
private val inverseOnSurfaceLight = Color(0xFFECF2EF)
private val inversePrimaryLight = Color(0xFF84D6C3)
private val surfaceDimLight = Color(0xFFD5DBD8)
private val surfaceBrightLight = Color(0xFFF5FBF7)
private val surfaceContainerLowestLight = Color(0xFFFFFFFF)
private val surfaceContainerLowLight = Color(0xFFEFF5F2)
private val surfaceContainerLight = Color(0xFFE9EFEC)
private val surfaceContainerHighLight = Color(0xFFE3EAE6)
private val surfaceContainerHighestLight = Color(0xFFDEE4E1)

private val primaryDark = Color(0xFF84D6C3)
private val onPrimaryDark = Color(0xFF00382F)
private val primaryContainerDark = Color(0xFF005045)
private val onPrimaryContainerDark = Color(0xFFA0F2DF)
private val secondaryDark = Color(0xFFB1CCC4)
private val onSecondaryDark = Color(0xFF1C352F)
private val secondaryContainerDark = Color(0xFF334B46)
private val onSecondaryContainerDark = Color(0xFFCDE8E0)
private val tertiaryDark = Color(0xFFABCAE4)
private val onTertiaryDark = Color(0xFF123348)
private val tertiaryContainerDark = Color(0xFF2B4A5F)
private val onTertiaryContainerDark = Color(0xFFC9E6FF)
private val errorDark = Color(0xFFFFB4AB)
private val onErrorDark = Color(0xFF690005)
private val errorContainerDark = Color(0xFF93000A)
private val onErrorContainerDark = Color(0xFFFFDAD6)
private val backgroundDark = Color(0xFF0E1513)
private val onBackgroundDark = Color(0xFFDEE4E1)
private val surfaceDark = Color(0xFF0E1513)
private val onSurfaceDark = Color(0xFFDEE4E1)
private val surfaceVariantDark = Color(0xFF3F4946)
private val onSurfaceVariantDark = Color(0xFFBEC9C5)
private val outlineDark = Color(0xFF89938F)
private val outlineVariantDark = Color(0xFF3F4946)
private val scrimDark = Color(0xFF000000)
private val inverseSurfaceDark = Color(0xFFDEE4E1)
private val inverseOnSurfaceDark = Color(0xFF2B3230)
private val inversePrimaryDark = Color(0xFF046B5C)
private val surfaceDimDark = Color(0xFF0E1513)
private val surfaceBrightDark = Color(0xFF343B38)
private val surfaceContainerLowestDark = Color(0xFF090F0E)
private val surfaceContainerLowDark = Color(0xFF171D1B)
private val surfaceContainerDark = Color(0xFF1B211F)
private val surfaceContainerHighDark = Color(0xFF252B29)
private val surfaceContainerHighestDark = Color(0xFF303634)

val PoppyFieldLightScheme = lightColorScheme(
    primary = primaryLight,
    onPrimary = onPrimaryLight,
    primaryContainer = primaryContainerLight,
    onPrimaryContainer = onPrimaryContainerLight,
    secondary = secondaryLight,
    onSecondary = onSecondaryLight,
    secondaryContainer = secondaryContainerLight,
    onSecondaryContainer = onSecondaryContainerLight,
    tertiary = tertiaryLight,
    onTertiary = onTertiaryLight,
    tertiaryContainer = tertiaryContainerLight,
    onTertiaryContainer = onTertiaryContainerLight,
    error = errorLight,
    onError = onErrorLight,
    errorContainer = errorContainerLight,
    onErrorContainer = onErrorContainerLight,
    background = backgroundLight,
    onBackground = onBackgroundLight,
    surface = surfaceLight,
    onSurface = onSurfaceLight,
    surfaceVariant = surfaceVariantLight,
    onSurfaceVariant = onSurfaceVariantLight,
    outline = outlineLight,
    outlineVariant = outlineVariantLight,
    scrim = scrimLight,
    inverseSurface = inverseSurfaceLight,
    inverseOnSurface = inverseOnSurfaceLight,
    inversePrimary = inversePrimaryLight,
    surfaceDim = surfaceDimLight,
    surfaceBright = surfaceBrightLight,
    surfaceContainerLowest = surfaceContainerLowestLight,
    surfaceContainerLow = surfaceContainerLowLight,
    surfaceContainer = surfaceContainerLight,
    surfaceContainerHigh = surfaceContainerHighLight,
    surfaceContainerHighest = surfaceContainerHighestLight,
)

val PoppyFieldDarkScheme = darkColorScheme(
    primary = primaryDark,
    onPrimary = onPrimaryDark,
    primaryContainer = primaryContainerDark,
    onPrimaryContainer = onPrimaryContainerDark,
    secondary = secondaryDark,
    onSecondary = onSecondaryDark,
    secondaryContainer = secondaryContainerDark,
    onSecondaryContainer = onSecondaryContainerDark,
    tertiary = tertiaryDark,
    onTertiary = onTertiaryDark,
    tertiaryContainer = tertiaryContainerDark,
    onTertiaryContainer = onTertiaryContainerDark,
    error = errorDark,
    onError = onErrorDark,
    errorContainer = errorContainerDark,
    onErrorContainer = onErrorContainerDark,
    background = backgroundDark,
    onBackground = onBackgroundDark,
    surface = surfaceDark,
    onSurface = onSurfaceDark,
    surfaceVariant = surfaceVariantDark,
    onSurfaceVariant = onSurfaceVariantDark,
    outline = outlineDark,
    outlineVariant = outlineVariantDark,
    scrim = scrimDark,
    inverseSurface = inverseSurfaceDark,
    inverseOnSurface = inverseOnSurfaceDark,
    inversePrimary = inversePrimaryDark,
    surfaceDim = surfaceDimDark,
    surfaceBright = surfaceBrightDark,
    surfaceContainerLowest = surfaceContainerLowestDark,
    surfaceContainerLow = surfaceContainerLowDark,
    surfaceContainer = surfaceContainerDark,
    surfaceContainerHigh = surfaceContainerHighDark,
    surfaceContainerHighest = surfaceContainerHighestDark,
)