// Copyright (c) 2018, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

// ignore: implementation_imports
import 'package:build_runner_core/src/generate/run_post_process_builder.dart'
    as build_runner_core;
import 'package:logging/logging.dart';

import '../asset/id.dart';
import '../asset/reader.dart';
import '../asset/writer.dart';
import '../builder/post_process_builder.dart';

/// Run [builder] with [inputId] as the primary input.
///
/// [addAsset] should update the build systems knowledge of what assets exist.
/// If an asset should not be written this function should throw.
/// [deleteAsset] should remove the asset from the build system, it will not be
/// deleted on disk since the `writer` has no mechanism for delete.
@Deprecated('''
This method has moved to `package:build_runner_core` and will be
deleted from `package:build` in 4.0.0.

The currently supported ways to run builders are using `build_runner`
on the command line or `build_test` in tests. If you need ongoing
support for a different way to run builders please get in touch at
https://github.com/dart-lang/build/discussions.
''')
Future<void> runPostProcessBuilder(
  PostProcessBuilder builder,
  AssetId inputId,
  AssetReader reader,
  AssetWriter writer,
  Logger logger, {
  required void Function(AssetId) addAsset,
  required void Function(AssetId) deleteAsset,
}) => build_runner_core.runPostProcessBuilder(
  builder,
  inputId,
  reader,
  writer,
  logger,
  addAsset: addAsset,
  deleteAsset: deleteAsset,
);
