// Autogenerated from Pigeon (v26.0.0), do not edit directly.
// See also: https://pub.dev/packages/pigeon

#undef _HAS_EXCEPTIONS

#include "my_api.g.h"

#include <flutter/basic_message_channel.h>
#include <flutter/binary_messenger.h>
#include <flutter/encodable_value.h>
#include <flutter/standard_message_codec.h>

#include <map>
#include <optional>
#include <string>

namespace bluetooth_low_energy_windows {
using flutter::BasicMessageChannel;
using flutter::CustomEncodableValue;
using flutter::EncodableList;
using flutter::EncodableMap;
using flutter::EncodableValue;

FlutterError CreateConnectionError(const std::string channel_name) {
  return FlutterError(
      "channel-error",
      "Unable to establish connection on channel: '" + channel_name + "'.",
      EncodableValue(""));
}

// MyManufacturerSpecificDataArgs

MyManufacturerSpecificDataArgs::MyManufacturerSpecificDataArgs(
  int64_t id_args,
  const std::vector<uint8_t>& data_args)
 : id_args_(id_args),
    data_args_(data_args) {}

int64_t MyManufacturerSpecificDataArgs::id_args() const {
  return id_args_;
}

void MyManufacturerSpecificDataArgs::set_id_args(int64_t value_arg) {
  id_args_ = value_arg;
}


const std::vector<uint8_t>& MyManufacturerSpecificDataArgs::data_args() const {
  return data_args_;
}

void MyManufacturerSpecificDataArgs::set_data_args(const std::vector<uint8_t>& value_arg) {
  data_args_ = value_arg;
}


EncodableList MyManufacturerSpecificDataArgs::ToEncodableList() const {
  EncodableList list;
  list.reserve(2);
  list.push_back(EncodableValue(id_args_));
  list.push_back(EncodableValue(data_args_));
  return list;
}

MyManufacturerSpecificDataArgs MyManufacturerSpecificDataArgs::FromEncodableList(const EncodableList& list) {
  MyManufacturerSpecificDataArgs decoded(
    std::get<int64_t>(list[0]),
    std::get<std::vector<uint8_t>>(list[1]));
  return decoded;
}

// MyAdvertisementArgs

MyAdvertisementArgs::MyAdvertisementArgs(
  const EncodableList& service_u_u_i_ds_args,
  const EncodableMap& service_data_args,
  const EncodableList& manufacturer_specific_data_args)
 : service_u_u_i_ds_args_(service_u_u_i_ds_args),
    service_data_args_(service_data_args),
    manufacturer_specific_data_args_(manufacturer_specific_data_args) {}

MyAdvertisementArgs::MyAdvertisementArgs(
  const std::string* name_args,
  const EncodableList& service_u_u_i_ds_args,
  const EncodableMap& service_data_args,
  const EncodableList& manufacturer_specific_data_args)
 : name_args_(name_args ? std::optional<std::string>(*name_args) : std::nullopt),
    service_u_u_i_ds_args_(service_u_u_i_ds_args),
    service_data_args_(service_data_args),
    manufacturer_specific_data_args_(manufacturer_specific_data_args) {}

const std::string* MyAdvertisementArgs::name_args() const {
  return name_args_ ? &(*name_args_) : nullptr;
}

void MyAdvertisementArgs::set_name_args(const std::string_view* value_arg) {
  name_args_ = value_arg ? std::optional<std::string>(*value_arg) : std::nullopt;
}

void MyAdvertisementArgs::set_name_args(std::string_view value_arg) {
  name_args_ = value_arg;
}


const EncodableList& MyAdvertisementArgs::service_u_u_i_ds_args() const {
  return service_u_u_i_ds_args_;
}

void MyAdvertisementArgs::set_service_u_u_i_ds_args(const EncodableList& value_arg) {
  service_u_u_i_ds_args_ = value_arg;
}


const EncodableMap& MyAdvertisementArgs::service_data_args() const {
  return service_data_args_;
}

void MyAdvertisementArgs::set_service_data_args(const EncodableMap& value_arg) {
  service_data_args_ = value_arg;
}


const EncodableList& MyAdvertisementArgs::manufacturer_specific_data_args() const {
  return manufacturer_specific_data_args_;
}

void MyAdvertisementArgs::set_manufacturer_specific_data_args(const EncodableList& value_arg) {
  manufacturer_specific_data_args_ = value_arg;
}


EncodableList MyAdvertisementArgs::ToEncodableList() const {
  EncodableList list;
  list.reserve(4);
  list.push_back(name_args_ ? EncodableValue(*name_args_) : EncodableValue());
  list.push_back(EncodableValue(service_u_u_i_ds_args_));
  list.push_back(EncodableValue(service_data_args_));
  list.push_back(EncodableValue(manufacturer_specific_data_args_));
  return list;
}

MyAdvertisementArgs MyAdvertisementArgs::FromEncodableList(const EncodableList& list) {
  MyAdvertisementArgs decoded(
    std::get<EncodableList>(list[1]),
    std::get<EncodableMap>(list[2]),
    std::get<EncodableList>(list[3]));
  auto& encodable_name_args = list[0];
  if (!encodable_name_args.IsNull()) {
    decoded.set_name_args(std::get<std::string>(encodable_name_args));
  }
  return decoded;
}

// MyCentralArgs

MyCentralArgs::MyCentralArgs(int64_t address_args)
 : address_args_(address_args) {}

int64_t MyCentralArgs::address_args() const {
  return address_args_;
}

void MyCentralArgs::set_address_args(int64_t value_arg) {
  address_args_ = value_arg;
}


EncodableList MyCentralArgs::ToEncodableList() const {
  EncodableList list;
  list.reserve(1);
  list.push_back(EncodableValue(address_args_));
  return list;
}

MyCentralArgs MyCentralArgs::FromEncodableList(const EncodableList& list) {
  MyCentralArgs decoded(
    std::get<int64_t>(list[0]));
  return decoded;
}

// MyPeripheralArgs

MyPeripheralArgs::MyPeripheralArgs(int64_t address_args)
 : address_args_(address_args) {}

int64_t MyPeripheralArgs::address_args() const {
  return address_args_;
}

void MyPeripheralArgs::set_address_args(int64_t value_arg) {
  address_args_ = value_arg;
}


EncodableList MyPeripheralArgs::ToEncodableList() const {
  EncodableList list;
  list.reserve(1);
  list.push_back(EncodableValue(address_args_));
  return list;
}

MyPeripheralArgs MyPeripheralArgs::FromEncodableList(const EncodableList& list) {
  MyPeripheralArgs decoded(
    std::get<int64_t>(list[0]));
  return decoded;
}

// MyGATTDescriptorArgs

MyGATTDescriptorArgs::MyGATTDescriptorArgs(
  int64_t handle_args,
  const std::string& uuid_args)
 : handle_args_(handle_args),
    uuid_args_(uuid_args) {}

int64_t MyGATTDescriptorArgs::handle_args() const {
  return handle_args_;
}

void MyGATTDescriptorArgs::set_handle_args(int64_t value_arg) {
  handle_args_ = value_arg;
}


const std::string& MyGATTDescriptorArgs::uuid_args() const {
  return uuid_args_;
}

void MyGATTDescriptorArgs::set_uuid_args(std::string_view value_arg) {
  uuid_args_ = value_arg;
}


EncodableList MyGATTDescriptorArgs::ToEncodableList() const {
  EncodableList list;
  list.reserve(2);
  list.push_back(EncodableValue(handle_args_));
  list.push_back(EncodableValue(uuid_args_));
  return list;
}

MyGATTDescriptorArgs MyGATTDescriptorArgs::FromEncodableList(const EncodableList& list) {
  MyGATTDescriptorArgs decoded(
    std::get<int64_t>(list[0]),
    std::get<std::string>(list[1]));
  return decoded;
}

// MyGATTCharacteristicArgs

MyGATTCharacteristicArgs::MyGATTCharacteristicArgs(
  int64_t handle_args,
  const std::string& uuid_args,
  const EncodableList& property_numbers_args,
  const EncodableList& descriptors_args)
 : handle_args_(handle_args),
    uuid_args_(uuid_args),
    property_numbers_args_(property_numbers_args),
    descriptors_args_(descriptors_args) {}

int64_t MyGATTCharacteristicArgs::handle_args() const {
  return handle_args_;
}

void MyGATTCharacteristicArgs::set_handle_args(int64_t value_arg) {
  handle_args_ = value_arg;
}


const std::string& MyGATTCharacteristicArgs::uuid_args() const {
  return uuid_args_;
}

void MyGATTCharacteristicArgs::set_uuid_args(std::string_view value_arg) {
  uuid_args_ = value_arg;
}


const EncodableList& MyGATTCharacteristicArgs::property_numbers_args() const {
  return property_numbers_args_;
}

void MyGATTCharacteristicArgs::set_property_numbers_args(const EncodableList& value_arg) {
  property_numbers_args_ = value_arg;
}


const EncodableList& MyGATTCharacteristicArgs::descriptors_args() const {
  return descriptors_args_;
}

void MyGATTCharacteristicArgs::set_descriptors_args(const EncodableList& value_arg) {
  descriptors_args_ = value_arg;
}


EncodableList MyGATTCharacteristicArgs::ToEncodableList() const {
  EncodableList list;
  list.reserve(4);
  list.push_back(EncodableValue(handle_args_));
  list.push_back(EncodableValue(uuid_args_));
  list.push_back(EncodableValue(property_numbers_args_));
  list.push_back(EncodableValue(descriptors_args_));
  return list;
}

MyGATTCharacteristicArgs MyGATTCharacteristicArgs::FromEncodableList(const EncodableList& list) {
  MyGATTCharacteristicArgs decoded(
    std::get<int64_t>(list[0]),
    std::get<std::string>(list[1]),
    std::get<EncodableList>(list[2]),
    std::get<EncodableList>(list[3]));
  return decoded;
}

// MyGATTServiceArgs

MyGATTServiceArgs::MyGATTServiceArgs(
  int64_t handle_args,
  const std::string& uuid_args,
  bool is_primary_args,
  const EncodableList& included_services_args,
  const EncodableList& characteristics_args)
 : handle_args_(handle_args),
    uuid_args_(uuid_args),
    is_primary_args_(is_primary_args),
    included_services_args_(included_services_args),
    characteristics_args_(characteristics_args) {}

int64_t MyGATTServiceArgs::handle_args() const {
  return handle_args_;
}

void MyGATTServiceArgs::set_handle_args(int64_t value_arg) {
  handle_args_ = value_arg;
}


const std::string& MyGATTServiceArgs::uuid_args() const {
  return uuid_args_;
}

void MyGATTServiceArgs::set_uuid_args(std::string_view value_arg) {
  uuid_args_ = value_arg;
}


bool MyGATTServiceArgs::is_primary_args() const {
  return is_primary_args_;
}

void MyGATTServiceArgs::set_is_primary_args(bool value_arg) {
  is_primary_args_ = value_arg;
}


const EncodableList& MyGATTServiceArgs::included_services_args() const {
  return included_services_args_;
}

void MyGATTServiceArgs::set_included_services_args(const EncodableList& value_arg) {
  included_services_args_ = value_arg;
}


const EncodableList& MyGATTServiceArgs::characteristics_args() const {
  return characteristics_args_;
}

void MyGATTServiceArgs::set_characteristics_args(const EncodableList& value_arg) {
  characteristics_args_ = value_arg;
}


EncodableList MyGATTServiceArgs::ToEncodableList() const {
  EncodableList list;
  list.reserve(5);
  list.push_back(EncodableValue(handle_args_));
  list.push_back(EncodableValue(uuid_args_));
  list.push_back(EncodableValue(is_primary_args_));
  list.push_back(EncodableValue(included_services_args_));
  list.push_back(EncodableValue(characteristics_args_));
  return list;
}

MyGATTServiceArgs MyGATTServiceArgs::FromEncodableList(const EncodableList& list) {
  MyGATTServiceArgs decoded(
    std::get<int64_t>(list[0]),
    std::get<std::string>(list[1]),
    std::get<bool>(list[2]),
    std::get<EncodableList>(list[3]),
    std::get<EncodableList>(list[4]));
  return decoded;
}

// MyMutableGATTDescriptorArgs

MyMutableGATTDescriptorArgs::MyMutableGATTDescriptorArgs(
  int64_t hash_code_args,
  const std::string& uuid_args)
 : hash_code_args_(hash_code_args),
    uuid_args_(uuid_args) {}

MyMutableGATTDescriptorArgs::MyMutableGATTDescriptorArgs(
  int64_t hash_code_args,
  const std::string& uuid_args,
  const std::vector<uint8_t>* value_args,
  const MyGATTProtectionLevelArgs* read_protection_level_args,
  const MyGATTProtectionLevelArgs* write_protection_level_args)
 : hash_code_args_(hash_code_args),
    uuid_args_(uuid_args),
    value_args_(value_args ? std::optional<std::vector<uint8_t>>(*value_args) : std::nullopt),
    read_protection_level_args_(read_protection_level_args ? std::optional<MyGATTProtectionLevelArgs>(*read_protection_level_args) : std::nullopt),
    write_protection_level_args_(write_protection_level_args ? std::optional<MyGATTProtectionLevelArgs>(*write_protection_level_args) : std::nullopt) {}

int64_t MyMutableGATTDescriptorArgs::hash_code_args() const {
  return hash_code_args_;
}

void MyMutableGATTDescriptorArgs::set_hash_code_args(int64_t value_arg) {
  hash_code_args_ = value_arg;
}


const std::string& MyMutableGATTDescriptorArgs::uuid_args() const {
  return uuid_args_;
}

void MyMutableGATTDescriptorArgs::set_uuid_args(std::string_view value_arg) {
  uuid_args_ = value_arg;
}


const std::vector<uint8_t>* MyMutableGATTDescriptorArgs::value_args() const {
  return value_args_ ? &(*value_args_) : nullptr;
}

void MyMutableGATTDescriptorArgs::set_value_args(const std::vector<uint8_t>* value_arg) {
  value_args_ = value_arg ? std::optional<std::vector<uint8_t>>(*value_arg) : std::nullopt;
}

void MyMutableGATTDescriptorArgs::set_value_args(const std::vector<uint8_t>& value_arg) {
  value_args_ = value_arg;
}


const MyGATTProtectionLevelArgs* MyMutableGATTDescriptorArgs::read_protection_level_args() const {
  return read_protection_level_args_ ? &(*read_protection_level_args_) : nullptr;
}

void MyMutableGATTDescriptorArgs::set_read_protection_level_args(const MyGATTProtectionLevelArgs* value_arg) {
  read_protection_level_args_ = value_arg ? std::optional<MyGATTProtectionLevelArgs>(*value_arg) : std::nullopt;
}

void MyMutableGATTDescriptorArgs::set_read_protection_level_args(const MyGATTProtectionLevelArgs& value_arg) {
  read_protection_level_args_ = value_arg;
}


const MyGATTProtectionLevelArgs* MyMutableGATTDescriptorArgs::write_protection_level_args() const {
  return write_protection_level_args_ ? &(*write_protection_level_args_) : nullptr;
}

void MyMutableGATTDescriptorArgs::set_write_protection_level_args(const MyGATTProtectionLevelArgs* value_arg) {
  write_protection_level_args_ = value_arg ? std::optional<MyGATTProtectionLevelArgs>(*value_arg) : std::nullopt;
}

void MyMutableGATTDescriptorArgs::set_write_protection_level_args(const MyGATTProtectionLevelArgs& value_arg) {
  write_protection_level_args_ = value_arg;
}


EncodableList MyMutableGATTDescriptorArgs::ToEncodableList() const {
  EncodableList list;
  list.reserve(5);
  list.push_back(EncodableValue(hash_code_args_));
  list.push_back(EncodableValue(uuid_args_));
  list.push_back(value_args_ ? EncodableValue(*value_args_) : EncodableValue());
  list.push_back(read_protection_level_args_ ? CustomEncodableValue(*read_protection_level_args_) : EncodableValue());
  list.push_back(write_protection_level_args_ ? CustomEncodableValue(*write_protection_level_args_) : EncodableValue());
  return list;
}

MyMutableGATTDescriptorArgs MyMutableGATTDescriptorArgs::FromEncodableList(const EncodableList& list) {
  MyMutableGATTDescriptorArgs decoded(
    std::get<int64_t>(list[0]),
    std::get<std::string>(list[1]));
  auto& encodable_value_args = list[2];
  if (!encodable_value_args.IsNull()) {
    decoded.set_value_args(std::get<std::vector<uint8_t>>(encodable_value_args));
  }
  auto& encodable_read_protection_level_args = list[3];
  if (!encodable_read_protection_level_args.IsNull()) {
    decoded.set_read_protection_level_args(std::any_cast<const MyGATTProtectionLevelArgs&>(std::get<CustomEncodableValue>(encodable_read_protection_level_args)));
  }
  auto& encodable_write_protection_level_args = list[4];
  if (!encodable_write_protection_level_args.IsNull()) {
    decoded.set_write_protection_level_args(std::any_cast<const MyGATTProtectionLevelArgs&>(std::get<CustomEncodableValue>(encodable_write_protection_level_args)));
  }
  return decoded;
}

// MyMutableGATTCharacteristicArgs

MyMutableGATTCharacteristicArgs::MyMutableGATTCharacteristicArgs(
  int64_t hash_code_args,
  const std::string& uuid_args,
  const EncodableList& property_numbers_args,
  const EncodableList& descriptors_args)
 : hash_code_args_(hash_code_args),
    uuid_args_(uuid_args),
    property_numbers_args_(property_numbers_args),
    descriptors_args_(descriptors_args) {}

MyMutableGATTCharacteristicArgs::MyMutableGATTCharacteristicArgs(
  int64_t hash_code_args,
  const std::string& uuid_args,
  const std::vector<uint8_t>* value_args,
  const EncodableList& property_numbers_args,
  const MyGATTProtectionLevelArgs* read_protection_level_args,
  const MyGATTProtectionLevelArgs* write_protection_level_args,
  const EncodableList& descriptors_args)
 : hash_code_args_(hash_code_args),
    uuid_args_(uuid_args),
    value_args_(value_args ? std::optional<std::vector<uint8_t>>(*value_args) : std::nullopt),
    property_numbers_args_(property_numbers_args),
    read_protection_level_args_(read_protection_level_args ? std::optional<MyGATTProtectionLevelArgs>(*read_protection_level_args) : std::nullopt),
    write_protection_level_args_(write_protection_level_args ? std::optional<MyGATTProtectionLevelArgs>(*write_protection_level_args) : std::nullopt),
    descriptors_args_(descriptors_args) {}

int64_t MyMutableGATTCharacteristicArgs::hash_code_args() const {
  return hash_code_args_;
}

void MyMutableGATTCharacteristicArgs::set_hash_code_args(int64_t value_arg) {
  hash_code_args_ = value_arg;
}


const std::string& MyMutableGATTCharacteristicArgs::uuid_args() const {
  return uuid_args_;
}

void MyMutableGATTCharacteristicArgs::set_uuid_args(std::string_view value_arg) {
  uuid_args_ = value_arg;
}


const std::vector<uint8_t>* MyMutableGATTCharacteristicArgs::value_args() const {
  return value_args_ ? &(*value_args_) : nullptr;
}

void MyMutableGATTCharacteristicArgs::set_value_args(const std::vector<uint8_t>* value_arg) {
  value_args_ = value_arg ? std::optional<std::vector<uint8_t>>(*value_arg) : std::nullopt;
}

void MyMutableGATTCharacteristicArgs::set_value_args(const std::vector<uint8_t>& value_arg) {
  value_args_ = value_arg;
}


const EncodableList& MyMutableGATTCharacteristicArgs::property_numbers_args() const {
  return property_numbers_args_;
}

void MyMutableGATTCharacteristicArgs::set_property_numbers_args(const EncodableList& value_arg) {
  property_numbers_args_ = value_arg;
}


const MyGATTProtectionLevelArgs* MyMutableGATTCharacteristicArgs::read_protection_level_args() const {
  return read_protection_level_args_ ? &(*read_protection_level_args_) : nullptr;
}

void MyMutableGATTCharacteristicArgs::set_read_protection_level_args(const MyGATTProtectionLevelArgs* value_arg) {
  read_protection_level_args_ = value_arg ? std::optional<MyGATTProtectionLevelArgs>(*value_arg) : std::nullopt;
}

void MyMutableGATTCharacteristicArgs::set_read_protection_level_args(const MyGATTProtectionLevelArgs& value_arg) {
  read_protection_level_args_ = value_arg;
}


const MyGATTProtectionLevelArgs* MyMutableGATTCharacteristicArgs::write_protection_level_args() const {
  return write_protection_level_args_ ? &(*write_protection_level_args_) : nullptr;
}

void MyMutableGATTCharacteristicArgs::set_write_protection_level_args(const MyGATTProtectionLevelArgs* value_arg) {
  write_protection_level_args_ = value_arg ? std::optional<MyGATTProtectionLevelArgs>(*value_arg) : std::nullopt;
}

void MyMutableGATTCharacteristicArgs::set_write_protection_level_args(const MyGATTProtectionLevelArgs& value_arg) {
  write_protection_level_args_ = value_arg;
}


const EncodableList& MyMutableGATTCharacteristicArgs::descriptors_args() const {
  return descriptors_args_;
}

void MyMutableGATTCharacteristicArgs::set_descriptors_args(const EncodableList& value_arg) {
  descriptors_args_ = value_arg;
}


EncodableList MyMutableGATTCharacteristicArgs::ToEncodableList() const {
  EncodableList list;
  list.reserve(7);
  list.push_back(EncodableValue(hash_code_args_));
  list.push_back(EncodableValue(uuid_args_));
  list.push_back(value_args_ ? EncodableValue(*value_args_) : EncodableValue());
  list.push_back(EncodableValue(property_numbers_args_));
  list.push_back(read_protection_level_args_ ? CustomEncodableValue(*read_protection_level_args_) : EncodableValue());
  list.push_back(write_protection_level_args_ ? CustomEncodableValue(*write_protection_level_args_) : EncodableValue());
  list.push_back(EncodableValue(descriptors_args_));
  return list;
}

MyMutableGATTCharacteristicArgs MyMutableGATTCharacteristicArgs::FromEncodableList(const EncodableList& list) {
  MyMutableGATTCharacteristicArgs decoded(
    std::get<int64_t>(list[0]),
    std::get<std::string>(list[1]),
    std::get<EncodableList>(list[3]),
    std::get<EncodableList>(list[6]));
  auto& encodable_value_args = list[2];
  if (!encodable_value_args.IsNull()) {
    decoded.set_value_args(std::get<std::vector<uint8_t>>(encodable_value_args));
  }
  auto& encodable_read_protection_level_args = list[4];
  if (!encodable_read_protection_level_args.IsNull()) {
    decoded.set_read_protection_level_args(std::any_cast<const MyGATTProtectionLevelArgs&>(std::get<CustomEncodableValue>(encodable_read_protection_level_args)));
  }
  auto& encodable_write_protection_level_args = list[5];
  if (!encodable_write_protection_level_args.IsNull()) {
    decoded.set_write_protection_level_args(std::any_cast<const MyGATTProtectionLevelArgs&>(std::get<CustomEncodableValue>(encodable_write_protection_level_args)));
  }
  return decoded;
}

// MyMutableGATTServiceArgs

MyMutableGATTServiceArgs::MyMutableGATTServiceArgs(
  int64_t hash_code_args,
  const std::string& uuid_args,
  bool is_primary_args,
  const EncodableList& included_services_args,
  const EncodableList& characteristics_args)
 : hash_code_args_(hash_code_args),
    uuid_args_(uuid_args),
    is_primary_args_(is_primary_args),
    included_services_args_(included_services_args),
    characteristics_args_(characteristics_args) {}

int64_t MyMutableGATTServiceArgs::hash_code_args() const {
  return hash_code_args_;
}

void MyMutableGATTServiceArgs::set_hash_code_args(int64_t value_arg) {
  hash_code_args_ = value_arg;
}


const std::string& MyMutableGATTServiceArgs::uuid_args() const {
  return uuid_args_;
}

void MyMutableGATTServiceArgs::set_uuid_args(std::string_view value_arg) {
  uuid_args_ = value_arg;
}


bool MyMutableGATTServiceArgs::is_primary_args() const {
  return is_primary_args_;
}

void MyMutableGATTServiceArgs::set_is_primary_args(bool value_arg) {
  is_primary_args_ = value_arg;
}


const EncodableList& MyMutableGATTServiceArgs::included_services_args() const {
  return included_services_args_;
}

void MyMutableGATTServiceArgs::set_included_services_args(const EncodableList& value_arg) {
  included_services_args_ = value_arg;
}


const EncodableList& MyMutableGATTServiceArgs::characteristics_args() const {
  return characteristics_args_;
}

void MyMutableGATTServiceArgs::set_characteristics_args(const EncodableList& value_arg) {
  characteristics_args_ = value_arg;
}


EncodableList MyMutableGATTServiceArgs::ToEncodableList() const {
  EncodableList list;
  list.reserve(5);
  list.push_back(EncodableValue(hash_code_args_));
  list.push_back(EncodableValue(uuid_args_));
  list.push_back(EncodableValue(is_primary_args_));
  list.push_back(EncodableValue(included_services_args_));
  list.push_back(EncodableValue(characteristics_args_));
  return list;
}

MyMutableGATTServiceArgs MyMutableGATTServiceArgs::FromEncodableList(const EncodableList& list) {
  MyMutableGATTServiceArgs decoded(
    std::get<int64_t>(list[0]),
    std::get<std::string>(list[1]),
    std::get<bool>(list[2]),
    std::get<EncodableList>(list[3]),
    std::get<EncodableList>(list[4]));
  return decoded;
}

// MyGATTReadRequestArgs

MyGATTReadRequestArgs::MyGATTReadRequestArgs(
  int64_t id_args,
  int64_t offset_args,
  int64_t length_args)
 : id_args_(id_args),
    offset_args_(offset_args),
    length_args_(length_args) {}

int64_t MyGATTReadRequestArgs::id_args() const {
  return id_args_;
}

void MyGATTReadRequestArgs::set_id_args(int64_t value_arg) {
  id_args_ = value_arg;
}


int64_t MyGATTReadRequestArgs::offset_args() const {
  return offset_args_;
}

void MyGATTReadRequestArgs::set_offset_args(int64_t value_arg) {
  offset_args_ = value_arg;
}


int64_t MyGATTReadRequestArgs::length_args() const {
  return length_args_;
}

void MyGATTReadRequestArgs::set_length_args(int64_t value_arg) {
  length_args_ = value_arg;
}


EncodableList MyGATTReadRequestArgs::ToEncodableList() const {
  EncodableList list;
  list.reserve(3);
  list.push_back(EncodableValue(id_args_));
  list.push_back(EncodableValue(offset_args_));
  list.push_back(EncodableValue(length_args_));
  return list;
}

MyGATTReadRequestArgs MyGATTReadRequestArgs::FromEncodableList(const EncodableList& list) {
  MyGATTReadRequestArgs decoded(
    std::get<int64_t>(list[0]),
    std::get<int64_t>(list[1]),
    std::get<int64_t>(list[2]));
  return decoded;
}

// MyGATTWriteRequestArgs

MyGATTWriteRequestArgs::MyGATTWriteRequestArgs(
  int64_t id_args,
  int64_t offset_args,
  const std::vector<uint8_t>& value_args,
  const MyGATTCharacteristicWriteTypeArgs& type_args)
 : id_args_(id_args),
    offset_args_(offset_args),
    value_args_(value_args),
    type_args_(type_args) {}

int64_t MyGATTWriteRequestArgs::id_args() const {
  return id_args_;
}

void MyGATTWriteRequestArgs::set_id_args(int64_t value_arg) {
  id_args_ = value_arg;
}


int64_t MyGATTWriteRequestArgs::offset_args() const {
  return offset_args_;
}

void MyGATTWriteRequestArgs::set_offset_args(int64_t value_arg) {
  offset_args_ = value_arg;
}


const std::vector<uint8_t>& MyGATTWriteRequestArgs::value_args() const {
  return value_args_;
}

void MyGATTWriteRequestArgs::set_value_args(const std::vector<uint8_t>& value_arg) {
  value_args_ = value_arg;
}


const MyGATTCharacteristicWriteTypeArgs& MyGATTWriteRequestArgs::type_args() const {
  return type_args_;
}

void MyGATTWriteRequestArgs::set_type_args(const MyGATTCharacteristicWriteTypeArgs& value_arg) {
  type_args_ = value_arg;
}


EncodableList MyGATTWriteRequestArgs::ToEncodableList() const {
  EncodableList list;
  list.reserve(4);
  list.push_back(EncodableValue(id_args_));
  list.push_back(EncodableValue(offset_args_));
  list.push_back(EncodableValue(value_args_));
  list.push_back(CustomEncodableValue(type_args_));
  return list;
}

MyGATTWriteRequestArgs MyGATTWriteRequestArgs::FromEncodableList(const EncodableList& list) {
  MyGATTWriteRequestArgs decoded(
    std::get<int64_t>(list[0]),
    std::get<int64_t>(list[1]),
    std::get<std::vector<uint8_t>>(list[2]),
    std::any_cast<const MyGATTCharacteristicWriteTypeArgs&>(std::get<CustomEncodableValue>(list[3])));
  return decoded;
}


PigeonInternalCodecSerializer::PigeonInternalCodecSerializer() {}

EncodableValue PigeonInternalCodecSerializer::ReadValueOfType(
  uint8_t type,
  flutter::ByteStreamReader* stream) const {
  switch (type) {
    case 129: {
        const auto& encodable_enum_arg = ReadValue(stream);
        const int64_t enum_arg_value = encodable_enum_arg.IsNull() ? 0 : encodable_enum_arg.LongValue();
        return encodable_enum_arg.IsNull() ? EncodableValue() : CustomEncodableValue(static_cast<MyBluetoothLowEnergyStateArgs>(enum_arg_value));
      }
    case 130: {
        const auto& encodable_enum_arg = ReadValue(stream);
        const int64_t enum_arg_value = encodable_enum_arg.IsNull() ? 0 : encodable_enum_arg.LongValue();
        return encodable_enum_arg.IsNull() ? EncodableValue() : CustomEncodableValue(static_cast<MyAdvertisementTypeArgs>(enum_arg_value));
      }
    case 131: {
        const auto& encodable_enum_arg = ReadValue(stream);
        const int64_t enum_arg_value = encodable_enum_arg.IsNull() ? 0 : encodable_enum_arg.LongValue();
        return encodable_enum_arg.IsNull() ? EncodableValue() : CustomEncodableValue(static_cast<MyConnectionStateArgs>(enum_arg_value));
      }
    case 132: {
        const auto& encodable_enum_arg = ReadValue(stream);
        const int64_t enum_arg_value = encodable_enum_arg.IsNull() ? 0 : encodable_enum_arg.LongValue();
        return encodable_enum_arg.IsNull() ? EncodableValue() : CustomEncodableValue(static_cast<MyGATTCharacteristicPropertyArgs>(enum_arg_value));
      }
    case 133: {
        const auto& encodable_enum_arg = ReadValue(stream);
        const int64_t enum_arg_value = encodable_enum_arg.IsNull() ? 0 : encodable_enum_arg.LongValue();
        return encodable_enum_arg.IsNull() ? EncodableValue() : CustomEncodableValue(static_cast<MyGATTCharacteristicWriteTypeArgs>(enum_arg_value));
      }
    case 134: {
        const auto& encodable_enum_arg = ReadValue(stream);
        const int64_t enum_arg_value = encodable_enum_arg.IsNull() ? 0 : encodable_enum_arg.LongValue();
        return encodable_enum_arg.IsNull() ? EncodableValue() : CustomEncodableValue(static_cast<MyGATTCharacteristicNotifyStateArgs>(enum_arg_value));
      }
    case 135: {
        const auto& encodable_enum_arg = ReadValue(stream);
        const int64_t enum_arg_value = encodable_enum_arg.IsNull() ? 0 : encodable_enum_arg.LongValue();
        return encodable_enum_arg.IsNull() ? EncodableValue() : CustomEncodableValue(static_cast<MyGATTProtectionLevelArgs>(enum_arg_value));
      }
    case 136: {
        const auto& encodable_enum_arg = ReadValue(stream);
        const int64_t enum_arg_value = encodable_enum_arg.IsNull() ? 0 : encodable_enum_arg.LongValue();
        return encodable_enum_arg.IsNull() ? EncodableValue() : CustomEncodableValue(static_cast<MyGATTProtocolErrorArgs>(enum_arg_value));
      }
    case 137: {
        const auto& encodable_enum_arg = ReadValue(stream);
        const int64_t enum_arg_value = encodable_enum_arg.IsNull() ? 0 : encodable_enum_arg.LongValue();
        return encodable_enum_arg.IsNull() ? EncodableValue() : CustomEncodableValue(static_cast<MyCacheModeArgs>(enum_arg_value));
      }
    case 138: {
        return CustomEncodableValue(MyManufacturerSpecificDataArgs::FromEncodableList(std::get<EncodableList>(ReadValue(stream))));
      }
    case 139: {
        return CustomEncodableValue(MyAdvertisementArgs::FromEncodableList(std::get<EncodableList>(ReadValue(stream))));
      }
    case 140: {
        return CustomEncodableValue(MyCentralArgs::FromEncodableList(std::get<EncodableList>(ReadValue(stream))));
      }
    case 141: {
        return CustomEncodableValue(MyPeripheralArgs::FromEncodableList(std::get<EncodableList>(ReadValue(stream))));
      }
    case 142: {
        return CustomEncodableValue(MyGATTDescriptorArgs::FromEncodableList(std::get<EncodableList>(ReadValue(stream))));
      }
    case 143: {
        return CustomEncodableValue(MyGATTCharacteristicArgs::FromEncodableList(std::get<EncodableList>(ReadValue(stream))));
      }
    case 144: {
        return CustomEncodableValue(MyGATTServiceArgs::FromEncodableList(std::get<EncodableList>(ReadValue(stream))));
      }
    case 145: {
        return CustomEncodableValue(MyMutableGATTDescriptorArgs::FromEncodableList(std::get<EncodableList>(ReadValue(stream))));
      }
    case 146: {
        return CustomEncodableValue(MyMutableGATTCharacteristicArgs::FromEncodableList(std::get<EncodableList>(ReadValue(stream))));
      }
    case 147: {
        return CustomEncodableValue(MyMutableGATTServiceArgs::FromEncodableList(std::get<EncodableList>(ReadValue(stream))));
      }
    case 148: {
        return CustomEncodableValue(MyGATTReadRequestArgs::FromEncodableList(std::get<EncodableList>(ReadValue(stream))));
      }
    case 149: {
        return CustomEncodableValue(MyGATTWriteRequestArgs::FromEncodableList(std::get<EncodableList>(ReadValue(stream))));
      }
    default:
      return flutter::StandardCodecSerializer::ReadValueOfType(type, stream);
    }
}

void PigeonInternalCodecSerializer::WriteValue(
  const EncodableValue& value,
  flutter::ByteStreamWriter* stream) const {
  if (const CustomEncodableValue* custom_value = std::get_if<CustomEncodableValue>(&value)) {
    if (custom_value->type() == typeid(MyBluetoothLowEnergyStateArgs)) {
      stream->WriteByte(129);
      WriteValue(EncodableValue(static_cast<int>(std::any_cast<MyBluetoothLowEnergyStateArgs>(*custom_value))), stream);
      return;
    }
    if (custom_value->type() == typeid(MyAdvertisementTypeArgs)) {
      stream->WriteByte(130);
      WriteValue(EncodableValue(static_cast<int>(std::any_cast<MyAdvertisementTypeArgs>(*custom_value))), stream);
      return;
    }
    if (custom_value->type() == typeid(MyConnectionStateArgs)) {
      stream->WriteByte(131);
      WriteValue(EncodableValue(static_cast<int>(std::any_cast<MyConnectionStateArgs>(*custom_value))), stream);
      return;
    }
    if (custom_value->type() == typeid(MyGATTCharacteristicPropertyArgs)) {
      stream->WriteByte(132);
      WriteValue(EncodableValue(static_cast<int>(std::any_cast<MyGATTCharacteristicPropertyArgs>(*custom_value))), stream);
      return;
    }
    if (custom_value->type() == typeid(MyGATTCharacteristicWriteTypeArgs)) {
      stream->WriteByte(133);
      WriteValue(EncodableValue(static_cast<int>(std::any_cast<MyGATTCharacteristicWriteTypeArgs>(*custom_value))), stream);
      return;
    }
    if (custom_value->type() == typeid(MyGATTCharacteristicNotifyStateArgs)) {
      stream->WriteByte(134);
      WriteValue(EncodableValue(static_cast<int>(std::any_cast<MyGATTCharacteristicNotifyStateArgs>(*custom_value))), stream);
      return;
    }
    if (custom_value->type() == typeid(MyGATTProtectionLevelArgs)) {
      stream->WriteByte(135);
      WriteValue(EncodableValue(static_cast<int>(std::any_cast<MyGATTProtectionLevelArgs>(*custom_value))), stream);
      return;
    }
    if (custom_value->type() == typeid(MyGATTProtocolErrorArgs)) {
      stream->WriteByte(136);
      WriteValue(EncodableValue(static_cast<int>(std::any_cast<MyGATTProtocolErrorArgs>(*custom_value))), stream);
      return;
    }
    if (custom_value->type() == typeid(MyCacheModeArgs)) {
      stream->WriteByte(137);
      WriteValue(EncodableValue(static_cast<int>(std::any_cast<MyCacheModeArgs>(*custom_value))), stream);
      return;
    }
    if (custom_value->type() == typeid(MyManufacturerSpecificDataArgs)) {
      stream->WriteByte(138);
      WriteValue(EncodableValue(std::any_cast<MyManufacturerSpecificDataArgs>(*custom_value).ToEncodableList()), stream);
      return;
    }
    if (custom_value->type() == typeid(MyAdvertisementArgs)) {
      stream->WriteByte(139);
      WriteValue(EncodableValue(std::any_cast<MyAdvertisementArgs>(*custom_value).ToEncodableList()), stream);
      return;
    }
    if (custom_value->type() == typeid(MyCentralArgs)) {
      stream->WriteByte(140);
      WriteValue(EncodableValue(std::any_cast<MyCentralArgs>(*custom_value).ToEncodableList()), stream);
      return;
    }
    if (custom_value->type() == typeid(MyPeripheralArgs)) {
      stream->WriteByte(141);
      WriteValue(EncodableValue(std::any_cast<MyPeripheralArgs>(*custom_value).ToEncodableList()), stream);
      return;
    }
    if (custom_value->type() == typeid(MyGATTDescriptorArgs)) {
      stream->WriteByte(142);
      WriteValue(EncodableValue(std::any_cast<MyGATTDescriptorArgs>(*custom_value).ToEncodableList()), stream);
      return;
    }
    if (custom_value->type() == typeid(MyGATTCharacteristicArgs)) {
      stream->WriteByte(143);
      WriteValue(EncodableValue(std::any_cast<MyGATTCharacteristicArgs>(*custom_value).ToEncodableList()), stream);
      return;
    }
    if (custom_value->type() == typeid(MyGATTServiceArgs)) {
      stream->WriteByte(144);
      WriteValue(EncodableValue(std::any_cast<MyGATTServiceArgs>(*custom_value).ToEncodableList()), stream);
      return;
    }
    if (custom_value->type() == typeid(MyMutableGATTDescriptorArgs)) {
      stream->WriteByte(145);
      WriteValue(EncodableValue(std::any_cast<MyMutableGATTDescriptorArgs>(*custom_value).ToEncodableList()), stream);
      return;
    }
    if (custom_value->type() == typeid(MyMutableGATTCharacteristicArgs)) {
      stream->WriteByte(146);
      WriteValue(EncodableValue(std::any_cast<MyMutableGATTCharacteristicArgs>(*custom_value).ToEncodableList()), stream);
      return;
    }
    if (custom_value->type() == typeid(MyMutableGATTServiceArgs)) {
      stream->WriteByte(147);
      WriteValue(EncodableValue(std::any_cast<MyMutableGATTServiceArgs>(*custom_value).ToEncodableList()), stream);
      return;
    }
    if (custom_value->type() == typeid(MyGATTReadRequestArgs)) {
      stream->WriteByte(148);
      WriteValue(EncodableValue(std::any_cast<MyGATTReadRequestArgs>(*custom_value).ToEncodableList()), stream);
      return;
    }
    if (custom_value->type() == typeid(MyGATTWriteRequestArgs)) {
      stream->WriteByte(149);
      WriteValue(EncodableValue(std::any_cast<MyGATTWriteRequestArgs>(*custom_value).ToEncodableList()), stream);
      return;
    }
  }
  flutter::StandardCodecSerializer::WriteValue(value, stream);
}

/// The codec used by MyCentralManagerHostAPI.
const flutter::StandardMessageCodec& MyCentralManagerHostAPI::GetCodec() {
  return flutter::StandardMessageCodec::GetInstance(&PigeonInternalCodecSerializer::GetInstance());
}

// Sets up an instance of `MyCentralManagerHostAPI` to handle messages through the `binary_messenger`.
void MyCentralManagerHostAPI::SetUp(
  flutter::BinaryMessenger* binary_messenger,
  MyCentralManagerHostAPI* api) {
  MyCentralManagerHostAPI::SetUp(binary_messenger, api, "");
}

void MyCentralManagerHostAPI::SetUp(
  flutter::BinaryMessenger* binary_messenger,
  MyCentralManagerHostAPI* api,
  const std::string& message_channel_suffix) {
  const std::string prepended_suffix = message_channel_suffix.length() > 0 ? std::string(".") + message_channel_suffix : "";
  {
    BasicMessageChannel<> channel(binary_messenger, "dev.flutter.pigeon.bluetooth_low_energy_windows.MyCentralManagerHostAPI.initialize" + prepended_suffix, &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler([api](const EncodableValue& message, const flutter::MessageReply<EncodableValue>& reply) {
        try {
          api->Initialize([reply](std::optional<FlutterError>&& output) {
            if (output.has_value()) {
              reply(WrapError(output.value()));
              return;
            }
            EncodableList wrapped;
            wrapped.push_back(EncodableValue());
            reply(EncodableValue(std::move(wrapped)));
          });
        } catch (const std::exception& exception) {
          reply(WrapError(exception.what()));
        }
      });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger, "dev.flutter.pigeon.bluetooth_low_energy_windows.MyCentralManagerHostAPI.getState" + prepended_suffix, &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler([api](const EncodableValue& message, const flutter::MessageReply<EncodableValue>& reply) {
        try {
          ErrorOr<MyBluetoothLowEnergyStateArgs> output = api->GetState();
          if (output.has_error()) {
            reply(WrapError(output.error()));
            return;
          }
          EncodableList wrapped;
          wrapped.push_back(CustomEncodableValue(std::move(output).TakeValue()));
          reply(EncodableValue(std::move(wrapped)));
        } catch (const std::exception& exception) {
          reply(WrapError(exception.what()));
        }
      });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger, "dev.flutter.pigeon.bluetooth_low_energy_windows.MyCentralManagerHostAPI.startDiscovery" + prepended_suffix, &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler([api](const EncodableValue& message, const flutter::MessageReply<EncodableValue>& reply) {
        try {
          const auto& args = std::get<EncodableList>(message);
          const auto& encodable_service_u_u_i_ds_args_arg = args.at(0);
          if (encodable_service_u_u_i_ds_args_arg.IsNull()) {
            reply(WrapError("service_u_u_i_ds_args_arg unexpectedly null."));
            return;
          }
          const auto& service_u_u_i_ds_args_arg = std::get<EncodableList>(encodable_service_u_u_i_ds_args_arg);
          std::optional<FlutterError> output = api->StartDiscovery(service_u_u_i_ds_args_arg);
          if (output.has_value()) {
            reply(WrapError(output.value()));
            return;
          }
          EncodableList wrapped;
          wrapped.push_back(EncodableValue());
          reply(EncodableValue(std::move(wrapped)));
        } catch (const std::exception& exception) {
          reply(WrapError(exception.what()));
        }
      });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger, "dev.flutter.pigeon.bluetooth_low_energy_windows.MyCentralManagerHostAPI.stopDiscovery" + prepended_suffix, &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler([api](const EncodableValue& message, const flutter::MessageReply<EncodableValue>& reply) {
        try {
          std::optional<FlutterError> output = api->StopDiscovery();
          if (output.has_value()) {
            reply(WrapError(output.value()));
            return;
          }
          EncodableList wrapped;
          wrapped.push_back(EncodableValue());
          reply(EncodableValue(std::move(wrapped)));
        } catch (const std::exception& exception) {
          reply(WrapError(exception.what()));
        }
      });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger, "dev.flutter.pigeon.bluetooth_low_energy_windows.MyCentralManagerHostAPI.connect" + prepended_suffix, &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler([api](const EncodableValue& message, const flutter::MessageReply<EncodableValue>& reply) {
        try {
          const auto& args = std::get<EncodableList>(message);
          const auto& encodable_address_args_arg = args.at(0);
          if (encodable_address_args_arg.IsNull()) {
            reply(WrapError("address_args_arg unexpectedly null."));
            return;
          }
          const int64_t address_args_arg = encodable_address_args_arg.LongValue();
          api->Connect(address_args_arg, [reply](std::optional<FlutterError>&& output) {
            if (output.has_value()) {
              reply(WrapError(output.value()));
              return;
            }
            EncodableList wrapped;
            wrapped.push_back(EncodableValue());
            reply(EncodableValue(std::move(wrapped)));
          });
        } catch (const std::exception& exception) {
          reply(WrapError(exception.what()));
        }
      });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger, "dev.flutter.pigeon.bluetooth_low_energy_windows.MyCentralManagerHostAPI.disconnect" + prepended_suffix, &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler([api](const EncodableValue& message, const flutter::MessageReply<EncodableValue>& reply) {
        try {
          const auto& args = std::get<EncodableList>(message);
          const auto& encodable_address_args_arg = args.at(0);
          if (encodable_address_args_arg.IsNull()) {
            reply(WrapError("address_args_arg unexpectedly null."));
            return;
          }
          const int64_t address_args_arg = encodable_address_args_arg.LongValue();
          std::optional<FlutterError> output = api->Disconnect(address_args_arg);
          if (output.has_value()) {
            reply(WrapError(output.value()));
            return;
          }
          EncodableList wrapped;
          wrapped.push_back(EncodableValue());
          reply(EncodableValue(std::move(wrapped)));
        } catch (const std::exception& exception) {
          reply(WrapError(exception.what()));
        }
      });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger, "dev.flutter.pigeon.bluetooth_low_energy_windows.MyCentralManagerHostAPI.getMTU" + prepended_suffix, &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler([api](const EncodableValue& message, const flutter::MessageReply<EncodableValue>& reply) {
        try {
          const auto& args = std::get<EncodableList>(message);
          const auto& encodable_address_args_arg = args.at(0);
          if (encodable_address_args_arg.IsNull()) {
            reply(WrapError("address_args_arg unexpectedly null."));
            return;
          }
          const int64_t address_args_arg = encodable_address_args_arg.LongValue();
          ErrorOr<int64_t> output = api->GetMTU(address_args_arg);
          if (output.has_error()) {
            reply(WrapError(output.error()));
            return;
          }
          EncodableList wrapped;
          wrapped.push_back(EncodableValue(std::move(output).TakeValue()));
          reply(EncodableValue(std::move(wrapped)));
        } catch (const std::exception& exception) {
          reply(WrapError(exception.what()));
        }
      });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger, "dev.flutter.pigeon.bluetooth_low_energy_windows.MyCentralManagerHostAPI.getServices" + prepended_suffix, &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler([api](const EncodableValue& message, const flutter::MessageReply<EncodableValue>& reply) {
        try {
          const auto& args = std::get<EncodableList>(message);
          const auto& encodable_address_args_arg = args.at(0);
          if (encodable_address_args_arg.IsNull()) {
            reply(WrapError("address_args_arg unexpectedly null."));
            return;
          }
          const int64_t address_args_arg = encodable_address_args_arg.LongValue();
          const auto& encodable_mode_args_arg = args.at(1);
          if (encodable_mode_args_arg.IsNull()) {
            reply(WrapError("mode_args_arg unexpectedly null."));
            return;
          }
          const auto& mode_args_arg = std::any_cast<const MyCacheModeArgs&>(std::get<CustomEncodableValue>(encodable_mode_args_arg));
          api->GetServices(address_args_arg, mode_args_arg, [reply](ErrorOr<EncodableList>&& output) {
            if (output.has_error()) {
              reply(WrapError(output.error()));
              return;
            }
            EncodableList wrapped;
            wrapped.push_back(EncodableValue(std::move(output).TakeValue()));
            reply(EncodableValue(std::move(wrapped)));
          });
        } catch (const std::exception& exception) {
          reply(WrapError(exception.what()));
        }
      });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger, "dev.flutter.pigeon.bluetooth_low_energy_windows.MyCentralManagerHostAPI.getIncludedServices" + prepended_suffix, &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler([api](const EncodableValue& message, const flutter::MessageReply<EncodableValue>& reply) {
        try {
          const auto& args = std::get<EncodableList>(message);
          const auto& encodable_address_args_arg = args.at(0);
          if (encodable_address_args_arg.IsNull()) {
            reply(WrapError("address_args_arg unexpectedly null."));
            return;
          }
          const int64_t address_args_arg = encodable_address_args_arg.LongValue();
          const auto& encodable_handle_args_arg = args.at(1);
          if (encodable_handle_args_arg.IsNull()) {
            reply(WrapError("handle_args_arg unexpectedly null."));
            return;
          }
          const int64_t handle_args_arg = encodable_handle_args_arg.LongValue();
          const auto& encodable_mode_args_arg = args.at(2);
          if (encodable_mode_args_arg.IsNull()) {
            reply(WrapError("mode_args_arg unexpectedly null."));
            return;
          }
          const auto& mode_args_arg = std::any_cast<const MyCacheModeArgs&>(std::get<CustomEncodableValue>(encodable_mode_args_arg));
          api->GetIncludedServices(address_args_arg, handle_args_arg, mode_args_arg, [reply](ErrorOr<EncodableList>&& output) {
            if (output.has_error()) {
              reply(WrapError(output.error()));
              return;
            }
            EncodableList wrapped;
            wrapped.push_back(EncodableValue(std::move(output).TakeValue()));
            reply(EncodableValue(std::move(wrapped)));
          });
        } catch (const std::exception& exception) {
          reply(WrapError(exception.what()));
        }
      });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger, "dev.flutter.pigeon.bluetooth_low_energy_windows.MyCentralManagerHostAPI.getCharacteristics" + prepended_suffix, &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler([api](const EncodableValue& message, const flutter::MessageReply<EncodableValue>& reply) {
        try {
          const auto& args = std::get<EncodableList>(message);
          const auto& encodable_address_args_arg = args.at(0);
          if (encodable_address_args_arg.IsNull()) {
            reply(WrapError("address_args_arg unexpectedly null."));
            return;
          }
          const int64_t address_args_arg = encodable_address_args_arg.LongValue();
          const auto& encodable_handle_args_arg = args.at(1);
          if (encodable_handle_args_arg.IsNull()) {
            reply(WrapError("handle_args_arg unexpectedly null."));
            return;
          }
          const int64_t handle_args_arg = encodable_handle_args_arg.LongValue();
          const auto& encodable_mode_args_arg = args.at(2);
          if (encodable_mode_args_arg.IsNull()) {
            reply(WrapError("mode_args_arg unexpectedly null."));
            return;
          }
          const auto& mode_args_arg = std::any_cast<const MyCacheModeArgs&>(std::get<CustomEncodableValue>(encodable_mode_args_arg));
          api->GetCharacteristics(address_args_arg, handle_args_arg, mode_args_arg, [reply](ErrorOr<EncodableList>&& output) {
            if (output.has_error()) {
              reply(WrapError(output.error()));
              return;
            }
            EncodableList wrapped;
            wrapped.push_back(EncodableValue(std::move(output).TakeValue()));
            reply(EncodableValue(std::move(wrapped)));
          });
        } catch (const std::exception& exception) {
          reply(WrapError(exception.what()));
        }
      });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger, "dev.flutter.pigeon.bluetooth_low_energy_windows.MyCentralManagerHostAPI.getDescriptors" + prepended_suffix, &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler([api](const EncodableValue& message, const flutter::MessageReply<EncodableValue>& reply) {
        try {
          const auto& args = std::get<EncodableList>(message);
          const auto& encodable_address_args_arg = args.at(0);
          if (encodable_address_args_arg.IsNull()) {
            reply(WrapError("address_args_arg unexpectedly null."));
            return;
          }
          const int64_t address_args_arg = encodable_address_args_arg.LongValue();
          const auto& encodable_handle_args_arg = args.at(1);
          if (encodable_handle_args_arg.IsNull()) {
            reply(WrapError("handle_args_arg unexpectedly null."));
            return;
          }
          const int64_t handle_args_arg = encodable_handle_args_arg.LongValue();
          const auto& encodable_mode_args_arg = args.at(2);
          if (encodable_mode_args_arg.IsNull()) {
            reply(WrapError("mode_args_arg unexpectedly null."));
            return;
          }
          const auto& mode_args_arg = std::any_cast<const MyCacheModeArgs&>(std::get<CustomEncodableValue>(encodable_mode_args_arg));
          api->GetDescriptors(address_args_arg, handle_args_arg, mode_args_arg, [reply](ErrorOr<EncodableList>&& output) {
            if (output.has_error()) {
              reply(WrapError(output.error()));
              return;
            }
            EncodableList wrapped;
            wrapped.push_back(EncodableValue(std::move(output).TakeValue()));
            reply(EncodableValue(std::move(wrapped)));
          });
        } catch (const std::exception& exception) {
          reply(WrapError(exception.what()));
        }
      });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger, "dev.flutter.pigeon.bluetooth_low_energy_windows.MyCentralManagerHostAPI.readCharacteristic" + prepended_suffix, &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler([api](const EncodableValue& message, const flutter::MessageReply<EncodableValue>& reply) {
        try {
          const auto& args = std::get<EncodableList>(message);
          const auto& encodable_address_args_arg = args.at(0);
          if (encodable_address_args_arg.IsNull()) {
            reply(WrapError("address_args_arg unexpectedly null."));
            return;
          }
          const int64_t address_args_arg = encodable_address_args_arg.LongValue();
          const auto& encodable_handle_args_arg = args.at(1);
          if (encodable_handle_args_arg.IsNull()) {
            reply(WrapError("handle_args_arg unexpectedly null."));
            return;
          }
          const int64_t handle_args_arg = encodable_handle_args_arg.LongValue();
          const auto& encodable_mode_args_arg = args.at(2);
          if (encodable_mode_args_arg.IsNull()) {
            reply(WrapError("mode_args_arg unexpectedly null."));
            return;
          }
          const auto& mode_args_arg = std::any_cast<const MyCacheModeArgs&>(std::get<CustomEncodableValue>(encodable_mode_args_arg));
          api->ReadCharacteristic(address_args_arg, handle_args_arg, mode_args_arg, [reply](ErrorOr<std::vector<uint8_t>>&& output) {
            if (output.has_error()) {
              reply(WrapError(output.error()));
              return;
            }
            EncodableList wrapped;
            wrapped.push_back(EncodableValue(std::move(output).TakeValue()));
            reply(EncodableValue(std::move(wrapped)));
          });
        } catch (const std::exception& exception) {
          reply(WrapError(exception.what()));
        }
      });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger, "dev.flutter.pigeon.bluetooth_low_energy_windows.MyCentralManagerHostAPI.writeCharacteristic" + prepended_suffix, &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler([api](const EncodableValue& message, const flutter::MessageReply<EncodableValue>& reply) {
        try {
          const auto& args = std::get<EncodableList>(message);
          const auto& encodable_address_args_arg = args.at(0);
          if (encodable_address_args_arg.IsNull()) {
            reply(WrapError("address_args_arg unexpectedly null."));
            return;
          }
          const int64_t address_args_arg = encodable_address_args_arg.LongValue();
          const auto& encodable_handle_args_arg = args.at(1);
          if (encodable_handle_args_arg.IsNull()) {
            reply(WrapError("handle_args_arg unexpectedly null."));
            return;
          }
          const int64_t handle_args_arg = encodable_handle_args_arg.LongValue();
          const auto& encodable_value_args_arg = args.at(2);
          if (encodable_value_args_arg.IsNull()) {
            reply(WrapError("value_args_arg unexpectedly null."));
            return;
          }
          const auto& value_args_arg = std::get<std::vector<uint8_t>>(encodable_value_args_arg);
          const auto& encodable_type_args_arg = args.at(3);
          if (encodable_type_args_arg.IsNull()) {
            reply(WrapError("type_args_arg unexpectedly null."));
            return;
          }
          const auto& type_args_arg = std::any_cast<const MyGATTCharacteristicWriteTypeArgs&>(std::get<CustomEncodableValue>(encodable_type_args_arg));
          api->WriteCharacteristic(address_args_arg, handle_args_arg, value_args_arg, type_args_arg, [reply](std::optional<FlutterError>&& output) {
            if (output.has_value()) {
              reply(WrapError(output.value()));
              return;
            }
            EncodableList wrapped;
            wrapped.push_back(EncodableValue());
            reply(EncodableValue(std::move(wrapped)));
          });
        } catch (const std::exception& exception) {
          reply(WrapError(exception.what()));
        }
      });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger, "dev.flutter.pigeon.bluetooth_low_energy_windows.MyCentralManagerHostAPI.setCharacteristicNotifyState" + prepended_suffix, &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler([api](const EncodableValue& message, const flutter::MessageReply<EncodableValue>& reply) {
        try {
          const auto& args = std::get<EncodableList>(message);
          const auto& encodable_address_args_arg = args.at(0);
          if (encodable_address_args_arg.IsNull()) {
            reply(WrapError("address_args_arg unexpectedly null."));
            return;
          }
          const int64_t address_args_arg = encodable_address_args_arg.LongValue();
          const auto& encodable_handle_args_arg = args.at(1);
          if (encodable_handle_args_arg.IsNull()) {
            reply(WrapError("handle_args_arg unexpectedly null."));
            return;
          }
          const int64_t handle_args_arg = encodable_handle_args_arg.LongValue();
          const auto& encodable_state_args_arg = args.at(2);
          if (encodable_state_args_arg.IsNull()) {
            reply(WrapError("state_args_arg unexpectedly null."));
            return;
          }
          const auto& state_args_arg = std::any_cast<const MyGATTCharacteristicNotifyStateArgs&>(std::get<CustomEncodableValue>(encodable_state_args_arg));
          api->SetCharacteristicNotifyState(address_args_arg, handle_args_arg, state_args_arg, [reply](std::optional<FlutterError>&& output) {
            if (output.has_value()) {
              reply(WrapError(output.value()));
              return;
            }
            EncodableList wrapped;
            wrapped.push_back(EncodableValue());
            reply(EncodableValue(std::move(wrapped)));
          });
        } catch (const std::exception& exception) {
          reply(WrapError(exception.what()));
        }
      });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger, "dev.flutter.pigeon.bluetooth_low_energy_windows.MyCentralManagerHostAPI.readDescriptor" + prepended_suffix, &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler([api](const EncodableValue& message, const flutter::MessageReply<EncodableValue>& reply) {
        try {
          const auto& args = std::get<EncodableList>(message);
          const auto& encodable_address_args_arg = args.at(0);
          if (encodable_address_args_arg.IsNull()) {
            reply(WrapError("address_args_arg unexpectedly null."));
            return;
          }
          const int64_t address_args_arg = encodable_address_args_arg.LongValue();
          const auto& encodable_handle_args_arg = args.at(1);
          if (encodable_handle_args_arg.IsNull()) {
            reply(WrapError("handle_args_arg unexpectedly null."));
            return;
          }
          const int64_t handle_args_arg = encodable_handle_args_arg.LongValue();
          const auto& encodable_mode_args_arg = args.at(2);
          if (encodable_mode_args_arg.IsNull()) {
            reply(WrapError("mode_args_arg unexpectedly null."));
            return;
          }
          const auto& mode_args_arg = std::any_cast<const MyCacheModeArgs&>(std::get<CustomEncodableValue>(encodable_mode_args_arg));
          api->ReadDescriptor(address_args_arg, handle_args_arg, mode_args_arg, [reply](ErrorOr<std::vector<uint8_t>>&& output) {
            if (output.has_error()) {
              reply(WrapError(output.error()));
              return;
            }
            EncodableList wrapped;
            wrapped.push_back(EncodableValue(std::move(output).TakeValue()));
            reply(EncodableValue(std::move(wrapped)));
          });
        } catch (const std::exception& exception) {
          reply(WrapError(exception.what()));
        }
      });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger, "dev.flutter.pigeon.bluetooth_low_energy_windows.MyCentralManagerHostAPI.writeDescriptor" + prepended_suffix, &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler([api](const EncodableValue& message, const flutter::MessageReply<EncodableValue>& reply) {
        try {
          const auto& args = std::get<EncodableList>(message);
          const auto& encodable_address_args_arg = args.at(0);
          if (encodable_address_args_arg.IsNull()) {
            reply(WrapError("address_args_arg unexpectedly null."));
            return;
          }
          const int64_t address_args_arg = encodable_address_args_arg.LongValue();
          const auto& encodable_handle_args_arg = args.at(1);
          if (encodable_handle_args_arg.IsNull()) {
            reply(WrapError("handle_args_arg unexpectedly null."));
            return;
          }
          const int64_t handle_args_arg = encodable_handle_args_arg.LongValue();
          const auto& encodable_value_args_arg = args.at(2);
          if (encodable_value_args_arg.IsNull()) {
            reply(WrapError("value_args_arg unexpectedly null."));
            return;
          }
          const auto& value_args_arg = std::get<std::vector<uint8_t>>(encodable_value_args_arg);
          api->WriteDescriptor(address_args_arg, handle_args_arg, value_args_arg, [reply](std::optional<FlutterError>&& output) {
            if (output.has_value()) {
              reply(WrapError(output.value()));
              return;
            }
            EncodableList wrapped;
            wrapped.push_back(EncodableValue());
            reply(EncodableValue(std::move(wrapped)));
          });
        } catch (const std::exception& exception) {
          reply(WrapError(exception.what()));
        }
      });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
}

EncodableValue MyCentralManagerHostAPI::WrapError(std::string_view error_message) {
  return EncodableValue(EncodableList{
    EncodableValue(std::string(error_message)),
    EncodableValue("Error"),
    EncodableValue()
  });
}

EncodableValue MyCentralManagerHostAPI::WrapError(const FlutterError& error) {
  return EncodableValue(EncodableList{
    EncodableValue(error.code()),
    EncodableValue(error.message()),
    error.details()
  });
}

// Generated class from Pigeon that represents Flutter messages that can be called from C++.
MyCentralManagerFlutterAPI::MyCentralManagerFlutterAPI(flutter::BinaryMessenger* binary_messenger)
 : binary_messenger_(binary_messenger),
    message_channel_suffix_("") {}

MyCentralManagerFlutterAPI::MyCentralManagerFlutterAPI(
  flutter::BinaryMessenger* binary_messenger,
  const std::string& message_channel_suffix)
 : binary_messenger_(binary_messenger),
    message_channel_suffix_(message_channel_suffix.length() > 0 ? std::string(".") + message_channel_suffix : "") {}

const flutter::StandardMessageCodec& MyCentralManagerFlutterAPI::GetCodec() {
  return flutter::StandardMessageCodec::GetInstance(&PigeonInternalCodecSerializer::GetInstance());
}

void MyCentralManagerFlutterAPI::OnStateChanged(
  const MyBluetoothLowEnergyStateArgs& state_args_arg,
  std::function<void(void)>&& on_success,
  std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name = "dev.flutter.pigeon.bluetooth_low_energy_windows.MyCentralManagerFlutterAPI.onStateChanged" + message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
    CustomEncodableValue(state_args_arg),
  });
  channel.Send(encoded_api_arguments, [channel_name, on_success = std::move(on_success), on_error = std::move(on_error)](const uint8_t* reply, size_t reply_size) {
    std::unique_ptr<EncodableValue> response = GetCodec().DecodeMessage(reply, reply_size);
    const auto& encodable_return_value = *response;
    const auto* list_return_value = std::get_if<EncodableList>(&encodable_return_value);
    if (list_return_value) {
      if (list_return_value->size() > 1) {
        on_error(FlutterError(std::get<std::string>(list_return_value->at(0)), std::get<std::string>(list_return_value->at(1)), list_return_value->at(2)));
      } else {
        on_success();
      }
    } else {
      on_error(CreateConnectionError(channel_name));
    } 
  });
}

void MyCentralManagerFlutterAPI::OnDiscovered(
  const MyPeripheralArgs& peripheral_args_arg,
  int64_t rssi_args_arg,
  int64_t timestamp_args_arg,
  const MyAdvertisementTypeArgs& type_args_arg,
  const MyAdvertisementArgs& advertisement_args_arg,
  std::function<void(void)>&& on_success,
  std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name = "dev.flutter.pigeon.bluetooth_low_energy_windows.MyCentralManagerFlutterAPI.onDiscovered" + message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
    CustomEncodableValue(peripheral_args_arg),
    EncodableValue(rssi_args_arg),
    EncodableValue(timestamp_args_arg),
    CustomEncodableValue(type_args_arg),
    CustomEncodableValue(advertisement_args_arg),
  });
  channel.Send(encoded_api_arguments, [channel_name, on_success = std::move(on_success), on_error = std::move(on_error)](const uint8_t* reply, size_t reply_size) {
    std::unique_ptr<EncodableValue> response = GetCodec().DecodeMessage(reply, reply_size);
    const auto& encodable_return_value = *response;
    const auto* list_return_value = std::get_if<EncodableList>(&encodable_return_value);
    if (list_return_value) {
      if (list_return_value->size() > 1) {
        on_error(FlutterError(std::get<std::string>(list_return_value->at(0)), std::get<std::string>(list_return_value->at(1)), list_return_value->at(2)));
      } else {
        on_success();
      }
    } else {
      on_error(CreateConnectionError(channel_name));
    } 
  });
}

void MyCentralManagerFlutterAPI::OnConnectionStateChanged(
  const MyPeripheralArgs& peripheral_args_arg,
  const MyConnectionStateArgs& state_args_arg,
  std::function<void(void)>&& on_success,
  std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name = "dev.flutter.pigeon.bluetooth_low_energy_windows.MyCentralManagerFlutterAPI.onConnectionStateChanged" + message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
    CustomEncodableValue(peripheral_args_arg),
    CustomEncodableValue(state_args_arg),
  });
  channel.Send(encoded_api_arguments, [channel_name, on_success = std::move(on_success), on_error = std::move(on_error)](const uint8_t* reply, size_t reply_size) {
    std::unique_ptr<EncodableValue> response = GetCodec().DecodeMessage(reply, reply_size);
    const auto& encodable_return_value = *response;
    const auto* list_return_value = std::get_if<EncodableList>(&encodable_return_value);
    if (list_return_value) {
      if (list_return_value->size() > 1) {
        on_error(FlutterError(std::get<std::string>(list_return_value->at(0)), std::get<std::string>(list_return_value->at(1)), list_return_value->at(2)));
      } else {
        on_success();
      }
    } else {
      on_error(CreateConnectionError(channel_name));
    } 
  });
}

void MyCentralManagerFlutterAPI::OnMTUChanged(
  const MyPeripheralArgs& peripheral_args_arg,
  int64_t mtu_args_arg,
  std::function<void(void)>&& on_success,
  std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name = "dev.flutter.pigeon.bluetooth_low_energy_windows.MyCentralManagerFlutterAPI.onMTUChanged" + message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
    CustomEncodableValue(peripheral_args_arg),
    EncodableValue(mtu_args_arg),
  });
  channel.Send(encoded_api_arguments, [channel_name, on_success = std::move(on_success), on_error = std::move(on_error)](const uint8_t* reply, size_t reply_size) {
    std::unique_ptr<EncodableValue> response = GetCodec().DecodeMessage(reply, reply_size);
    const auto& encodable_return_value = *response;
    const auto* list_return_value = std::get_if<EncodableList>(&encodable_return_value);
    if (list_return_value) {
      if (list_return_value->size() > 1) {
        on_error(FlutterError(std::get<std::string>(list_return_value->at(0)), std::get<std::string>(list_return_value->at(1)), list_return_value->at(2)));
      } else {
        on_success();
      }
    } else {
      on_error(CreateConnectionError(channel_name));
    } 
  });
}

void MyCentralManagerFlutterAPI::OnCharacteristicNotified(
  const MyPeripheralArgs& peripheral_args_arg,
  const MyGATTCharacteristicArgs& characteristic_args_arg,
  const std::vector<uint8_t>& value_args_arg,
  std::function<void(void)>&& on_success,
  std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name = "dev.flutter.pigeon.bluetooth_low_energy_windows.MyCentralManagerFlutterAPI.onCharacteristicNotified" + message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
    CustomEncodableValue(peripheral_args_arg),
    CustomEncodableValue(characteristic_args_arg),
    EncodableValue(value_args_arg),
  });
  channel.Send(encoded_api_arguments, [channel_name, on_success = std::move(on_success), on_error = std::move(on_error)](const uint8_t* reply, size_t reply_size) {
    std::unique_ptr<EncodableValue> response = GetCodec().DecodeMessage(reply, reply_size);
    const auto& encodable_return_value = *response;
    const auto* list_return_value = std::get_if<EncodableList>(&encodable_return_value);
    if (list_return_value) {
      if (list_return_value->size() > 1) {
        on_error(FlutterError(std::get<std::string>(list_return_value->at(0)), std::get<std::string>(list_return_value->at(1)), list_return_value->at(2)));
      } else {
        on_success();
      }
    } else {
      on_error(CreateConnectionError(channel_name));
    } 
  });
}

/// The codec used by MyPeripheralManagerHostAPI.
const flutter::StandardMessageCodec& MyPeripheralManagerHostAPI::GetCodec() {
  return flutter::StandardMessageCodec::GetInstance(&PigeonInternalCodecSerializer::GetInstance());
}

// Sets up an instance of `MyPeripheralManagerHostAPI` to handle messages through the `binary_messenger`.
void MyPeripheralManagerHostAPI::SetUp(
  flutter::BinaryMessenger* binary_messenger,
  MyPeripheralManagerHostAPI* api) {
  MyPeripheralManagerHostAPI::SetUp(binary_messenger, api, "");
}

void MyPeripheralManagerHostAPI::SetUp(
  flutter::BinaryMessenger* binary_messenger,
  MyPeripheralManagerHostAPI* api,
  const std::string& message_channel_suffix) {
  const std::string prepended_suffix = message_channel_suffix.length() > 0 ? std::string(".") + message_channel_suffix : "";
  {
    BasicMessageChannel<> channel(binary_messenger, "dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerHostAPI.initialize" + prepended_suffix, &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler([api](const EncodableValue& message, const flutter::MessageReply<EncodableValue>& reply) {
        try {
          api->Initialize([reply](std::optional<FlutterError>&& output) {
            if (output.has_value()) {
              reply(WrapError(output.value()));
              return;
            }
            EncodableList wrapped;
            wrapped.push_back(EncodableValue());
            reply(EncodableValue(std::move(wrapped)));
          });
        } catch (const std::exception& exception) {
          reply(WrapError(exception.what()));
        }
      });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger, "dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerHostAPI.getState" + prepended_suffix, &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler([api](const EncodableValue& message, const flutter::MessageReply<EncodableValue>& reply) {
        try {
          ErrorOr<MyBluetoothLowEnergyStateArgs> output = api->GetState();
          if (output.has_error()) {
            reply(WrapError(output.error()));
            return;
          }
          EncodableList wrapped;
          wrapped.push_back(CustomEncodableValue(std::move(output).TakeValue()));
          reply(EncodableValue(std::move(wrapped)));
        } catch (const std::exception& exception) {
          reply(WrapError(exception.what()));
        }
      });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger, "dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerHostAPI.addService" + prepended_suffix, &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler([api](const EncodableValue& message, const flutter::MessageReply<EncodableValue>& reply) {
        try {
          const auto& args = std::get<EncodableList>(message);
          const auto& encodable_service_args_arg = args.at(0);
          if (encodable_service_args_arg.IsNull()) {
            reply(WrapError("service_args_arg unexpectedly null."));
            return;
          }
          const auto& service_args_arg = std::any_cast<const MyMutableGATTServiceArgs&>(std::get<CustomEncodableValue>(encodable_service_args_arg));
          api->AddService(service_args_arg, [reply](std::optional<FlutterError>&& output) {
            if (output.has_value()) {
              reply(WrapError(output.value()));
              return;
            }
            EncodableList wrapped;
            wrapped.push_back(EncodableValue());
            reply(EncodableValue(std::move(wrapped)));
          });
        } catch (const std::exception& exception) {
          reply(WrapError(exception.what()));
        }
      });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger, "dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerHostAPI.removeService" + prepended_suffix, &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler([api](const EncodableValue& message, const flutter::MessageReply<EncodableValue>& reply) {
        try {
          const auto& args = std::get<EncodableList>(message);
          const auto& encodable_hash_code_args_arg = args.at(0);
          if (encodable_hash_code_args_arg.IsNull()) {
            reply(WrapError("hash_code_args_arg unexpectedly null."));
            return;
          }
          const int64_t hash_code_args_arg = encodable_hash_code_args_arg.LongValue();
          std::optional<FlutterError> output = api->RemoveService(hash_code_args_arg);
          if (output.has_value()) {
            reply(WrapError(output.value()));
            return;
          }
          EncodableList wrapped;
          wrapped.push_back(EncodableValue());
          reply(EncodableValue(std::move(wrapped)));
        } catch (const std::exception& exception) {
          reply(WrapError(exception.what()));
        }
      });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger, "dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerHostAPI.startAdvertising" + prepended_suffix, &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler([api](const EncodableValue& message, const flutter::MessageReply<EncodableValue>& reply) {
        try {
          const auto& args = std::get<EncodableList>(message);
          const auto& encodable_advertisement_args_arg = args.at(0);
          if (encodable_advertisement_args_arg.IsNull()) {
            reply(WrapError("advertisement_args_arg unexpectedly null."));
            return;
          }
          const auto& advertisement_args_arg = std::any_cast<const MyAdvertisementArgs&>(std::get<CustomEncodableValue>(encodable_advertisement_args_arg));
          std::optional<FlutterError> output = api->StartAdvertising(advertisement_args_arg);
          if (output.has_value()) {
            reply(WrapError(output.value()));
            return;
          }
          EncodableList wrapped;
          wrapped.push_back(EncodableValue());
          reply(EncodableValue(std::move(wrapped)));
        } catch (const std::exception& exception) {
          reply(WrapError(exception.what()));
        }
      });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger, "dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerHostAPI.stopAdvertising" + prepended_suffix, &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler([api](const EncodableValue& message, const flutter::MessageReply<EncodableValue>& reply) {
        try {
          std::optional<FlutterError> output = api->StopAdvertising();
          if (output.has_value()) {
            reply(WrapError(output.value()));
            return;
          }
          EncodableList wrapped;
          wrapped.push_back(EncodableValue());
          reply(EncodableValue(std::move(wrapped)));
        } catch (const std::exception& exception) {
          reply(WrapError(exception.what()));
        }
      });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger, "dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerHostAPI.getMaxNotificationSize" + prepended_suffix, &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler([api](const EncodableValue& message, const flutter::MessageReply<EncodableValue>& reply) {
        try {
          const auto& args = std::get<EncodableList>(message);
          const auto& encodable_address_args_arg = args.at(0);
          if (encodable_address_args_arg.IsNull()) {
            reply(WrapError("address_args_arg unexpectedly null."));
            return;
          }
          const int64_t address_args_arg = encodable_address_args_arg.LongValue();
          ErrorOr<int64_t> output = api->GetMaxNotificationSize(address_args_arg);
          if (output.has_error()) {
            reply(WrapError(output.error()));
            return;
          }
          EncodableList wrapped;
          wrapped.push_back(EncodableValue(std::move(output).TakeValue()));
          reply(EncodableValue(std::move(wrapped)));
        } catch (const std::exception& exception) {
          reply(WrapError(exception.what()));
        }
      });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger, "dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerHostAPI.respondReadRequestWithValue" + prepended_suffix, &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler([api](const EncodableValue& message, const flutter::MessageReply<EncodableValue>& reply) {
        try {
          const auto& args = std::get<EncodableList>(message);
          const auto& encodable_id_args_arg = args.at(0);
          if (encodable_id_args_arg.IsNull()) {
            reply(WrapError("id_args_arg unexpectedly null."));
            return;
          }
          const int64_t id_args_arg = encodable_id_args_arg.LongValue();
          const auto& encodable_value_args_arg = args.at(1);
          if (encodable_value_args_arg.IsNull()) {
            reply(WrapError("value_args_arg unexpectedly null."));
            return;
          }
          const auto& value_args_arg = std::get<std::vector<uint8_t>>(encodable_value_args_arg);
          std::optional<FlutterError> output = api->RespondReadRequestWithValue(id_args_arg, value_args_arg);
          if (output.has_value()) {
            reply(WrapError(output.value()));
            return;
          }
          EncodableList wrapped;
          wrapped.push_back(EncodableValue());
          reply(EncodableValue(std::move(wrapped)));
        } catch (const std::exception& exception) {
          reply(WrapError(exception.what()));
        }
      });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger, "dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerHostAPI.respondReadRequestWithProtocolError" + prepended_suffix, &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler([api](const EncodableValue& message, const flutter::MessageReply<EncodableValue>& reply) {
        try {
          const auto& args = std::get<EncodableList>(message);
          const auto& encodable_id_args_arg = args.at(0);
          if (encodable_id_args_arg.IsNull()) {
            reply(WrapError("id_args_arg unexpectedly null."));
            return;
          }
          const int64_t id_args_arg = encodable_id_args_arg.LongValue();
          const auto& encodable_error_args_arg = args.at(1);
          if (encodable_error_args_arg.IsNull()) {
            reply(WrapError("error_args_arg unexpectedly null."));
            return;
          }
          const auto& error_args_arg = std::any_cast<const MyGATTProtocolErrorArgs&>(std::get<CustomEncodableValue>(encodable_error_args_arg));
          std::optional<FlutterError> output = api->RespondReadRequestWithProtocolError(id_args_arg, error_args_arg);
          if (output.has_value()) {
            reply(WrapError(output.value()));
            return;
          }
          EncodableList wrapped;
          wrapped.push_back(EncodableValue());
          reply(EncodableValue(std::move(wrapped)));
        } catch (const std::exception& exception) {
          reply(WrapError(exception.what()));
        }
      });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger, "dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerHostAPI.respondWriteRequest" + prepended_suffix, &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler([api](const EncodableValue& message, const flutter::MessageReply<EncodableValue>& reply) {
        try {
          const auto& args = std::get<EncodableList>(message);
          const auto& encodable_id_args_arg = args.at(0);
          if (encodable_id_args_arg.IsNull()) {
            reply(WrapError("id_args_arg unexpectedly null."));
            return;
          }
          const int64_t id_args_arg = encodable_id_args_arg.LongValue();
          std::optional<FlutterError> output = api->RespondWriteRequest(id_args_arg);
          if (output.has_value()) {
            reply(WrapError(output.value()));
            return;
          }
          EncodableList wrapped;
          wrapped.push_back(EncodableValue());
          reply(EncodableValue(std::move(wrapped)));
        } catch (const std::exception& exception) {
          reply(WrapError(exception.what()));
        }
      });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger, "dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerHostAPI.respondWriteRequestWithProtocolError" + prepended_suffix, &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler([api](const EncodableValue& message, const flutter::MessageReply<EncodableValue>& reply) {
        try {
          const auto& args = std::get<EncodableList>(message);
          const auto& encodable_id_args_arg = args.at(0);
          if (encodable_id_args_arg.IsNull()) {
            reply(WrapError("id_args_arg unexpectedly null."));
            return;
          }
          const int64_t id_args_arg = encodable_id_args_arg.LongValue();
          const auto& encodable_error_args_arg = args.at(1);
          if (encodable_error_args_arg.IsNull()) {
            reply(WrapError("error_args_arg unexpectedly null."));
            return;
          }
          const auto& error_args_arg = std::any_cast<const MyGATTProtocolErrorArgs&>(std::get<CustomEncodableValue>(encodable_error_args_arg));
          std::optional<FlutterError> output = api->RespondWriteRequestWithProtocolError(id_args_arg, error_args_arg);
          if (output.has_value()) {
            reply(WrapError(output.value()));
            return;
          }
          EncodableList wrapped;
          wrapped.push_back(EncodableValue());
          reply(EncodableValue(std::move(wrapped)));
        } catch (const std::exception& exception) {
          reply(WrapError(exception.what()));
        }
      });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger, "dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerHostAPI.notifyValue" + prepended_suffix, &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler([api](const EncodableValue& message, const flutter::MessageReply<EncodableValue>& reply) {
        try {
          const auto& args = std::get<EncodableList>(message);
          const auto& encodable_address_args_arg = args.at(0);
          if (encodable_address_args_arg.IsNull()) {
            reply(WrapError("address_args_arg unexpectedly null."));
            return;
          }
          const int64_t address_args_arg = encodable_address_args_arg.LongValue();
          const auto& encodable_hash_code_args_arg = args.at(1);
          if (encodable_hash_code_args_arg.IsNull()) {
            reply(WrapError("hash_code_args_arg unexpectedly null."));
            return;
          }
          const int64_t hash_code_args_arg = encodable_hash_code_args_arg.LongValue();
          const auto& encodable_value_args_arg = args.at(2);
          if (encodable_value_args_arg.IsNull()) {
            reply(WrapError("value_args_arg unexpectedly null."));
            return;
          }
          const auto& value_args_arg = std::get<std::vector<uint8_t>>(encodable_value_args_arg);
          api->NotifyValue(address_args_arg, hash_code_args_arg, value_args_arg, [reply](std::optional<FlutterError>&& output) {
            if (output.has_value()) {
              reply(WrapError(output.value()));
              return;
            }
            EncodableList wrapped;
            wrapped.push_back(EncodableValue());
            reply(EncodableValue(std::move(wrapped)));
          });
        } catch (const std::exception& exception) {
          reply(WrapError(exception.what()));
        }
      });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
}

EncodableValue MyPeripheralManagerHostAPI::WrapError(std::string_view error_message) {
  return EncodableValue(EncodableList{
    EncodableValue(std::string(error_message)),
    EncodableValue("Error"),
    EncodableValue()
  });
}

EncodableValue MyPeripheralManagerHostAPI::WrapError(const FlutterError& error) {
  return EncodableValue(EncodableList{
    EncodableValue(error.code()),
    EncodableValue(error.message()),
    error.details()
  });
}

// Generated class from Pigeon that represents Flutter messages that can be called from C++.
MyPeripheralManagerFlutterAPI::MyPeripheralManagerFlutterAPI(flutter::BinaryMessenger* binary_messenger)
 : binary_messenger_(binary_messenger),
    message_channel_suffix_("") {}

MyPeripheralManagerFlutterAPI::MyPeripheralManagerFlutterAPI(
  flutter::BinaryMessenger* binary_messenger,
  const std::string& message_channel_suffix)
 : binary_messenger_(binary_messenger),
    message_channel_suffix_(message_channel_suffix.length() > 0 ? std::string(".") + message_channel_suffix : "") {}

const flutter::StandardMessageCodec& MyPeripheralManagerFlutterAPI::GetCodec() {
  return flutter::StandardMessageCodec::GetInstance(&PigeonInternalCodecSerializer::GetInstance());
}

void MyPeripheralManagerFlutterAPI::OnStateChanged(
  const MyBluetoothLowEnergyStateArgs& state_args_arg,
  std::function<void(void)>&& on_success,
  std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name = "dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerFlutterAPI.onStateChanged" + message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
    CustomEncodableValue(state_args_arg),
  });
  channel.Send(encoded_api_arguments, [channel_name, on_success = std::move(on_success), on_error = std::move(on_error)](const uint8_t* reply, size_t reply_size) {
    std::unique_ptr<EncodableValue> response = GetCodec().DecodeMessage(reply, reply_size);
    const auto& encodable_return_value = *response;
    const auto* list_return_value = std::get_if<EncodableList>(&encodable_return_value);
    if (list_return_value) {
      if (list_return_value->size() > 1) {
        on_error(FlutterError(std::get<std::string>(list_return_value->at(0)), std::get<std::string>(list_return_value->at(1)), list_return_value->at(2)));
      } else {
        on_success();
      }
    } else {
      on_error(CreateConnectionError(channel_name));
    } 
  });
}

void MyPeripheralManagerFlutterAPI::OnMTUChanged(
  const MyCentralArgs& central_args_arg,
  int64_t mtu_args_arg,
  std::function<void(void)>&& on_success,
  std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name = "dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerFlutterAPI.onMTUChanged" + message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
    CustomEncodableValue(central_args_arg),
    EncodableValue(mtu_args_arg),
  });
  channel.Send(encoded_api_arguments, [channel_name, on_success = std::move(on_success), on_error = std::move(on_error)](const uint8_t* reply, size_t reply_size) {
    std::unique_ptr<EncodableValue> response = GetCodec().DecodeMessage(reply, reply_size);
    const auto& encodable_return_value = *response;
    const auto* list_return_value = std::get_if<EncodableList>(&encodable_return_value);
    if (list_return_value) {
      if (list_return_value->size() > 1) {
        on_error(FlutterError(std::get<std::string>(list_return_value->at(0)), std::get<std::string>(list_return_value->at(1)), list_return_value->at(2)));
      } else {
        on_success();
      }
    } else {
      on_error(CreateConnectionError(channel_name));
    } 
  });
}

void MyPeripheralManagerFlutterAPI::OnCharacteristicReadRequest(
  const MyCentralArgs& central_args_arg,
  int64_t hash_code_args_arg,
  const MyGATTReadRequestArgs& request_args_arg,
  std::function<void(void)>&& on_success,
  std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name = "dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerFlutterAPI.onCharacteristicReadRequest" + message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
    CustomEncodableValue(central_args_arg),
    EncodableValue(hash_code_args_arg),
    CustomEncodableValue(request_args_arg),
  });
  channel.Send(encoded_api_arguments, [channel_name, on_success = std::move(on_success), on_error = std::move(on_error)](const uint8_t* reply, size_t reply_size) {
    std::unique_ptr<EncodableValue> response = GetCodec().DecodeMessage(reply, reply_size);
    const auto& encodable_return_value = *response;
    const auto* list_return_value = std::get_if<EncodableList>(&encodable_return_value);
    if (list_return_value) {
      if (list_return_value->size() > 1) {
        on_error(FlutterError(std::get<std::string>(list_return_value->at(0)), std::get<std::string>(list_return_value->at(1)), list_return_value->at(2)));
      } else {
        on_success();
      }
    } else {
      on_error(CreateConnectionError(channel_name));
    } 
  });
}

void MyPeripheralManagerFlutterAPI::OnCharacteristicWriteRequest(
  const MyCentralArgs& central_args_arg,
  int64_t hash_code_args_arg,
  const MyGATTWriteRequestArgs& request_args_arg,
  std::function<void(void)>&& on_success,
  std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name = "dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerFlutterAPI.onCharacteristicWriteRequest" + message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
    CustomEncodableValue(central_args_arg),
    EncodableValue(hash_code_args_arg),
    CustomEncodableValue(request_args_arg),
  });
  channel.Send(encoded_api_arguments, [channel_name, on_success = std::move(on_success), on_error = std::move(on_error)](const uint8_t* reply, size_t reply_size) {
    std::unique_ptr<EncodableValue> response = GetCodec().DecodeMessage(reply, reply_size);
    const auto& encodable_return_value = *response;
    const auto* list_return_value = std::get_if<EncodableList>(&encodable_return_value);
    if (list_return_value) {
      if (list_return_value->size() > 1) {
        on_error(FlutterError(std::get<std::string>(list_return_value->at(0)), std::get<std::string>(list_return_value->at(1)), list_return_value->at(2)));
      } else {
        on_success();
      }
    } else {
      on_error(CreateConnectionError(channel_name));
    } 
  });
}

void MyPeripheralManagerFlutterAPI::OnCharacteristicSubscribedClientsChanged(
  int64_t hash_code_args_arg,
  const EncodableList& centrals_args_arg,
  std::function<void(void)>&& on_success,
  std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name = "dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerFlutterAPI.onCharacteristicSubscribedClientsChanged" + message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
    EncodableValue(hash_code_args_arg),
    EncodableValue(centrals_args_arg),
  });
  channel.Send(encoded_api_arguments, [channel_name, on_success = std::move(on_success), on_error = std::move(on_error)](const uint8_t* reply, size_t reply_size) {
    std::unique_ptr<EncodableValue> response = GetCodec().DecodeMessage(reply, reply_size);
    const auto& encodable_return_value = *response;
    const auto* list_return_value = std::get_if<EncodableList>(&encodable_return_value);
    if (list_return_value) {
      if (list_return_value->size() > 1) {
        on_error(FlutterError(std::get<std::string>(list_return_value->at(0)), std::get<std::string>(list_return_value->at(1)), list_return_value->at(2)));
      } else {
        on_success();
      }
    } else {
      on_error(CreateConnectionError(channel_name));
    } 
  });
}

void MyPeripheralManagerFlutterAPI::OnDescriptorReadRequest(
  const MyCentralArgs& central_args_arg,
  int64_t hash_code_args_arg,
  const MyGATTReadRequestArgs& request_args_arg,
  std::function<void(void)>&& on_success,
  std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name = "dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerFlutterAPI.onDescriptorReadRequest" + message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
    CustomEncodableValue(central_args_arg),
    EncodableValue(hash_code_args_arg),
    CustomEncodableValue(request_args_arg),
  });
  channel.Send(encoded_api_arguments, [channel_name, on_success = std::move(on_success), on_error = std::move(on_error)](const uint8_t* reply, size_t reply_size) {
    std::unique_ptr<EncodableValue> response = GetCodec().DecodeMessage(reply, reply_size);
    const auto& encodable_return_value = *response;
    const auto* list_return_value = std::get_if<EncodableList>(&encodable_return_value);
    if (list_return_value) {
      if (list_return_value->size() > 1) {
        on_error(FlutterError(std::get<std::string>(list_return_value->at(0)), std::get<std::string>(list_return_value->at(1)), list_return_value->at(2)));
      } else {
        on_success();
      }
    } else {
      on_error(CreateConnectionError(channel_name));
    } 
  });
}

void MyPeripheralManagerFlutterAPI::OnDescriptorWriteRequest(
  const MyCentralArgs& central_args_arg,
  int64_t hash_code_args_arg,
  const MyGATTWriteRequestArgs& request_args_arg,
  std::function<void(void)>&& on_success,
  std::function<void(const FlutterError&)>&& on_error) {
  const std::string channel_name = "dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerFlutterAPI.onDescriptorWriteRequest" + message_channel_suffix_;
  BasicMessageChannel<> channel(binary_messenger_, channel_name, &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
    CustomEncodableValue(central_args_arg),
    EncodableValue(hash_code_args_arg),
    CustomEncodableValue(request_args_arg),
  });
  channel.Send(encoded_api_arguments, [channel_name, on_success = std::move(on_success), on_error = std::move(on_error)](const uint8_t* reply, size_t reply_size) {
    std::unique_ptr<EncodableValue> response = GetCodec().DecodeMessage(reply, reply_size);
    const auto& encodable_return_value = *response;
    const auto* list_return_value = std::get_if<EncodableList>(&encodable_return_value);
    if (list_return_value) {
      if (list_return_value->size() > 1) {
        on_error(FlutterError(std::get<std::string>(list_return_value->at(0)), std::get<std::string>(list_return_value->at(1)), list_return_value->at(2)));
      } else {
        on_success();
      }
    } else {
      on_error(CreateConnectionError(channel_name));
    } 
  });
}

}  // namespace bluetooth_low_energy_windows
