// Autogenerated from Pigeon (v26.0.0), do not edit directly.
// See also: https://pub.dev/packages/pigeon
// ignore_for_file: public_member_api_docs, non_constant_identifier_names, avoid_as, unused_import, unnecessary_parenthesis, prefer_null_aware_operators, omit_local_variable_types, unused_shown_name, unnecessary_import, no_leading_underscores_for_local_identifiers

import 'dart:async';
import 'dart:typed_data' show Float64List, Int32List, Int64List, Uint8List;

import 'package:flutter/foundation.dart' show ReadBuffer, WriteBuffer;
import 'package:flutter/services.dart';

PlatformException _createConnectionError(String channelName) {
  return PlatformException(
    code: 'channel-error',
    message: 'Unable to establish connection on channel: "$channelName".',
  );
}

List<Object?> wrapResponse({
  Object? result,
  PlatformException? error,
  bool empty = false,
}) {
  if (empty) {
    return <Object?>[];
  }
  if (error == null) {
    return <Object?>[result];
  }
  return <Object?>[error.code, error.message, error.details];
}

bool _deepEquals(Object? a, Object? b) {
  if (a is List && b is List) {
    return a.length == b.length &&
        a.indexed.every(
          ((int, dynamic) item) => _deepEquals(item.$2, b[item.$1]),
        );
  }
  if (a is Map && b is Map) {
    return a.length == b.length &&
        a.entries.every(
          (MapEntry<Object?, Object?> entry) =>
              (b as Map<Object?, Object?>).containsKey(entry.key) &&
              _deepEquals(entry.value, b[entry.key]),
        );
  }
  return a == b;
}

enum MyBluetoothLowEnergyStateArgs { unknown, unsupported, disabled, off, on }

enum MyAdvertisementTypeArgs {
  connectableUndirected,
  connectableDirected,
  scannableUndirected,
  nonConnectableUndirected,
  scanResponse,
  extended,
}

enum MyConnectionStateArgs { disconnected, connected }

enum MyGATTCharacteristicPropertyArgs {
  read,
  write,
  writeWithoutResponse,
  notify,
  indicate,
}

enum MyGATTCharacteristicWriteTypeArgs { withResponse, withoutResponse }

enum MyGATTCharacteristicNotifyStateArgs { none, notify, indicate }

enum MyGATTProtectionLevelArgs {
  plain,
  authenticationRequired,
  entryptionRequired,
  encryptionAndAuthenticationRequired,
}

enum MyGATTProtocolErrorArgs {
  invalidHandle,
  readNotPermitted,
  writeNotPermitted,
  invalidPDU,
  insufficientAuthentication,
  requestNotSupported,
  invalidOffset,
  insufficientAuthorization,
  prepareQueueFull,
  attributeNotFound,
  attributeNotLong,
  insufficientEncryptionKeySize,
  invalidAttributeValueLength,
  unlikelyError,
  insufficientEncryption,
  unsupportedGroupType,
  insufficientResources,
}

enum MyCacheModeArgs { cached, uncached }

class MyManufacturerSpecificDataArgs {
  MyManufacturerSpecificDataArgs({
    required this.idArgs,
    required this.dataArgs,
  });

  int idArgs;

  Uint8List dataArgs;

  List<Object?> _toList() {
    return <Object?>[idArgs, dataArgs];
  }

  Object encode() {
    return _toList();
  }

  static MyManufacturerSpecificDataArgs decode(Object result) {
    result as List<Object?>;
    return MyManufacturerSpecificDataArgs(
      idArgs: result[0]! as int,
      dataArgs: result[1]! as Uint8List,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! MyManufacturerSpecificDataArgs ||
        other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList());
}

class MyAdvertisementArgs {
  MyAdvertisementArgs({
    this.nameArgs,
    required this.serviceUUIDsArgs,
    required this.serviceDataArgs,
    required this.manufacturerSpecificDataArgs,
  });

  String? nameArgs;

  List<String?> serviceUUIDsArgs;

  Map<String?, Uint8List?> serviceDataArgs;

  List<MyManufacturerSpecificDataArgs?> manufacturerSpecificDataArgs;

  List<Object?> _toList() {
    return <Object?>[
      nameArgs,
      serviceUUIDsArgs,
      serviceDataArgs,
      manufacturerSpecificDataArgs,
    ];
  }

  Object encode() {
    return _toList();
  }

  static MyAdvertisementArgs decode(Object result) {
    result as List<Object?>;
    return MyAdvertisementArgs(
      nameArgs: result[0] as String?,
      serviceUUIDsArgs: (result[1] as List<Object?>?)!.cast<String?>(),
      serviceDataArgs:
          (result[2] as Map<Object?, Object?>?)!.cast<String?, Uint8List?>(),
      manufacturerSpecificDataArgs:
          (result[3] as List<Object?>?)!
              .cast<MyManufacturerSpecificDataArgs?>(),
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! MyAdvertisementArgs || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList());
}

class MyCentralArgs {
  MyCentralArgs({required this.addressArgs});

  int addressArgs;

  List<Object?> _toList() {
    return <Object?>[addressArgs];
  }

  Object encode() {
    return _toList();
  }

  static MyCentralArgs decode(Object result) {
    result as List<Object?>;
    return MyCentralArgs(addressArgs: result[0]! as int);
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! MyCentralArgs || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList());
}

class MyPeripheralArgs {
  MyPeripheralArgs({required this.addressArgs});

  int addressArgs;

  List<Object?> _toList() {
    return <Object?>[addressArgs];
  }

  Object encode() {
    return _toList();
  }

  static MyPeripheralArgs decode(Object result) {
    result as List<Object?>;
    return MyPeripheralArgs(addressArgs: result[0]! as int);
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! MyPeripheralArgs || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList());
}

class MyGATTDescriptorArgs {
  MyGATTDescriptorArgs({required this.handleArgs, required this.uuidArgs});

  int handleArgs;

  String uuidArgs;

  List<Object?> _toList() {
    return <Object?>[handleArgs, uuidArgs];
  }

  Object encode() {
    return _toList();
  }

  static MyGATTDescriptorArgs decode(Object result) {
    result as List<Object?>;
    return MyGATTDescriptorArgs(
      handleArgs: result[0]! as int,
      uuidArgs: result[1]! as String,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! MyGATTDescriptorArgs || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList());
}

class MyGATTCharacteristicArgs {
  MyGATTCharacteristicArgs({
    required this.handleArgs,
    required this.uuidArgs,
    required this.propertyNumbersArgs,
    required this.descriptorsArgs,
  });

  int handleArgs;

  String uuidArgs;

  List<int?> propertyNumbersArgs;

  List<MyGATTDescriptorArgs?> descriptorsArgs;

  List<Object?> _toList() {
    return <Object?>[
      handleArgs,
      uuidArgs,
      propertyNumbersArgs,
      descriptorsArgs,
    ];
  }

  Object encode() {
    return _toList();
  }

  static MyGATTCharacteristicArgs decode(Object result) {
    result as List<Object?>;
    return MyGATTCharacteristicArgs(
      handleArgs: result[0]! as int,
      uuidArgs: result[1]! as String,
      propertyNumbersArgs: (result[2] as List<Object?>?)!.cast<int?>(),
      descriptorsArgs:
          (result[3] as List<Object?>?)!.cast<MyGATTDescriptorArgs?>(),
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! MyGATTCharacteristicArgs ||
        other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList());
}

class MyGATTServiceArgs {
  MyGATTServiceArgs({
    required this.handleArgs,
    required this.uuidArgs,
    required this.isPrimaryArgs,
    required this.includedServicesArgs,
    required this.characteristicsArgs,
  });

  int handleArgs;

  String uuidArgs;

  bool isPrimaryArgs;

  List<MyGATTServiceArgs?> includedServicesArgs;

  List<MyGATTCharacteristicArgs?> characteristicsArgs;

  List<Object?> _toList() {
    return <Object?>[
      handleArgs,
      uuidArgs,
      isPrimaryArgs,
      includedServicesArgs,
      characteristicsArgs,
    ];
  }

  Object encode() {
    return _toList();
  }

  static MyGATTServiceArgs decode(Object result) {
    result as List<Object?>;
    return MyGATTServiceArgs(
      handleArgs: result[0]! as int,
      uuidArgs: result[1]! as String,
      isPrimaryArgs: result[2]! as bool,
      includedServicesArgs:
          (result[3] as List<Object?>?)!.cast<MyGATTServiceArgs?>(),
      characteristicsArgs:
          (result[4] as List<Object?>?)!.cast<MyGATTCharacteristicArgs?>(),
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! MyGATTServiceArgs || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList());
}

class MyMutableGATTDescriptorArgs {
  MyMutableGATTDescriptorArgs({
    required this.hashCodeArgs,
    required this.uuidArgs,
    this.valueArgs,
    this.readProtectionLevelArgs,
    this.writeProtectionLevelArgs,
  });

  int hashCodeArgs;

  String uuidArgs;

  Uint8List? valueArgs;

  MyGATTProtectionLevelArgs? readProtectionLevelArgs;

  MyGATTProtectionLevelArgs? writeProtectionLevelArgs;

  List<Object?> _toList() {
    return <Object?>[
      hashCodeArgs,
      uuidArgs,
      valueArgs,
      readProtectionLevelArgs,
      writeProtectionLevelArgs,
    ];
  }

  Object encode() {
    return _toList();
  }

  static MyMutableGATTDescriptorArgs decode(Object result) {
    result as List<Object?>;
    return MyMutableGATTDescriptorArgs(
      hashCodeArgs: result[0]! as int,
      uuidArgs: result[1]! as String,
      valueArgs: result[2] as Uint8List?,
      readProtectionLevelArgs: result[3] as MyGATTProtectionLevelArgs?,
      writeProtectionLevelArgs: result[4] as MyGATTProtectionLevelArgs?,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! MyMutableGATTDescriptorArgs ||
        other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList());
}

class MyMutableGATTCharacteristicArgs {
  MyMutableGATTCharacteristicArgs({
    required this.hashCodeArgs,
    required this.uuidArgs,
    this.valueArgs,
    required this.propertyNumbersArgs,
    this.readProtectionLevelArgs,
    this.writeProtectionLevelArgs,
    required this.descriptorsArgs,
  });

  int hashCodeArgs;

  String uuidArgs;

  Uint8List? valueArgs;

  List<int?> propertyNumbersArgs;

  MyGATTProtectionLevelArgs? readProtectionLevelArgs;

  MyGATTProtectionLevelArgs? writeProtectionLevelArgs;

  List<MyMutableGATTDescriptorArgs?> descriptorsArgs;

  List<Object?> _toList() {
    return <Object?>[
      hashCodeArgs,
      uuidArgs,
      valueArgs,
      propertyNumbersArgs,
      readProtectionLevelArgs,
      writeProtectionLevelArgs,
      descriptorsArgs,
    ];
  }

  Object encode() {
    return _toList();
  }

  static MyMutableGATTCharacteristicArgs decode(Object result) {
    result as List<Object?>;
    return MyMutableGATTCharacteristicArgs(
      hashCodeArgs: result[0]! as int,
      uuidArgs: result[1]! as String,
      valueArgs: result[2] as Uint8List?,
      propertyNumbersArgs: (result[3] as List<Object?>?)!.cast<int?>(),
      readProtectionLevelArgs: result[4] as MyGATTProtectionLevelArgs?,
      writeProtectionLevelArgs: result[5] as MyGATTProtectionLevelArgs?,
      descriptorsArgs:
          (result[6] as List<Object?>?)!.cast<MyMutableGATTDescriptorArgs?>(),
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! MyMutableGATTCharacteristicArgs ||
        other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList());
}

class MyMutableGATTServiceArgs {
  MyMutableGATTServiceArgs({
    required this.hashCodeArgs,
    required this.uuidArgs,
    required this.isPrimaryArgs,
    required this.includedServicesArgs,
    required this.characteristicsArgs,
  });

  int hashCodeArgs;

  String uuidArgs;

  bool isPrimaryArgs;

  List<MyMutableGATTServiceArgs?> includedServicesArgs;

  List<MyMutableGATTCharacteristicArgs?> characteristicsArgs;

  List<Object?> _toList() {
    return <Object?>[
      hashCodeArgs,
      uuidArgs,
      isPrimaryArgs,
      includedServicesArgs,
      characteristicsArgs,
    ];
  }

  Object encode() {
    return _toList();
  }

  static MyMutableGATTServiceArgs decode(Object result) {
    result as List<Object?>;
    return MyMutableGATTServiceArgs(
      hashCodeArgs: result[0]! as int,
      uuidArgs: result[1]! as String,
      isPrimaryArgs: result[2]! as bool,
      includedServicesArgs:
          (result[3] as List<Object?>?)!.cast<MyMutableGATTServiceArgs?>(),
      characteristicsArgs:
          (result[4] as List<Object?>?)!
              .cast<MyMutableGATTCharacteristicArgs?>(),
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! MyMutableGATTServiceArgs ||
        other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList());
}

class MyGATTReadRequestArgs {
  MyGATTReadRequestArgs({
    required this.idArgs,
    required this.offsetArgs,
    required this.lengthArgs,
  });

  int idArgs;

  int offsetArgs;

  int lengthArgs;

  List<Object?> _toList() {
    return <Object?>[idArgs, offsetArgs, lengthArgs];
  }

  Object encode() {
    return _toList();
  }

  static MyGATTReadRequestArgs decode(Object result) {
    result as List<Object?>;
    return MyGATTReadRequestArgs(
      idArgs: result[0]! as int,
      offsetArgs: result[1]! as int,
      lengthArgs: result[2]! as int,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! MyGATTReadRequestArgs || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList());
}

class MyGATTWriteRequestArgs {
  MyGATTWriteRequestArgs({
    required this.idArgs,
    required this.offsetArgs,
    required this.valueArgs,
    required this.typeArgs,
  });

  int idArgs;

  int offsetArgs;

  Uint8List valueArgs;

  MyGATTCharacteristicWriteTypeArgs typeArgs;

  List<Object?> _toList() {
    return <Object?>[idArgs, offsetArgs, valueArgs, typeArgs];
  }

  Object encode() {
    return _toList();
  }

  static MyGATTWriteRequestArgs decode(Object result) {
    result as List<Object?>;
    return MyGATTWriteRequestArgs(
      idArgs: result[0]! as int,
      offsetArgs: result[1]! as int,
      valueArgs: result[2]! as Uint8List,
      typeArgs: result[3]! as MyGATTCharacteristicWriteTypeArgs,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! MyGATTWriteRequestArgs || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList());
}

class _PigeonCodec extends StandardMessageCodec {
  const _PigeonCodec();
  @override
  void writeValue(WriteBuffer buffer, Object? value) {
    if (value is int) {
      buffer.putUint8(4);
      buffer.putInt64(value);
    } else if (value is MyBluetoothLowEnergyStateArgs) {
      buffer.putUint8(129);
      writeValue(buffer, value.index);
    } else if (value is MyAdvertisementTypeArgs) {
      buffer.putUint8(130);
      writeValue(buffer, value.index);
    } else if (value is MyConnectionStateArgs) {
      buffer.putUint8(131);
      writeValue(buffer, value.index);
    } else if (value is MyGATTCharacteristicPropertyArgs) {
      buffer.putUint8(132);
      writeValue(buffer, value.index);
    } else if (value is MyGATTCharacteristicWriteTypeArgs) {
      buffer.putUint8(133);
      writeValue(buffer, value.index);
    } else if (value is MyGATTCharacteristicNotifyStateArgs) {
      buffer.putUint8(134);
      writeValue(buffer, value.index);
    } else if (value is MyGATTProtectionLevelArgs) {
      buffer.putUint8(135);
      writeValue(buffer, value.index);
    } else if (value is MyGATTProtocolErrorArgs) {
      buffer.putUint8(136);
      writeValue(buffer, value.index);
    } else if (value is MyCacheModeArgs) {
      buffer.putUint8(137);
      writeValue(buffer, value.index);
    } else if (value is MyManufacturerSpecificDataArgs) {
      buffer.putUint8(138);
      writeValue(buffer, value.encode());
    } else if (value is MyAdvertisementArgs) {
      buffer.putUint8(139);
      writeValue(buffer, value.encode());
    } else if (value is MyCentralArgs) {
      buffer.putUint8(140);
      writeValue(buffer, value.encode());
    } else if (value is MyPeripheralArgs) {
      buffer.putUint8(141);
      writeValue(buffer, value.encode());
    } else if (value is MyGATTDescriptorArgs) {
      buffer.putUint8(142);
      writeValue(buffer, value.encode());
    } else if (value is MyGATTCharacteristicArgs) {
      buffer.putUint8(143);
      writeValue(buffer, value.encode());
    } else if (value is MyGATTServiceArgs) {
      buffer.putUint8(144);
      writeValue(buffer, value.encode());
    } else if (value is MyMutableGATTDescriptorArgs) {
      buffer.putUint8(145);
      writeValue(buffer, value.encode());
    } else if (value is MyMutableGATTCharacteristicArgs) {
      buffer.putUint8(146);
      writeValue(buffer, value.encode());
    } else if (value is MyMutableGATTServiceArgs) {
      buffer.putUint8(147);
      writeValue(buffer, value.encode());
    } else if (value is MyGATTReadRequestArgs) {
      buffer.putUint8(148);
      writeValue(buffer, value.encode());
    } else if (value is MyGATTWriteRequestArgs) {
      buffer.putUint8(149);
      writeValue(buffer, value.encode());
    } else {
      super.writeValue(buffer, value);
    }
  }

  @override
  Object? readValueOfType(int type, ReadBuffer buffer) {
    switch (type) {
      case 129:
        final int? value = readValue(buffer) as int?;
        return value == null
            ? null
            : MyBluetoothLowEnergyStateArgs.values[value];
      case 130:
        final int? value = readValue(buffer) as int?;
        return value == null ? null : MyAdvertisementTypeArgs.values[value];
      case 131:
        final int? value = readValue(buffer) as int?;
        return value == null ? null : MyConnectionStateArgs.values[value];
      case 132:
        final int? value = readValue(buffer) as int?;
        return value == null
            ? null
            : MyGATTCharacteristicPropertyArgs.values[value];
      case 133:
        final int? value = readValue(buffer) as int?;
        return value == null
            ? null
            : MyGATTCharacteristicWriteTypeArgs.values[value];
      case 134:
        final int? value = readValue(buffer) as int?;
        return value == null
            ? null
            : MyGATTCharacteristicNotifyStateArgs.values[value];
      case 135:
        final int? value = readValue(buffer) as int?;
        return value == null ? null : MyGATTProtectionLevelArgs.values[value];
      case 136:
        final int? value = readValue(buffer) as int?;
        return value == null ? null : MyGATTProtocolErrorArgs.values[value];
      case 137:
        final int? value = readValue(buffer) as int?;
        return value == null ? null : MyCacheModeArgs.values[value];
      case 138:
        return MyManufacturerSpecificDataArgs.decode(readValue(buffer)!);
      case 139:
        return MyAdvertisementArgs.decode(readValue(buffer)!);
      case 140:
        return MyCentralArgs.decode(readValue(buffer)!);
      case 141:
        return MyPeripheralArgs.decode(readValue(buffer)!);
      case 142:
        return MyGATTDescriptorArgs.decode(readValue(buffer)!);
      case 143:
        return MyGATTCharacteristicArgs.decode(readValue(buffer)!);
      case 144:
        return MyGATTServiceArgs.decode(readValue(buffer)!);
      case 145:
        return MyMutableGATTDescriptorArgs.decode(readValue(buffer)!);
      case 146:
        return MyMutableGATTCharacteristicArgs.decode(readValue(buffer)!);
      case 147:
        return MyMutableGATTServiceArgs.decode(readValue(buffer)!);
      case 148:
        return MyGATTReadRequestArgs.decode(readValue(buffer)!);
      case 149:
        return MyGATTWriteRequestArgs.decode(readValue(buffer)!);
      default:
        return super.readValueOfType(type, buffer);
    }
  }
}

class MyCentralManagerHostAPI {
  /// Constructor for [MyCentralManagerHostAPI].  The [binaryMessenger] named argument is
  /// available for dependency injection.  If it is left null, the default
  /// BinaryMessenger will be used which routes to the host platform.
  MyCentralManagerHostAPI({
    BinaryMessenger? binaryMessenger,
    String messageChannelSuffix = '',
  }) : pigeonVar_binaryMessenger = binaryMessenger,
       pigeonVar_messageChannelSuffix =
           messageChannelSuffix.isNotEmpty ? '.$messageChannelSuffix' : '';
  final BinaryMessenger? pigeonVar_binaryMessenger;

  static const MessageCodec<Object?> pigeonChannelCodec = _PigeonCodec();

  final String pigeonVar_messageChannelSuffix;

  Future<void> initialize() async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_windows.MyCentralManagerHostAPI.initialize$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(null);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<MyBluetoothLowEnergyStateArgs> getState() async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_windows.MyCentralManagerHostAPI.getState$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(null);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as MyBluetoothLowEnergyStateArgs?)!;
    }
  }

  Future<void> startDiscovery(List<String> serviceUUIDsArgs) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_windows.MyCentralManagerHostAPI.startDiscovery$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[serviceUUIDsArgs],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> stopDiscovery() async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_windows.MyCentralManagerHostAPI.stopDiscovery$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(null);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> connect(int addressArgs) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_windows.MyCentralManagerHostAPI.connect$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[addressArgs],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> disconnect(int addressArgs) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_windows.MyCentralManagerHostAPI.disconnect$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[addressArgs],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<int> getMTU(int addressArgs) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_windows.MyCentralManagerHostAPI.getMTU$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[addressArgs],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as int?)!;
    }
  }

  Future<List<MyGATTServiceArgs>> getServices(
    int addressArgs,
    MyCacheModeArgs modeArgs,
  ) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_windows.MyCentralManagerHostAPI.getServices$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[addressArgs, modeArgs],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as List<Object?>?)!
          .cast<MyGATTServiceArgs>();
    }
  }

  Future<List<MyGATTServiceArgs>> getIncludedServices(
    int addressArgs,
    int handleArgs,
    MyCacheModeArgs modeArgs,
  ) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_windows.MyCentralManagerHostAPI.getIncludedServices$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[addressArgs, handleArgs, modeArgs],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as List<Object?>?)!
          .cast<MyGATTServiceArgs>();
    }
  }

  Future<List<MyGATTCharacteristicArgs>> getCharacteristics(
    int addressArgs,
    int handleArgs,
    MyCacheModeArgs modeArgs,
  ) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_windows.MyCentralManagerHostAPI.getCharacteristics$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[addressArgs, handleArgs, modeArgs],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as List<Object?>?)!
          .cast<MyGATTCharacteristicArgs>();
    }
  }

  Future<List<MyGATTDescriptorArgs>> getDescriptors(
    int addressArgs,
    int handleArgs,
    MyCacheModeArgs modeArgs,
  ) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_windows.MyCentralManagerHostAPI.getDescriptors$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[addressArgs, handleArgs, modeArgs],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as List<Object?>?)!
          .cast<MyGATTDescriptorArgs>();
    }
  }

  Future<Uint8List> readCharacteristic(
    int addressArgs,
    int handleArgs,
    MyCacheModeArgs modeArgs,
  ) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_windows.MyCentralManagerHostAPI.readCharacteristic$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[addressArgs, handleArgs, modeArgs],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as Uint8List?)!;
    }
  }

  Future<void> writeCharacteristic(
    int addressArgs,
    int handleArgs,
    Uint8List valueArgs,
    MyGATTCharacteristicWriteTypeArgs typeArgs,
  ) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_windows.MyCentralManagerHostAPI.writeCharacteristic$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[addressArgs, handleArgs, valueArgs, typeArgs],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> setCharacteristicNotifyState(
    int addressArgs,
    int handleArgs,
    MyGATTCharacteristicNotifyStateArgs stateArgs,
  ) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_windows.MyCentralManagerHostAPI.setCharacteristicNotifyState$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[addressArgs, handleArgs, stateArgs],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<Uint8List> readDescriptor(
    int addressArgs,
    int handleArgs,
    MyCacheModeArgs modeArgs,
  ) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_windows.MyCentralManagerHostAPI.readDescriptor$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[addressArgs, handleArgs, modeArgs],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as Uint8List?)!;
    }
  }

  Future<void> writeDescriptor(
    int addressArgs,
    int handleArgs,
    Uint8List valueArgs,
  ) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_windows.MyCentralManagerHostAPI.writeDescriptor$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[addressArgs, handleArgs, valueArgs],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }
}

abstract class MyCentralManagerFlutterAPI {
  static const MessageCodec<Object?> pigeonChannelCodec = _PigeonCodec();

  void onStateChanged(MyBluetoothLowEnergyStateArgs stateArgs);

  void onDiscovered(
    MyPeripheralArgs peripheralArgs,
    int rssiArgs,
    int timestampArgs,
    MyAdvertisementTypeArgs typeArgs,
    MyAdvertisementArgs advertisementArgs,
  );

  void onConnectionStateChanged(
    MyPeripheralArgs peripheralArgs,
    MyConnectionStateArgs stateArgs,
  );

  void onMTUChanged(MyPeripheralArgs peripheralArgs, int mtuArgs);

  void onCharacteristicNotified(
    MyPeripheralArgs peripheralArgs,
    MyGATTCharacteristicArgs characteristicArgs,
    Uint8List valueArgs,
  );

  static void setUp(
    MyCentralManagerFlutterAPI? api, {
    BinaryMessenger? binaryMessenger,
    String messageChannelSuffix = '',
  }) {
    messageChannelSuffix =
        messageChannelSuffix.isNotEmpty ? '.$messageChannelSuffix' : '';
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.bluetooth_low_energy_windows.MyCentralManagerFlutterAPI.onStateChanged$messageChannelSuffix',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_windows.MyCentralManagerFlutterAPI.onStateChanged was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final MyBluetoothLowEnergyStateArgs? arg_stateArgs =
              (args[0] as MyBluetoothLowEnergyStateArgs?);
          assert(
            arg_stateArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_windows.MyCentralManagerFlutterAPI.onStateChanged was null, expected non-null MyBluetoothLowEnergyStateArgs.',
          );
          try {
            api.onStateChanged(arg_stateArgs!);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.bluetooth_low_energy_windows.MyCentralManagerFlutterAPI.onDiscovered$messageChannelSuffix',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_windows.MyCentralManagerFlutterAPI.onDiscovered was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final MyPeripheralArgs? arg_peripheralArgs =
              (args[0] as MyPeripheralArgs?);
          assert(
            arg_peripheralArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_windows.MyCentralManagerFlutterAPI.onDiscovered was null, expected non-null MyPeripheralArgs.',
          );
          final int? arg_rssiArgs = (args[1] as int?);
          assert(
            arg_rssiArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_windows.MyCentralManagerFlutterAPI.onDiscovered was null, expected non-null int.',
          );
          final int? arg_timestampArgs = (args[2] as int?);
          assert(
            arg_timestampArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_windows.MyCentralManagerFlutterAPI.onDiscovered was null, expected non-null int.',
          );
          final MyAdvertisementTypeArgs? arg_typeArgs =
              (args[3] as MyAdvertisementTypeArgs?);
          assert(
            arg_typeArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_windows.MyCentralManagerFlutterAPI.onDiscovered was null, expected non-null MyAdvertisementTypeArgs.',
          );
          final MyAdvertisementArgs? arg_advertisementArgs =
              (args[4] as MyAdvertisementArgs?);
          assert(
            arg_advertisementArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_windows.MyCentralManagerFlutterAPI.onDiscovered was null, expected non-null MyAdvertisementArgs.',
          );
          try {
            api.onDiscovered(
              arg_peripheralArgs!,
              arg_rssiArgs!,
              arg_timestampArgs!,
              arg_typeArgs!,
              arg_advertisementArgs!,
            );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.bluetooth_low_energy_windows.MyCentralManagerFlutterAPI.onConnectionStateChanged$messageChannelSuffix',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_windows.MyCentralManagerFlutterAPI.onConnectionStateChanged was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final MyPeripheralArgs? arg_peripheralArgs =
              (args[0] as MyPeripheralArgs?);
          assert(
            arg_peripheralArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_windows.MyCentralManagerFlutterAPI.onConnectionStateChanged was null, expected non-null MyPeripheralArgs.',
          );
          final MyConnectionStateArgs? arg_stateArgs =
              (args[1] as MyConnectionStateArgs?);
          assert(
            arg_stateArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_windows.MyCentralManagerFlutterAPI.onConnectionStateChanged was null, expected non-null MyConnectionStateArgs.',
          );
          try {
            api.onConnectionStateChanged(arg_peripheralArgs!, arg_stateArgs!);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.bluetooth_low_energy_windows.MyCentralManagerFlutterAPI.onMTUChanged$messageChannelSuffix',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_windows.MyCentralManagerFlutterAPI.onMTUChanged was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final MyPeripheralArgs? arg_peripheralArgs =
              (args[0] as MyPeripheralArgs?);
          assert(
            arg_peripheralArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_windows.MyCentralManagerFlutterAPI.onMTUChanged was null, expected non-null MyPeripheralArgs.',
          );
          final int? arg_mtuArgs = (args[1] as int?);
          assert(
            arg_mtuArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_windows.MyCentralManagerFlutterAPI.onMTUChanged was null, expected non-null int.',
          );
          try {
            api.onMTUChanged(arg_peripheralArgs!, arg_mtuArgs!);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.bluetooth_low_energy_windows.MyCentralManagerFlutterAPI.onCharacteristicNotified$messageChannelSuffix',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_windows.MyCentralManagerFlutterAPI.onCharacteristicNotified was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final MyPeripheralArgs? arg_peripheralArgs =
              (args[0] as MyPeripheralArgs?);
          assert(
            arg_peripheralArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_windows.MyCentralManagerFlutterAPI.onCharacteristicNotified was null, expected non-null MyPeripheralArgs.',
          );
          final MyGATTCharacteristicArgs? arg_characteristicArgs =
              (args[1] as MyGATTCharacteristicArgs?);
          assert(
            arg_characteristicArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_windows.MyCentralManagerFlutterAPI.onCharacteristicNotified was null, expected non-null MyGATTCharacteristicArgs.',
          );
          final Uint8List? arg_valueArgs = (args[2] as Uint8List?);
          assert(
            arg_valueArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_windows.MyCentralManagerFlutterAPI.onCharacteristicNotified was null, expected non-null Uint8List.',
          );
          try {
            api.onCharacteristicNotified(
              arg_peripheralArgs!,
              arg_characteristicArgs!,
              arg_valueArgs!,
            );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }
}

class MyPeripheralManagerHostAPI {
  /// Constructor for [MyPeripheralManagerHostAPI].  The [binaryMessenger] named argument is
  /// available for dependency injection.  If it is left null, the default
  /// BinaryMessenger will be used which routes to the host platform.
  MyPeripheralManagerHostAPI({
    BinaryMessenger? binaryMessenger,
    String messageChannelSuffix = '',
  }) : pigeonVar_binaryMessenger = binaryMessenger,
       pigeonVar_messageChannelSuffix =
           messageChannelSuffix.isNotEmpty ? '.$messageChannelSuffix' : '';
  final BinaryMessenger? pigeonVar_binaryMessenger;

  static const MessageCodec<Object?> pigeonChannelCodec = _PigeonCodec();

  final String pigeonVar_messageChannelSuffix;

  Future<void> initialize() async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerHostAPI.initialize$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(null);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<MyBluetoothLowEnergyStateArgs> getState() async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerHostAPI.getState$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(null);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as MyBluetoothLowEnergyStateArgs?)!;
    }
  }

  Future<void> addService(MyMutableGATTServiceArgs serviceArgs) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerHostAPI.addService$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[serviceArgs],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> removeService(int hashCodeArgs) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerHostAPI.removeService$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[hashCodeArgs],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> startAdvertising(MyAdvertisementArgs advertisementArgs) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerHostAPI.startAdvertising$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[advertisementArgs],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> stopAdvertising() async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerHostAPI.stopAdvertising$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(null);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<int> getMaxNotificationSize(int addressArgs) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerHostAPI.getMaxNotificationSize$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[addressArgs],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as int?)!;
    }
  }

  Future<void> respondReadRequestWithValue(
    int idArgs,
    Uint8List valueArgs,
  ) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerHostAPI.respondReadRequestWithValue$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[idArgs, valueArgs],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> respondReadRequestWithProtocolError(
    int idArgs,
    MyGATTProtocolErrorArgs errorArgs,
  ) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerHostAPI.respondReadRequestWithProtocolError$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[idArgs, errorArgs],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> respondWriteRequest(int idArgs) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerHostAPI.respondWriteRequest$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[idArgs],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> respondWriteRequestWithProtocolError(
    int idArgs,
    MyGATTProtocolErrorArgs errorArgs,
  ) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerHostAPI.respondWriteRequestWithProtocolError$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[idArgs, errorArgs],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> notifyValue(
    int addressArgs,
    int hashCodeArgs,
    Uint8List valueArgs,
  ) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerHostAPI.notifyValue$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[addressArgs, hashCodeArgs, valueArgs],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }
}

abstract class MyPeripheralManagerFlutterAPI {
  static const MessageCodec<Object?> pigeonChannelCodec = _PigeonCodec();

  void onStateChanged(MyBluetoothLowEnergyStateArgs stateArgs);

  void onMTUChanged(MyCentralArgs centralArgs, int mtuArgs);

  void onCharacteristicReadRequest(
    MyCentralArgs centralArgs,
    int hashCodeArgs,
    MyGATTReadRequestArgs requestArgs,
  );

  void onCharacteristicWriteRequest(
    MyCentralArgs centralArgs,
    int hashCodeArgs,
    MyGATTWriteRequestArgs requestArgs,
  );

  void onCharacteristicSubscribedClientsChanged(
    int hashCodeArgs,
    List<MyCentralArgs> centralsArgs,
  );

  void onDescriptorReadRequest(
    MyCentralArgs centralArgs,
    int hashCodeArgs,
    MyGATTReadRequestArgs requestArgs,
  );

  void onDescriptorWriteRequest(
    MyCentralArgs centralArgs,
    int hashCodeArgs,
    MyGATTWriteRequestArgs requestArgs,
  );

  static void setUp(
    MyPeripheralManagerFlutterAPI? api, {
    BinaryMessenger? binaryMessenger,
    String messageChannelSuffix = '',
  }) {
    messageChannelSuffix =
        messageChannelSuffix.isNotEmpty ? '.$messageChannelSuffix' : '';
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerFlutterAPI.onStateChanged$messageChannelSuffix',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerFlutterAPI.onStateChanged was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final MyBluetoothLowEnergyStateArgs? arg_stateArgs =
              (args[0] as MyBluetoothLowEnergyStateArgs?);
          assert(
            arg_stateArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerFlutterAPI.onStateChanged was null, expected non-null MyBluetoothLowEnergyStateArgs.',
          );
          try {
            api.onStateChanged(arg_stateArgs!);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerFlutterAPI.onMTUChanged$messageChannelSuffix',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerFlutterAPI.onMTUChanged was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final MyCentralArgs? arg_centralArgs = (args[0] as MyCentralArgs?);
          assert(
            arg_centralArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerFlutterAPI.onMTUChanged was null, expected non-null MyCentralArgs.',
          );
          final int? arg_mtuArgs = (args[1] as int?);
          assert(
            arg_mtuArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerFlutterAPI.onMTUChanged was null, expected non-null int.',
          );
          try {
            api.onMTUChanged(arg_centralArgs!, arg_mtuArgs!);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerFlutterAPI.onCharacteristicReadRequest$messageChannelSuffix',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerFlutterAPI.onCharacteristicReadRequest was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final MyCentralArgs? arg_centralArgs = (args[0] as MyCentralArgs?);
          assert(
            arg_centralArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerFlutterAPI.onCharacteristicReadRequest was null, expected non-null MyCentralArgs.',
          );
          final int? arg_hashCodeArgs = (args[1] as int?);
          assert(
            arg_hashCodeArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerFlutterAPI.onCharacteristicReadRequest was null, expected non-null int.',
          );
          final MyGATTReadRequestArgs? arg_requestArgs =
              (args[2] as MyGATTReadRequestArgs?);
          assert(
            arg_requestArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerFlutterAPI.onCharacteristicReadRequest was null, expected non-null MyGATTReadRequestArgs.',
          );
          try {
            api.onCharacteristicReadRequest(
              arg_centralArgs!,
              arg_hashCodeArgs!,
              arg_requestArgs!,
            );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerFlutterAPI.onCharacteristicWriteRequest$messageChannelSuffix',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerFlutterAPI.onCharacteristicWriteRequest was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final MyCentralArgs? arg_centralArgs = (args[0] as MyCentralArgs?);
          assert(
            arg_centralArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerFlutterAPI.onCharacteristicWriteRequest was null, expected non-null MyCentralArgs.',
          );
          final int? arg_hashCodeArgs = (args[1] as int?);
          assert(
            arg_hashCodeArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerFlutterAPI.onCharacteristicWriteRequest was null, expected non-null int.',
          );
          final MyGATTWriteRequestArgs? arg_requestArgs =
              (args[2] as MyGATTWriteRequestArgs?);
          assert(
            arg_requestArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerFlutterAPI.onCharacteristicWriteRequest was null, expected non-null MyGATTWriteRequestArgs.',
          );
          try {
            api.onCharacteristicWriteRequest(
              arg_centralArgs!,
              arg_hashCodeArgs!,
              arg_requestArgs!,
            );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerFlutterAPI.onCharacteristicSubscribedClientsChanged$messageChannelSuffix',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerFlutterAPI.onCharacteristicSubscribedClientsChanged was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_hashCodeArgs = (args[0] as int?);
          assert(
            arg_hashCodeArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerFlutterAPI.onCharacteristicSubscribedClientsChanged was null, expected non-null int.',
          );
          final List<MyCentralArgs>? arg_centralsArgs =
              (args[1] as List<Object?>?)?.cast<MyCentralArgs>();
          assert(
            arg_centralsArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerFlutterAPI.onCharacteristicSubscribedClientsChanged was null, expected non-null List<MyCentralArgs>.',
          );
          try {
            api.onCharacteristicSubscribedClientsChanged(
              arg_hashCodeArgs!,
              arg_centralsArgs!,
            );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerFlutterAPI.onDescriptorReadRequest$messageChannelSuffix',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerFlutterAPI.onDescriptorReadRequest was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final MyCentralArgs? arg_centralArgs = (args[0] as MyCentralArgs?);
          assert(
            arg_centralArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerFlutterAPI.onDescriptorReadRequest was null, expected non-null MyCentralArgs.',
          );
          final int? arg_hashCodeArgs = (args[1] as int?);
          assert(
            arg_hashCodeArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerFlutterAPI.onDescriptorReadRequest was null, expected non-null int.',
          );
          final MyGATTReadRequestArgs? arg_requestArgs =
              (args[2] as MyGATTReadRequestArgs?);
          assert(
            arg_requestArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerFlutterAPI.onDescriptorReadRequest was null, expected non-null MyGATTReadRequestArgs.',
          );
          try {
            api.onDescriptorReadRequest(
              arg_centralArgs!,
              arg_hashCodeArgs!,
              arg_requestArgs!,
            );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerFlutterAPI.onDescriptorWriteRequest$messageChannelSuffix',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerFlutterAPI.onDescriptorWriteRequest was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final MyCentralArgs? arg_centralArgs = (args[0] as MyCentralArgs?);
          assert(
            arg_centralArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerFlutterAPI.onDescriptorWriteRequest was null, expected non-null MyCentralArgs.',
          );
          final int? arg_hashCodeArgs = (args[1] as int?);
          assert(
            arg_hashCodeArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerFlutterAPI.onDescriptorWriteRequest was null, expected non-null int.',
          );
          final MyGATTWriteRequestArgs? arg_requestArgs =
              (args[2] as MyGATTWriteRequestArgs?);
          assert(
            arg_requestArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_windows.MyPeripheralManagerFlutterAPI.onDescriptorWriteRequest was null, expected non-null MyGATTWriteRequestArgs.',
          );
          try {
            api.onDescriptorWriteRequest(
              arg_centralArgs!,
              arg_hashCodeArgs!,
              arg_requestArgs!,
            );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }
}
