// Autogenerated from Pigeon (v26.0.0), do not edit directly.
// See also: https://pub.dev/packages/pigeon
// ignore_for_file: public_member_api_docs, non_constant_identifier_names, avoid_as, unused_import, unnecessary_parenthesis, prefer_null_aware_operators, omit_local_variable_types, unused_shown_name, unnecessary_import, no_leading_underscores_for_local_identifiers

import 'dart:async';
import 'dart:typed_data' show Float64List, Int32List, Int64List, Uint8List;

import 'package:flutter/foundation.dart' show ReadBuffer, WriteBuffer;
import 'package:flutter/services.dart';

PlatformException _createConnectionError(String channelName) {
  return PlatformException(
    code: 'channel-error',
    message: 'Unable to establish connection on channel: "$channelName".',
  );
}

List<Object?> wrapResponse({
  Object? result,
  PlatformException? error,
  bool empty = false,
}) {
  if (empty) {
    return <Object?>[];
  }
  if (error == null) {
    return <Object?>[result];
  }
  return <Object?>[error.code, error.message, error.details];
}

bool _deepEquals(Object? a, Object? b) {
  if (a is List && b is List) {
    return a.length == b.length &&
        a.indexed.every(
          ((int, dynamic) item) => _deepEquals(item.$2, b[item.$1]),
        );
  }
  if (a is Map && b is Map) {
    return a.length == b.length &&
        a.entries.every(
          (MapEntry<Object?, Object?> entry) =>
              (b as Map<Object?, Object?>).containsKey(entry.key) &&
              _deepEquals(entry.value, b[entry.key]),
        );
  }
  return a == b;
}

enum MyBluetoothLowEnergyStateArgs {
  unknown,
  resetting,
  unsupported,
  unauthorized,
  poweredOff,
  poweredOn,
}

enum MyConnectionStateArgs { disconnected, connected }

enum MyGATTCharacteristicPropertyArgs {
  read,
  write,
  writeWithoutResponse,
  notify,
  indicate,
}

enum MyGATTCharacteristicPermissionArgs {
  read,
  readEncrypted,
  write,
  writeEncrypted,
}

enum MyGATTCharacteristicWriteTypeArgs { withResponse, withoutResponse }

enum MyATTErrorArgs {
  success,
  invalidHandle,
  readNotPermitted,
  writeNotPermitted,
  invalidPDU,
  insufficientAuthentication,
  requestNotSupported,
  invalidOffset,
  insufficientAuthorization,
  prepareQueueFull,
  attributeNotFound,
  attributeNotLong,
  insufficientEncryptionKeySize,
  invalidAttributeValueLength,
  unlikelyError,
  insufficientEncryption,
  unsupportedGroupType,
  insufficientResources,
}

class MyManufacturerSpecificDataArgs {
  MyManufacturerSpecificDataArgs({
    required this.idArgs,
    required this.dataArgs,
  });

  int idArgs;

  Uint8List dataArgs;

  List<Object?> _toList() {
    return <Object?>[idArgs, dataArgs];
  }

  Object encode() {
    return _toList();
  }

  static MyManufacturerSpecificDataArgs decode(Object result) {
    result as List<Object?>;
    return MyManufacturerSpecificDataArgs(
      idArgs: result[0]! as int,
      dataArgs: result[1]! as Uint8List,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! MyManufacturerSpecificDataArgs ||
        other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList());
}

class MyAdvertisementArgs {
  MyAdvertisementArgs({
    this.nameArgs,
    required this.serviceUUIDsArgs,
    required this.serviceDataArgs,
    this.manufacturerSpecificDataArgs,
  });

  String? nameArgs;

  List<String?> serviceUUIDsArgs;

  Map<String?, Uint8List?> serviceDataArgs;

  Uint8List? manufacturerSpecificDataArgs;

  List<Object?> _toList() {
    return <Object?>[
      nameArgs,
      serviceUUIDsArgs,
      serviceDataArgs,
      manufacturerSpecificDataArgs,
    ];
  }

  Object encode() {
    return _toList();
  }

  static MyAdvertisementArgs decode(Object result) {
    result as List<Object?>;
    return MyAdvertisementArgs(
      nameArgs: result[0] as String?,
      serviceUUIDsArgs: (result[1] as List<Object?>?)!.cast<String?>(),
      serviceDataArgs:
          (result[2] as Map<Object?, Object?>?)!.cast<String?, Uint8List?>(),
      manufacturerSpecificDataArgs: result[3] as Uint8List?,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! MyAdvertisementArgs || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList());
}

class MyCentralArgs {
  MyCentralArgs({required this.uuidArgs});

  String uuidArgs;

  List<Object?> _toList() {
    return <Object?>[uuidArgs];
  }

  Object encode() {
    return _toList();
  }

  static MyCentralArgs decode(Object result) {
    result as List<Object?>;
    return MyCentralArgs(uuidArgs: result[0]! as String);
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! MyCentralArgs || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList());
}

class MyPeripheralArgs {
  MyPeripheralArgs({required this.uuidArgs});

  String uuidArgs;

  List<Object?> _toList() {
    return <Object?>[uuidArgs];
  }

  Object encode() {
    return _toList();
  }

  static MyPeripheralArgs decode(Object result) {
    result as List<Object?>;
    return MyPeripheralArgs(uuidArgs: result[0]! as String);
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! MyPeripheralArgs || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList());
}

class MyGATTDescriptorArgs {
  MyGATTDescriptorArgs({required this.hashCodeArgs, required this.uuidArgs});

  int hashCodeArgs;

  String uuidArgs;

  List<Object?> _toList() {
    return <Object?>[hashCodeArgs, uuidArgs];
  }

  Object encode() {
    return _toList();
  }

  static MyGATTDescriptorArgs decode(Object result) {
    result as List<Object?>;
    return MyGATTDescriptorArgs(
      hashCodeArgs: result[0]! as int,
      uuidArgs: result[1]! as String,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! MyGATTDescriptorArgs || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList());
}

class MyGATTCharacteristicArgs {
  MyGATTCharacteristicArgs({
    required this.hashCodeArgs,
    required this.uuidArgs,
    required this.propertyNumbersArgs,
    required this.descriptorsArgs,
  });

  int hashCodeArgs;

  String uuidArgs;

  List<int?> propertyNumbersArgs;

  List<MyGATTDescriptorArgs?> descriptorsArgs;

  List<Object?> _toList() {
    return <Object?>[
      hashCodeArgs,
      uuidArgs,
      propertyNumbersArgs,
      descriptorsArgs,
    ];
  }

  Object encode() {
    return _toList();
  }

  static MyGATTCharacteristicArgs decode(Object result) {
    result as List<Object?>;
    return MyGATTCharacteristicArgs(
      hashCodeArgs: result[0]! as int,
      uuidArgs: result[1]! as String,
      propertyNumbersArgs: (result[2] as List<Object?>?)!.cast<int?>(),
      descriptorsArgs:
          (result[3] as List<Object?>?)!.cast<MyGATTDescriptorArgs?>(),
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! MyGATTCharacteristicArgs ||
        other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList());
}

class MyGATTServiceArgs {
  MyGATTServiceArgs({
    required this.hashCodeArgs,
    required this.uuidArgs,
    required this.isPrimaryArgs,
    required this.includedServicesArgs,
    required this.characteristicsArgs,
  });

  int hashCodeArgs;

  String uuidArgs;

  bool isPrimaryArgs;

  List<MyGATTServiceArgs?> includedServicesArgs;

  List<MyGATTCharacteristicArgs?> characteristicsArgs;

  List<Object?> _toList() {
    return <Object?>[
      hashCodeArgs,
      uuidArgs,
      isPrimaryArgs,
      includedServicesArgs,
      characteristicsArgs,
    ];
  }

  Object encode() {
    return _toList();
  }

  static MyGATTServiceArgs decode(Object result) {
    result as List<Object?>;
    return MyGATTServiceArgs(
      hashCodeArgs: result[0]! as int,
      uuidArgs: result[1]! as String,
      isPrimaryArgs: result[2]! as bool,
      includedServicesArgs:
          (result[3] as List<Object?>?)!.cast<MyGATTServiceArgs?>(),
      characteristicsArgs:
          (result[4] as List<Object?>?)!.cast<MyGATTCharacteristicArgs?>(),
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! MyGATTServiceArgs || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList());
}

class MyMutableGATTDescriptorArgs {
  MyMutableGATTDescriptorArgs({
    required this.hashCodeArgs,
    required this.uuidArgs,
    this.valueArgs,
  });

  int hashCodeArgs;

  String uuidArgs;

  Uint8List? valueArgs;

  List<Object?> _toList() {
    return <Object?>[hashCodeArgs, uuidArgs, valueArgs];
  }

  Object encode() {
    return _toList();
  }

  static MyMutableGATTDescriptorArgs decode(Object result) {
    result as List<Object?>;
    return MyMutableGATTDescriptorArgs(
      hashCodeArgs: result[0]! as int,
      uuidArgs: result[1]! as String,
      valueArgs: result[2] as Uint8List?,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! MyMutableGATTDescriptorArgs ||
        other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList());
}

class MyMutableGATTCharacteristicArgs {
  MyMutableGATTCharacteristicArgs({
    required this.hashCodeArgs,
    required this.uuidArgs,
    required this.propertyNumbersArgs,
    required this.permissionNumbersArgs,
    this.valueArgs,
    required this.descriptorsArgs,
  });

  int hashCodeArgs;

  String uuidArgs;

  List<int?> propertyNumbersArgs;

  List<int?> permissionNumbersArgs;

  Uint8List? valueArgs;

  List<MyMutableGATTDescriptorArgs?> descriptorsArgs;

  List<Object?> _toList() {
    return <Object?>[
      hashCodeArgs,
      uuidArgs,
      propertyNumbersArgs,
      permissionNumbersArgs,
      valueArgs,
      descriptorsArgs,
    ];
  }

  Object encode() {
    return _toList();
  }

  static MyMutableGATTCharacteristicArgs decode(Object result) {
    result as List<Object?>;
    return MyMutableGATTCharacteristicArgs(
      hashCodeArgs: result[0]! as int,
      uuidArgs: result[1]! as String,
      propertyNumbersArgs: (result[2] as List<Object?>?)!.cast<int?>(),
      permissionNumbersArgs: (result[3] as List<Object?>?)!.cast<int?>(),
      valueArgs: result[4] as Uint8List?,
      descriptorsArgs:
          (result[5] as List<Object?>?)!.cast<MyMutableGATTDescriptorArgs?>(),
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! MyMutableGATTCharacteristicArgs ||
        other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList());
}

class MyMutableGATTServiceArgs {
  MyMutableGATTServiceArgs({
    required this.hashCodeArgs,
    required this.uuidArgs,
    required this.isPrimaryArgs,
    required this.includedServicesArgs,
    required this.characteristicsArgs,
  });

  int hashCodeArgs;

  String uuidArgs;

  bool isPrimaryArgs;

  List<MyMutableGATTServiceArgs?> includedServicesArgs;

  List<MyMutableGATTCharacteristicArgs?> characteristicsArgs;

  List<Object?> _toList() {
    return <Object?>[
      hashCodeArgs,
      uuidArgs,
      isPrimaryArgs,
      includedServicesArgs,
      characteristicsArgs,
    ];
  }

  Object encode() {
    return _toList();
  }

  static MyMutableGATTServiceArgs decode(Object result) {
    result as List<Object?>;
    return MyMutableGATTServiceArgs(
      hashCodeArgs: result[0]! as int,
      uuidArgs: result[1]! as String,
      isPrimaryArgs: result[2]! as bool,
      includedServicesArgs:
          (result[3] as List<Object?>?)!.cast<MyMutableGATTServiceArgs?>(),
      characteristicsArgs:
          (result[4] as List<Object?>?)!
              .cast<MyMutableGATTCharacteristicArgs?>(),
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! MyMutableGATTServiceArgs ||
        other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList());
}

class MyATTRequestArgs {
  MyATTRequestArgs({
    required this.hashCodeArgs,
    required this.centralArgs,
    required this.characteristicHashCodeArgs,
    this.valueArgs,
    required this.offsetArgs,
  });

  int hashCodeArgs;

  MyCentralArgs centralArgs;

  int characteristicHashCodeArgs;

  Uint8List? valueArgs;

  int offsetArgs;

  List<Object?> _toList() {
    return <Object?>[
      hashCodeArgs,
      centralArgs,
      characteristicHashCodeArgs,
      valueArgs,
      offsetArgs,
    ];
  }

  Object encode() {
    return _toList();
  }

  static MyATTRequestArgs decode(Object result) {
    result as List<Object?>;
    return MyATTRequestArgs(
      hashCodeArgs: result[0]! as int,
      centralArgs: result[1]! as MyCentralArgs,
      characteristicHashCodeArgs: result[2]! as int,
      valueArgs: result[3] as Uint8List?,
      offsetArgs: result[4]! as int,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! MyATTRequestArgs || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList());
}

class _PigeonCodec extends StandardMessageCodec {
  const _PigeonCodec();
  @override
  void writeValue(WriteBuffer buffer, Object? value) {
    if (value is int) {
      buffer.putUint8(4);
      buffer.putInt64(value);
    } else if (value is MyBluetoothLowEnergyStateArgs) {
      buffer.putUint8(129);
      writeValue(buffer, value.index);
    } else if (value is MyConnectionStateArgs) {
      buffer.putUint8(130);
      writeValue(buffer, value.index);
    } else if (value is MyGATTCharacteristicPropertyArgs) {
      buffer.putUint8(131);
      writeValue(buffer, value.index);
    } else if (value is MyGATTCharacteristicPermissionArgs) {
      buffer.putUint8(132);
      writeValue(buffer, value.index);
    } else if (value is MyGATTCharacteristicWriteTypeArgs) {
      buffer.putUint8(133);
      writeValue(buffer, value.index);
    } else if (value is MyATTErrorArgs) {
      buffer.putUint8(134);
      writeValue(buffer, value.index);
    } else if (value is MyManufacturerSpecificDataArgs) {
      buffer.putUint8(135);
      writeValue(buffer, value.encode());
    } else if (value is MyAdvertisementArgs) {
      buffer.putUint8(136);
      writeValue(buffer, value.encode());
    } else if (value is MyCentralArgs) {
      buffer.putUint8(137);
      writeValue(buffer, value.encode());
    } else if (value is MyPeripheralArgs) {
      buffer.putUint8(138);
      writeValue(buffer, value.encode());
    } else if (value is MyGATTDescriptorArgs) {
      buffer.putUint8(139);
      writeValue(buffer, value.encode());
    } else if (value is MyGATTCharacteristicArgs) {
      buffer.putUint8(140);
      writeValue(buffer, value.encode());
    } else if (value is MyGATTServiceArgs) {
      buffer.putUint8(141);
      writeValue(buffer, value.encode());
    } else if (value is MyMutableGATTDescriptorArgs) {
      buffer.putUint8(142);
      writeValue(buffer, value.encode());
    } else if (value is MyMutableGATTCharacteristicArgs) {
      buffer.putUint8(143);
      writeValue(buffer, value.encode());
    } else if (value is MyMutableGATTServiceArgs) {
      buffer.putUint8(144);
      writeValue(buffer, value.encode());
    } else if (value is MyATTRequestArgs) {
      buffer.putUint8(145);
      writeValue(buffer, value.encode());
    } else {
      super.writeValue(buffer, value);
    }
  }

  @override
  Object? readValueOfType(int type, ReadBuffer buffer) {
    switch (type) {
      case 129:
        final int? value = readValue(buffer) as int?;
        return value == null
            ? null
            : MyBluetoothLowEnergyStateArgs.values[value];
      case 130:
        final int? value = readValue(buffer) as int?;
        return value == null ? null : MyConnectionStateArgs.values[value];
      case 131:
        final int? value = readValue(buffer) as int?;
        return value == null
            ? null
            : MyGATTCharacteristicPropertyArgs.values[value];
      case 132:
        final int? value = readValue(buffer) as int?;
        return value == null
            ? null
            : MyGATTCharacteristicPermissionArgs.values[value];
      case 133:
        final int? value = readValue(buffer) as int?;
        return value == null
            ? null
            : MyGATTCharacteristicWriteTypeArgs.values[value];
      case 134:
        final int? value = readValue(buffer) as int?;
        return value == null ? null : MyATTErrorArgs.values[value];
      case 135:
        return MyManufacturerSpecificDataArgs.decode(readValue(buffer)!);
      case 136:
        return MyAdvertisementArgs.decode(readValue(buffer)!);
      case 137:
        return MyCentralArgs.decode(readValue(buffer)!);
      case 138:
        return MyPeripheralArgs.decode(readValue(buffer)!);
      case 139:
        return MyGATTDescriptorArgs.decode(readValue(buffer)!);
      case 140:
        return MyGATTCharacteristicArgs.decode(readValue(buffer)!);
      case 141:
        return MyGATTServiceArgs.decode(readValue(buffer)!);
      case 142:
        return MyMutableGATTDescriptorArgs.decode(readValue(buffer)!);
      case 143:
        return MyMutableGATTCharacteristicArgs.decode(readValue(buffer)!);
      case 144:
        return MyMutableGATTServiceArgs.decode(readValue(buffer)!);
      case 145:
        return MyATTRequestArgs.decode(readValue(buffer)!);
      default:
        return super.readValueOfType(type, buffer);
    }
  }
}

class MyCentralManagerHostAPI {
  /// Constructor for [MyCentralManagerHostAPI].  The [binaryMessenger] named argument is
  /// available for dependency injection.  If it is left null, the default
  /// BinaryMessenger will be used which routes to the host platform.
  MyCentralManagerHostAPI({
    BinaryMessenger? binaryMessenger,
    String messageChannelSuffix = '',
  }) : pigeonVar_binaryMessenger = binaryMessenger,
       pigeonVar_messageChannelSuffix =
           messageChannelSuffix.isNotEmpty ? '.$messageChannelSuffix' : '';
  final BinaryMessenger? pigeonVar_binaryMessenger;

  static const MessageCodec<Object?> pigeonChannelCodec = _PigeonCodec();

  final String pigeonVar_messageChannelSuffix;

  Future<void> initialize() async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_darwin.MyCentralManagerHostAPI.initialize$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(null);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<MyBluetoothLowEnergyStateArgs> getState() async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_darwin.MyCentralManagerHostAPI.getState$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(null);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as MyBluetoothLowEnergyStateArgs?)!;
    }
  }

  Future<void> showAppSettings() async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_darwin.MyCentralManagerHostAPI.showAppSettings$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(null);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> startDiscovery(List<String> serviceUUIDsArgs) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_darwin.MyCentralManagerHostAPI.startDiscovery$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[serviceUUIDsArgs],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> stopDiscovery() async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_darwin.MyCentralManagerHostAPI.stopDiscovery$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(null);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<List<MyPeripheralArgs>> retrieveConnectedPeripherals() async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_darwin.MyCentralManagerHostAPI.retrieveConnectedPeripherals$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(null);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as List<Object?>?)!
          .cast<MyPeripheralArgs>();
    }
  }

  Future<void> connect(String uuidArgs) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_darwin.MyCentralManagerHostAPI.connect$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[uuidArgs],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> disconnect(String uuidArgs) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_darwin.MyCentralManagerHostAPI.disconnect$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[uuidArgs],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<int> getMaximumWriteLength(
    String uuidArgs,
    MyGATTCharacteristicWriteTypeArgs typeArgs,
  ) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_darwin.MyCentralManagerHostAPI.getMaximumWriteLength$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[uuidArgs, typeArgs],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as int?)!;
    }
  }

  Future<int> readRSSI(String uuidArgs) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_darwin.MyCentralManagerHostAPI.readRSSI$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[uuidArgs],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as int?)!;
    }
  }

  Future<List<MyGATTServiceArgs>> discoverServices(String uuidArgs) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_darwin.MyCentralManagerHostAPI.discoverServices$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[uuidArgs],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as List<Object?>?)!
          .cast<MyGATTServiceArgs>();
    }
  }

  Future<List<MyGATTServiceArgs>> discoverIncludedServices(
    String uuidArgs,
    int hashCodeArgs,
  ) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_darwin.MyCentralManagerHostAPI.discoverIncludedServices$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[uuidArgs, hashCodeArgs],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as List<Object?>?)!
          .cast<MyGATTServiceArgs>();
    }
  }

  Future<List<MyGATTCharacteristicArgs>> discoverCharacteristics(
    String uuidArgs,
    int hashCodeArgs,
  ) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_darwin.MyCentralManagerHostAPI.discoverCharacteristics$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[uuidArgs, hashCodeArgs],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as List<Object?>?)!
          .cast<MyGATTCharacteristicArgs>();
    }
  }

  Future<List<MyGATTDescriptorArgs>> discoverDescriptors(
    String uuidArgs,
    int hashCodeArgs,
  ) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_darwin.MyCentralManagerHostAPI.discoverDescriptors$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[uuidArgs, hashCodeArgs],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as List<Object?>?)!
          .cast<MyGATTDescriptorArgs>();
    }
  }

  Future<Uint8List> readCharacteristic(
    String uuidArgs,
    int hashCodeArgs,
  ) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_darwin.MyCentralManagerHostAPI.readCharacteristic$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[uuidArgs, hashCodeArgs],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as Uint8List?)!;
    }
  }

  Future<void> writeCharacteristic(
    String uuidArgs,
    int hashCodeArgs,
    Uint8List valueArgs,
    MyGATTCharacteristicWriteTypeArgs typeArgs,
  ) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_darwin.MyCentralManagerHostAPI.writeCharacteristic$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[uuidArgs, hashCodeArgs, valueArgs, typeArgs],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> setCharacteristicNotifyState(
    String uuidArgs,
    int hashCodeArgs,
    bool stateArgs,
  ) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_darwin.MyCentralManagerHostAPI.setCharacteristicNotifyState$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[uuidArgs, hashCodeArgs, stateArgs],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<Uint8List> readDescriptor(String uuidArgs, int hashCodeArgs) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_darwin.MyCentralManagerHostAPI.readDescriptor$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[uuidArgs, hashCodeArgs],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as Uint8List?)!;
    }
  }

  Future<void> writeDescriptor(
    String uuidArgs,
    int hashCodeArgs,
    Uint8List valueArgs,
  ) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_darwin.MyCentralManagerHostAPI.writeDescriptor$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[uuidArgs, hashCodeArgs, valueArgs],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }
}

abstract class MyCentralManagerFlutterAPI {
  static const MessageCodec<Object?> pigeonChannelCodec = _PigeonCodec();

  void onStateChanged(MyBluetoothLowEnergyStateArgs stateArgs);

  void onDiscovered(
    MyPeripheralArgs peripheralArgs,
    int rssiArgs,
    MyAdvertisementArgs advertisementArgs,
  );

  void onConnectionStateChanged(
    MyPeripheralArgs peripheralArgs,
    MyConnectionStateArgs stateArgs,
  );

  void onCharacteristicNotified(
    MyPeripheralArgs peripheralArgs,
    MyGATTCharacteristicArgs characteristicArgs,
    Uint8List valueArgs,
  );

  static void setUp(
    MyCentralManagerFlutterAPI? api, {
    BinaryMessenger? binaryMessenger,
    String messageChannelSuffix = '',
  }) {
    messageChannelSuffix =
        messageChannelSuffix.isNotEmpty ? '.$messageChannelSuffix' : '';
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.bluetooth_low_energy_darwin.MyCentralManagerFlutterAPI.onStateChanged$messageChannelSuffix',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_darwin.MyCentralManagerFlutterAPI.onStateChanged was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final MyBluetoothLowEnergyStateArgs? arg_stateArgs =
              (args[0] as MyBluetoothLowEnergyStateArgs?);
          assert(
            arg_stateArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_darwin.MyCentralManagerFlutterAPI.onStateChanged was null, expected non-null MyBluetoothLowEnergyStateArgs.',
          );
          try {
            api.onStateChanged(arg_stateArgs!);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.bluetooth_low_energy_darwin.MyCentralManagerFlutterAPI.onDiscovered$messageChannelSuffix',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_darwin.MyCentralManagerFlutterAPI.onDiscovered was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final MyPeripheralArgs? arg_peripheralArgs =
              (args[0] as MyPeripheralArgs?);
          assert(
            arg_peripheralArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_darwin.MyCentralManagerFlutterAPI.onDiscovered was null, expected non-null MyPeripheralArgs.',
          );
          final int? arg_rssiArgs = (args[1] as int?);
          assert(
            arg_rssiArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_darwin.MyCentralManagerFlutterAPI.onDiscovered was null, expected non-null int.',
          );
          final MyAdvertisementArgs? arg_advertisementArgs =
              (args[2] as MyAdvertisementArgs?);
          assert(
            arg_advertisementArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_darwin.MyCentralManagerFlutterAPI.onDiscovered was null, expected non-null MyAdvertisementArgs.',
          );
          try {
            api.onDiscovered(
              arg_peripheralArgs!,
              arg_rssiArgs!,
              arg_advertisementArgs!,
            );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.bluetooth_low_energy_darwin.MyCentralManagerFlutterAPI.onConnectionStateChanged$messageChannelSuffix',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_darwin.MyCentralManagerFlutterAPI.onConnectionStateChanged was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final MyPeripheralArgs? arg_peripheralArgs =
              (args[0] as MyPeripheralArgs?);
          assert(
            arg_peripheralArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_darwin.MyCentralManagerFlutterAPI.onConnectionStateChanged was null, expected non-null MyPeripheralArgs.',
          );
          final MyConnectionStateArgs? arg_stateArgs =
              (args[1] as MyConnectionStateArgs?);
          assert(
            arg_stateArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_darwin.MyCentralManagerFlutterAPI.onConnectionStateChanged was null, expected non-null MyConnectionStateArgs.',
          );
          try {
            api.onConnectionStateChanged(arg_peripheralArgs!, arg_stateArgs!);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.bluetooth_low_energy_darwin.MyCentralManagerFlutterAPI.onCharacteristicNotified$messageChannelSuffix',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_darwin.MyCentralManagerFlutterAPI.onCharacteristicNotified was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final MyPeripheralArgs? arg_peripheralArgs =
              (args[0] as MyPeripheralArgs?);
          assert(
            arg_peripheralArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_darwin.MyCentralManagerFlutterAPI.onCharacteristicNotified was null, expected non-null MyPeripheralArgs.',
          );
          final MyGATTCharacteristicArgs? arg_characteristicArgs =
              (args[1] as MyGATTCharacteristicArgs?);
          assert(
            arg_characteristicArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_darwin.MyCentralManagerFlutterAPI.onCharacteristicNotified was null, expected non-null MyGATTCharacteristicArgs.',
          );
          final Uint8List? arg_valueArgs = (args[2] as Uint8List?);
          assert(
            arg_valueArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_darwin.MyCentralManagerFlutterAPI.onCharacteristicNotified was null, expected non-null Uint8List.',
          );
          try {
            api.onCharacteristicNotified(
              arg_peripheralArgs!,
              arg_characteristicArgs!,
              arg_valueArgs!,
            );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }
}

class MyPeripheralManagerHostAPI {
  /// Constructor for [MyPeripheralManagerHostAPI].  The [binaryMessenger] named argument is
  /// available for dependency injection.  If it is left null, the default
  /// BinaryMessenger will be used which routes to the host platform.
  MyPeripheralManagerHostAPI({
    BinaryMessenger? binaryMessenger,
    String messageChannelSuffix = '',
  }) : pigeonVar_binaryMessenger = binaryMessenger,
       pigeonVar_messageChannelSuffix =
           messageChannelSuffix.isNotEmpty ? '.$messageChannelSuffix' : '';
  final BinaryMessenger? pigeonVar_binaryMessenger;

  static const MessageCodec<Object?> pigeonChannelCodec = _PigeonCodec();

  final String pigeonVar_messageChannelSuffix;

  Future<void> initialize() async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_darwin.MyPeripheralManagerHostAPI.initialize$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(null);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<MyBluetoothLowEnergyStateArgs> getState() async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_darwin.MyPeripheralManagerHostAPI.getState$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(null);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as MyBluetoothLowEnergyStateArgs?)!;
    }
  }

  Future<void> showAppSettings() async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_darwin.MyPeripheralManagerHostAPI.showAppSettings$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(null);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> addService(MyMutableGATTServiceArgs serviceArgs) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_darwin.MyPeripheralManagerHostAPI.addService$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[serviceArgs],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> removeService(int hashCodeArgs) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_darwin.MyPeripheralManagerHostAPI.removeService$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[hashCodeArgs],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> removeAllServices() async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_darwin.MyPeripheralManagerHostAPI.removeAllServices$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(null);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> startAdvertising(MyAdvertisementArgs advertisementArgs) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_darwin.MyPeripheralManagerHostAPI.startAdvertising$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[advertisementArgs],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> stopAdvertising() async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_darwin.MyPeripheralManagerHostAPI.stopAdvertising$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(null);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<int> getMaximumNotifyLength(String uuidArgs) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_darwin.MyPeripheralManagerHostAPI.getMaximumNotifyLength$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[uuidArgs],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as int?)!;
    }
  }

  Future<void> respond(
    int hashCodeArgs,
    Uint8List? valueArgs,
    MyATTErrorArgs errorArgs,
  ) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_darwin.MyPeripheralManagerHostAPI.respond$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[hashCodeArgs, valueArgs, errorArgs],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<bool> updateValue(
    int hashCodeArgs,
    Uint8List valueArgs,
    List<String>? uuidsArgs,
  ) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_darwin.MyPeripheralManagerHostAPI.updateValue$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[hashCodeArgs, valueArgs, uuidsArgs],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as bool?)!;
    }
  }
}

abstract class MyPeripheralManagerFlutterAPI {
  static const MessageCodec<Object?> pigeonChannelCodec = _PigeonCodec();

  void onStateChanged(MyBluetoothLowEnergyStateArgs stateArgs);

  void didReceiveRead(MyATTRequestArgs requestArgs);

  void didReceiveWrite(List<MyATTRequestArgs> requestsArgs);

  void isReady();

  void onCharacteristicNotifyStateChanged(
    MyCentralArgs centralArgs,
    int hashCodeArgs,
    bool stateArgs,
  );

  static void setUp(
    MyPeripheralManagerFlutterAPI? api, {
    BinaryMessenger? binaryMessenger,
    String messageChannelSuffix = '',
  }) {
    messageChannelSuffix =
        messageChannelSuffix.isNotEmpty ? '.$messageChannelSuffix' : '';
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.bluetooth_low_energy_darwin.MyPeripheralManagerFlutterAPI.onStateChanged$messageChannelSuffix',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_darwin.MyPeripheralManagerFlutterAPI.onStateChanged was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final MyBluetoothLowEnergyStateArgs? arg_stateArgs =
              (args[0] as MyBluetoothLowEnergyStateArgs?);
          assert(
            arg_stateArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_darwin.MyPeripheralManagerFlutterAPI.onStateChanged was null, expected non-null MyBluetoothLowEnergyStateArgs.',
          );
          try {
            api.onStateChanged(arg_stateArgs!);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.bluetooth_low_energy_darwin.MyPeripheralManagerFlutterAPI.didReceiveRead$messageChannelSuffix',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_darwin.MyPeripheralManagerFlutterAPI.didReceiveRead was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final MyATTRequestArgs? arg_requestArgs =
              (args[0] as MyATTRequestArgs?);
          assert(
            arg_requestArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_darwin.MyPeripheralManagerFlutterAPI.didReceiveRead was null, expected non-null MyATTRequestArgs.',
          );
          try {
            api.didReceiveRead(arg_requestArgs!);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.bluetooth_low_energy_darwin.MyPeripheralManagerFlutterAPI.didReceiveWrite$messageChannelSuffix',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_darwin.MyPeripheralManagerFlutterAPI.didReceiveWrite was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final List<MyATTRequestArgs>? arg_requestsArgs =
              (args[0] as List<Object?>?)?.cast<MyATTRequestArgs>();
          assert(
            arg_requestsArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_darwin.MyPeripheralManagerFlutterAPI.didReceiveWrite was null, expected non-null List<MyATTRequestArgs>.',
          );
          try {
            api.didReceiveWrite(arg_requestsArgs!);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.bluetooth_low_energy_darwin.MyPeripheralManagerFlutterAPI.isReady$messageChannelSuffix',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          try {
            api.isReady();
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.bluetooth_low_energy_darwin.MyPeripheralManagerFlutterAPI.onCharacteristicNotifyStateChanged$messageChannelSuffix',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_darwin.MyPeripheralManagerFlutterAPI.onCharacteristicNotifyStateChanged was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final MyCentralArgs? arg_centralArgs = (args[0] as MyCentralArgs?);
          assert(
            arg_centralArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_darwin.MyPeripheralManagerFlutterAPI.onCharacteristicNotifyStateChanged was null, expected non-null MyCentralArgs.',
          );
          final int? arg_hashCodeArgs = (args[1] as int?);
          assert(
            arg_hashCodeArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_darwin.MyPeripheralManagerFlutterAPI.onCharacteristicNotifyStateChanged was null, expected non-null int.',
          );
          final bool? arg_stateArgs = (args[2] as bool?);
          assert(
            arg_stateArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_darwin.MyPeripheralManagerFlutterAPI.onCharacteristicNotifyStateChanged was null, expected non-null bool.',
          );
          try {
            api.onCharacteristicNotifyStateChanged(
              arg_centralArgs!,
              arg_hashCodeArgs!,
              arg_stateArgs!,
            );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }
}
