// Autogenerated from Pigeon (v26.0.0), do not edit directly.
// See also: https://pub.dev/packages/pigeon

import Foundation

#if os(iOS)
  import Flutter
#elseif os(macOS)
  import FlutterMacOS
#else
  #error("Unsupported platform.")
#endif

/// Error class for passing custom error details to Dart side.
final class PigeonError: Error {
  let code: String
  let message: String?
  let details: Sendable?

  init(code: String, message: String?, details: Sendable?) {
    self.code = code
    self.message = message
    self.details = details
  }

  var localizedDescription: String {
    return
      "PigeonError(code: \(code), message: \(message ?? "<nil>"), details: \(details ?? "<nil>")"
  }
}

private func wrapResult(_ result: Any?) -> [Any?] {
  return [result]
}

private func wrapError(_ error: Any) -> [Any?] {
  if let pigeonError = error as? PigeonError {
    return [
      pigeonError.code,
      pigeonError.message,
      pigeonError.details,
    ]
  }
  if let flutterError = error as? FlutterError {
    return [
      flutterError.code,
      flutterError.message,
      flutterError.details,
    ]
  }
  return [
    "\(error)",
    "\(type(of: error))",
    "Stacktrace: \(Thread.callStackSymbols)",
  ]
}

private func createConnectionError(withChannelName channelName: String) -> PigeonError {
  return PigeonError(code: "channel-error", message: "Unable to establish connection on channel: '\(channelName)'.", details: "")
}

private func isNullish(_ value: Any?) -> Bool {
  return value is NSNull || value == nil
}

private func nilOrValue<T>(_ value: Any?) -> T? {
  if value is NSNull { return nil }
  return value as! T?
}

func deepEqualsMyAPI(_ lhs: Any?, _ rhs: Any?) -> Bool {
  let cleanLhs = nilOrValue(lhs) as Any?
  let cleanRhs = nilOrValue(rhs) as Any?
  switch (cleanLhs, cleanRhs) {
  case (nil, nil):
    return true

  case (nil, _), (_, nil):
    return false

  case is (Void, Void):
    return true

  case let (cleanLhsHashable, cleanRhsHashable) as (AnyHashable, AnyHashable):
    return cleanLhsHashable == cleanRhsHashable

  case let (cleanLhsArray, cleanRhsArray) as ([Any?], [Any?]):
    guard cleanLhsArray.count == cleanRhsArray.count else { return false }
    for (index, element) in cleanLhsArray.enumerated() {
      if !deepEqualsMyAPI(element, cleanRhsArray[index]) {
        return false
      }
    }
    return true

  case let (cleanLhsDictionary, cleanRhsDictionary) as ([AnyHashable: Any?], [AnyHashable: Any?]):
    guard cleanLhsDictionary.count == cleanRhsDictionary.count else { return false }
    for (key, cleanLhsValue) in cleanLhsDictionary {
      guard cleanRhsDictionary.index(forKey: key) != nil else { return false }
      if !deepEqualsMyAPI(cleanLhsValue, cleanRhsDictionary[key]!) {
        return false
      }
    }
    return true

  default:
    // Any other type shouldn't be able to be used with pigeon. File an issue if you find this to be untrue.
    return false
  }
}

func deepHashMyAPI(value: Any?, hasher: inout Hasher) {
  if let valueList = value as? [AnyHashable] {
     for item in valueList { deepHashMyAPI(value: item, hasher: &hasher) }
     return
  }

  if let valueDict = value as? [AnyHashable: AnyHashable] {
    for key in valueDict.keys { 
      hasher.combine(key)
      deepHashMyAPI(value: valueDict[key]!, hasher: &hasher)
    }
    return
  }

  if let hashableValue = value as? AnyHashable {
    hasher.combine(hashableValue.hashValue)
  }

  return hasher.combine(String(describing: value))
}

    

enum MyBluetoothLowEnergyStateArgs: Int {
  case unknown = 0
  case resetting = 1
  case unsupported = 2
  case unauthorized = 3
  case poweredOff = 4
  case poweredOn = 5
}

enum MyConnectionStateArgs: Int {
  case disconnected = 0
  case connected = 1
}

enum MyGATTCharacteristicPropertyArgs: Int {
  case read = 0
  case write = 1
  case writeWithoutResponse = 2
  case notify = 3
  case indicate = 4
}

enum MyGATTCharacteristicPermissionArgs: Int {
  case read = 0
  case readEncrypted = 1
  case write = 2
  case writeEncrypted = 3
}

enum MyGATTCharacteristicWriteTypeArgs: Int {
  case withResponse = 0
  case withoutResponse = 1
}

enum MyATTErrorArgs: Int {
  case success = 0
  case invalidHandle = 1
  case readNotPermitted = 2
  case writeNotPermitted = 3
  case invalidPDU = 4
  case insufficientAuthentication = 5
  case requestNotSupported = 6
  case invalidOffset = 7
  case insufficientAuthorization = 8
  case prepareQueueFull = 9
  case attributeNotFound = 10
  case attributeNotLong = 11
  case insufficientEncryptionKeySize = 12
  case invalidAttributeValueLength = 13
  case unlikelyError = 14
  case insufficientEncryption = 15
  case unsupportedGroupType = 16
  case insufficientResources = 17
}

/// Generated class from Pigeon that represents data sent in messages.
struct MyManufacturerSpecificDataArgs: Hashable {
  var idArgs: Int64
  var dataArgs: FlutterStandardTypedData


  // swift-format-ignore: AlwaysUseLowerCamelCase
  static func fromList(_ pigeonVar_list: [Any?]) -> MyManufacturerSpecificDataArgs? {
    let idArgs = pigeonVar_list[0] as! Int64
    let dataArgs = pigeonVar_list[1] as! FlutterStandardTypedData

    return MyManufacturerSpecificDataArgs(
      idArgs: idArgs,
      dataArgs: dataArgs
    )
  }
  func toList() -> [Any?] {
    return [
      idArgs,
      dataArgs,
    ]
  }
  static func == (lhs: MyManufacturerSpecificDataArgs, rhs: MyManufacturerSpecificDataArgs) -> Bool {
    return deepEqualsMyAPI(lhs.toList(), rhs.toList())  }
  func hash(into hasher: inout Hasher) {
    deepHashMyAPI(value: toList(), hasher: &hasher)
  }
}

/// Generated class from Pigeon that represents data sent in messages.
struct MyAdvertisementArgs: Hashable {
  var nameArgs: String? = nil
  var serviceUUIDsArgs: [String?]
  var serviceDataArgs: [String?: FlutterStandardTypedData?]
  var manufacturerSpecificDataArgs: FlutterStandardTypedData? = nil


  // swift-format-ignore: AlwaysUseLowerCamelCase
  static func fromList(_ pigeonVar_list: [Any?]) -> MyAdvertisementArgs? {
    let nameArgs: String? = nilOrValue(pigeonVar_list[0])
    let serviceUUIDsArgs = pigeonVar_list[1] as! [String?]
    let serviceDataArgs = pigeonVar_list[2] as! [String?: FlutterStandardTypedData?]
    let manufacturerSpecificDataArgs: FlutterStandardTypedData? = nilOrValue(pigeonVar_list[3])

    return MyAdvertisementArgs(
      nameArgs: nameArgs,
      serviceUUIDsArgs: serviceUUIDsArgs,
      serviceDataArgs: serviceDataArgs,
      manufacturerSpecificDataArgs: manufacturerSpecificDataArgs
    )
  }
  func toList() -> [Any?] {
    return [
      nameArgs,
      serviceUUIDsArgs,
      serviceDataArgs,
      manufacturerSpecificDataArgs,
    ]
  }
  static func == (lhs: MyAdvertisementArgs, rhs: MyAdvertisementArgs) -> Bool {
    return deepEqualsMyAPI(lhs.toList(), rhs.toList())  }
  func hash(into hasher: inout Hasher) {
    deepHashMyAPI(value: toList(), hasher: &hasher)
  }
}

/// Generated class from Pigeon that represents data sent in messages.
struct MyCentralArgs: Hashable {
  var uuidArgs: String


  // swift-format-ignore: AlwaysUseLowerCamelCase
  static func fromList(_ pigeonVar_list: [Any?]) -> MyCentralArgs? {
    let uuidArgs = pigeonVar_list[0] as! String

    return MyCentralArgs(
      uuidArgs: uuidArgs
    )
  }
  func toList() -> [Any?] {
    return [
      uuidArgs
    ]
  }
  static func == (lhs: MyCentralArgs, rhs: MyCentralArgs) -> Bool {
    return deepEqualsMyAPI(lhs.toList(), rhs.toList())  }
  func hash(into hasher: inout Hasher) {
    deepHashMyAPI(value: toList(), hasher: &hasher)
  }
}

/// Generated class from Pigeon that represents data sent in messages.
struct MyPeripheralArgs: Hashable {
  var uuidArgs: String


  // swift-format-ignore: AlwaysUseLowerCamelCase
  static func fromList(_ pigeonVar_list: [Any?]) -> MyPeripheralArgs? {
    let uuidArgs = pigeonVar_list[0] as! String

    return MyPeripheralArgs(
      uuidArgs: uuidArgs
    )
  }
  func toList() -> [Any?] {
    return [
      uuidArgs
    ]
  }
  static func == (lhs: MyPeripheralArgs, rhs: MyPeripheralArgs) -> Bool {
    return deepEqualsMyAPI(lhs.toList(), rhs.toList())  }
  func hash(into hasher: inout Hasher) {
    deepHashMyAPI(value: toList(), hasher: &hasher)
  }
}

/// Generated class from Pigeon that represents data sent in messages.
struct MyGATTDescriptorArgs: Hashable {
  var hashCodeArgs: Int64
  var uuidArgs: String


  // swift-format-ignore: AlwaysUseLowerCamelCase
  static func fromList(_ pigeonVar_list: [Any?]) -> MyGATTDescriptorArgs? {
    let hashCodeArgs = pigeonVar_list[0] as! Int64
    let uuidArgs = pigeonVar_list[1] as! String

    return MyGATTDescriptorArgs(
      hashCodeArgs: hashCodeArgs,
      uuidArgs: uuidArgs
    )
  }
  func toList() -> [Any?] {
    return [
      hashCodeArgs,
      uuidArgs,
    ]
  }
  static func == (lhs: MyGATTDescriptorArgs, rhs: MyGATTDescriptorArgs) -> Bool {
    return deepEqualsMyAPI(lhs.toList(), rhs.toList())  }
  func hash(into hasher: inout Hasher) {
    deepHashMyAPI(value: toList(), hasher: &hasher)
  }
}

/// Generated class from Pigeon that represents data sent in messages.
struct MyGATTCharacteristicArgs: Hashable {
  var hashCodeArgs: Int64
  var uuidArgs: String
  var propertyNumbersArgs: [Int64?]
  var descriptorsArgs: [MyGATTDescriptorArgs?]


  // swift-format-ignore: AlwaysUseLowerCamelCase
  static func fromList(_ pigeonVar_list: [Any?]) -> MyGATTCharacteristicArgs? {
    let hashCodeArgs = pigeonVar_list[0] as! Int64
    let uuidArgs = pigeonVar_list[1] as! String
    let propertyNumbersArgs = pigeonVar_list[2] as! [Int64?]
    let descriptorsArgs = pigeonVar_list[3] as! [MyGATTDescriptorArgs?]

    return MyGATTCharacteristicArgs(
      hashCodeArgs: hashCodeArgs,
      uuidArgs: uuidArgs,
      propertyNumbersArgs: propertyNumbersArgs,
      descriptorsArgs: descriptorsArgs
    )
  }
  func toList() -> [Any?] {
    return [
      hashCodeArgs,
      uuidArgs,
      propertyNumbersArgs,
      descriptorsArgs,
    ]
  }
  static func == (lhs: MyGATTCharacteristicArgs, rhs: MyGATTCharacteristicArgs) -> Bool {
    return deepEqualsMyAPI(lhs.toList(), rhs.toList())  }
  func hash(into hasher: inout Hasher) {
    deepHashMyAPI(value: toList(), hasher: &hasher)
  }
}

/// Generated class from Pigeon that represents data sent in messages.
struct MyGATTServiceArgs: Hashable {
  var hashCodeArgs: Int64
  var uuidArgs: String
  var isPrimaryArgs: Bool
  var includedServicesArgs: [MyGATTServiceArgs?]
  var characteristicsArgs: [MyGATTCharacteristicArgs?]


  // swift-format-ignore: AlwaysUseLowerCamelCase
  static func fromList(_ pigeonVar_list: [Any?]) -> MyGATTServiceArgs? {
    let hashCodeArgs = pigeonVar_list[0] as! Int64
    let uuidArgs = pigeonVar_list[1] as! String
    let isPrimaryArgs = pigeonVar_list[2] as! Bool
    let includedServicesArgs = pigeonVar_list[3] as! [MyGATTServiceArgs?]
    let characteristicsArgs = pigeonVar_list[4] as! [MyGATTCharacteristicArgs?]

    return MyGATTServiceArgs(
      hashCodeArgs: hashCodeArgs,
      uuidArgs: uuidArgs,
      isPrimaryArgs: isPrimaryArgs,
      includedServicesArgs: includedServicesArgs,
      characteristicsArgs: characteristicsArgs
    )
  }
  func toList() -> [Any?] {
    return [
      hashCodeArgs,
      uuidArgs,
      isPrimaryArgs,
      includedServicesArgs,
      characteristicsArgs,
    ]
  }
  static func == (lhs: MyGATTServiceArgs, rhs: MyGATTServiceArgs) -> Bool {
    return deepEqualsMyAPI(lhs.toList(), rhs.toList())  }
  func hash(into hasher: inout Hasher) {
    deepHashMyAPI(value: toList(), hasher: &hasher)
  }
}

/// Generated class from Pigeon that represents data sent in messages.
struct MyMutableGATTDescriptorArgs: Hashable {
  var hashCodeArgs: Int64
  var uuidArgs: String
  var valueArgs: FlutterStandardTypedData? = nil


  // swift-format-ignore: AlwaysUseLowerCamelCase
  static func fromList(_ pigeonVar_list: [Any?]) -> MyMutableGATTDescriptorArgs? {
    let hashCodeArgs = pigeonVar_list[0] as! Int64
    let uuidArgs = pigeonVar_list[1] as! String
    let valueArgs: FlutterStandardTypedData? = nilOrValue(pigeonVar_list[2])

    return MyMutableGATTDescriptorArgs(
      hashCodeArgs: hashCodeArgs,
      uuidArgs: uuidArgs,
      valueArgs: valueArgs
    )
  }
  func toList() -> [Any?] {
    return [
      hashCodeArgs,
      uuidArgs,
      valueArgs,
    ]
  }
  static func == (lhs: MyMutableGATTDescriptorArgs, rhs: MyMutableGATTDescriptorArgs) -> Bool {
    return deepEqualsMyAPI(lhs.toList(), rhs.toList())  }
  func hash(into hasher: inout Hasher) {
    deepHashMyAPI(value: toList(), hasher: &hasher)
  }
}

/// Generated class from Pigeon that represents data sent in messages.
struct MyMutableGATTCharacteristicArgs: Hashable {
  var hashCodeArgs: Int64
  var uuidArgs: String
  var propertyNumbersArgs: [Int64?]
  var permissionNumbersArgs: [Int64?]
  var valueArgs: FlutterStandardTypedData? = nil
  var descriptorsArgs: [MyMutableGATTDescriptorArgs?]


  // swift-format-ignore: AlwaysUseLowerCamelCase
  static func fromList(_ pigeonVar_list: [Any?]) -> MyMutableGATTCharacteristicArgs? {
    let hashCodeArgs = pigeonVar_list[0] as! Int64
    let uuidArgs = pigeonVar_list[1] as! String
    let propertyNumbersArgs = pigeonVar_list[2] as! [Int64?]
    let permissionNumbersArgs = pigeonVar_list[3] as! [Int64?]
    let valueArgs: FlutterStandardTypedData? = nilOrValue(pigeonVar_list[4])
    let descriptorsArgs = pigeonVar_list[5] as! [MyMutableGATTDescriptorArgs?]

    return MyMutableGATTCharacteristicArgs(
      hashCodeArgs: hashCodeArgs,
      uuidArgs: uuidArgs,
      propertyNumbersArgs: propertyNumbersArgs,
      permissionNumbersArgs: permissionNumbersArgs,
      valueArgs: valueArgs,
      descriptorsArgs: descriptorsArgs
    )
  }
  func toList() -> [Any?] {
    return [
      hashCodeArgs,
      uuidArgs,
      propertyNumbersArgs,
      permissionNumbersArgs,
      valueArgs,
      descriptorsArgs,
    ]
  }
  static func == (lhs: MyMutableGATTCharacteristicArgs, rhs: MyMutableGATTCharacteristicArgs) -> Bool {
    return deepEqualsMyAPI(lhs.toList(), rhs.toList())  }
  func hash(into hasher: inout Hasher) {
    deepHashMyAPI(value: toList(), hasher: &hasher)
  }
}

/// Generated class from Pigeon that represents data sent in messages.
struct MyMutableGATTServiceArgs: Hashable {
  var hashCodeArgs: Int64
  var uuidArgs: String
  var isPrimaryArgs: Bool
  var includedServicesArgs: [MyMutableGATTServiceArgs?]
  var characteristicsArgs: [MyMutableGATTCharacteristicArgs?]


  // swift-format-ignore: AlwaysUseLowerCamelCase
  static func fromList(_ pigeonVar_list: [Any?]) -> MyMutableGATTServiceArgs? {
    let hashCodeArgs = pigeonVar_list[0] as! Int64
    let uuidArgs = pigeonVar_list[1] as! String
    let isPrimaryArgs = pigeonVar_list[2] as! Bool
    let includedServicesArgs = pigeonVar_list[3] as! [MyMutableGATTServiceArgs?]
    let characteristicsArgs = pigeonVar_list[4] as! [MyMutableGATTCharacteristicArgs?]

    return MyMutableGATTServiceArgs(
      hashCodeArgs: hashCodeArgs,
      uuidArgs: uuidArgs,
      isPrimaryArgs: isPrimaryArgs,
      includedServicesArgs: includedServicesArgs,
      characteristicsArgs: characteristicsArgs
    )
  }
  func toList() -> [Any?] {
    return [
      hashCodeArgs,
      uuidArgs,
      isPrimaryArgs,
      includedServicesArgs,
      characteristicsArgs,
    ]
  }
  static func == (lhs: MyMutableGATTServiceArgs, rhs: MyMutableGATTServiceArgs) -> Bool {
    return deepEqualsMyAPI(lhs.toList(), rhs.toList())  }
  func hash(into hasher: inout Hasher) {
    deepHashMyAPI(value: toList(), hasher: &hasher)
  }
}

/// Generated class from Pigeon that represents data sent in messages.
struct MyATTRequestArgs: Hashable {
  var hashCodeArgs: Int64
  var centralArgs: MyCentralArgs
  var characteristicHashCodeArgs: Int64
  var valueArgs: FlutterStandardTypedData? = nil
  var offsetArgs: Int64


  // swift-format-ignore: AlwaysUseLowerCamelCase
  static func fromList(_ pigeonVar_list: [Any?]) -> MyATTRequestArgs? {
    let hashCodeArgs = pigeonVar_list[0] as! Int64
    let centralArgs = pigeonVar_list[1] as! MyCentralArgs
    let characteristicHashCodeArgs = pigeonVar_list[2] as! Int64
    let valueArgs: FlutterStandardTypedData? = nilOrValue(pigeonVar_list[3])
    let offsetArgs = pigeonVar_list[4] as! Int64

    return MyATTRequestArgs(
      hashCodeArgs: hashCodeArgs,
      centralArgs: centralArgs,
      characteristicHashCodeArgs: characteristicHashCodeArgs,
      valueArgs: valueArgs,
      offsetArgs: offsetArgs
    )
  }
  func toList() -> [Any?] {
    return [
      hashCodeArgs,
      centralArgs,
      characteristicHashCodeArgs,
      valueArgs,
      offsetArgs,
    ]
  }
  static func == (lhs: MyATTRequestArgs, rhs: MyATTRequestArgs) -> Bool {
    return deepEqualsMyAPI(lhs.toList(), rhs.toList())  }
  func hash(into hasher: inout Hasher) {
    deepHashMyAPI(value: toList(), hasher: &hasher)
  }
}

private class MyAPIPigeonCodecReader: FlutterStandardReader {
  override func readValue(ofType type: UInt8) -> Any? {
    switch type {
    case 129:
      let enumResultAsInt: Int? = nilOrValue(self.readValue() as! Int?)
      if let enumResultAsInt = enumResultAsInt {
        return MyBluetoothLowEnergyStateArgs(rawValue: enumResultAsInt)
      }
      return nil
    case 130:
      let enumResultAsInt: Int? = nilOrValue(self.readValue() as! Int?)
      if let enumResultAsInt = enumResultAsInt {
        return MyConnectionStateArgs(rawValue: enumResultAsInt)
      }
      return nil
    case 131:
      let enumResultAsInt: Int? = nilOrValue(self.readValue() as! Int?)
      if let enumResultAsInt = enumResultAsInt {
        return MyGATTCharacteristicPropertyArgs(rawValue: enumResultAsInt)
      }
      return nil
    case 132:
      let enumResultAsInt: Int? = nilOrValue(self.readValue() as! Int?)
      if let enumResultAsInt = enumResultAsInt {
        return MyGATTCharacteristicPermissionArgs(rawValue: enumResultAsInt)
      }
      return nil
    case 133:
      let enumResultAsInt: Int? = nilOrValue(self.readValue() as! Int?)
      if let enumResultAsInt = enumResultAsInt {
        return MyGATTCharacteristicWriteTypeArgs(rawValue: enumResultAsInt)
      }
      return nil
    case 134:
      let enumResultAsInt: Int? = nilOrValue(self.readValue() as! Int?)
      if let enumResultAsInt = enumResultAsInt {
        return MyATTErrorArgs(rawValue: enumResultAsInt)
      }
      return nil
    case 135:
      return MyManufacturerSpecificDataArgs.fromList(self.readValue() as! [Any?])
    case 136:
      return MyAdvertisementArgs.fromList(self.readValue() as! [Any?])
    case 137:
      return MyCentralArgs.fromList(self.readValue() as! [Any?])
    case 138:
      return MyPeripheralArgs.fromList(self.readValue() as! [Any?])
    case 139:
      return MyGATTDescriptorArgs.fromList(self.readValue() as! [Any?])
    case 140:
      return MyGATTCharacteristicArgs.fromList(self.readValue() as! [Any?])
    case 141:
      return MyGATTServiceArgs.fromList(self.readValue() as! [Any?])
    case 142:
      return MyMutableGATTDescriptorArgs.fromList(self.readValue() as! [Any?])
    case 143:
      return MyMutableGATTCharacteristicArgs.fromList(self.readValue() as! [Any?])
    case 144:
      return MyMutableGATTServiceArgs.fromList(self.readValue() as! [Any?])
    case 145:
      return MyATTRequestArgs.fromList(self.readValue() as! [Any?])
    default:
      return super.readValue(ofType: type)
    }
  }
}

private class MyAPIPigeonCodecWriter: FlutterStandardWriter {
  override func writeValue(_ value: Any) {
    if let value = value as? MyBluetoothLowEnergyStateArgs {
      super.writeByte(129)
      super.writeValue(value.rawValue)
    } else if let value = value as? MyConnectionStateArgs {
      super.writeByte(130)
      super.writeValue(value.rawValue)
    } else if let value = value as? MyGATTCharacteristicPropertyArgs {
      super.writeByte(131)
      super.writeValue(value.rawValue)
    } else if let value = value as? MyGATTCharacteristicPermissionArgs {
      super.writeByte(132)
      super.writeValue(value.rawValue)
    } else if let value = value as? MyGATTCharacteristicWriteTypeArgs {
      super.writeByte(133)
      super.writeValue(value.rawValue)
    } else if let value = value as? MyATTErrorArgs {
      super.writeByte(134)
      super.writeValue(value.rawValue)
    } else if let value = value as? MyManufacturerSpecificDataArgs {
      super.writeByte(135)
      super.writeValue(value.toList())
    } else if let value = value as? MyAdvertisementArgs {
      super.writeByte(136)
      super.writeValue(value.toList())
    } else if let value = value as? MyCentralArgs {
      super.writeByte(137)
      super.writeValue(value.toList())
    } else if let value = value as? MyPeripheralArgs {
      super.writeByte(138)
      super.writeValue(value.toList())
    } else if let value = value as? MyGATTDescriptorArgs {
      super.writeByte(139)
      super.writeValue(value.toList())
    } else if let value = value as? MyGATTCharacteristicArgs {
      super.writeByte(140)
      super.writeValue(value.toList())
    } else if let value = value as? MyGATTServiceArgs {
      super.writeByte(141)
      super.writeValue(value.toList())
    } else if let value = value as? MyMutableGATTDescriptorArgs {
      super.writeByte(142)
      super.writeValue(value.toList())
    } else if let value = value as? MyMutableGATTCharacteristicArgs {
      super.writeByte(143)
      super.writeValue(value.toList())
    } else if let value = value as? MyMutableGATTServiceArgs {
      super.writeByte(144)
      super.writeValue(value.toList())
    } else if let value = value as? MyATTRequestArgs {
      super.writeByte(145)
      super.writeValue(value.toList())
    } else {
      super.writeValue(value)
    }
  }
}

private class MyAPIPigeonCodecReaderWriter: FlutterStandardReaderWriter {
  override func reader(with data: Data) -> FlutterStandardReader {
    return MyAPIPigeonCodecReader(data: data)
  }

  override func writer(with data: NSMutableData) -> FlutterStandardWriter {
    return MyAPIPigeonCodecWriter(data: data)
  }
}

class MyAPIPigeonCodec: FlutterStandardMessageCodec, @unchecked Sendable {
  static let shared = MyAPIPigeonCodec(readerWriter: MyAPIPigeonCodecReaderWriter())
}


/// Generated protocol from Pigeon that represents a handler of messages from Flutter.
protocol MyCentralManagerHostAPI {
  func initialize() throws
  func getState() throws -> MyBluetoothLowEnergyStateArgs
  func showAppSettings(completion: @escaping (Result<Void, Error>) -> Void)
  func startDiscovery(serviceUUIDsArgs: [String]) throws
  func stopDiscovery() throws
  func retrieveConnectedPeripherals() throws -> [MyPeripheralArgs]
  func connect(uuidArgs: String, completion: @escaping (Result<Void, Error>) -> Void)
  func disconnect(uuidArgs: String, completion: @escaping (Result<Void, Error>) -> Void)
  func getMaximumWriteLength(uuidArgs: String, typeArgs: MyGATTCharacteristicWriteTypeArgs) throws -> Int64
  func readRSSI(uuidArgs: String, completion: @escaping (Result<Int64, Error>) -> Void)
  func discoverServices(uuidArgs: String, completion: @escaping (Result<[MyGATTServiceArgs], Error>) -> Void)
  func discoverIncludedServices(uuidArgs: String, hashCodeArgs: Int64, completion: @escaping (Result<[MyGATTServiceArgs], Error>) -> Void)
  func discoverCharacteristics(uuidArgs: String, hashCodeArgs: Int64, completion: @escaping (Result<[MyGATTCharacteristicArgs], Error>) -> Void)
  func discoverDescriptors(uuidArgs: String, hashCodeArgs: Int64, completion: @escaping (Result<[MyGATTDescriptorArgs], Error>) -> Void)
  func readCharacteristic(uuidArgs: String, hashCodeArgs: Int64, completion: @escaping (Result<FlutterStandardTypedData, Error>) -> Void)
  func writeCharacteristic(uuidArgs: String, hashCodeArgs: Int64, valueArgs: FlutterStandardTypedData, typeArgs: MyGATTCharacteristicWriteTypeArgs, completion: @escaping (Result<Void, Error>) -> Void)
  func setCharacteristicNotifyState(uuidArgs: String, hashCodeArgs: Int64, stateArgs: Bool, completion: @escaping (Result<Void, Error>) -> Void)
  func readDescriptor(uuidArgs: String, hashCodeArgs: Int64, completion: @escaping (Result<FlutterStandardTypedData, Error>) -> Void)
  func writeDescriptor(uuidArgs: String, hashCodeArgs: Int64, valueArgs: FlutterStandardTypedData, completion: @escaping (Result<Void, Error>) -> Void)
}

/// Generated setup class from Pigeon to handle messages through the `binaryMessenger`.
class MyCentralManagerHostAPISetup {
  static var codec: FlutterStandardMessageCodec { MyAPIPigeonCodec.shared }
  /// Sets up an instance of `MyCentralManagerHostAPI` to handle messages through the `binaryMessenger`.
  static func setUp(binaryMessenger: FlutterBinaryMessenger, api: MyCentralManagerHostAPI?, messageChannelSuffix: String = "") {
    let channelSuffix = messageChannelSuffix.count > 0 ? ".\(messageChannelSuffix)" : ""
    let initializeChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.bluetooth_low_energy_darwin.MyCentralManagerHostAPI.initialize\(channelSuffix)", binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      initializeChannel.setMessageHandler { _, reply in
        do {
          try api.initialize()
          reply(wrapResult(nil))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      initializeChannel.setMessageHandler(nil)
    }
    let getStateChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.bluetooth_low_energy_darwin.MyCentralManagerHostAPI.getState\(channelSuffix)", binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      getStateChannel.setMessageHandler { _, reply in
        do {
          let result = try api.getState()
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      getStateChannel.setMessageHandler(nil)
    }
    let showAppSettingsChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.bluetooth_low_energy_darwin.MyCentralManagerHostAPI.showAppSettings\(channelSuffix)", binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      showAppSettingsChannel.setMessageHandler { _, reply in
        api.showAppSettings { result in
          switch result {
          case .success:
            reply(wrapResult(nil))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      showAppSettingsChannel.setMessageHandler(nil)
    }
    let startDiscoveryChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.bluetooth_low_energy_darwin.MyCentralManagerHostAPI.startDiscovery\(channelSuffix)", binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      startDiscoveryChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let serviceUUIDsArgsArg = args[0] as! [String]
        do {
          try api.startDiscovery(serviceUUIDsArgs: serviceUUIDsArgsArg)
          reply(wrapResult(nil))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      startDiscoveryChannel.setMessageHandler(nil)
    }
    let stopDiscoveryChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.bluetooth_low_energy_darwin.MyCentralManagerHostAPI.stopDiscovery\(channelSuffix)", binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      stopDiscoveryChannel.setMessageHandler { _, reply in
        do {
          try api.stopDiscovery()
          reply(wrapResult(nil))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      stopDiscoveryChannel.setMessageHandler(nil)
    }
    let retrieveConnectedPeripheralsChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.bluetooth_low_energy_darwin.MyCentralManagerHostAPI.retrieveConnectedPeripherals\(channelSuffix)", binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      retrieveConnectedPeripheralsChannel.setMessageHandler { _, reply in
        do {
          let result = try api.retrieveConnectedPeripherals()
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      retrieveConnectedPeripheralsChannel.setMessageHandler(nil)
    }
    let connectChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.bluetooth_low_energy_darwin.MyCentralManagerHostAPI.connect\(channelSuffix)", binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      connectChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let uuidArgsArg = args[0] as! String
        api.connect(uuidArgs: uuidArgsArg) { result in
          switch result {
          case .success:
            reply(wrapResult(nil))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      connectChannel.setMessageHandler(nil)
    }
    let disconnectChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.bluetooth_low_energy_darwin.MyCentralManagerHostAPI.disconnect\(channelSuffix)", binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      disconnectChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let uuidArgsArg = args[0] as! String
        api.disconnect(uuidArgs: uuidArgsArg) { result in
          switch result {
          case .success:
            reply(wrapResult(nil))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      disconnectChannel.setMessageHandler(nil)
    }
    let getMaximumWriteLengthChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.bluetooth_low_energy_darwin.MyCentralManagerHostAPI.getMaximumWriteLength\(channelSuffix)", binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      getMaximumWriteLengthChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let uuidArgsArg = args[0] as! String
        let typeArgsArg = args[1] as! MyGATTCharacteristicWriteTypeArgs
        do {
          let result = try api.getMaximumWriteLength(uuidArgs: uuidArgsArg, typeArgs: typeArgsArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      getMaximumWriteLengthChannel.setMessageHandler(nil)
    }
    let readRSSIChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.bluetooth_low_energy_darwin.MyCentralManagerHostAPI.readRSSI\(channelSuffix)", binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      readRSSIChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let uuidArgsArg = args[0] as! String
        api.readRSSI(uuidArgs: uuidArgsArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      readRSSIChannel.setMessageHandler(nil)
    }
    let discoverServicesChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.bluetooth_low_energy_darwin.MyCentralManagerHostAPI.discoverServices\(channelSuffix)", binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      discoverServicesChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let uuidArgsArg = args[0] as! String
        api.discoverServices(uuidArgs: uuidArgsArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      discoverServicesChannel.setMessageHandler(nil)
    }
    let discoverIncludedServicesChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.bluetooth_low_energy_darwin.MyCentralManagerHostAPI.discoverIncludedServices\(channelSuffix)", binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      discoverIncludedServicesChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let uuidArgsArg = args[0] as! String
        let hashCodeArgsArg = args[1] as! Int64
        api.discoverIncludedServices(uuidArgs: uuidArgsArg, hashCodeArgs: hashCodeArgsArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      discoverIncludedServicesChannel.setMessageHandler(nil)
    }
    let discoverCharacteristicsChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.bluetooth_low_energy_darwin.MyCentralManagerHostAPI.discoverCharacteristics\(channelSuffix)", binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      discoverCharacteristicsChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let uuidArgsArg = args[0] as! String
        let hashCodeArgsArg = args[1] as! Int64
        api.discoverCharacteristics(uuidArgs: uuidArgsArg, hashCodeArgs: hashCodeArgsArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      discoverCharacteristicsChannel.setMessageHandler(nil)
    }
    let discoverDescriptorsChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.bluetooth_low_energy_darwin.MyCentralManagerHostAPI.discoverDescriptors\(channelSuffix)", binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      discoverDescriptorsChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let uuidArgsArg = args[0] as! String
        let hashCodeArgsArg = args[1] as! Int64
        api.discoverDescriptors(uuidArgs: uuidArgsArg, hashCodeArgs: hashCodeArgsArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      discoverDescriptorsChannel.setMessageHandler(nil)
    }
    let readCharacteristicChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.bluetooth_low_energy_darwin.MyCentralManagerHostAPI.readCharacteristic\(channelSuffix)", binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      readCharacteristicChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let uuidArgsArg = args[0] as! String
        let hashCodeArgsArg = args[1] as! Int64
        api.readCharacteristic(uuidArgs: uuidArgsArg, hashCodeArgs: hashCodeArgsArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      readCharacteristicChannel.setMessageHandler(nil)
    }
    let writeCharacteristicChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.bluetooth_low_energy_darwin.MyCentralManagerHostAPI.writeCharacteristic\(channelSuffix)", binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      writeCharacteristicChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let uuidArgsArg = args[0] as! String
        let hashCodeArgsArg = args[1] as! Int64
        let valueArgsArg = args[2] as! FlutterStandardTypedData
        let typeArgsArg = args[3] as! MyGATTCharacteristicWriteTypeArgs
        api.writeCharacteristic(uuidArgs: uuidArgsArg, hashCodeArgs: hashCodeArgsArg, valueArgs: valueArgsArg, typeArgs: typeArgsArg) { result in
          switch result {
          case .success:
            reply(wrapResult(nil))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      writeCharacteristicChannel.setMessageHandler(nil)
    }
    let setCharacteristicNotifyStateChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.bluetooth_low_energy_darwin.MyCentralManagerHostAPI.setCharacteristicNotifyState\(channelSuffix)", binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      setCharacteristicNotifyStateChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let uuidArgsArg = args[0] as! String
        let hashCodeArgsArg = args[1] as! Int64
        let stateArgsArg = args[2] as! Bool
        api.setCharacteristicNotifyState(uuidArgs: uuidArgsArg, hashCodeArgs: hashCodeArgsArg, stateArgs: stateArgsArg) { result in
          switch result {
          case .success:
            reply(wrapResult(nil))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      setCharacteristicNotifyStateChannel.setMessageHandler(nil)
    }
    let readDescriptorChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.bluetooth_low_energy_darwin.MyCentralManagerHostAPI.readDescriptor\(channelSuffix)", binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      readDescriptorChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let uuidArgsArg = args[0] as! String
        let hashCodeArgsArg = args[1] as! Int64
        api.readDescriptor(uuidArgs: uuidArgsArg, hashCodeArgs: hashCodeArgsArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      readDescriptorChannel.setMessageHandler(nil)
    }
    let writeDescriptorChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.bluetooth_low_energy_darwin.MyCentralManagerHostAPI.writeDescriptor\(channelSuffix)", binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      writeDescriptorChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let uuidArgsArg = args[0] as! String
        let hashCodeArgsArg = args[1] as! Int64
        let valueArgsArg = args[2] as! FlutterStandardTypedData
        api.writeDescriptor(uuidArgs: uuidArgsArg, hashCodeArgs: hashCodeArgsArg, valueArgs: valueArgsArg) { result in
          switch result {
          case .success:
            reply(wrapResult(nil))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      writeDescriptorChannel.setMessageHandler(nil)
    }
  }
}
/// Generated protocol from Pigeon that represents Flutter messages that can be called from Swift.
protocol MyCentralManagerFlutterAPIProtocol {
  func onStateChanged(stateArgs stateArgsArg: MyBluetoothLowEnergyStateArgs, completion: @escaping (Result<Void, PigeonError>) -> Void)
  func onDiscovered(peripheralArgs peripheralArgsArg: MyPeripheralArgs, rssiArgs rssiArgsArg: Int64, advertisementArgs advertisementArgsArg: MyAdvertisementArgs, completion: @escaping (Result<Void, PigeonError>) -> Void)
  func onConnectionStateChanged(peripheralArgs peripheralArgsArg: MyPeripheralArgs, stateArgs stateArgsArg: MyConnectionStateArgs, completion: @escaping (Result<Void, PigeonError>) -> Void)
  func onCharacteristicNotified(peripheralArgs peripheralArgsArg: MyPeripheralArgs, characteristicArgs characteristicArgsArg: MyGATTCharacteristicArgs, valueArgs valueArgsArg: FlutterStandardTypedData, completion: @escaping (Result<Void, PigeonError>) -> Void)
}
class MyCentralManagerFlutterAPI: MyCentralManagerFlutterAPIProtocol {
  private let binaryMessenger: FlutterBinaryMessenger
  private let messageChannelSuffix: String
  init(binaryMessenger: FlutterBinaryMessenger, messageChannelSuffix: String = "") {
    self.binaryMessenger = binaryMessenger
    self.messageChannelSuffix = messageChannelSuffix.count > 0 ? ".\(messageChannelSuffix)" : ""
  }
  var codec: MyAPIPigeonCodec {
    return MyAPIPigeonCodec.shared
  }
  func onStateChanged(stateArgs stateArgsArg: MyBluetoothLowEnergyStateArgs, completion: @escaping (Result<Void, PigeonError>) -> Void) {
    let channelName: String = "dev.flutter.pigeon.bluetooth_low_energy_darwin.MyCentralManagerFlutterAPI.onStateChanged\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([stateArgsArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else {
        completion(.success(()))
      }
    }
  }
  func onDiscovered(peripheralArgs peripheralArgsArg: MyPeripheralArgs, rssiArgs rssiArgsArg: Int64, advertisementArgs advertisementArgsArg: MyAdvertisementArgs, completion: @escaping (Result<Void, PigeonError>) -> Void) {
    let channelName: String = "dev.flutter.pigeon.bluetooth_low_energy_darwin.MyCentralManagerFlutterAPI.onDiscovered\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([peripheralArgsArg, rssiArgsArg, advertisementArgsArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else {
        completion(.success(()))
      }
    }
  }
  func onConnectionStateChanged(peripheralArgs peripheralArgsArg: MyPeripheralArgs, stateArgs stateArgsArg: MyConnectionStateArgs, completion: @escaping (Result<Void, PigeonError>) -> Void) {
    let channelName: String = "dev.flutter.pigeon.bluetooth_low_energy_darwin.MyCentralManagerFlutterAPI.onConnectionStateChanged\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([peripheralArgsArg, stateArgsArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else {
        completion(.success(()))
      }
    }
  }
  func onCharacteristicNotified(peripheralArgs peripheralArgsArg: MyPeripheralArgs, characteristicArgs characteristicArgsArg: MyGATTCharacteristicArgs, valueArgs valueArgsArg: FlutterStandardTypedData, completion: @escaping (Result<Void, PigeonError>) -> Void) {
    let channelName: String = "dev.flutter.pigeon.bluetooth_low_energy_darwin.MyCentralManagerFlutterAPI.onCharacteristicNotified\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([peripheralArgsArg, characteristicArgsArg, valueArgsArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else {
        completion(.success(()))
      }
    }
  }
}
/// Generated protocol from Pigeon that represents a handler of messages from Flutter.
protocol MyPeripheralManagerHostAPI {
  func initialize() throws
  func getState() throws -> MyBluetoothLowEnergyStateArgs
  func showAppSettings(completion: @escaping (Result<Void, Error>) -> Void)
  func addService(serviceArgs: MyMutableGATTServiceArgs, completion: @escaping (Result<Void, Error>) -> Void)
  func removeService(hashCodeArgs: Int64) throws
  func removeAllServices() throws
  func startAdvertising(advertisementArgs: MyAdvertisementArgs, completion: @escaping (Result<Void, Error>) -> Void)
  func stopAdvertising() throws
  func getMaximumNotifyLength(uuidArgs: String) throws -> Int64
  func respond(hashCodeArgs: Int64, valueArgs: FlutterStandardTypedData?, errorArgs: MyATTErrorArgs) throws
  func updateValue(hashCodeArgs: Int64, valueArgs: FlutterStandardTypedData, uuidsArgs: [String]?) throws -> Bool
}

/// Generated setup class from Pigeon to handle messages through the `binaryMessenger`.
class MyPeripheralManagerHostAPISetup {
  static var codec: FlutterStandardMessageCodec { MyAPIPigeonCodec.shared }
  /// Sets up an instance of `MyPeripheralManagerHostAPI` to handle messages through the `binaryMessenger`.
  static func setUp(binaryMessenger: FlutterBinaryMessenger, api: MyPeripheralManagerHostAPI?, messageChannelSuffix: String = "") {
    let channelSuffix = messageChannelSuffix.count > 0 ? ".\(messageChannelSuffix)" : ""
    let initializeChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.bluetooth_low_energy_darwin.MyPeripheralManagerHostAPI.initialize\(channelSuffix)", binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      initializeChannel.setMessageHandler { _, reply in
        do {
          try api.initialize()
          reply(wrapResult(nil))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      initializeChannel.setMessageHandler(nil)
    }
    let getStateChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.bluetooth_low_energy_darwin.MyPeripheralManagerHostAPI.getState\(channelSuffix)", binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      getStateChannel.setMessageHandler { _, reply in
        do {
          let result = try api.getState()
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      getStateChannel.setMessageHandler(nil)
    }
    let showAppSettingsChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.bluetooth_low_energy_darwin.MyPeripheralManagerHostAPI.showAppSettings\(channelSuffix)", binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      showAppSettingsChannel.setMessageHandler { _, reply in
        api.showAppSettings { result in
          switch result {
          case .success:
            reply(wrapResult(nil))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      showAppSettingsChannel.setMessageHandler(nil)
    }
    let addServiceChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.bluetooth_low_energy_darwin.MyPeripheralManagerHostAPI.addService\(channelSuffix)", binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      addServiceChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let serviceArgsArg = args[0] as! MyMutableGATTServiceArgs
        api.addService(serviceArgs: serviceArgsArg) { result in
          switch result {
          case .success:
            reply(wrapResult(nil))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      addServiceChannel.setMessageHandler(nil)
    }
    let removeServiceChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.bluetooth_low_energy_darwin.MyPeripheralManagerHostAPI.removeService\(channelSuffix)", binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      removeServiceChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let hashCodeArgsArg = args[0] as! Int64
        do {
          try api.removeService(hashCodeArgs: hashCodeArgsArg)
          reply(wrapResult(nil))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      removeServiceChannel.setMessageHandler(nil)
    }
    let removeAllServicesChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.bluetooth_low_energy_darwin.MyPeripheralManagerHostAPI.removeAllServices\(channelSuffix)", binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      removeAllServicesChannel.setMessageHandler { _, reply in
        do {
          try api.removeAllServices()
          reply(wrapResult(nil))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      removeAllServicesChannel.setMessageHandler(nil)
    }
    let startAdvertisingChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.bluetooth_low_energy_darwin.MyPeripheralManagerHostAPI.startAdvertising\(channelSuffix)", binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      startAdvertisingChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let advertisementArgsArg = args[0] as! MyAdvertisementArgs
        api.startAdvertising(advertisementArgs: advertisementArgsArg) { result in
          switch result {
          case .success:
            reply(wrapResult(nil))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      startAdvertisingChannel.setMessageHandler(nil)
    }
    let stopAdvertisingChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.bluetooth_low_energy_darwin.MyPeripheralManagerHostAPI.stopAdvertising\(channelSuffix)", binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      stopAdvertisingChannel.setMessageHandler { _, reply in
        do {
          try api.stopAdvertising()
          reply(wrapResult(nil))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      stopAdvertisingChannel.setMessageHandler(nil)
    }
    let getMaximumNotifyLengthChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.bluetooth_low_energy_darwin.MyPeripheralManagerHostAPI.getMaximumNotifyLength\(channelSuffix)", binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      getMaximumNotifyLengthChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let uuidArgsArg = args[0] as! String
        do {
          let result = try api.getMaximumNotifyLength(uuidArgs: uuidArgsArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      getMaximumNotifyLengthChannel.setMessageHandler(nil)
    }
    let respondChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.bluetooth_low_energy_darwin.MyPeripheralManagerHostAPI.respond\(channelSuffix)", binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      respondChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let hashCodeArgsArg = args[0] as! Int64
        let valueArgsArg: FlutterStandardTypedData? = nilOrValue(args[1])
        let errorArgsArg = args[2] as! MyATTErrorArgs
        do {
          try api.respond(hashCodeArgs: hashCodeArgsArg, valueArgs: valueArgsArg, errorArgs: errorArgsArg)
          reply(wrapResult(nil))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      respondChannel.setMessageHandler(nil)
    }
    let updateValueChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.bluetooth_low_energy_darwin.MyPeripheralManagerHostAPI.updateValue\(channelSuffix)", binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      updateValueChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let hashCodeArgsArg = args[0] as! Int64
        let valueArgsArg = args[1] as! FlutterStandardTypedData
        let uuidsArgsArg: [String]? = nilOrValue(args[2])
        do {
          let result = try api.updateValue(hashCodeArgs: hashCodeArgsArg, valueArgs: valueArgsArg, uuidsArgs: uuidsArgsArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      updateValueChannel.setMessageHandler(nil)
    }
  }
}
/// Generated protocol from Pigeon that represents Flutter messages that can be called from Swift.
protocol MyPeripheralManagerFlutterAPIProtocol {
  func onStateChanged(stateArgs stateArgsArg: MyBluetoothLowEnergyStateArgs, completion: @escaping (Result<Void, PigeonError>) -> Void)
  func didReceiveRead(requestArgs requestArgsArg: MyATTRequestArgs, completion: @escaping (Result<Void, PigeonError>) -> Void)
  func didReceiveWrite(requestsArgs requestsArgsArg: [MyATTRequestArgs], completion: @escaping (Result<Void, PigeonError>) -> Void)
  func isReady(completion: @escaping (Result<Void, PigeonError>) -> Void)
  func onCharacteristicNotifyStateChanged(centralArgs centralArgsArg: MyCentralArgs, hashCodeArgs hashCodeArgsArg: Int64, stateArgs stateArgsArg: Bool, completion: @escaping (Result<Void, PigeonError>) -> Void)
}
class MyPeripheralManagerFlutterAPI: MyPeripheralManagerFlutterAPIProtocol {
  private let binaryMessenger: FlutterBinaryMessenger
  private let messageChannelSuffix: String
  init(binaryMessenger: FlutterBinaryMessenger, messageChannelSuffix: String = "") {
    self.binaryMessenger = binaryMessenger
    self.messageChannelSuffix = messageChannelSuffix.count > 0 ? ".\(messageChannelSuffix)" : ""
  }
  var codec: MyAPIPigeonCodec {
    return MyAPIPigeonCodec.shared
  }
  func onStateChanged(stateArgs stateArgsArg: MyBluetoothLowEnergyStateArgs, completion: @escaping (Result<Void, PigeonError>) -> Void) {
    let channelName: String = "dev.flutter.pigeon.bluetooth_low_energy_darwin.MyPeripheralManagerFlutterAPI.onStateChanged\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([stateArgsArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else {
        completion(.success(()))
      }
    }
  }
  func didReceiveRead(requestArgs requestArgsArg: MyATTRequestArgs, completion: @escaping (Result<Void, PigeonError>) -> Void) {
    let channelName: String = "dev.flutter.pigeon.bluetooth_low_energy_darwin.MyPeripheralManagerFlutterAPI.didReceiveRead\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([requestArgsArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else {
        completion(.success(()))
      }
    }
  }
  func didReceiveWrite(requestsArgs requestsArgsArg: [MyATTRequestArgs], completion: @escaping (Result<Void, PigeonError>) -> Void) {
    let channelName: String = "dev.flutter.pigeon.bluetooth_low_energy_darwin.MyPeripheralManagerFlutterAPI.didReceiveWrite\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([requestsArgsArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else {
        completion(.success(()))
      }
    }
  }
  func isReady(completion: @escaping (Result<Void, PigeonError>) -> Void) {
    let channelName: String = "dev.flutter.pigeon.bluetooth_low_energy_darwin.MyPeripheralManagerFlutterAPI.isReady\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage(nil) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else {
        completion(.success(()))
      }
    }
  }
  func onCharacteristicNotifyStateChanged(centralArgs centralArgsArg: MyCentralArgs, hashCodeArgs hashCodeArgsArg: Int64, stateArgs stateArgsArg: Bool, completion: @escaping (Result<Void, PigeonError>) -> Void) {
    let channelName: String = "dev.flutter.pigeon.bluetooth_low_energy_darwin.MyPeripheralManagerFlutterAPI.onCharacteristicNotifyStateChanged\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([centralArgsArg, hashCodeArgsArg, stateArgsArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else {
        completion(.success(()))
      }
    }
  }
}
