// Autogenerated from Pigeon (v26.0.0), do not edit directly.
// See also: https://pub.dev/packages/pigeon
// ignore_for_file: public_member_api_docs, non_constant_identifier_names, avoid_as, unused_import, unnecessary_parenthesis, prefer_null_aware_operators, omit_local_variable_types, unused_shown_name, unnecessary_import, no_leading_underscores_for_local_identifiers

import 'dart:async';
import 'dart:typed_data' show Float64List, Int32List, Int64List, Uint8List;

import 'package:flutter/foundation.dart' show ReadBuffer, WriteBuffer;
import 'package:flutter/services.dart';

PlatformException _createConnectionError(String channelName) {
  return PlatformException(
    code: 'channel-error',
    message: 'Unable to establish connection on channel: "$channelName".',
  );
}

List<Object?> wrapResponse({
  Object? result,
  PlatformException? error,
  bool empty = false,
}) {
  if (empty) {
    return <Object?>[];
  }
  if (error == null) {
    return <Object?>[result];
  }
  return <Object?>[error.code, error.message, error.details];
}

bool _deepEquals(Object? a, Object? b) {
  if (a is List && b is List) {
    return a.length == b.length &&
        a.indexed.every(
          ((int, dynamic) item) => _deepEquals(item.$2, b[item.$1]),
        );
  }
  if (a is Map && b is Map) {
    return a.length == b.length &&
        a.entries.every(
          (MapEntry<Object?, Object?> entry) =>
              (b as Map<Object?, Object?>).containsKey(entry.key) &&
              _deepEquals(entry.value, b[entry.key]),
        );
  }
  return a == b;
}

enum MyBluetoothLowEnergyStateArgs {
  unknown,
  unsupported,
  unauthorized,
  off,
  turningOn,
  on,
  turningOff,
}

enum MyAdvertiseModeArgs { lowPower, balanced, lowLatency }

enum MyTXPowerLevelArgs { ultraLow, low, medium, high }

enum MyConnectionStateArgs {
  disconnected,
  connecting,
  connected,
  disconnecting,
}

enum MyGATTCharacteristicPropertyArgs {
  read,
  write,
  writeWithoutResponse,
  notify,
  indicate,
}

enum MyGATTCharacteristicPermissionArgs {
  read,
  readEncrypted,
  write,
  writeEncrypted,
}

enum MyGATTCharacteristicWriteTypeArgs { withResponse, withoutResponse }

enum MyGATTStatusArgs {
  success,
  readNotPermitted,
  writeNotPermitted,
  insufficientAuthentication,
  requestNotSupported,
  insufficientEncryption,
  invalidOffset,
  insufficientAuthorization,
  invalidAttributeLength,
  connectionCongested,
  failure,
}

class MyCentralManagerArgs {
  MyCentralManagerArgs({
    required this.enableNotificationValue,
    required this.enableIndicationValue,
    required this.disableNotificationValue,
  });

  Uint8List enableNotificationValue;

  Uint8List enableIndicationValue;

  Uint8List disableNotificationValue;

  List<Object?> _toList() {
    return <Object?>[
      enableNotificationValue,
      enableIndicationValue,
      disableNotificationValue,
    ];
  }

  Object encode() {
    return _toList();
  }

  static MyCentralManagerArgs decode(Object result) {
    result as List<Object?>;
    return MyCentralManagerArgs(
      enableNotificationValue: result[0]! as Uint8List,
      enableIndicationValue: result[1]! as Uint8List,
      disableNotificationValue: result[2]! as Uint8List,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! MyCentralManagerArgs || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList());
}

class MyPeripheralManagerArgs {
  MyPeripheralManagerArgs({
    required this.enableNotificationValue,
    required this.enableIndicationValue,
    required this.disableNotificationValue,
  });

  Uint8List enableNotificationValue;

  Uint8List enableIndicationValue;

  Uint8List disableNotificationValue;

  List<Object?> _toList() {
    return <Object?>[
      enableNotificationValue,
      enableIndicationValue,
      disableNotificationValue,
    ];
  }

  Object encode() {
    return _toList();
  }

  static MyPeripheralManagerArgs decode(Object result) {
    result as List<Object?>;
    return MyPeripheralManagerArgs(
      enableNotificationValue: result[0]! as Uint8List,
      enableIndicationValue: result[1]! as Uint8List,
      disableNotificationValue: result[2]! as Uint8List,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! MyPeripheralManagerArgs || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList());
}

class MyManufacturerSpecificDataArgs {
  MyManufacturerSpecificDataArgs({
    required this.idArgs,
    required this.dataArgs,
  });

  int idArgs;

  Uint8List dataArgs;

  List<Object?> _toList() {
    return <Object?>[idArgs, dataArgs];
  }

  Object encode() {
    return _toList();
  }

  static MyManufacturerSpecificDataArgs decode(Object result) {
    result as List<Object?>;
    return MyManufacturerSpecificDataArgs(
      idArgs: result[0]! as int,
      dataArgs: result[1]! as Uint8List,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! MyManufacturerSpecificDataArgs ||
        other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList());
}

class MyAdvertisementArgs {
  MyAdvertisementArgs({
    this.nameArgs,
    required this.serviceUUIDsArgs,
    required this.serviceDataArgs,
    required this.manufacturerSpecificDataArgs,
  });

  String? nameArgs;

  List<String?> serviceUUIDsArgs;

  Map<String?, Uint8List?> serviceDataArgs;

  List<MyManufacturerSpecificDataArgs?> manufacturerSpecificDataArgs;

  List<Object?> _toList() {
    return <Object?>[
      nameArgs,
      serviceUUIDsArgs,
      serviceDataArgs,
      manufacturerSpecificDataArgs,
    ];
  }

  Object encode() {
    return _toList();
  }

  static MyAdvertisementArgs decode(Object result) {
    result as List<Object?>;
    return MyAdvertisementArgs(
      nameArgs: result[0] as String?,
      serviceUUIDsArgs: (result[1] as List<Object?>?)!.cast<String?>(),
      serviceDataArgs:
          (result[2] as Map<Object?, Object?>?)!.cast<String?, Uint8List?>(),
      manufacturerSpecificDataArgs:
          (result[3] as List<Object?>?)!
              .cast<MyManufacturerSpecificDataArgs?>(),
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! MyAdvertisementArgs || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList());
}

class MyAdvertiseSettingsArgs {
  MyAdvertiseSettingsArgs({
    this.modeArgs,
    this.connectableArgs,
    this.timeoutArgs,
    this.txPowerLevelArgs,
  });

  MyAdvertiseModeArgs? modeArgs;

  bool? connectableArgs;

  int? timeoutArgs;

  MyTXPowerLevelArgs? txPowerLevelArgs;

  List<Object?> _toList() {
    return <Object?>[modeArgs, connectableArgs, timeoutArgs, txPowerLevelArgs];
  }

  Object encode() {
    return _toList();
  }

  static MyAdvertiseSettingsArgs decode(Object result) {
    result as List<Object?>;
    return MyAdvertiseSettingsArgs(
      modeArgs: result[0] as MyAdvertiseModeArgs?,
      connectableArgs: result[1] as bool?,
      timeoutArgs: result[2] as int?,
      txPowerLevelArgs: result[3] as MyTXPowerLevelArgs?,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! MyAdvertiseSettingsArgs || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList());
}

class MyAdvertiseDataArgs {
  MyAdvertiseDataArgs({
    this.includeDeviceNameArgs,
    this.includeTXPowerLevelArgs,
    required this.serviceUUIDsArgs,
    required this.serviceDataArgs,
    required this.manufacturerSpecificDataArgs,
  });

  bool? includeDeviceNameArgs;

  bool? includeTXPowerLevelArgs;

  List<String?> serviceUUIDsArgs;

  Map<String?, Uint8List?> serviceDataArgs;

  List<MyManufacturerSpecificDataArgs?> manufacturerSpecificDataArgs;

  List<Object?> _toList() {
    return <Object?>[
      includeDeviceNameArgs,
      includeTXPowerLevelArgs,
      serviceUUIDsArgs,
      serviceDataArgs,
      manufacturerSpecificDataArgs,
    ];
  }

  Object encode() {
    return _toList();
  }

  static MyAdvertiseDataArgs decode(Object result) {
    result as List<Object?>;
    return MyAdvertiseDataArgs(
      includeDeviceNameArgs: result[0] as bool?,
      includeTXPowerLevelArgs: result[1] as bool?,
      serviceUUIDsArgs: (result[2] as List<Object?>?)!.cast<String?>(),
      serviceDataArgs:
          (result[3] as Map<Object?, Object?>?)!.cast<String?, Uint8List?>(),
      manufacturerSpecificDataArgs:
          (result[4] as List<Object?>?)!
              .cast<MyManufacturerSpecificDataArgs?>(),
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! MyAdvertiseDataArgs || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList());
}

class MyCentralArgs {
  MyCentralArgs({required this.addressArgs});

  String addressArgs;

  List<Object?> _toList() {
    return <Object?>[addressArgs];
  }

  Object encode() {
    return _toList();
  }

  static MyCentralArgs decode(Object result) {
    result as List<Object?>;
    return MyCentralArgs(addressArgs: result[0]! as String);
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! MyCentralArgs || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList());
}

class MyPeripheralArgs {
  MyPeripheralArgs({required this.addressArgs});

  String addressArgs;

  List<Object?> _toList() {
    return <Object?>[addressArgs];
  }

  Object encode() {
    return _toList();
  }

  static MyPeripheralArgs decode(Object result) {
    result as List<Object?>;
    return MyPeripheralArgs(addressArgs: result[0]! as String);
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! MyPeripheralArgs || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList());
}

class MyGATTDescriptorArgs {
  MyGATTDescriptorArgs({required this.hashCodeArgs, required this.uuidArgs});

  int hashCodeArgs;

  String uuidArgs;

  List<Object?> _toList() {
    return <Object?>[hashCodeArgs, uuidArgs];
  }

  Object encode() {
    return _toList();
  }

  static MyGATTDescriptorArgs decode(Object result) {
    result as List<Object?>;
    return MyGATTDescriptorArgs(
      hashCodeArgs: result[0]! as int,
      uuidArgs: result[1]! as String,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! MyGATTDescriptorArgs || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList());
}

class MyGATTCharacteristicArgs {
  MyGATTCharacteristicArgs({
    required this.hashCodeArgs,
    required this.uuidArgs,
    required this.propertyNumbersArgs,
    required this.descriptorsArgs,
  });

  int hashCodeArgs;

  String uuidArgs;

  List<int?> propertyNumbersArgs;

  List<MyGATTDescriptorArgs?> descriptorsArgs;

  List<Object?> _toList() {
    return <Object?>[
      hashCodeArgs,
      uuidArgs,
      propertyNumbersArgs,
      descriptorsArgs,
    ];
  }

  Object encode() {
    return _toList();
  }

  static MyGATTCharacteristicArgs decode(Object result) {
    result as List<Object?>;
    return MyGATTCharacteristicArgs(
      hashCodeArgs: result[0]! as int,
      uuidArgs: result[1]! as String,
      propertyNumbersArgs: (result[2] as List<Object?>?)!.cast<int?>(),
      descriptorsArgs:
          (result[3] as List<Object?>?)!.cast<MyGATTDescriptorArgs?>(),
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! MyGATTCharacteristicArgs ||
        other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList());
}

class MyGATTServiceArgs {
  MyGATTServiceArgs({
    required this.hashCodeArgs,
    required this.uuidArgs,
    required this.isPrimaryArgs,
    required this.includedServicesArgs,
    required this.characteristicsArgs,
  });

  int hashCodeArgs;

  String uuidArgs;

  bool isPrimaryArgs;

  List<MyGATTServiceArgs?> includedServicesArgs;

  List<MyGATTCharacteristicArgs?> characteristicsArgs;

  List<Object?> _toList() {
    return <Object?>[
      hashCodeArgs,
      uuidArgs,
      isPrimaryArgs,
      includedServicesArgs,
      characteristicsArgs,
    ];
  }

  Object encode() {
    return _toList();
  }

  static MyGATTServiceArgs decode(Object result) {
    result as List<Object?>;
    return MyGATTServiceArgs(
      hashCodeArgs: result[0]! as int,
      uuidArgs: result[1]! as String,
      isPrimaryArgs: result[2]! as bool,
      includedServicesArgs:
          (result[3] as List<Object?>?)!.cast<MyGATTServiceArgs?>(),
      characteristicsArgs:
          (result[4] as List<Object?>?)!.cast<MyGATTCharacteristicArgs?>(),
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! MyGATTServiceArgs || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList());
}

class MyMutableGATTDescriptorArgs {
  MyMutableGATTDescriptorArgs({
    required this.hashCodeArgs,
    required this.uuidArgs,
    required this.permissionNumbersArgs,
  });

  int hashCodeArgs;

  String uuidArgs;

  List<int?> permissionNumbersArgs;

  List<Object?> _toList() {
    return <Object?>[hashCodeArgs, uuidArgs, permissionNumbersArgs];
  }

  Object encode() {
    return _toList();
  }

  static MyMutableGATTDescriptorArgs decode(Object result) {
    result as List<Object?>;
    return MyMutableGATTDescriptorArgs(
      hashCodeArgs: result[0]! as int,
      uuidArgs: result[1]! as String,
      permissionNumbersArgs: (result[2] as List<Object?>?)!.cast<int?>(),
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! MyMutableGATTDescriptorArgs ||
        other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList());
}

class MyMutableGATTCharacteristicArgs {
  MyMutableGATTCharacteristicArgs({
    required this.hashCodeArgs,
    required this.uuidArgs,
    required this.permissionNumbersArgs,
    required this.propertyNumbersArgs,
    required this.descriptorsArgs,
  });

  int hashCodeArgs;

  String uuidArgs;

  List<int?> permissionNumbersArgs;

  List<int?> propertyNumbersArgs;

  List<MyMutableGATTDescriptorArgs?> descriptorsArgs;

  List<Object?> _toList() {
    return <Object?>[
      hashCodeArgs,
      uuidArgs,
      permissionNumbersArgs,
      propertyNumbersArgs,
      descriptorsArgs,
    ];
  }

  Object encode() {
    return _toList();
  }

  static MyMutableGATTCharacteristicArgs decode(Object result) {
    result as List<Object?>;
    return MyMutableGATTCharacteristicArgs(
      hashCodeArgs: result[0]! as int,
      uuidArgs: result[1]! as String,
      permissionNumbersArgs: (result[2] as List<Object?>?)!.cast<int?>(),
      propertyNumbersArgs: (result[3] as List<Object?>?)!.cast<int?>(),
      descriptorsArgs:
          (result[4] as List<Object?>?)!.cast<MyMutableGATTDescriptorArgs?>(),
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! MyMutableGATTCharacteristicArgs ||
        other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList());
}

class MyMutableGATTServiceArgs {
  MyMutableGATTServiceArgs({
    required this.hashCodeArgs,
    required this.uuidArgs,
    required this.isPrimaryArgs,
    required this.includedServicesArgs,
    required this.characteristicsArgs,
  });

  int hashCodeArgs;

  String uuidArgs;

  bool isPrimaryArgs;

  List<MyMutableGATTServiceArgs?> includedServicesArgs;

  List<MyMutableGATTCharacteristicArgs?> characteristicsArgs;

  List<Object?> _toList() {
    return <Object?>[
      hashCodeArgs,
      uuidArgs,
      isPrimaryArgs,
      includedServicesArgs,
      characteristicsArgs,
    ];
  }

  Object encode() {
    return _toList();
  }

  static MyMutableGATTServiceArgs decode(Object result) {
    result as List<Object?>;
    return MyMutableGATTServiceArgs(
      hashCodeArgs: result[0]! as int,
      uuidArgs: result[1]! as String,
      isPrimaryArgs: result[2]! as bool,
      includedServicesArgs:
          (result[3] as List<Object?>?)!.cast<MyMutableGATTServiceArgs?>(),
      characteristicsArgs:
          (result[4] as List<Object?>?)!
              .cast<MyMutableGATTCharacteristicArgs?>(),
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! MyMutableGATTServiceArgs ||
        other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList());
}

class _PigeonCodec extends StandardMessageCodec {
  const _PigeonCodec();
  @override
  void writeValue(WriteBuffer buffer, Object? value) {
    if (value is int) {
      buffer.putUint8(4);
      buffer.putInt64(value);
    } else if (value is MyBluetoothLowEnergyStateArgs) {
      buffer.putUint8(129);
      writeValue(buffer, value.index);
    } else if (value is MyAdvertiseModeArgs) {
      buffer.putUint8(130);
      writeValue(buffer, value.index);
    } else if (value is MyTXPowerLevelArgs) {
      buffer.putUint8(131);
      writeValue(buffer, value.index);
    } else if (value is MyConnectionStateArgs) {
      buffer.putUint8(132);
      writeValue(buffer, value.index);
    } else if (value is MyGATTCharacteristicPropertyArgs) {
      buffer.putUint8(133);
      writeValue(buffer, value.index);
    } else if (value is MyGATTCharacteristicPermissionArgs) {
      buffer.putUint8(134);
      writeValue(buffer, value.index);
    } else if (value is MyGATTCharacteristicWriteTypeArgs) {
      buffer.putUint8(135);
      writeValue(buffer, value.index);
    } else if (value is MyGATTStatusArgs) {
      buffer.putUint8(136);
      writeValue(buffer, value.index);
    } else if (value is MyCentralManagerArgs) {
      buffer.putUint8(137);
      writeValue(buffer, value.encode());
    } else if (value is MyPeripheralManagerArgs) {
      buffer.putUint8(138);
      writeValue(buffer, value.encode());
    } else if (value is MyManufacturerSpecificDataArgs) {
      buffer.putUint8(139);
      writeValue(buffer, value.encode());
    } else if (value is MyAdvertisementArgs) {
      buffer.putUint8(140);
      writeValue(buffer, value.encode());
    } else if (value is MyAdvertiseSettingsArgs) {
      buffer.putUint8(141);
      writeValue(buffer, value.encode());
    } else if (value is MyAdvertiseDataArgs) {
      buffer.putUint8(142);
      writeValue(buffer, value.encode());
    } else if (value is MyCentralArgs) {
      buffer.putUint8(143);
      writeValue(buffer, value.encode());
    } else if (value is MyPeripheralArgs) {
      buffer.putUint8(144);
      writeValue(buffer, value.encode());
    } else if (value is MyGATTDescriptorArgs) {
      buffer.putUint8(145);
      writeValue(buffer, value.encode());
    } else if (value is MyGATTCharacteristicArgs) {
      buffer.putUint8(146);
      writeValue(buffer, value.encode());
    } else if (value is MyGATTServiceArgs) {
      buffer.putUint8(147);
      writeValue(buffer, value.encode());
    } else if (value is MyMutableGATTDescriptorArgs) {
      buffer.putUint8(148);
      writeValue(buffer, value.encode());
    } else if (value is MyMutableGATTCharacteristicArgs) {
      buffer.putUint8(149);
      writeValue(buffer, value.encode());
    } else if (value is MyMutableGATTServiceArgs) {
      buffer.putUint8(150);
      writeValue(buffer, value.encode());
    } else {
      super.writeValue(buffer, value);
    }
  }

  @override
  Object? readValueOfType(int type, ReadBuffer buffer) {
    switch (type) {
      case 129:
        final int? value = readValue(buffer) as int?;
        return value == null
            ? null
            : MyBluetoothLowEnergyStateArgs.values[value];
      case 130:
        final int? value = readValue(buffer) as int?;
        return value == null ? null : MyAdvertiseModeArgs.values[value];
      case 131:
        final int? value = readValue(buffer) as int?;
        return value == null ? null : MyTXPowerLevelArgs.values[value];
      case 132:
        final int? value = readValue(buffer) as int?;
        return value == null ? null : MyConnectionStateArgs.values[value];
      case 133:
        final int? value = readValue(buffer) as int?;
        return value == null
            ? null
            : MyGATTCharacteristicPropertyArgs.values[value];
      case 134:
        final int? value = readValue(buffer) as int?;
        return value == null
            ? null
            : MyGATTCharacteristicPermissionArgs.values[value];
      case 135:
        final int? value = readValue(buffer) as int?;
        return value == null
            ? null
            : MyGATTCharacteristicWriteTypeArgs.values[value];
      case 136:
        final int? value = readValue(buffer) as int?;
        return value == null ? null : MyGATTStatusArgs.values[value];
      case 137:
        return MyCentralManagerArgs.decode(readValue(buffer)!);
      case 138:
        return MyPeripheralManagerArgs.decode(readValue(buffer)!);
      case 139:
        return MyManufacturerSpecificDataArgs.decode(readValue(buffer)!);
      case 140:
        return MyAdvertisementArgs.decode(readValue(buffer)!);
      case 141:
        return MyAdvertiseSettingsArgs.decode(readValue(buffer)!);
      case 142:
        return MyAdvertiseDataArgs.decode(readValue(buffer)!);
      case 143:
        return MyCentralArgs.decode(readValue(buffer)!);
      case 144:
        return MyPeripheralArgs.decode(readValue(buffer)!);
      case 145:
        return MyGATTDescriptorArgs.decode(readValue(buffer)!);
      case 146:
        return MyGATTCharacteristicArgs.decode(readValue(buffer)!);
      case 147:
        return MyGATTServiceArgs.decode(readValue(buffer)!);
      case 148:
        return MyMutableGATTDescriptorArgs.decode(readValue(buffer)!);
      case 149:
        return MyMutableGATTCharacteristicArgs.decode(readValue(buffer)!);
      case 150:
        return MyMutableGATTServiceArgs.decode(readValue(buffer)!);
      default:
        return super.readValueOfType(type, buffer);
    }
  }
}

class MyCentralManagerHostAPI {
  /// Constructor for [MyCentralManagerHostAPI].  The [binaryMessenger] named argument is
  /// available for dependency injection.  If it is left null, the default
  /// BinaryMessenger will be used which routes to the host platform.
  MyCentralManagerHostAPI({
    BinaryMessenger? binaryMessenger,
    String messageChannelSuffix = '',
  }) : pigeonVar_binaryMessenger = binaryMessenger,
       pigeonVar_messageChannelSuffix =
           messageChannelSuffix.isNotEmpty ? '.$messageChannelSuffix' : '';
  final BinaryMessenger? pigeonVar_binaryMessenger;

  static const MessageCodec<Object?> pigeonChannelCodec = _PigeonCodec();

  final String pigeonVar_messageChannelSuffix;

  Future<MyCentralManagerArgs> initialize() async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_android.MyCentralManagerHostAPI.initialize$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(null);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as MyCentralManagerArgs?)!;
    }
  }

  Future<MyBluetoothLowEnergyStateArgs> getState() async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_android.MyCentralManagerHostAPI.getState$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(null);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as MyBluetoothLowEnergyStateArgs?)!;
    }
  }

  Future<bool> authorize() async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_android.MyCentralManagerHostAPI.authorize$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(null);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as bool?)!;
    }
  }

  Future<void> showAppSettings() async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_android.MyCentralManagerHostAPI.showAppSettings$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(null);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> startDiscovery(List<String> serviceUUIDsArgs) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_android.MyCentralManagerHostAPI.startDiscovery$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[serviceUUIDsArgs],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> stopDiscovery() async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_android.MyCentralManagerHostAPI.stopDiscovery$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(null);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> connect(String addressArgs) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_android.MyCentralManagerHostAPI.connect$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[addressArgs],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> disconnect(String addressArgs) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_android.MyCentralManagerHostAPI.disconnect$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[addressArgs],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<List<MyPeripheralArgs>> retrieveConnectedPeripherals() async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_android.MyCentralManagerHostAPI.retrieveConnectedPeripherals$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(null);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as List<Object?>?)!
          .cast<MyPeripheralArgs>();
    }
  }

  Future<int> requestMTU(String addressArgs, int mtuArgs) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_android.MyCentralManagerHostAPI.requestMTU$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[addressArgs, mtuArgs],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as int?)!;
    }
  }

  Future<int> readRSSI(String addressArgs) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_android.MyCentralManagerHostAPI.readRSSI$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[addressArgs],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as int?)!;
    }
  }

  Future<List<MyGATTServiceArgs>> discoverGATT(String addressArgs) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_android.MyCentralManagerHostAPI.discoverGATT$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[addressArgs],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as List<Object?>?)!
          .cast<MyGATTServiceArgs>();
    }
  }

  Future<Uint8List> readCharacteristic(
    String addressArgs,
    int hashCodeArgs,
  ) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_android.MyCentralManagerHostAPI.readCharacteristic$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[addressArgs, hashCodeArgs],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as Uint8List?)!;
    }
  }

  Future<void> writeCharacteristic(
    String addressArgs,
    int hashCodeArgs,
    Uint8List valueArgs,
    MyGATTCharacteristicWriteTypeArgs typeArgs,
  ) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_android.MyCentralManagerHostAPI.writeCharacteristic$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[addressArgs, hashCodeArgs, valueArgs, typeArgs],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> setCharacteristicNotification(
    String addressArgs,
    int hashCodeArgs,
    bool enableArgs,
  ) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_android.MyCentralManagerHostAPI.setCharacteristicNotification$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[addressArgs, hashCodeArgs, enableArgs],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<Uint8List> readDescriptor(String addressArgs, int hashCodeArgs) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_android.MyCentralManagerHostAPI.readDescriptor$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[addressArgs, hashCodeArgs],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as Uint8List?)!;
    }
  }

  Future<void> writeDescriptor(
    String addressArgs,
    int hashCodeArgs,
    Uint8List valueArgs,
  ) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_android.MyCentralManagerHostAPI.writeDescriptor$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[addressArgs, hashCodeArgs, valueArgs],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }
}

abstract class MyCentralManagerFlutterAPI {
  static const MessageCodec<Object?> pigeonChannelCodec = _PigeonCodec();

  void onStateChanged(MyBluetoothLowEnergyStateArgs stateArgs);

  void onDiscovered(
    MyPeripheralArgs peripheralArgs,
    int rssiArgs,
    MyAdvertisementArgs advertisementArgs,
  );

  void onConnectionStateChanged(
    MyPeripheralArgs peripheralArgs,
    MyConnectionStateArgs stateArgs,
  );

  void onMTUChanged(MyPeripheralArgs peripheralArgs, int mtuArgs);

  void onCharacteristicNotified(
    MyPeripheralArgs peripheralArgs,
    MyGATTCharacteristicArgs characteristicArgs,
    Uint8List valueArgs,
  );

  static void setUp(
    MyCentralManagerFlutterAPI? api, {
    BinaryMessenger? binaryMessenger,
    String messageChannelSuffix = '',
  }) {
    messageChannelSuffix =
        messageChannelSuffix.isNotEmpty ? '.$messageChannelSuffix' : '';
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.bluetooth_low_energy_android.MyCentralManagerFlutterAPI.onStateChanged$messageChannelSuffix',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_android.MyCentralManagerFlutterAPI.onStateChanged was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final MyBluetoothLowEnergyStateArgs? arg_stateArgs =
              (args[0] as MyBluetoothLowEnergyStateArgs?);
          assert(
            arg_stateArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_android.MyCentralManagerFlutterAPI.onStateChanged was null, expected non-null MyBluetoothLowEnergyStateArgs.',
          );
          try {
            api.onStateChanged(arg_stateArgs!);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.bluetooth_low_energy_android.MyCentralManagerFlutterAPI.onDiscovered$messageChannelSuffix',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_android.MyCentralManagerFlutterAPI.onDiscovered was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final MyPeripheralArgs? arg_peripheralArgs =
              (args[0] as MyPeripheralArgs?);
          assert(
            arg_peripheralArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_android.MyCentralManagerFlutterAPI.onDiscovered was null, expected non-null MyPeripheralArgs.',
          );
          final int? arg_rssiArgs = (args[1] as int?);
          assert(
            arg_rssiArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_android.MyCentralManagerFlutterAPI.onDiscovered was null, expected non-null int.',
          );
          final MyAdvertisementArgs? arg_advertisementArgs =
              (args[2] as MyAdvertisementArgs?);
          assert(
            arg_advertisementArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_android.MyCentralManagerFlutterAPI.onDiscovered was null, expected non-null MyAdvertisementArgs.',
          );
          try {
            api.onDiscovered(
              arg_peripheralArgs!,
              arg_rssiArgs!,
              arg_advertisementArgs!,
            );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.bluetooth_low_energy_android.MyCentralManagerFlutterAPI.onConnectionStateChanged$messageChannelSuffix',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_android.MyCentralManagerFlutterAPI.onConnectionStateChanged was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final MyPeripheralArgs? arg_peripheralArgs =
              (args[0] as MyPeripheralArgs?);
          assert(
            arg_peripheralArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_android.MyCentralManagerFlutterAPI.onConnectionStateChanged was null, expected non-null MyPeripheralArgs.',
          );
          final MyConnectionStateArgs? arg_stateArgs =
              (args[1] as MyConnectionStateArgs?);
          assert(
            arg_stateArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_android.MyCentralManagerFlutterAPI.onConnectionStateChanged was null, expected non-null MyConnectionStateArgs.',
          );
          try {
            api.onConnectionStateChanged(arg_peripheralArgs!, arg_stateArgs!);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.bluetooth_low_energy_android.MyCentralManagerFlutterAPI.onMTUChanged$messageChannelSuffix',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_android.MyCentralManagerFlutterAPI.onMTUChanged was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final MyPeripheralArgs? arg_peripheralArgs =
              (args[0] as MyPeripheralArgs?);
          assert(
            arg_peripheralArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_android.MyCentralManagerFlutterAPI.onMTUChanged was null, expected non-null MyPeripheralArgs.',
          );
          final int? arg_mtuArgs = (args[1] as int?);
          assert(
            arg_mtuArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_android.MyCentralManagerFlutterAPI.onMTUChanged was null, expected non-null int.',
          );
          try {
            api.onMTUChanged(arg_peripheralArgs!, arg_mtuArgs!);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.bluetooth_low_energy_android.MyCentralManagerFlutterAPI.onCharacteristicNotified$messageChannelSuffix',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_android.MyCentralManagerFlutterAPI.onCharacteristicNotified was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final MyPeripheralArgs? arg_peripheralArgs =
              (args[0] as MyPeripheralArgs?);
          assert(
            arg_peripheralArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_android.MyCentralManagerFlutterAPI.onCharacteristicNotified was null, expected non-null MyPeripheralArgs.',
          );
          final MyGATTCharacteristicArgs? arg_characteristicArgs =
              (args[1] as MyGATTCharacteristicArgs?);
          assert(
            arg_characteristicArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_android.MyCentralManagerFlutterAPI.onCharacteristicNotified was null, expected non-null MyGATTCharacteristicArgs.',
          );
          final Uint8List? arg_valueArgs = (args[2] as Uint8List?);
          assert(
            arg_valueArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_android.MyCentralManagerFlutterAPI.onCharacteristicNotified was null, expected non-null Uint8List.',
          );
          try {
            api.onCharacteristicNotified(
              arg_peripheralArgs!,
              arg_characteristicArgs!,
              arg_valueArgs!,
            );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }
}

class MyPeripheralManagerHostAPI {
  /// Constructor for [MyPeripheralManagerHostAPI].  The [binaryMessenger] named argument is
  /// available for dependency injection.  If it is left null, the default
  /// BinaryMessenger will be used which routes to the host platform.
  MyPeripheralManagerHostAPI({
    BinaryMessenger? binaryMessenger,
    String messageChannelSuffix = '',
  }) : pigeonVar_binaryMessenger = binaryMessenger,
       pigeonVar_messageChannelSuffix =
           messageChannelSuffix.isNotEmpty ? '.$messageChannelSuffix' : '';
  final BinaryMessenger? pigeonVar_binaryMessenger;

  static const MessageCodec<Object?> pigeonChannelCodec = _PigeonCodec();

  final String pigeonVar_messageChannelSuffix;

  Future<MyPeripheralManagerArgs> initialize() async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerHostAPI.initialize$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(null);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as MyPeripheralManagerArgs?)!;
    }
  }

  Future<MyBluetoothLowEnergyStateArgs> getState() async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerHostAPI.getState$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(null);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as MyBluetoothLowEnergyStateArgs?)!;
    }
  }

  Future<bool> authorize() async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerHostAPI.authorize$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(null);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as bool?)!;
    }
  }

  Future<void> showAppSettings() async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerHostAPI.showAppSettings$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(null);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<String?> setName(String nameArgs) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerHostAPI.setName$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[nameArgs],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return (pigeonVar_replyList[0] as String?);
    }
  }

  Future<void> openGATTServer() async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerHostAPI.openGATTServer$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(null);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> closeGATTServer() async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerHostAPI.closeGATTServer$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(null);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> addService(MyMutableGATTServiceArgs serviceArgs) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerHostAPI.addService$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[serviceArgs],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> removeService(int hashCodeArgs) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerHostAPI.removeService$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[hashCodeArgs],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> removeAllServices() async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerHostAPI.removeAllServices$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(null);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> startAdvertising(
    MyAdvertiseSettingsArgs settingsArgs,
    MyAdvertiseDataArgs advertiseDataArgs,
    MyAdvertiseDataArgs scanResponseArgs,
  ) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerHostAPI.startAdvertising$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[settingsArgs, advertiseDataArgs, scanResponseArgs],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> stopAdvertising() async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerHostAPI.stopAdvertising$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(null);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> sendResponse(
    String addressArgs,
    int idArgs,
    MyGATTStatusArgs statusArgs,
    int offsetArgs,
    Uint8List? valueArgs,
  ) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerHostAPI.sendResponse$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[addressArgs, idArgs, statusArgs, offsetArgs, valueArgs],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> notifyCharacteristicChanged(
    String addressArgs,
    int hashCodeArgs,
    bool confirmArgs,
    Uint8List valueArgs,
  ) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerHostAPI.notifyCharacteristicChanged$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[addressArgs, hashCodeArgs, confirmArgs, valueArgs],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }
}

abstract class MyPeripheralManagerFlutterAPI {
  static const MessageCodec<Object?> pigeonChannelCodec = _PigeonCodec();

  void onStateChanged(MyBluetoothLowEnergyStateArgs stateArgs);

  void onConnectionStateChanged(
    MyCentralArgs centralArgs,
    int statusArgs,
    MyConnectionStateArgs stateArgs,
  );

  void onMTUChanged(MyCentralArgs centralArgs, int mtuArgs);

  void onCharacteristicReadRequest(
    MyCentralArgs centralArgs,
    int idArgs,
    int offsetArgs,
    int hashCodeArgs,
  );

  void onCharacteristicWriteRequest(
    MyCentralArgs centralArgs,
    int idArgs,
    int hashCodeArgs,
    bool preparedWriteArgs,
    bool responseNeededArgs,
    int offsetArgs,
    Uint8List valueArgs,
  );

  void onDescriptorReadRequest(
    MyCentralArgs centralArgs,
    int idArgs,
    int offsetArgs,
    int hashCodeArgs,
  );

  void onDescriptorWriteRequest(
    MyCentralArgs centralArgs,
    int idArgs,
    int hashCodeArgs,
    bool preparedWriteArgs,
    bool responseNeededArgs,
    int offsetArgs,
    Uint8List valueArgs,
  );

  void onExecuteWrite(MyCentralArgs centralArgs, int idArgs, bool executeArgs);

  static void setUp(
    MyPeripheralManagerFlutterAPI? api, {
    BinaryMessenger? binaryMessenger,
    String messageChannelSuffix = '',
  }) {
    messageChannelSuffix =
        messageChannelSuffix.isNotEmpty ? '.$messageChannelSuffix' : '';
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerFlutterAPI.onStateChanged$messageChannelSuffix',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerFlutterAPI.onStateChanged was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final MyBluetoothLowEnergyStateArgs? arg_stateArgs =
              (args[0] as MyBluetoothLowEnergyStateArgs?);
          assert(
            arg_stateArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerFlutterAPI.onStateChanged was null, expected non-null MyBluetoothLowEnergyStateArgs.',
          );
          try {
            api.onStateChanged(arg_stateArgs!);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerFlutterAPI.onConnectionStateChanged$messageChannelSuffix',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerFlutterAPI.onConnectionStateChanged was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final MyCentralArgs? arg_centralArgs = (args[0] as MyCentralArgs?);
          assert(
            arg_centralArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerFlutterAPI.onConnectionStateChanged was null, expected non-null MyCentralArgs.',
          );
          final int? arg_statusArgs = (args[1] as int?);
          assert(
            arg_statusArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerFlutterAPI.onConnectionStateChanged was null, expected non-null int.',
          );
          final MyConnectionStateArgs? arg_stateArgs =
              (args[2] as MyConnectionStateArgs?);
          assert(
            arg_stateArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerFlutterAPI.onConnectionStateChanged was null, expected non-null MyConnectionStateArgs.',
          );
          try {
            api.onConnectionStateChanged(
              arg_centralArgs!,
              arg_statusArgs!,
              arg_stateArgs!,
            );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerFlutterAPI.onMTUChanged$messageChannelSuffix',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerFlutterAPI.onMTUChanged was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final MyCentralArgs? arg_centralArgs = (args[0] as MyCentralArgs?);
          assert(
            arg_centralArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerFlutterAPI.onMTUChanged was null, expected non-null MyCentralArgs.',
          );
          final int? arg_mtuArgs = (args[1] as int?);
          assert(
            arg_mtuArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerFlutterAPI.onMTUChanged was null, expected non-null int.',
          );
          try {
            api.onMTUChanged(arg_centralArgs!, arg_mtuArgs!);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerFlutterAPI.onCharacteristicReadRequest$messageChannelSuffix',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerFlutterAPI.onCharacteristicReadRequest was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final MyCentralArgs? arg_centralArgs = (args[0] as MyCentralArgs?);
          assert(
            arg_centralArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerFlutterAPI.onCharacteristicReadRequest was null, expected non-null MyCentralArgs.',
          );
          final int? arg_idArgs = (args[1] as int?);
          assert(
            arg_idArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerFlutterAPI.onCharacteristicReadRequest was null, expected non-null int.',
          );
          final int? arg_offsetArgs = (args[2] as int?);
          assert(
            arg_offsetArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerFlutterAPI.onCharacteristicReadRequest was null, expected non-null int.',
          );
          final int? arg_hashCodeArgs = (args[3] as int?);
          assert(
            arg_hashCodeArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerFlutterAPI.onCharacteristicReadRequest was null, expected non-null int.',
          );
          try {
            api.onCharacteristicReadRequest(
              arg_centralArgs!,
              arg_idArgs!,
              arg_offsetArgs!,
              arg_hashCodeArgs!,
            );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerFlutterAPI.onCharacteristicWriteRequest$messageChannelSuffix',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerFlutterAPI.onCharacteristicWriteRequest was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final MyCentralArgs? arg_centralArgs = (args[0] as MyCentralArgs?);
          assert(
            arg_centralArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerFlutterAPI.onCharacteristicWriteRequest was null, expected non-null MyCentralArgs.',
          );
          final int? arg_idArgs = (args[1] as int?);
          assert(
            arg_idArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerFlutterAPI.onCharacteristicWriteRequest was null, expected non-null int.',
          );
          final int? arg_hashCodeArgs = (args[2] as int?);
          assert(
            arg_hashCodeArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerFlutterAPI.onCharacteristicWriteRequest was null, expected non-null int.',
          );
          final bool? arg_preparedWriteArgs = (args[3] as bool?);
          assert(
            arg_preparedWriteArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerFlutterAPI.onCharacteristicWriteRequest was null, expected non-null bool.',
          );
          final bool? arg_responseNeededArgs = (args[4] as bool?);
          assert(
            arg_responseNeededArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerFlutterAPI.onCharacteristicWriteRequest was null, expected non-null bool.',
          );
          final int? arg_offsetArgs = (args[5] as int?);
          assert(
            arg_offsetArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerFlutterAPI.onCharacteristicWriteRequest was null, expected non-null int.',
          );
          final Uint8List? arg_valueArgs = (args[6] as Uint8List?);
          assert(
            arg_valueArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerFlutterAPI.onCharacteristicWriteRequest was null, expected non-null Uint8List.',
          );
          try {
            api.onCharacteristicWriteRequest(
              arg_centralArgs!,
              arg_idArgs!,
              arg_hashCodeArgs!,
              arg_preparedWriteArgs!,
              arg_responseNeededArgs!,
              arg_offsetArgs!,
              arg_valueArgs!,
            );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerFlutterAPI.onDescriptorReadRequest$messageChannelSuffix',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerFlutterAPI.onDescriptorReadRequest was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final MyCentralArgs? arg_centralArgs = (args[0] as MyCentralArgs?);
          assert(
            arg_centralArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerFlutterAPI.onDescriptorReadRequest was null, expected non-null MyCentralArgs.',
          );
          final int? arg_idArgs = (args[1] as int?);
          assert(
            arg_idArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerFlutterAPI.onDescriptorReadRequest was null, expected non-null int.',
          );
          final int? arg_offsetArgs = (args[2] as int?);
          assert(
            arg_offsetArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerFlutterAPI.onDescriptorReadRequest was null, expected non-null int.',
          );
          final int? arg_hashCodeArgs = (args[3] as int?);
          assert(
            arg_hashCodeArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerFlutterAPI.onDescriptorReadRequest was null, expected non-null int.',
          );
          try {
            api.onDescriptorReadRequest(
              arg_centralArgs!,
              arg_idArgs!,
              arg_offsetArgs!,
              arg_hashCodeArgs!,
            );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerFlutterAPI.onDescriptorWriteRequest$messageChannelSuffix',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerFlutterAPI.onDescriptorWriteRequest was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final MyCentralArgs? arg_centralArgs = (args[0] as MyCentralArgs?);
          assert(
            arg_centralArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerFlutterAPI.onDescriptorWriteRequest was null, expected non-null MyCentralArgs.',
          );
          final int? arg_idArgs = (args[1] as int?);
          assert(
            arg_idArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerFlutterAPI.onDescriptorWriteRequest was null, expected non-null int.',
          );
          final int? arg_hashCodeArgs = (args[2] as int?);
          assert(
            arg_hashCodeArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerFlutterAPI.onDescriptorWriteRequest was null, expected non-null int.',
          );
          final bool? arg_preparedWriteArgs = (args[3] as bool?);
          assert(
            arg_preparedWriteArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerFlutterAPI.onDescriptorWriteRequest was null, expected non-null bool.',
          );
          final bool? arg_responseNeededArgs = (args[4] as bool?);
          assert(
            arg_responseNeededArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerFlutterAPI.onDescriptorWriteRequest was null, expected non-null bool.',
          );
          final int? arg_offsetArgs = (args[5] as int?);
          assert(
            arg_offsetArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerFlutterAPI.onDescriptorWriteRequest was null, expected non-null int.',
          );
          final Uint8List? arg_valueArgs = (args[6] as Uint8List?);
          assert(
            arg_valueArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerFlutterAPI.onDescriptorWriteRequest was null, expected non-null Uint8List.',
          );
          try {
            api.onDescriptorWriteRequest(
              arg_centralArgs!,
              arg_idArgs!,
              arg_hashCodeArgs!,
              arg_preparedWriteArgs!,
              arg_responseNeededArgs!,
              arg_offsetArgs!,
              arg_valueArgs!,
            );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerFlutterAPI.onExecuteWrite$messageChannelSuffix',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerFlutterAPI.onExecuteWrite was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final MyCentralArgs? arg_centralArgs = (args[0] as MyCentralArgs?);
          assert(
            arg_centralArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerFlutterAPI.onExecuteWrite was null, expected non-null MyCentralArgs.',
          );
          final int? arg_idArgs = (args[1] as int?);
          assert(
            arg_idArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerFlutterAPI.onExecuteWrite was null, expected non-null int.',
          );
          final bool? arg_executeArgs = (args[2] as bool?);
          assert(
            arg_executeArgs != null,
            'Argument for dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerFlutterAPI.onExecuteWrite was null, expected non-null bool.',
          );
          try {
            api.onExecuteWrite(arg_centralArgs!, arg_idArgs!, arg_executeArgs!);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }
}
