// Autogenerated from Pigeon (v26.0.0), do not edit directly.
// See also: https://pub.dev/packages/pigeon
@file:Suppress("UNCHECKED_CAST", "ArrayInDataClass")

package dev.zeekr.bluetooth_low_energy_android

import android.util.Log
import io.flutter.plugin.common.BasicMessageChannel
import io.flutter.plugin.common.BinaryMessenger
import io.flutter.plugin.common.EventChannel
import io.flutter.plugin.common.MessageCodec
import io.flutter.plugin.common.StandardMethodCodec
import io.flutter.plugin.common.StandardMessageCodec
import java.io.ByteArrayOutputStream
import java.nio.ByteBuffer
private object MyAPIPigeonUtils {

  fun createConnectionError(channelName: String): FlutterError {
    return FlutterError("channel-error",  "Unable to establish connection on channel: '$channelName'.", "")  }

  fun wrapResult(result: Any?): List<Any?> {
    return listOf(result)
  }

  fun wrapError(exception: Throwable): List<Any?> {
    return if (exception is FlutterError) {
      listOf(
        exception.code,
        exception.message,
        exception.details
      )
    } else {
      listOf(
        exception.javaClass.simpleName,
        exception.toString(),
        "Cause: " + exception.cause + ", Stacktrace: " + Log.getStackTraceString(exception)
      )
    }
  }
  fun deepEquals(a: Any?, b: Any?): Boolean {
    if (a is ByteArray && b is ByteArray) {
        return a.contentEquals(b)
    }
    if (a is IntArray && b is IntArray) {
        return a.contentEquals(b)
    }
    if (a is LongArray && b is LongArray) {
        return a.contentEquals(b)
    }
    if (a is DoubleArray && b is DoubleArray) {
        return a.contentEquals(b)
    }
    if (a is Array<*> && b is Array<*>) {
      return a.size == b.size &&
          a.indices.all{ deepEquals(a[it], b[it]) }
    }
    if (a is List<*> && b is List<*>) {
      return a.size == b.size &&
          a.indices.all{ deepEquals(a[it], b[it]) }
    }
    if (a is Map<*, *> && b is Map<*, *>) {
      return a.size == b.size && a.all {
          (b as Map<Any?, Any?>).containsKey(it.key) &&
          deepEquals(it.value, b[it.key])
      }
    }
    return a == b
  }
      
}

/**
 * Error class for passing custom error details to Flutter via a thrown PlatformException.
 * @property code The error code.
 * @property message The error message.
 * @property details The error details. Must be a datatype supported by the api codec.
 */
class FlutterError (
  val code: String,
  override val message: String? = null,
  val details: Any? = null
) : Throwable()

enum class MyBluetoothLowEnergyStateArgs(val raw: Int) {
  UNKNOWN(0),
  UNSUPPORTED(1),
  UNAUTHORIZED(2),
  OFF(3),
  TURNING_ON(4),
  ON(5),
  TURNING_OFF(6);

  companion object {
    fun ofRaw(raw: Int): MyBluetoothLowEnergyStateArgs? {
      return values().firstOrNull { it.raw == raw }
    }
  }
}

enum class MyAdvertiseModeArgs(val raw: Int) {
  LOW_POWER(0),
  BALANCED(1),
  LOW_LATENCY(2);

  companion object {
    fun ofRaw(raw: Int): MyAdvertiseModeArgs? {
      return values().firstOrNull { it.raw == raw }
    }
  }
}

enum class MyTXPowerLevelArgs(val raw: Int) {
  ULTRA_LOW(0),
  LOW(1),
  MEDIUM(2),
  HIGH(3);

  companion object {
    fun ofRaw(raw: Int): MyTXPowerLevelArgs? {
      return values().firstOrNull { it.raw == raw }
    }
  }
}

enum class MyConnectionStateArgs(val raw: Int) {
  DISCONNECTED(0),
  CONNECTING(1),
  CONNECTED(2),
  DISCONNECTING(3);

  companion object {
    fun ofRaw(raw: Int): MyConnectionStateArgs? {
      return values().firstOrNull { it.raw == raw }
    }
  }
}

enum class MyGATTCharacteristicPropertyArgs(val raw: Int) {
  READ(0),
  WRITE(1),
  WRITE_WITHOUT_RESPONSE(2),
  NOTIFY(3),
  INDICATE(4);

  companion object {
    fun ofRaw(raw: Int): MyGATTCharacteristicPropertyArgs? {
      return values().firstOrNull { it.raw == raw }
    }
  }
}

enum class MyGATTCharacteristicPermissionArgs(val raw: Int) {
  READ(0),
  READ_ENCRYPTED(1),
  WRITE(2),
  WRITE_ENCRYPTED(3);

  companion object {
    fun ofRaw(raw: Int): MyGATTCharacteristicPermissionArgs? {
      return values().firstOrNull { it.raw == raw }
    }
  }
}

enum class MyGATTCharacteristicWriteTypeArgs(val raw: Int) {
  WITH_RESPONSE(0),
  WITHOUT_RESPONSE(1);

  companion object {
    fun ofRaw(raw: Int): MyGATTCharacteristicWriteTypeArgs? {
      return values().firstOrNull { it.raw == raw }
    }
  }
}

enum class MyGATTStatusArgs(val raw: Int) {
  SUCCESS(0),
  READ_NOT_PERMITTED(1),
  WRITE_NOT_PERMITTED(2),
  INSUFFICIENT_AUTHENTICATION(3),
  REQUEST_NOT_SUPPORTED(4),
  INSUFFICIENT_ENCRYPTION(5),
  INVALID_OFFSET(6),
  INSUFFICIENT_AUTHORIZATION(7),
  INVALID_ATTRIBUTE_LENGTH(8),
  CONNECTION_CONGESTED(9),
  FAILURE(10);

  companion object {
    fun ofRaw(raw: Int): MyGATTStatusArgs? {
      return values().firstOrNull { it.raw == raw }
    }
  }
}

/** Generated class from Pigeon that represents data sent in messages. */
data class MyCentralManagerArgs (
  val enableNotificationValue: ByteArray,
  val enableIndicationValue: ByteArray,
  val disableNotificationValue: ByteArray
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): MyCentralManagerArgs {
      val enableNotificationValue = pigeonVar_list[0] as ByteArray
      val enableIndicationValue = pigeonVar_list[1] as ByteArray
      val disableNotificationValue = pigeonVar_list[2] as ByteArray
      return MyCentralManagerArgs(enableNotificationValue, enableIndicationValue, disableNotificationValue)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      enableNotificationValue,
      enableIndicationValue,
      disableNotificationValue,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is MyCentralManagerArgs) {
      return false
    }
    if (this === other) {
      return true
    }
    return MyAPIPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/** Generated class from Pigeon that represents data sent in messages. */
data class MyPeripheralManagerArgs (
  val enableNotificationValue: ByteArray,
  val enableIndicationValue: ByteArray,
  val disableNotificationValue: ByteArray
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): MyPeripheralManagerArgs {
      val enableNotificationValue = pigeonVar_list[0] as ByteArray
      val enableIndicationValue = pigeonVar_list[1] as ByteArray
      val disableNotificationValue = pigeonVar_list[2] as ByteArray
      return MyPeripheralManagerArgs(enableNotificationValue, enableIndicationValue, disableNotificationValue)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      enableNotificationValue,
      enableIndicationValue,
      disableNotificationValue,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is MyPeripheralManagerArgs) {
      return false
    }
    if (this === other) {
      return true
    }
    return MyAPIPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/** Generated class from Pigeon that represents data sent in messages. */
data class MyManufacturerSpecificDataArgs (
  val idArgs: Long,
  val dataArgs: ByteArray
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): MyManufacturerSpecificDataArgs {
      val idArgs = pigeonVar_list[0] as Long
      val dataArgs = pigeonVar_list[1] as ByteArray
      return MyManufacturerSpecificDataArgs(idArgs, dataArgs)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      idArgs,
      dataArgs,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is MyManufacturerSpecificDataArgs) {
      return false
    }
    if (this === other) {
      return true
    }
    return MyAPIPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/** Generated class from Pigeon that represents data sent in messages. */
data class MyAdvertisementArgs (
  val nameArgs: String? = null,
  val serviceUUIDsArgs: List<String?>,
  val serviceDataArgs: Map<String?, ByteArray?>,
  val manufacturerSpecificDataArgs: List<MyManufacturerSpecificDataArgs?>
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): MyAdvertisementArgs {
      val nameArgs = pigeonVar_list[0] as String?
      val serviceUUIDsArgs = pigeonVar_list[1] as List<String?>
      val serviceDataArgs = pigeonVar_list[2] as Map<String?, ByteArray?>
      val manufacturerSpecificDataArgs = pigeonVar_list[3] as List<MyManufacturerSpecificDataArgs?>
      return MyAdvertisementArgs(nameArgs, serviceUUIDsArgs, serviceDataArgs, manufacturerSpecificDataArgs)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      nameArgs,
      serviceUUIDsArgs,
      serviceDataArgs,
      manufacturerSpecificDataArgs,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is MyAdvertisementArgs) {
      return false
    }
    if (this === other) {
      return true
    }
    return MyAPIPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/** Generated class from Pigeon that represents data sent in messages. */
data class MyAdvertiseSettingsArgs (
  val modeArgs: MyAdvertiseModeArgs? = null,
  val connectableArgs: Boolean? = null,
  val timeoutArgs: Long? = null,
  val txPowerLevelArgs: MyTXPowerLevelArgs? = null
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): MyAdvertiseSettingsArgs {
      val modeArgs = pigeonVar_list[0] as MyAdvertiseModeArgs?
      val connectableArgs = pigeonVar_list[1] as Boolean?
      val timeoutArgs = pigeonVar_list[2] as Long?
      val txPowerLevelArgs = pigeonVar_list[3] as MyTXPowerLevelArgs?
      return MyAdvertiseSettingsArgs(modeArgs, connectableArgs, timeoutArgs, txPowerLevelArgs)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      modeArgs,
      connectableArgs,
      timeoutArgs,
      txPowerLevelArgs,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is MyAdvertiseSettingsArgs) {
      return false
    }
    if (this === other) {
      return true
    }
    return MyAPIPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/** Generated class from Pigeon that represents data sent in messages. */
data class MyAdvertiseDataArgs (
  val includeDeviceNameArgs: Boolean? = null,
  val includeTXPowerLevelArgs: Boolean? = null,
  val serviceUUIDsArgs: List<String?>,
  val serviceDataArgs: Map<String?, ByteArray?>,
  val manufacturerSpecificDataArgs: List<MyManufacturerSpecificDataArgs?>
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): MyAdvertiseDataArgs {
      val includeDeviceNameArgs = pigeonVar_list[0] as Boolean?
      val includeTXPowerLevelArgs = pigeonVar_list[1] as Boolean?
      val serviceUUIDsArgs = pigeonVar_list[2] as List<String?>
      val serviceDataArgs = pigeonVar_list[3] as Map<String?, ByteArray?>
      val manufacturerSpecificDataArgs = pigeonVar_list[4] as List<MyManufacturerSpecificDataArgs?>
      return MyAdvertiseDataArgs(includeDeviceNameArgs, includeTXPowerLevelArgs, serviceUUIDsArgs, serviceDataArgs, manufacturerSpecificDataArgs)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      includeDeviceNameArgs,
      includeTXPowerLevelArgs,
      serviceUUIDsArgs,
      serviceDataArgs,
      manufacturerSpecificDataArgs,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is MyAdvertiseDataArgs) {
      return false
    }
    if (this === other) {
      return true
    }
    return MyAPIPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/** Generated class from Pigeon that represents data sent in messages. */
data class MyCentralArgs (
  val addressArgs: String
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): MyCentralArgs {
      val addressArgs = pigeonVar_list[0] as String
      return MyCentralArgs(addressArgs)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      addressArgs,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is MyCentralArgs) {
      return false
    }
    if (this === other) {
      return true
    }
    return MyAPIPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/** Generated class from Pigeon that represents data sent in messages. */
data class MyPeripheralArgs (
  val addressArgs: String
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): MyPeripheralArgs {
      val addressArgs = pigeonVar_list[0] as String
      return MyPeripheralArgs(addressArgs)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      addressArgs,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is MyPeripheralArgs) {
      return false
    }
    if (this === other) {
      return true
    }
    return MyAPIPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/** Generated class from Pigeon that represents data sent in messages. */
data class MyGATTDescriptorArgs (
  val hashCodeArgs: Long,
  val uuidArgs: String
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): MyGATTDescriptorArgs {
      val hashCodeArgs = pigeonVar_list[0] as Long
      val uuidArgs = pigeonVar_list[1] as String
      return MyGATTDescriptorArgs(hashCodeArgs, uuidArgs)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      hashCodeArgs,
      uuidArgs,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is MyGATTDescriptorArgs) {
      return false
    }
    if (this === other) {
      return true
    }
    return MyAPIPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/** Generated class from Pigeon that represents data sent in messages. */
data class MyGATTCharacteristicArgs (
  val hashCodeArgs: Long,
  val uuidArgs: String,
  val propertyNumbersArgs: List<Long?>,
  val descriptorsArgs: List<MyGATTDescriptorArgs?>
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): MyGATTCharacteristicArgs {
      val hashCodeArgs = pigeonVar_list[0] as Long
      val uuidArgs = pigeonVar_list[1] as String
      val propertyNumbersArgs = pigeonVar_list[2] as List<Long?>
      val descriptorsArgs = pigeonVar_list[3] as List<MyGATTDescriptorArgs?>
      return MyGATTCharacteristicArgs(hashCodeArgs, uuidArgs, propertyNumbersArgs, descriptorsArgs)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      hashCodeArgs,
      uuidArgs,
      propertyNumbersArgs,
      descriptorsArgs,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is MyGATTCharacteristicArgs) {
      return false
    }
    if (this === other) {
      return true
    }
    return MyAPIPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/** Generated class from Pigeon that represents data sent in messages. */
data class MyGATTServiceArgs (
  val hashCodeArgs: Long,
  val uuidArgs: String,
  val isPrimaryArgs: Boolean,
  val includedServicesArgs: List<MyGATTServiceArgs?>,
  val characteristicsArgs: List<MyGATTCharacteristicArgs?>
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): MyGATTServiceArgs {
      val hashCodeArgs = pigeonVar_list[0] as Long
      val uuidArgs = pigeonVar_list[1] as String
      val isPrimaryArgs = pigeonVar_list[2] as Boolean
      val includedServicesArgs = pigeonVar_list[3] as List<MyGATTServiceArgs?>
      val characteristicsArgs = pigeonVar_list[4] as List<MyGATTCharacteristicArgs?>
      return MyGATTServiceArgs(hashCodeArgs, uuidArgs, isPrimaryArgs, includedServicesArgs, characteristicsArgs)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      hashCodeArgs,
      uuidArgs,
      isPrimaryArgs,
      includedServicesArgs,
      characteristicsArgs,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is MyGATTServiceArgs) {
      return false
    }
    if (this === other) {
      return true
    }
    return MyAPIPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/** Generated class from Pigeon that represents data sent in messages. */
data class MyMutableGATTDescriptorArgs (
  val hashCodeArgs: Long,
  val uuidArgs: String,
  val permissionNumbersArgs: List<Long?>
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): MyMutableGATTDescriptorArgs {
      val hashCodeArgs = pigeonVar_list[0] as Long
      val uuidArgs = pigeonVar_list[1] as String
      val permissionNumbersArgs = pigeonVar_list[2] as List<Long?>
      return MyMutableGATTDescriptorArgs(hashCodeArgs, uuidArgs, permissionNumbersArgs)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      hashCodeArgs,
      uuidArgs,
      permissionNumbersArgs,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is MyMutableGATTDescriptorArgs) {
      return false
    }
    if (this === other) {
      return true
    }
    return MyAPIPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/** Generated class from Pigeon that represents data sent in messages. */
data class MyMutableGATTCharacteristicArgs (
  val hashCodeArgs: Long,
  val uuidArgs: String,
  val permissionNumbersArgs: List<Long?>,
  val propertyNumbersArgs: List<Long?>,
  val descriptorsArgs: List<MyMutableGATTDescriptorArgs?>
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): MyMutableGATTCharacteristicArgs {
      val hashCodeArgs = pigeonVar_list[0] as Long
      val uuidArgs = pigeonVar_list[1] as String
      val permissionNumbersArgs = pigeonVar_list[2] as List<Long?>
      val propertyNumbersArgs = pigeonVar_list[3] as List<Long?>
      val descriptorsArgs = pigeonVar_list[4] as List<MyMutableGATTDescriptorArgs?>
      return MyMutableGATTCharacteristicArgs(hashCodeArgs, uuidArgs, permissionNumbersArgs, propertyNumbersArgs, descriptorsArgs)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      hashCodeArgs,
      uuidArgs,
      permissionNumbersArgs,
      propertyNumbersArgs,
      descriptorsArgs,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is MyMutableGATTCharacteristicArgs) {
      return false
    }
    if (this === other) {
      return true
    }
    return MyAPIPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/** Generated class from Pigeon that represents data sent in messages. */
data class MyMutableGATTServiceArgs (
  val hashCodeArgs: Long,
  val uuidArgs: String,
  val isPrimaryArgs: Boolean,
  val includedServicesArgs: List<MyMutableGATTServiceArgs?>,
  val characteristicsArgs: List<MyMutableGATTCharacteristicArgs?>
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): MyMutableGATTServiceArgs {
      val hashCodeArgs = pigeonVar_list[0] as Long
      val uuidArgs = pigeonVar_list[1] as String
      val isPrimaryArgs = pigeonVar_list[2] as Boolean
      val includedServicesArgs = pigeonVar_list[3] as List<MyMutableGATTServiceArgs?>
      val characteristicsArgs = pigeonVar_list[4] as List<MyMutableGATTCharacteristicArgs?>
      return MyMutableGATTServiceArgs(hashCodeArgs, uuidArgs, isPrimaryArgs, includedServicesArgs, characteristicsArgs)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      hashCodeArgs,
      uuidArgs,
      isPrimaryArgs,
      includedServicesArgs,
      characteristicsArgs,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is MyMutableGATTServiceArgs) {
      return false
    }
    if (this === other) {
      return true
    }
    return MyAPIPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}
private open class MyAPIPigeonCodec : StandardMessageCodec() {
  override fun readValueOfType(type: Byte, buffer: ByteBuffer): Any? {
    return when (type) {
      129.toByte() -> {
        return (readValue(buffer) as Long?)?.let {
          MyBluetoothLowEnergyStateArgs.ofRaw(it.toInt())
        }
      }
      130.toByte() -> {
        return (readValue(buffer) as Long?)?.let {
          MyAdvertiseModeArgs.ofRaw(it.toInt())
        }
      }
      131.toByte() -> {
        return (readValue(buffer) as Long?)?.let {
          MyTXPowerLevelArgs.ofRaw(it.toInt())
        }
      }
      132.toByte() -> {
        return (readValue(buffer) as Long?)?.let {
          MyConnectionStateArgs.ofRaw(it.toInt())
        }
      }
      133.toByte() -> {
        return (readValue(buffer) as Long?)?.let {
          MyGATTCharacteristicPropertyArgs.ofRaw(it.toInt())
        }
      }
      134.toByte() -> {
        return (readValue(buffer) as Long?)?.let {
          MyGATTCharacteristicPermissionArgs.ofRaw(it.toInt())
        }
      }
      135.toByte() -> {
        return (readValue(buffer) as Long?)?.let {
          MyGATTCharacteristicWriteTypeArgs.ofRaw(it.toInt())
        }
      }
      136.toByte() -> {
        return (readValue(buffer) as Long?)?.let {
          MyGATTStatusArgs.ofRaw(it.toInt())
        }
      }
      137.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          MyCentralManagerArgs.fromList(it)
        }
      }
      138.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          MyPeripheralManagerArgs.fromList(it)
        }
      }
      139.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          MyManufacturerSpecificDataArgs.fromList(it)
        }
      }
      140.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          MyAdvertisementArgs.fromList(it)
        }
      }
      141.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          MyAdvertiseSettingsArgs.fromList(it)
        }
      }
      142.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          MyAdvertiseDataArgs.fromList(it)
        }
      }
      143.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          MyCentralArgs.fromList(it)
        }
      }
      144.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          MyPeripheralArgs.fromList(it)
        }
      }
      145.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          MyGATTDescriptorArgs.fromList(it)
        }
      }
      146.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          MyGATTCharacteristicArgs.fromList(it)
        }
      }
      147.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          MyGATTServiceArgs.fromList(it)
        }
      }
      148.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          MyMutableGATTDescriptorArgs.fromList(it)
        }
      }
      149.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          MyMutableGATTCharacteristicArgs.fromList(it)
        }
      }
      150.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          MyMutableGATTServiceArgs.fromList(it)
        }
      }
      else -> super.readValueOfType(type, buffer)
    }
  }
  override fun writeValue(stream: ByteArrayOutputStream, value: Any?)   {
    when (value) {
      is MyBluetoothLowEnergyStateArgs -> {
        stream.write(129)
        writeValue(stream, value.raw)
      }
      is MyAdvertiseModeArgs -> {
        stream.write(130)
        writeValue(stream, value.raw)
      }
      is MyTXPowerLevelArgs -> {
        stream.write(131)
        writeValue(stream, value.raw)
      }
      is MyConnectionStateArgs -> {
        stream.write(132)
        writeValue(stream, value.raw)
      }
      is MyGATTCharacteristicPropertyArgs -> {
        stream.write(133)
        writeValue(stream, value.raw)
      }
      is MyGATTCharacteristicPermissionArgs -> {
        stream.write(134)
        writeValue(stream, value.raw)
      }
      is MyGATTCharacteristicWriteTypeArgs -> {
        stream.write(135)
        writeValue(stream, value.raw)
      }
      is MyGATTStatusArgs -> {
        stream.write(136)
        writeValue(stream, value.raw)
      }
      is MyCentralManagerArgs -> {
        stream.write(137)
        writeValue(stream, value.toList())
      }
      is MyPeripheralManagerArgs -> {
        stream.write(138)
        writeValue(stream, value.toList())
      }
      is MyManufacturerSpecificDataArgs -> {
        stream.write(139)
        writeValue(stream, value.toList())
      }
      is MyAdvertisementArgs -> {
        stream.write(140)
        writeValue(stream, value.toList())
      }
      is MyAdvertiseSettingsArgs -> {
        stream.write(141)
        writeValue(stream, value.toList())
      }
      is MyAdvertiseDataArgs -> {
        stream.write(142)
        writeValue(stream, value.toList())
      }
      is MyCentralArgs -> {
        stream.write(143)
        writeValue(stream, value.toList())
      }
      is MyPeripheralArgs -> {
        stream.write(144)
        writeValue(stream, value.toList())
      }
      is MyGATTDescriptorArgs -> {
        stream.write(145)
        writeValue(stream, value.toList())
      }
      is MyGATTCharacteristicArgs -> {
        stream.write(146)
        writeValue(stream, value.toList())
      }
      is MyGATTServiceArgs -> {
        stream.write(147)
        writeValue(stream, value.toList())
      }
      is MyMutableGATTDescriptorArgs -> {
        stream.write(148)
        writeValue(stream, value.toList())
      }
      is MyMutableGATTCharacteristicArgs -> {
        stream.write(149)
        writeValue(stream, value.toList())
      }
      is MyMutableGATTServiceArgs -> {
        stream.write(150)
        writeValue(stream, value.toList())
      }
      else -> super.writeValue(stream, value)
    }
  }
}


/** Generated interface from Pigeon that represents a handler of messages from Flutter. */
interface MyCentralManagerHostAPI {
  fun initialize(): MyCentralManagerArgs
  fun getState(): MyBluetoothLowEnergyStateArgs
  fun authorize(callback: (Result<Boolean>) -> Unit)
  fun showAppSettings()
  fun startDiscovery(serviceUUIDsArgs: List<String>, callback: (Result<Unit>) -> Unit)
  fun stopDiscovery()
  fun connect(addressArgs: String, callback: (Result<Unit>) -> Unit)
  fun disconnect(addressArgs: String, callback: (Result<Unit>) -> Unit)
  fun retrieveConnectedPeripherals(): List<MyPeripheralArgs>
  fun requestMTU(addressArgs: String, mtuArgs: Long, callback: (Result<Long>) -> Unit)
  fun readRSSI(addressArgs: String, callback: (Result<Long>) -> Unit)
  fun discoverGATT(addressArgs: String, callback: (Result<List<MyGATTServiceArgs>>) -> Unit)
  fun readCharacteristic(addressArgs: String, hashCodeArgs: Long, callback: (Result<ByteArray>) -> Unit)
  fun writeCharacteristic(addressArgs: String, hashCodeArgs: Long, valueArgs: ByteArray, typeArgs: MyGATTCharacteristicWriteTypeArgs, callback: (Result<Unit>) -> Unit)
  fun setCharacteristicNotification(addressArgs: String, hashCodeArgs: Long, enableArgs: Boolean)
  fun readDescriptor(addressArgs: String, hashCodeArgs: Long, callback: (Result<ByteArray>) -> Unit)
  fun writeDescriptor(addressArgs: String, hashCodeArgs: Long, valueArgs: ByteArray, callback: (Result<Unit>) -> Unit)

  companion object {
    /** The codec used by MyCentralManagerHostAPI. */
    val codec: MessageCodec<Any?> by lazy {
      MyAPIPigeonCodec()
    }
    /** Sets up an instance of `MyCentralManagerHostAPI` to handle messages through the `binaryMessenger`. */
    @JvmOverloads
    fun setUp(binaryMessenger: BinaryMessenger, api: MyCentralManagerHostAPI?, messageChannelSuffix: String = "") {
      val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.bluetooth_low_energy_android.MyCentralManagerHostAPI.initialize$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            val wrapped: List<Any?> = try {
              listOf(api.initialize())
            } catch (exception: Throwable) {
              MyAPIPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.bluetooth_low_energy_android.MyCentralManagerHostAPI.getState$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            val wrapped: List<Any?> = try {
              listOf(api.getState())
            } catch (exception: Throwable) {
              MyAPIPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.bluetooth_low_energy_android.MyCentralManagerHostAPI.authorize$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            api.authorize{ result: Result<Boolean> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(MyAPIPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(MyAPIPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.bluetooth_low_energy_android.MyCentralManagerHostAPI.showAppSettings$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            val wrapped: List<Any?> = try {
              api.showAppSettings()
              listOf(null)
            } catch (exception: Throwable) {
              MyAPIPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.bluetooth_low_energy_android.MyCentralManagerHostAPI.startDiscovery$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val serviceUUIDsArgsArg = args[0] as List<String>
            api.startDiscovery(serviceUUIDsArgsArg) { result: Result<Unit> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(MyAPIPigeonUtils.wrapError(error))
              } else {
                reply.reply(MyAPIPigeonUtils.wrapResult(null))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.bluetooth_low_energy_android.MyCentralManagerHostAPI.stopDiscovery$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            val wrapped: List<Any?> = try {
              api.stopDiscovery()
              listOf(null)
            } catch (exception: Throwable) {
              MyAPIPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.bluetooth_low_energy_android.MyCentralManagerHostAPI.connect$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val addressArgsArg = args[0] as String
            api.connect(addressArgsArg) { result: Result<Unit> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(MyAPIPigeonUtils.wrapError(error))
              } else {
                reply.reply(MyAPIPigeonUtils.wrapResult(null))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.bluetooth_low_energy_android.MyCentralManagerHostAPI.disconnect$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val addressArgsArg = args[0] as String
            api.disconnect(addressArgsArg) { result: Result<Unit> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(MyAPIPigeonUtils.wrapError(error))
              } else {
                reply.reply(MyAPIPigeonUtils.wrapResult(null))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.bluetooth_low_energy_android.MyCentralManagerHostAPI.retrieveConnectedPeripherals$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            val wrapped: List<Any?> = try {
              listOf(api.retrieveConnectedPeripherals())
            } catch (exception: Throwable) {
              MyAPIPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.bluetooth_low_energy_android.MyCentralManagerHostAPI.requestMTU$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val addressArgsArg = args[0] as String
            val mtuArgsArg = args[1] as Long
            api.requestMTU(addressArgsArg, mtuArgsArg) { result: Result<Long> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(MyAPIPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(MyAPIPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.bluetooth_low_energy_android.MyCentralManagerHostAPI.readRSSI$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val addressArgsArg = args[0] as String
            api.readRSSI(addressArgsArg) { result: Result<Long> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(MyAPIPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(MyAPIPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.bluetooth_low_energy_android.MyCentralManagerHostAPI.discoverGATT$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val addressArgsArg = args[0] as String
            api.discoverGATT(addressArgsArg) { result: Result<List<MyGATTServiceArgs>> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(MyAPIPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(MyAPIPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.bluetooth_low_energy_android.MyCentralManagerHostAPI.readCharacteristic$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val addressArgsArg = args[0] as String
            val hashCodeArgsArg = args[1] as Long
            api.readCharacteristic(addressArgsArg, hashCodeArgsArg) { result: Result<ByteArray> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(MyAPIPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(MyAPIPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.bluetooth_low_energy_android.MyCentralManagerHostAPI.writeCharacteristic$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val addressArgsArg = args[0] as String
            val hashCodeArgsArg = args[1] as Long
            val valueArgsArg = args[2] as ByteArray
            val typeArgsArg = args[3] as MyGATTCharacteristicWriteTypeArgs
            api.writeCharacteristic(addressArgsArg, hashCodeArgsArg, valueArgsArg, typeArgsArg) { result: Result<Unit> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(MyAPIPigeonUtils.wrapError(error))
              } else {
                reply.reply(MyAPIPigeonUtils.wrapResult(null))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.bluetooth_low_energy_android.MyCentralManagerHostAPI.setCharacteristicNotification$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val addressArgsArg = args[0] as String
            val hashCodeArgsArg = args[1] as Long
            val enableArgsArg = args[2] as Boolean
            val wrapped: List<Any?> = try {
              api.setCharacteristicNotification(addressArgsArg, hashCodeArgsArg, enableArgsArg)
              listOf(null)
            } catch (exception: Throwable) {
              MyAPIPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.bluetooth_low_energy_android.MyCentralManagerHostAPI.readDescriptor$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val addressArgsArg = args[0] as String
            val hashCodeArgsArg = args[1] as Long
            api.readDescriptor(addressArgsArg, hashCodeArgsArg) { result: Result<ByteArray> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(MyAPIPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(MyAPIPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.bluetooth_low_energy_android.MyCentralManagerHostAPI.writeDescriptor$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val addressArgsArg = args[0] as String
            val hashCodeArgsArg = args[1] as Long
            val valueArgsArg = args[2] as ByteArray
            api.writeDescriptor(addressArgsArg, hashCodeArgsArg, valueArgsArg) { result: Result<Unit> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(MyAPIPigeonUtils.wrapError(error))
              } else {
                reply.reply(MyAPIPigeonUtils.wrapResult(null))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }
}
/** Generated class from Pigeon that represents Flutter messages that can be called from Kotlin. */
class MyCentralManagerFlutterAPI(private val binaryMessenger: BinaryMessenger, private val messageChannelSuffix: String = "") {
  companion object {
    /** The codec used by MyCentralManagerFlutterAPI. */
    val codec: MessageCodec<Any?> by lazy {
      MyAPIPigeonCodec()
    }
  }
  fun onStateChanged(stateArgsArg: MyBluetoothLowEnergyStateArgs, callback: (Result<Unit>) -> Unit)
{
    val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName = "dev.flutter.pigeon.bluetooth_low_energy_android.MyCentralManagerFlutterAPI.onStateChanged$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(stateArgsArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          callback(Result.success(Unit))
        }
      } else {
        callback(Result.failure(MyAPIPigeonUtils.createConnectionError(channelName)))
      } 
    }
  }
  fun onDiscovered(peripheralArgsArg: MyPeripheralArgs, rssiArgsArg: Long, advertisementArgsArg: MyAdvertisementArgs, callback: (Result<Unit>) -> Unit)
{
    val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName = "dev.flutter.pigeon.bluetooth_low_energy_android.MyCentralManagerFlutterAPI.onDiscovered$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(peripheralArgsArg, rssiArgsArg, advertisementArgsArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          callback(Result.success(Unit))
        }
      } else {
        callback(Result.failure(MyAPIPigeonUtils.createConnectionError(channelName)))
      } 
    }
  }
  fun onConnectionStateChanged(peripheralArgsArg: MyPeripheralArgs, stateArgsArg: MyConnectionStateArgs, callback: (Result<Unit>) -> Unit)
{
    val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName = "dev.flutter.pigeon.bluetooth_low_energy_android.MyCentralManagerFlutterAPI.onConnectionStateChanged$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(peripheralArgsArg, stateArgsArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          callback(Result.success(Unit))
        }
      } else {
        callback(Result.failure(MyAPIPigeonUtils.createConnectionError(channelName)))
      } 
    }
  }
  fun onMTUChanged(peripheralArgsArg: MyPeripheralArgs, mtuArgsArg: Long, callback: (Result<Unit>) -> Unit)
{
    val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName = "dev.flutter.pigeon.bluetooth_low_energy_android.MyCentralManagerFlutterAPI.onMTUChanged$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(peripheralArgsArg, mtuArgsArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          callback(Result.success(Unit))
        }
      } else {
        callback(Result.failure(MyAPIPigeonUtils.createConnectionError(channelName)))
      } 
    }
  }
  fun onCharacteristicNotified(peripheralArgsArg: MyPeripheralArgs, characteristicArgsArg: MyGATTCharacteristicArgs, valueArgsArg: ByteArray, callback: (Result<Unit>) -> Unit)
{
    val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName = "dev.flutter.pigeon.bluetooth_low_energy_android.MyCentralManagerFlutterAPI.onCharacteristicNotified$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(peripheralArgsArg, characteristicArgsArg, valueArgsArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          callback(Result.success(Unit))
        }
      } else {
        callback(Result.failure(MyAPIPigeonUtils.createConnectionError(channelName)))
      } 
    }
  }
}
/** Generated interface from Pigeon that represents a handler of messages from Flutter. */
interface MyPeripheralManagerHostAPI {
  fun initialize(): MyPeripheralManagerArgs
  fun getState(): MyBluetoothLowEnergyStateArgs
  fun authorize(callback: (Result<Boolean>) -> Unit)
  fun showAppSettings()
  fun setName(nameArgs: String, callback: (Result<String?>) -> Unit)
  fun openGATTServer()
  fun closeGATTServer()
  fun addService(serviceArgs: MyMutableGATTServiceArgs, callback: (Result<Unit>) -> Unit)
  fun removeService(hashCodeArgs: Long)
  fun removeAllServices()
  fun startAdvertising(settingsArgs: MyAdvertiseSettingsArgs, advertiseDataArgs: MyAdvertiseDataArgs, scanResponseArgs: MyAdvertiseDataArgs, callback: (Result<Unit>) -> Unit)
  fun stopAdvertising()
  fun sendResponse(addressArgs: String, idArgs: Long, statusArgs: MyGATTStatusArgs, offsetArgs: Long, valueArgs: ByteArray?)
  fun notifyCharacteristicChanged(addressArgs: String, hashCodeArgs: Long, confirmArgs: Boolean, valueArgs: ByteArray, callback: (Result<Unit>) -> Unit)

  companion object {
    /** The codec used by MyPeripheralManagerHostAPI. */
    val codec: MessageCodec<Any?> by lazy {
      MyAPIPigeonCodec()
    }
    /** Sets up an instance of `MyPeripheralManagerHostAPI` to handle messages through the `binaryMessenger`. */
    @JvmOverloads
    fun setUp(binaryMessenger: BinaryMessenger, api: MyPeripheralManagerHostAPI?, messageChannelSuffix: String = "") {
      val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerHostAPI.initialize$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            val wrapped: List<Any?> = try {
              listOf(api.initialize())
            } catch (exception: Throwable) {
              MyAPIPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerHostAPI.getState$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            val wrapped: List<Any?> = try {
              listOf(api.getState())
            } catch (exception: Throwable) {
              MyAPIPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerHostAPI.authorize$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            api.authorize{ result: Result<Boolean> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(MyAPIPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(MyAPIPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerHostAPI.showAppSettings$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            val wrapped: List<Any?> = try {
              api.showAppSettings()
              listOf(null)
            } catch (exception: Throwable) {
              MyAPIPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerHostAPI.setName$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val nameArgsArg = args[0] as String
            api.setName(nameArgsArg) { result: Result<String?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(MyAPIPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(MyAPIPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerHostAPI.openGATTServer$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            val wrapped: List<Any?> = try {
              api.openGATTServer()
              listOf(null)
            } catch (exception: Throwable) {
              MyAPIPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerHostAPI.closeGATTServer$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            val wrapped: List<Any?> = try {
              api.closeGATTServer()
              listOf(null)
            } catch (exception: Throwable) {
              MyAPIPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerHostAPI.addService$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val serviceArgsArg = args[0] as MyMutableGATTServiceArgs
            api.addService(serviceArgsArg) { result: Result<Unit> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(MyAPIPigeonUtils.wrapError(error))
              } else {
                reply.reply(MyAPIPigeonUtils.wrapResult(null))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerHostAPI.removeService$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val hashCodeArgsArg = args[0] as Long
            val wrapped: List<Any?> = try {
              api.removeService(hashCodeArgsArg)
              listOf(null)
            } catch (exception: Throwable) {
              MyAPIPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerHostAPI.removeAllServices$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            val wrapped: List<Any?> = try {
              api.removeAllServices()
              listOf(null)
            } catch (exception: Throwable) {
              MyAPIPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerHostAPI.startAdvertising$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val settingsArgsArg = args[0] as MyAdvertiseSettingsArgs
            val advertiseDataArgsArg = args[1] as MyAdvertiseDataArgs
            val scanResponseArgsArg = args[2] as MyAdvertiseDataArgs
            api.startAdvertising(settingsArgsArg, advertiseDataArgsArg, scanResponseArgsArg) { result: Result<Unit> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(MyAPIPigeonUtils.wrapError(error))
              } else {
                reply.reply(MyAPIPigeonUtils.wrapResult(null))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerHostAPI.stopAdvertising$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            val wrapped: List<Any?> = try {
              api.stopAdvertising()
              listOf(null)
            } catch (exception: Throwable) {
              MyAPIPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerHostAPI.sendResponse$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val addressArgsArg = args[0] as String
            val idArgsArg = args[1] as Long
            val statusArgsArg = args[2] as MyGATTStatusArgs
            val offsetArgsArg = args[3] as Long
            val valueArgsArg = args[4] as ByteArray?
            val wrapped: List<Any?> = try {
              api.sendResponse(addressArgsArg, idArgsArg, statusArgsArg, offsetArgsArg, valueArgsArg)
              listOf(null)
            } catch (exception: Throwable) {
              MyAPIPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerHostAPI.notifyCharacteristicChanged$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val addressArgsArg = args[0] as String
            val hashCodeArgsArg = args[1] as Long
            val confirmArgsArg = args[2] as Boolean
            val valueArgsArg = args[3] as ByteArray
            api.notifyCharacteristicChanged(addressArgsArg, hashCodeArgsArg, confirmArgsArg, valueArgsArg) { result: Result<Unit> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(MyAPIPigeonUtils.wrapError(error))
              } else {
                reply.reply(MyAPIPigeonUtils.wrapResult(null))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }
}
/** Generated class from Pigeon that represents Flutter messages that can be called from Kotlin. */
class MyPeripheralManagerFlutterAPI(private val binaryMessenger: BinaryMessenger, private val messageChannelSuffix: String = "") {
  companion object {
    /** The codec used by MyPeripheralManagerFlutterAPI. */
    val codec: MessageCodec<Any?> by lazy {
      MyAPIPigeonCodec()
    }
  }
  fun onStateChanged(stateArgsArg: MyBluetoothLowEnergyStateArgs, callback: (Result<Unit>) -> Unit)
{
    val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName = "dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerFlutterAPI.onStateChanged$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(stateArgsArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          callback(Result.success(Unit))
        }
      } else {
        callback(Result.failure(MyAPIPigeonUtils.createConnectionError(channelName)))
      } 
    }
  }
  fun onConnectionStateChanged(centralArgsArg: MyCentralArgs, statusArgsArg: Long, stateArgsArg: MyConnectionStateArgs, callback: (Result<Unit>) -> Unit)
{
    val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName = "dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerFlutterAPI.onConnectionStateChanged$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(centralArgsArg, statusArgsArg, stateArgsArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          callback(Result.success(Unit))
        }
      } else {
        callback(Result.failure(MyAPIPigeonUtils.createConnectionError(channelName)))
      } 
    }
  }
  fun onMTUChanged(centralArgsArg: MyCentralArgs, mtuArgsArg: Long, callback: (Result<Unit>) -> Unit)
{
    val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName = "dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerFlutterAPI.onMTUChanged$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(centralArgsArg, mtuArgsArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          callback(Result.success(Unit))
        }
      } else {
        callback(Result.failure(MyAPIPigeonUtils.createConnectionError(channelName)))
      } 
    }
  }
  fun onCharacteristicReadRequest(centralArgsArg: MyCentralArgs, idArgsArg: Long, offsetArgsArg: Long, hashCodeArgsArg: Long, callback: (Result<Unit>) -> Unit)
{
    val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName = "dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerFlutterAPI.onCharacteristicReadRequest$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(centralArgsArg, idArgsArg, offsetArgsArg, hashCodeArgsArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          callback(Result.success(Unit))
        }
      } else {
        callback(Result.failure(MyAPIPigeonUtils.createConnectionError(channelName)))
      } 
    }
  }
  fun onCharacteristicWriteRequest(centralArgsArg: MyCentralArgs, idArgsArg: Long, hashCodeArgsArg: Long, preparedWriteArgsArg: Boolean, responseNeededArgsArg: Boolean, offsetArgsArg: Long, valueArgsArg: ByteArray, callback: (Result<Unit>) -> Unit)
{
    val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName = "dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerFlutterAPI.onCharacteristicWriteRequest$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(centralArgsArg, idArgsArg, hashCodeArgsArg, preparedWriteArgsArg, responseNeededArgsArg, offsetArgsArg, valueArgsArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          callback(Result.success(Unit))
        }
      } else {
        callback(Result.failure(MyAPIPigeonUtils.createConnectionError(channelName)))
      } 
    }
  }
  fun onDescriptorReadRequest(centralArgsArg: MyCentralArgs, idArgsArg: Long, offsetArgsArg: Long, hashCodeArgsArg: Long, callback: (Result<Unit>) -> Unit)
{
    val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName = "dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerFlutterAPI.onDescriptorReadRequest$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(centralArgsArg, idArgsArg, offsetArgsArg, hashCodeArgsArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          callback(Result.success(Unit))
        }
      } else {
        callback(Result.failure(MyAPIPigeonUtils.createConnectionError(channelName)))
      } 
    }
  }
  fun onDescriptorWriteRequest(centralArgsArg: MyCentralArgs, idArgsArg: Long, hashCodeArgsArg: Long, preparedWriteArgsArg: Boolean, responseNeededArgsArg: Boolean, offsetArgsArg: Long, valueArgsArg: ByteArray, callback: (Result<Unit>) -> Unit)
{
    val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName = "dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerFlutterAPI.onDescriptorWriteRequest$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(centralArgsArg, idArgsArg, hashCodeArgsArg, preparedWriteArgsArg, responseNeededArgsArg, offsetArgsArg, valueArgsArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          callback(Result.success(Unit))
        }
      } else {
        callback(Result.failure(MyAPIPigeonUtils.createConnectionError(channelName)))
      } 
    }
  }
  fun onExecuteWrite(centralArgsArg: MyCentralArgs, idArgsArg: Long, executeArgsArg: Boolean, callback: (Result<Unit>) -> Unit)
{
    val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName = "dev.flutter.pigeon.bluetooth_low_energy_android.MyPeripheralManagerFlutterAPI.onExecuteWrite$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(centralArgsArg, idArgsArg, executeArgsArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          callback(Result.success(Unit))
        }
      } else {
        callback(Result.failure(MyAPIPigeonUtils.createConnectionError(channelName)))
      } 
    }
  }
}
