<div align="center">  
  <img src="https://github.com/derdilla/blood-pressure-monitor-fl/blob/79b8a2d38703a5ff6d491019ba51b0374c39963a/android/app/src/main/res/drawable/icon.png" width="100px" height="100px"></img>
</div>


<h1 align="center">Blood Pressure Monitor</h1>
<div align="center">
  <img alt="Play installs" src="https://img.shields.io/endpoint?color=green&logo=google-play&logoColor=green&url=https%3A%2F%2Fplay.cuzi.workers.dev%2Fplay%3Fi%3Dcom.derdilla.bloodPressureApp%26gl%3DUS%26hl%3Den%26l%3DInstalls%26m%3D%24totalinstalls">
  <img alt="Play rating" src="https://img.shields.io/endpoint?color=green&logo=google-play&logoColor=green&url=https%3A%2F%2Fplay.cuzi.workers.dev%2Fplay%3Fi%3Dcom.derdilla.bloodPressureApp%26gl%3DDE%26hl%3Den%26l%3DRating%26m%3D%24rating%2520%25E2%2598%2585%2520">
  <a href="https://github.com/derdilla/blood-pressure-monitor-fl/actions/workflows/.yml">
    <img src="https://img.shields.io/github/actions/workflow/status/derdilla/blood-pressure-monitor-fl/.github%2Fworkflows%2Fapp-CI.yml?style=flat&logo=github&label=CI-app" alt="CI status"/><img src="https://img.shields.io/github/actions/workflow/status/derdilla/blood-pressure-monitor-fl/.github%2Fworkflows%2Fpkg-CI.yml?style=flat&logo=github&label=CI-pkgs" alt="CI pkg status"/></a>
  <img alt="GitHub Repo stars" src="https://img.shields.io/github/stars/derdilla/blood-pressure-monitor-fl?style=flat&logo=github">
  <img alt="GitHub watchers" src="https://img.shields.io/github/watchers/derdilla/blood-pressure-monitor-fl?style=flat&logo=github">
  <a href="https://hosted.weblate.org/engage/blood-pressure-monitor-fl/">
    <img src="https://img.shields.io/weblate/progress/blood-pressure-monitor-fl?logo=weblate" alt="Translation status"/></a>
</div>
<p align="center">
  A versatile app for tracking, analyzing, and exporting blood pressure-related data.
</p>

## Installation

Currently, the app is only developed for Android, but should be easy to port to other platforms as well.

Store    |  Note
---------|-------
<a href='https://play.google.com/store/apps/details?id=com.derdilla.bloodPressureApp&pcampaignid=pcampaignidMKT-Other-global-all-co-prtnr-py-PartBadge-Mar2515-1'><img alt='Get it on Google Play' src='https://play.google.com/intl/en_us/badges/static/images/badges/en_badge_web_generic.png'/></a> | APK provided by Google but uses the same source code. Download sizes may be smaller. <p><img alt="Google Play Version" src="https://img.shields.io/endpoint?style=flat&logo=google-play&label=Version&url=https%3A%2F%2Fplay.cuzi.workers.dev%2Fplay%3Fi%3Dcom.derdilla.bloodPressureApp%26gl%3DUS%26hl%3Den%26l%3DAndroid%26m%3D%24version&color=152238"></p>
<a href="https://f-droid.org/packages/com.derdilla.bloodPressureApp"> <img src="https://fdroid.gitlab.io/artwork/badge/get-it-on.png" alt="Get it on F-Droid"></a> | F-Droid can take up to a week to provide updates after release to build updates. The F-Droid version is signed with the F-Droid key, so no switching installation sources, without first uninstalling and deleting all data, is possible. Of course, you can still load backups of your data. <p><img alt="F-Droid Store" src="https://img.shields.io/f-droid/v/com.derdilla.bloodPressureApp?style=flat&logo=fdroid&label=Version&color=152238"></p>
<a href="https://github.com/derdilla/blood-pressure-monitor-fl/releases/latest"><img alt="Get it on GitHub" src="https://github.com/derdilla/blood-pressure-monitor-fl/assets/82763757/829c5327-3cf6-4b41-ab10-05133cf11579">| The app won't notify you about new updates so you need to check for new versions manually or use [Obtainium](https://github.com/ImranR98/Obtainium) for that. <p><img alt="GitHub version" src="https://img.shields.io/github/v/release/derdilla/blood-pressure-monitor-fl?style=flat&logo=github&label=Version&color=152238"></p>

As there is no demand Windows, Linux and MacOS builds have been stopped. In case you are interested in them feel free to open an issue to indicate that.IOS builds are currently not available as the platform is more restrictive and hard (expensive) to develop for. So I won't take this step unless there is significant demand.

## Features
<i>blood pressure monitor</i> is a reliable blood pressure measurement tracker and analyzer. It has the ambition to allow saving measurements faster than anywhere else and make sharing data with you doctor effortless. It works out of the box but can also be configured for individual use cases.

- 📏 <i>Reliable</i> measurement storing
- 🚀 Fast input through <i>user-friendly</i> dialogues on launch and automatic form navigation
- 📊 <i>Beautiful</i> analytics provide insights on trends, distribution, differences over the day and much more
- 📂 Versatile <i>export and import</i> (CSV, PDF, SQLite) with granular control
- ⚙️ High configurability
- Ad free without disturbances
- Well-documented, <i>open-source</i> code

### Screenshots

<div align="center">
  <img src="https://github.com/derdilla/blood-pressure-monitor-fl/blob/main/fastlane/metadata/android/en-US/images/phoneScreenshots/01-example_add.png?raw=true" width="23%" alt="Home">
  <img src="https://github.com/derdilla/blood-pressure-monitor-fl/blob/main/fastlane/metadata/android/en-US/images/phoneScreenshots/03-example_settings.png?raw=true" width="23%" alt="Settings">
  <img src="https://github.com/derdilla/blood-pressure-monitor-fl/blob/main/fastlane/metadata/android/en-US/images/phoneScreenshots/02-example_home.png?raw=true" width="23%" alt="Home">
  <img src="https://github.com/derdilla/blood-pressure-monitor-fl/blob/main/fastlane/metadata/android/en-US/images/phoneScreenshots/04-example_stats.png?raw=true" width="23%" alt="Statistics">
</div>

## Contributing

This app works best when everyone does their part! Anyone interested with a bit of domain knowledge can help make this the best blood pressure app. If you want to provide ideas, translate, code or help in another way *please* check out the [contributor docs](CONTRIBUTING.md).
