<h1 align="center">
	<img src="fastlane/metadata/android/en-US/images/icon.png" width="25%" /> <br>
	YTDLnis
</h1>

<div align="center">
	<a href="https://github.com/deniscerri/ytdlnis/blob/main/README.md">English</a>
	&nbsp;&nbsp;| &nbsp;&nbsp;
	Español
</div>

<h3 align="center">
YTDLnis es un descargador de audio/video gratuito y de código abierto que utiliza yt-dlp para Android 7.0 y superior.
</h3>
<h4 align="center">
	Creado por Denis Çerri
</h4>

<div align="center">

[![Github Download](https://custom-icon-badges.herokuapp.com/badge/Download-blue?style=for-the-badge&logo=download&logoColor=white)](https://github.com/deniscerri/ytdlnis/releases/latest)
[![IzzyOnDroid Repo](https://custom-icon-badges.herokuapp.com/badge/IzzyOnDroid%20Repo-red?style=for-the-badge&logo=download&logoColor=white)](https://android.izzysoft.de/repo/apk/com.deniscerri.ytdl)
[![UpToDown](https://custom-icon-badges.herokuapp.com/badge/UpToDown-green?style=for-the-badge&logo=download&logoColor=white)](https://ytdlnis.en.uptodown.com/android/download)

![CI](https://github.com/deniscerri/ytdlnis/actions/workflows/android.yml/badge.svg?branch=main&event=pull)
[![preview release](https://img.shields.io/github/release/deniscerri/ytdlnis.svg?maxAge=3600&include_prereleases&label=preview)](https://github.com/deniscerri/ytdlnis/releases) 
[![downloads](https://img.shields.io/github/downloads/deniscerri/ytdlnis/total?style=flat-square)](https://github.com/deniscerri/ytdlnis/releases) 
[![Translation status](https://hosted.weblate.org/widgets/ytdlnis/-/svg-badge.svg)](https://hosted.weblate.org/engage/ytdlnis/?utm_source=widget) 
[![community](https://img.shields.io/badge/Discord-YTDLnis-blueviolet?style=flat-square&logo=discord)](https://discord.gg/WW3KYWxAPm) 
[![community](https://img.shields.io/badge/Telegram-YTDLnis-blue?style=flat-square&logo=telegram)](https://t.me/ytdlnis)
[![community](https://img.shields.io/badge/Telegram-Updates-red?style=flat-square&logo=telegram)](https://t.me/ytdlnisupdates)


### Los enlaces anteriores son las únicas fuentes confiables de YTDLnis. Todo lo demás no está relacionado.

</div>

## 💡 Características:

- Descarga archivos de audio/vídeo de más de <a href="https://github.com/yt-dlp/yt-dlp/blob/master/supportedsites.md">1000 webs</a>
- Descarga Playlists
	- Edite cada elemento de la lista de reproducción por separado, como en un elemento de descarga normal
	- Seleccione un formato común para todos los elementos y/o seleccione múltiples formatos de audio en caso de que los esté descargando como un video
	- Seleccione una ruta de descarga para todos los items
	- Seleccione una plantilla de nombre de archivo para todos los items
	- Tipo de descarga de actualización por lotes a audio/vídeo/comando personalizado con un solo click
- Poner en cola las descargas y programarlas por fecha y hora
	- También puedes programar varios elementos al mismo tiempo
- Descargar varios elementos al mismo tiempo
- Use comandos y plantillas personalizados o acceda al modo yt-dlp completo con una terminal incorporada
	- Puedes hacer backup y restaurar plantillas para poder compartirlas con tus amigos.
- Soporte para COOKIES. Inicie sesión con sus cuentas y descargue videos privados/no disponibles, desbloquee formatos premium, etc.
- Cortar videos según marcas de tiempo y capítulos de video (esta función yt-dlp es experimental en el proyecto original)
	- Puedes hacer cortes ilimitados
- Elimina los patrocinadores del video (SponsorBlock)
	- Incrustarlos como capítulos en tu video
- Insertar subtítulos/metadatos/capítulos, etc.
- Modificar metadatos como título y autor
- Dividir el item en archivos separados dependiendo de sus capítulos
- Seleccione diferentes formatos de descarga
- Tarjeta inferior directamente desde el menú compartir, no es necesario abrir la aplicación
	- Puedes crear un archivo txt y llenarlo con enlaces/listas de reproducción/consultas de búsqueda separadas por una nueva línea y la aplicación las procesará
- Buscar o insertar un enlace desde la aplicación
	- Puedes acumular búsquedas para poder procesarlas al mismo tiempo.
- Registrar descargas en caso de problemas
- Volver a descargar descargas canceladas o fallidas
	- Puedes usar gestos para deslizarte hacia la izquierda para volver a descargar y hacia la derecha para eliminar
	- Puede hacer clic durante mucho tiempo en el botón volver a descargar en la hoja de detalles para mostrar la tarjeta de descarga y obtener más funciones.
- Modo incógnito cuando no desea guardar un historial de descargas o registros
- Modo de descarga rápida
	- Descargar inmediatamente sin tener que esperar a que se procesen los datos. Apague la tarjeta inferior y comenzará instantáneamente.
- Abrir/compartir archivos descargados directamente desde la notificación finalizada
- La mayoría de las funciones de yt-dlp están implementadas, las sugerencias son bienvenidas
- Interfaz "Material You"
- Opciones de tema
- Funciones de backup y restauración.  (Se puede hacer un backup de casi todo)
- Architecture MVVM con WorkManager

## 📲 Capturas de pantalla

<div>
<img src="fastlane/metadata/android/en-US/images/phoneScreenshots/01.png" width="30%" />
<img src="fastlane/metadata/android/en-US/images/phoneScreenshots/02.png" width="30%" />
<img src="fastlane/metadata/android/en-US/images/phoneScreenshots/03.png" width="30%" />
<img src="fastlane/metadata/android/en-US/images/phoneScreenshots/04.png" width="30%" />
<img src="fastlane/metadata/android/en-US/images/phoneScreenshots/05.png" width="30%" />
<img src="fastlane/metadata/android/en-US/images/phoneScreenshots/06.png" width="30%" />
<img src="fastlane/metadata/android/en-US/images/phoneScreenshots/07.png" width="30%" />
<img src="fastlane/metadata/android/en-US/images/phoneScreenshots/08.png" width="30%" />
<img src="fastlane/metadata/android/en-US/images/phoneScreenshots/09.png" width="30%" />
<img src="fastlane/metadata/android/en-US/images/phoneScreenshots/10.png" width="30%" />
<img src="fastlane/metadata/android/en-US/images/phoneScreenshots/11.png" width="30%" />
<img src="fastlane/metadata/android/en-US/images/phoneScreenshots/12.png" width="30%" />
<img src="fastlane/metadata/android/en-US/images/phoneScreenshots/13.png" width="90%" />
</div>

## 💬 Contacto

Únanse a nuestro [Canal de Telegram](https://t.me/ytdlnis) o [Discord](https://discord.gg/WW3KYWxAPm) para debates, anuncios y lanzamientos.

## 🔑 Conéctate con ReVanced

El nombre del paquete de la aplicación es "com.deniscerri.ytdl"

## 📝 Ayuda a traducir en Weblate
<a href="https://hosted.weblate.org/engage/ytdlnis/">
<img src="https://hosted.weblate.org/widgets/ytdlnis/-/strings/open-graph.png" alt="Translation status" />
</a>


<a href="https://hosted.weblate.org/engage/ytdlnis/">
<img src="https://hosted.weblate.org/widgets/ytdlnis/-/multi-auto.svg" alt="Translation status" />
</a>

## ✔️🤖 Conéctate con Tasker / Macrodroid etc

Puede usar intents en aplicaciones como tasker o macrodroid para enviar comandos a la aplicación para ejecutar una descarga sin interacción del usuario.
Variables aceptadas:

<b>TIPO</b> -> puede ser: audio, video, comando <br/>
<b>BACKGROUND</b> -> puede ser: verdadero, falso.  Si es cierto, la aplicación no mostrará la tarjeta de descarga pase lo que pase y ejecutará la descarga en segundo plano. <br/>

### Tasker Ejemplo de descarga de un audio en segundo plano
1. Crear tarea de intención de envío
2. Acción: android.intent.action.SEND
3. Cat: Por defecto
4. Mime Type: text/*
5. Extra: android.intent.extra.TEXT:url (instead of url write the url of the video you want to download)
6. Extra: TYPE:audio
7. Extra: BACKGROUND:true


## 😇 Contribuyendo

Si quieres contribuir.  Lea la sección [Contribuyendo](CONTRIBUTING.MD).

## 📄 Licencia

[GNU GPL v3.0](https://github.com/deniscerri/ytdlnis/blob/main/LICENSE)

⚠️  Advertencia <br>

A excepción del código fuente bajo la licencia GPLv3, todas las demás partes tienen prohibido utilizar el nombre 'YTDLnis' como aplicación de descarga, y lo mismo ocurre con sus derivados.  Los derivados incluyen, entre otros, bifurcaciones y compilaciones no oficiales.

## 🙏 Gracias

- [yt-dlp](https://github.com/yt-dlp/yt-dlp) y sus colaboradores por hacer posible esta herramienta.  Sin él esta aplicación no existiría.
- [youtubedl-android](https://github.com/yausername/youtubedl-android) para portar yt-dlp a android
- [dvd](https://github.com/yausername/dvd) para mostrar cómo implementar youtubedl-android
- [seal](https://github.com/JunkFood02/Seal) para ciertos elementos y características de diseño que quería usar también en esta aplicación
- [decipher3114](https://github.com/decipher3114) por hacer que el ícono de la aplicación esté disponible

y muchos otros extraños en foros de Internet.
