<p align="center">
  <img src="https://user-images.githubusercontent.com/51419598/161439601-fc228a0d-d09d-4dbb-b5a3-ebc5dbcf9f46.png">
</p>

<h6 align="center"><samp>#flutter, #package, #android, #saf, #storage</samp></h6>
<samp><h1 align="center">Shared Storage</h1></samp>

<h6 align="center">
    <samp>
      Access Android Storage Access Framework, Media Store and Environment APIs through your Flutter Apps.
    </samp>
</h6>

<p align="center">
  <a href="https://pub.dev/packages/shared_storage"><img src="https://img.shields.io/pub/v/shared_storage.svg?style=for-the-badge&showLabel=false&labelColor=15191f&logo=dart&logoColor=blue"></a>
  <img src="https://img.shields.io/badge/Flutter-22272E?style=for-the-badge&logo=flutter&logoColor=66B1F1">
  <img src="https://img.shields.io/badge/Kotlin-22272E?&style=for-the-badge&logo=kotlin">
  <img src="https://img.shields.io/badge/Dart-22272E?style=for-the-badge&logo=dart">
</p>

<h4 align="center"><samp><a href="https://pub.dev/packages/shared_storage">Install It</a></samp></h4>

## [Documentation](https://alexrintt.github.io/shared-storage)

See the website for [documentation](https://alexrintt.github.io/shared-storage).

All documentation is also available under `/docs` to each released version which is the data source of the website.

You can contribute to the documentation by just editing these files through the GitHub web editor!

## Contributing

To check all ways you can contribute to this package see [Contributing/Ways to contribute](https://alexrintt.github.io/shared-storage/Contributing/Ways%20to%20contribute/).

Use `release` branch as base. Latest changes are available on `master` branch but the actual latest published package version lives under `release` branch.

All other branches are derivated from issues, new features or bug fixes.

## Supporters

- [aplicatii-romanesti](https://www.bibliotecaortodoxa.ro/) who bought me a whole month of caffeine!

## Contributors

- [iamcosmin](https://github.com/iamcosmin), [limshengli](https://github.com/limshengli) reported a issue with Gradle and Kotlin version [#124](https://github.com/alexrintt/shared-storage/issues/124).
- [mx1up](https://github.com/mx1up) reported a issue with `openDocumentFile` API [#121](https://github.com/alexrintt/shared-storage/issues/121).
- [Tamerlanchiques](https://github.com/Tamerlanchiques) reported a bug which the persisted URI wasn't being properly persisted across device reboots [#118](https://github.com/alexrintt/shared-storage/issues/118).
- [honjow](https://github.com/honjow) implemented [`openDocument` Android API #110](https://github.com/alexrintt/shared-storage/pull/110) to pick single or multiple file URIs.
- [clragon](https://github.com/clragon) submitted a severe [bug report #107](https://github.com/alexrintt/shared-storage/issues/107) and opened [discussions around package architecture #108](https://github.com/alexrintt/shared-storage/discussions/108).
- [jfaltis](https://github.com/jfaltis) fixed [a memory leak #86](https://github.com/alexrintt/shared-storage/pull/86) and implemented an API to [override existing files #85](https://github.com/alexrintt/shared-storage/pull/85).
- [EternityForest](https://github.com/EternityForest) did [report a severe crash #50](https://github.com/alexrintt/shared-storage/issues/50) when the column ID was not provided and [implemented a new feature to list all subfolders #59](https://github.com/alexrintt/shared-storage/pull/59).
- [dhaval-k-simformsolutions](https://github.com/dhaval-k-simformsolutions) submitted [bug reports](https://github.com/alexrintt/shared-storage/issues?q=is%3Aissue+author%3Adhaval-k-simformsolutions) related to duplicated file entries.
- [dangilbert](https://github.com/dangilbert) [fixed a bug #14](https://github.com/alexrintt/shared-storage/pull/14) when the user doesn't select a folder.
- [aplicatii-romanesti](https://www.bibliotecaortodoxa.ro/) submitted [device specific issues](https://github.com/alexrintt/shared-storage/issues?q=author%3Aaplicatii-romanesti).
- [ankitparmar007](https://github.com/ankitparmar007) [requested create file related APIs #20](https://github.com/alexrintt/shared-storage/issues/10).

A huge thanks to all contributors!

<br>

<samp>

<h2 align="center">
  Open Source
</h2>
<p align="center">
  <sub>Copyright © 2021-present, Alex Rintt.</sub>
</p>
<p align="center">Shared Storage <a href="https://github.com/alexrintt/shared-storage/blob/master/LICENSE.md">is MIT licensed 💖</a></p>
<p align="center">
  <img src="https://user-images.githubusercontent.com/51419598/161439601-fc228a0d-d09d-4dbb-b5a3-ebc5dbcf9f46.png" width="35" />
</p>
  
</samp>
