import com.darkrockstudios.apps.hammer.base.ProjectId
import com.darkrockstudios.apps.hammer.project.ProjectDefinition
import com.darkrockstudios.apps.hammer.project.ProjectEntityFilesystemDatasource
import com.darkrockstudios.apps.hammer.projects.ProjectsFileSystemDatasource
import com.darkrockstudios.apps.hammer.utils.FileResourcesUtils
import com.darkrockstudios.apps.hammer.utils.getUserDataDirectory
import okio.Path
import okio.Path.Companion.toPath
import okio.fakefilesystem.FakeFileSystem

const val PROJECT_1_NAME = "Test Project 1"
val projectNames = listOf(
	PROJECT_1_NAME,
)

fun createRootDirectory(ffs: FakeFileSystem) {
	val rootDir = getUserDataDirectory(ffs)
	ffs.createDirectories(rootDir)
}

fun getUserDirectory(userId: Long, ffs: FakeFileSystem): Path {
	return ProjectsFileSystemDatasource.getUserDirectory(userId, ffs)
}

fun getProjectDirectory(userId: Long, projectName: String, ffs: FakeFileSystem): Path {
	return ProjectEntityFilesystemDatasource.getProjectDirectory(
		userId,
		ProjectDefinition(projectName, ProjectId("")),
		ffs
	)
}

/**
 * Create an in-mem project from a predefined resource
 */
fun createProject(userId: Long, projectName: String, ffs: FakeFileSystem) {
	val projDir = getProjectDirectory(userId, projectName, ffs)
	ffs.createDirectories(projDir)

	FileResourcesUtils.copyResourceFolderToFakeFileSystem(
		projectName.toPath(),
		getUserDirectory(userId, ffs),
		ffs
	)
}
