import com.darkrockstudios.build.registerLinuxDistributionTasks
import org.jetbrains.compose.desktop.application.dsl.TargetFormat

val data_version: String by extra

plugins {
	alias(libs.plugins.kotlin.multiplatform)
	alias(libs.plugins.kotlin.serialization)
	alias(libs.plugins.compose.compiler)
	alias(libs.plugins.jetbrains.compose)
	alias(libs.plugins.jetbrains.kover)
	alias(libs.plugins.aboutlibraries.plugin)
}

group = "com.darkrockstudios.apps.hammer.desktop"
version = libs.versions.app.get()


kotlin {
	jvmToolchain(libs.versions.jvm.get().toInt())
	jvm()
	sourceSets {
		all {
			languageSettings {
				optIn("kotlin.io.encoding.ExperimentalEncodingApi")
				optIn("kotlin.uuid.ExperimentalUuidApi")
			}
		}

		val commonMain by getting {
			resources.srcDirs("resources")
			dependencies {
				implementation(libs.aboutlibraries.core)
			}
		}
		val jvmMain by getting {
			dependencies {
				implementation(project(":base"))
				implementation(project(":common"))
				implementation(project(":composeUi"))
				implementation(compose.preview)
				implementation(compose.desktop.currentOs)
				implementation(libs.darklaf.core)
				implementation(libs.kotlinx.cli)
			}
		}
		val jvmTest by getting {
			dependencies {
				implementation(kotlin("test"))
				implementation(libs.bundles.junit.jupiter)
			}
		}
	}
}

compose.desktop {
	application {
		mainClass = "com.darkrockstudios.apps.hammer.desktop.MainKt"
		nativeDistributions {
			targetFormats(
				TargetFormat.Dmg,
				TargetFormat.Pkg,
				TargetFormat.AppImage,
				TargetFormat.Msi,
				TargetFormat.Exe,
				TargetFormat.Deb,
				TargetFormat.Rpm
			)
			modules = arrayListOf(":base", ":common", ":composeUi", ":desktop")
			includeAllModules = true
			packageName = "hammer"
			packageVersion = libs.versions.app.get()
			description = "A simple tool for building stories."
			copyright = "© 2025 Adam W. Brown, All rights reserved."
			licenseFile.set(project.file("../LICENSE"))
			outputBaseDir.set(project.buildDir.resolve("installers"))

			windows {
				menuGroup = "Hammer"
				shortcut = true
				console = false

				iconFile.set(project.file("icons/windows.ico"))
			}

			linux {
				rpmLicenseType = "MIT"
				shortcut = true

				iconFile.set(project.file("icons/linux.png"))
			}

			macOS {
				dockName = "Hammer"
				appStore = false

				iconFile.set(project.file("icons/macos.icns"))
			}
		}
		jvmArgs("-Dcompose.application.configure.swing.globals=false")

		buildTypes.release.proguard {
			version.set("7.6.0")
			isEnabled.set(true)
			obfuscate.set(false)
			optimize.set(false)
			//joinOutputJars.set(true)
			configurationFiles.from("proguard-rules.pro")
		}
	}
}

aboutLibraries {
	export {
		prettyPrint = true
		excludeFields.addAll("generated")
	}
}

registerLinuxDistributionTasks(libs.versions.app.get())