# Jeûne intermittent

**Le jeûne intermittent** est actuellement un domaine d'étude très actif. Certaines parties de ce sujet sont bien
établies, d'autres sont encore en cours d'étude. Donc, prenez tout cela avec précaution et consultez les sources
primaires liées ci-dessous.

## Comment et pourquoi le jeûne fonctionne :

On pense que, dans nos débuts en tant que chasseurs-cueilleurs, notre régime alimentaire alternait entre festins et
famines. Une petite tribu pouvait peut-être obtenir une grosse proie une fois par semaine ou moins. Ainsi, nos corps
sont bien conçus pour tirer le maximum de ces repas et stocker autant que possible pour une utilisation ultérieure.

Obtenir des glucides en grande quantité aurait été difficile. Par exemple : cueillir des baies, riches en sucre,
nécessitait beaucoup d'efforts pour une petite quantité de sucre.

### Ainsi, nos corps ont développé deux principales voies énergétiques :

1. **Glucose :** Les glucides se décomposent en glucose lorsqu'ils sont consommés. Le glucose peut être utilisé
   directement par les cellules pour produire de l'énergie. L'excès de glucose est ensuite stocké sous forme de
   glycogène dans diverses parties du corps, comme le foie et les muscles squelettiques. Une fois que vos réserves de
   glycogène sont pleines, le glucose restant est transformé en tissu adipeux. En cas de besoin, le glycogène stocké
   peut être à nouveau décomposé en glucose pour être consommé par vos cellules.
2. **Corps cétoniques :** Ceux-ci sont dérivés de la métabolisation des graisses, et les cellules peuvent les consommer
   à la place du glucose pour produire de l'énergie. Les calories excédentaires provenant des glucides ou des
   protéines (*qui se décomposent respectivement en glucose et en acides aminés*) seront stockées sous forme de tissu
   adipeux (*graisse*), et en cas de besoin, peuvent être décomposées en corps cétoniques qui seront utilisés comme
   énergie par vos cellules.

À l'époque des chasseurs-cueilleurs, nous tirions souvent notre énergie à la fois des corps cétoniques et du glucose.

Cependant, aujourd'hui, dans les sociétés occidentales modernes, les glucides sont si facilement accessibles que les
gens peuvent passer la majeure partie de leur vie sans que leurs corps aient besoin de recourir aux corps cétoniques
pour produire de l'énergie.

Un domaine de recherche actif étudie quels processus corporels ne sont actifs que lorsque le corps consomme
principalement des corps cétoniques.

## Étapes du jeûne :

1. **Brûlage de glucose :** Au début, votre corps consommera le glucose déjà présent dans votre sang. Vous avez
   peut-être entendu dire que, pendant l'exercice cardiovasculaire, il faut 20 minutes pour épuiser tout votre glucose.
   Pour les athlètes d'endurance comme les marathoniens, il est conseillé de consommer plus de glucose toutes les 20
   minutes si possible. Comme pour tous les chiffres ici, il s'agit d'une estimation approximative, une règle empirique.
   Cela sera affecté par de nombreux facteurs : votre propre corps, l'activité que vous faites, la quantité de glucose
   que vous avez déjà en raison de votre alimentation, etc. Mais c'est une estimation suffisante pour que nous l'
   utilisions.
2. **Dégradation du glycogène :** À mesure que le glucose dans votre sang diminue, votre corps le reconstituera en
   décomposant vos réserves de glycogène. Les personnes qui suivent des régimes pauvres en glucides auront des réserves
   de glycogène plus faibles, cette phase peut donc varier considérablement. Quelqu'un suivant un régime pauvre en
   glucides peut terminer cette phase en seulement quelques heures, tandis qu'une personne avec un régime riche en
   glucides qui ne fait pas d'exercice régulièrement pourrait prendre entre 24 et 48 heures pour épuiser ses réserves.
   Faire de l'exercice pendant cette phase l'accélérera en forçant votre corps à brûler le glucose plus rapidement.
3. **Dégradation du tissu adipeux :** À mesure que vos réserves de glycogène commencent à s'épuiser, votre corps
   commencera à décomposer le tissu adipeux (*graisse*) en corps cétoniques. C'est le début de la « combustion des
   graisses ».
4. **Cétose :** C'est la première étape qui semble montrer plus de bénéfices que la simple restriction calorique. La
   cétose est l'état où les corps cétoniques sont la principale source d'énergie dans votre sang. Bien que le mécanisme
   d'action ne soit pas encore connu, cet état semble avoir des avantages significatifs contre l'inflammation et les
   maladies liées à l'inflammation, telles que la goutte.
5. **Autophagie :** Le corps dispose d'un autre mécanisme pour produire de l'énergie. À ce stade, votre corps commencera
   à consommer des cellules anciennes ou endommagées pour produire de l'énergie. Ce domaine de recherche en est encore à
   ses débuts, mais il semble que ce soit un mécanisme important permettant au corps de résoudre des problèmes. Les
   cancers sont simplement des cellules endommagées qui ne savent pas quand arrêter de se diviser. Si un corps entre
   régulièrement en autophagie, il semble que ces cellules endommagées soient décomposées pour produire de l'énergie
   avant qu'elles n'aient le temps de devenir un problème. Un autre domaine de recherche concerne la maladie
   d'Alzheimer. Nous savons que la cause d'Alzheimer est une accumulation de plaques amyloïdes dans le cerveau, donc
   toute méthode pour empêcher ces accumulations devrait empêcher la maladie de s'installer. L'autophagie pourrait faire
   exactement cela, en consommant les plaques avant qu'elles ne deviennent un problème. De plus, certains endroits qui
   stockent le glycogène et les tissus adipeux sont acceptables en petites quantités, mais deviennent problématiques
   lorsque ces réserves ne sont jamais épuisées. La cirrhose du foie, par exemple, peut être causée par des dépôts
   graisseux dans le foie qui entravent son fonctionnement normal. Si vous buvez souvent de l'alcool et ne suivez pas un
   régime pauvre en glucides, le glycogène stocké dans votre foie sera rarement épuisé.
6. **Autophagie optimale :** C'est probablement le domaine de recherche le plus récent, donc prenez-le avec précaution.
   Mais lorsque votre corps est en autophagie depuis suffisamment longtemps, il semble que d'autres systèmes de «
   réparation » soient activés. Le mécanisme d'action n'est pas encore connu. Mais des études ont montré que les
   dommages à l'ADN, tels que la longueur des télomères aux extrémités de votre ADN, sont réparés, inversant
   efficacement les dommages liés à l'âge de l'ADN et abaissant votre âge biologique. Il semble que ce ne soit pas
   seulement l'autophagie qui déclenche ces systèmes ; stresser le corps de diverses manières peut également les
   activer. Les athlètes d'endurance peuvent déclencher ces systèmes, ce qui a du sens puisqu'il semble que nos ancêtres
   étaient des chasseurs d'endurance, courant pendant des heures en poursuivant leurs proies.

## Sources :

- [Comment ralentir le vieillissement (et même l'inverser)](https://www.youtube.com/watch?v=QRt7LjqJ45k) (*YouTube*)
- [Effets du jeûne intermittent sur la santé, le vieillissement et les maladies](https://www.nejm.org/action/showFullText?downloadfile=showFullText&downloadfile=showFullText&doi=10.1056/nejmra1905136) (
  *New England Journal of Medicine*)
