# Intermittent Fasting

**Intermittent Fasting** is currently a very active field of study, some parts of this are well established, and others are still being studied. So take this all with a grain of salt, and consult the primary sources linked below.

## How and why fasting works:
It's believed that in our early development as hunter gatherers, our diet was feast or famine. Maybe a small tribe would get a large kill once a week or less. Thus our bodies are well designed to make the most out of that and store everything possible for later use.

Acquiring carbs in large quantities would have been difficult. For instance: foraging for berries, which would be high in sugar, would require a lot of effort for only a small amount of sugar.

### Thus our bodies developed two primary energy pathways:

1. **Glucose:** Carbohydrates all break down into glucose when consumed. Glucose can be consumed directly by cells for energy. Excess glucose is then be stored as glycogen in various places around the body such as the liver and skeletal muscle. Once your glycogen reserves are full, the remaining glucose will be turned into adipose tissue. When needed, the stored glycogen can be broken back down into glucose in order to be consumed by your cells.
2. **Ketone Bodies:** These are derived by metabolizing fat, and cells can consume them instead of glucose for energy. Excess calories from carbohydrates or protein (*which break down into glucose and amino acids respectively*)  will be stored as adipose tissue (*fat*), and when needed, can be broken down into ketone bodies which will be used for energy by your cells.

In our hunter gatherer days we would have often been deriving our energy from ketone bodies as well as glucose.

However, today in modern western societies carbohydrates are so easy to come by that people can go most of their lives without their bodies having to resort to ketone bodies for energy.

An active area of research is about what processes the body has that are only active when the body is primarily consuming ketone bodies.

## Stages of Fasting:

1. **Glucose burning:** At first your body will be consuming the glucose that is already free in your blood. You may have heard that during cardiovascular exercise it takes 20 minutes to exhaust all your glucose. For endurance athletes such as marathon runners, they are advised to consume more glucose every 20 minutes if possible. As with all the numbers here, this is a rough estimate, a good rule of thumb if you will. This will be affected by many factors: your own body, the activity you are doing, how much glucose you already had due to your diet, etc. But it's a good enough estimate so we'll go with it.
2. **Glycogen Breakdown:** As the glucose in your blood depletes, your body will replenish it by breaking down your stores of glycogen. People who follow low carb diets will have smaller glycogen stores, so this phase can vary widely. Someone with a low carb diet may complete this stage in just a few hours, while someone with a high carb diet who does not regularly exercise could take anywhere from 24 to 48 hours to exhaust their stores. Exercise during this stage will accelerate it by forcing your body to burn glucose faster.
3. **Adipose Tissue Breakdown:** As your glycogen stores begin to deplete, your body will start switching over to breaking down adipose tissue (*fat*) into ketone bodies. This is the beginning of "Fat Burning."
4. **Ketosis:** This is the first stage that appears to show more benefits than simple calorie restriction. Ketosis is the state of ketone bodies being the primary energy source in your blood. Although the mechanism of action is not yet known, this state appears to have significant benefits for inflammation and inflammation related illnesses such as gout.
5. **Autophagy:** The body has another mechanism for harvesting energy. In this stage your body will begin consuming old or damaged cells for energy. This area of research is still in its infancy, but it appears this is actually an important mechanism for the body to fix issues. Cancers are simply damaged cells that don't know when to stop dividing. If a body regularly enters autophagy, it appears that those damaged cells are broken down for energy before they have time to become a problem. Another area of research is around Alzheimer's Disease. We know the cause of Alzheimer's is a build up of plaque amyloid in the brain, so any way to prevent those build ups should prevent the disease from taking root in the first place. Autophagy may do just that, by consuming the plaque before it becomes a problem. Additionally, some places that store glycogen and adipose tissues are fine in small quantities, but become a problem when those stores are never depleted. Cirrhosis of the liver for instance can be caused by fatty deposits in the liver impeding its normal function. If you often drink alcohol and don’t otherwise follow a low-carb diet, the stored glycogen in your liver will rarely be depleted.
6. **Optimal Autophagy:** This is probably the newest area of research, so take this with a grain of salt. But when your body has been in autophagy for a long enough period of time, it appears that further “repair” systems are activated. The mechanism of action is not yet known for this. But studies have shown that DNA damage, such as the length of telomeres on the ends of your DNA are repaired, effectively reversing age related DNA damage, and lowering your biological age. It appears to not just be autophagy that triggers these systems, stressing the body in a variety of ways can trigger them. Endurance athletes may trigger these systems, which may make sense as it appears our ancestors were endurance hunters, running for hours while stalking prey.

## Sources:

- [How to Slow Aging (and even reverse it)](https://www.youtube.com/watch?v=QRt7LjqJ45k) (*Youtube*)
- [Effects of Intermittent Fasting on Health, Aging, and Disease](https://www.nejm.org/action/showFullText?downloadfile=showFullText&downloadfile=showFullText&doi=10.1056/nejmra1905136) (*New England Journal of Medicine*)