# Digiuno intermittente

**Il digiuno intermittente** è attualmente un campo di studio molto attivo. Alcuni aspetti sono ben consolidati, altri
sono ancora oggetto di studio. Quindi prendi tutto questo con cautela e consulta le fonti primarie collegate qui sotto.

## Come e perché funziona il digiuno:

Si ritiene che, durante le prime fasi del nostro sviluppo come cacciatori-raccoglitori, la nostra dieta fosse
caratterizzata da periodi di abbondanza alternati a carestie. Forse una piccola tribù riusciva a catturare una grande
preda una volta alla settimana o meno. I nostri corpi sono quindi ben progettati per trarre il massimo da queste
situazioni e immagazzinare tutto il possibile per un uso successivo.

Ottenere carboidrati in grandi quantità sarebbe stato difficile. Ad esempio: raccogliere bacche, ricche di zucchero,
richiedeva molto sforzo per una piccola quantità di zucchero.

### Così i nostri corpi hanno sviluppato due principali vie energetiche:

1. **Glucosio:** I carboidrati vengono scomposti in glucosio quando consumati. Il glucosio può essere utilizzato
   direttamente dalle cellule per produrre energia. Il glucosio in eccesso viene poi immagazzinato sotto forma di
   glicogeno in varie parti del corpo come il fegato e i muscoli scheletrici. Una volta che le riserve di glicogeno sono
   piene, il glucosio rimanente viene trasformato in tessuto adiposo. Quando necessario, il glicogeno immagazzinato può
   essere nuovamente scomposto in glucosio per essere utilizzato dalle cellule.
2. **Corpi chetonici:** Questi derivano dalla metabolizzazione dei grassi, e le cellule possono utilizzarli al posto del
   glucosio per ottenere energia. Le calorie in eccesso provenienti da carboidrati o proteine (*che si scompongono
   rispettivamente in glucosio e amminoacidi*) verranno immagazzinate come tessuto adiposo (*grasso*) e, quando
   necessario, possono essere scomposte in corpi chetonici che verranno utilizzati come energia dalle cellule.

Durante l'era dei cacciatori-raccoglitori, spesso traevamo energia sia dai corpi chetonici che dal glucosio.

Oggi, nelle società occidentali moderne, i carboidrati sono così facilmente disponibili che le persone possono
trascorrere la maggior parte della loro vita senza che i loro corpi debbano ricorrere ai corpi chetonici per ottenere
energia.

Un'area di ricerca attiva studia quali processi corporei sono attivi solo quando il corpo consuma principalmente corpi
chetonici.

## Fasi del digiuno:

1. **Combustione del glucosio:** All'inizio, il corpo consumerà il glucosio già presente nel sangue. Potresti aver
   sentito dire che durante l'esercizio cardiovascolare ci vogliono circa 20 minuti per esaurire tutto il glucosio. Per
   gli atleti di resistenza, come i maratoneti, si consiglia di assumere più glucosio ogni 20 minuti, se possibile. Come
   per tutti i numeri qui riportati, si tratta di una stima approssimativa, una regola pratica. Questa sarà influenzata
   da molti fattori: il tuo corpo, l'attività che stai svolgendo, la quantità di glucosio già presente a causa della tua
   dieta, ecc. Ma è una stima abbastanza affidabile, quindi la useremo.
2. **Scomposizione del glicogeno:** Man mano che il glucosio nel sangue si esaurisce, il corpo lo reintegrerà
   scomponendo le riserve di glicogeno. Le persone che seguono diete a basso contenuto di carboidrati avranno riserve di
   glicogeno più piccole, quindi questa fase può variare notevolmente. Qualcuno con una dieta a basso contenuto di
   carboidrati può completare questa fase in poche ore, mentre qualcuno con una dieta ricca di carboidrati che non si
   allena regolarmente potrebbe impiegare dalle 24 alle 48 ore per esaurire le proprie riserve. L'esercizio fisico
   durante questa fase lo accelererà costringendo il corpo a bruciare il glucosio più rapidamente.
3. **Scomposizione del tessuto adiposo:** Quando le riserve di glicogeno cominciano a esaurirsi, il corpo inizierà a
   scomporre il tessuto adiposo (*grasso*) in corpi chetonici. Questo è l'inizio della "combustione dei grassi".
4. **Chetonemia:** Questa è la prima fase che sembra mostrare più benefici della semplice restrizione calorica. La
   chetonemia è lo stato in cui i corpi chetonici sono la principale fonte di energia nel sangue. Sebbene il meccanismo
   d'azione non sia ancora noto, questo stato sembra avere benefici significativi per l'infiammazione e le malattie
   correlate all'infiammazione come la gotta.
5. **Autofagia:** Il corpo ha un altro meccanismo per ottenere energia. In questa fase, il corpo inizierà a consumare
   cellule vecchie o danneggiate per ottenere energia. Questo campo di ricerca è ancora agli inizi, ma sembra essere un
   importante meccanismo attraverso il quale il corpo risolve problemi. I tumori sono semplicemente cellule danneggiate
   che non sanno quando smettere di dividersi. Se un corpo entra regolarmente in autofagia, sembra che queste cellule
   danneggiate vengano scomposte per ottenere energia prima che abbiano il tempo di diventare un problema. Un'altra area
   di ricerca riguarda il morbo di Alzheimer. Sappiamo che la causa dell'Alzheimer è l'accumulo di placche amiloidi nel
   cervello, quindi qualsiasi modo per prevenire questi accumuli dovrebbe impedire alla malattia di attecchire.
   L'autofagia potrebbe fare proprio questo, consumando le placche prima che diventino un problema. Inoltre, alcuni
   luoghi che immagazzinano glicogeno e tessuto adiposo vanno bene in piccole quantità, ma diventano un problema quando
   queste riserve non vengono mai esaurite. La cirrosi epatica, ad esempio, può essere causata da depositi di grasso nel
   fegato che ne ostacolano il normale funzionamento. Se bevi frequentemente alcol e non segui una dieta a basso
   contenuto di carboidrati, il glicogeno immagazzinato nel fegato verrà raramente esaurito.
6. **Autofagia ottimale:** Probabilmente questa è l'area di ricerca più recente, quindi prendi queste informazioni con
   cautela. Ma quando il corpo è stato in autofagia per un periodo di tempo sufficientemente lungo, sembra che vengano
   attivati ulteriori sistemi di "riparazione". Il meccanismo d'azione non è ancora noto. Tuttavia, studi hanno
   dimostrato che i danni al DNA, come la lunghezza dei telomeri alle estremità del DNA, vengono riparati, invertendo
   efficacemente i danni al DNA legati all'età e abbassando l'età biologica. Sembra che non sia solo l'autofagia a
   innescare questi sistemi; sottoporre il corpo a vari tipi di stress può attivarli anch'essi. Gli atleti di resistenza
   possono innescare questi sistemi, il che ha senso dato che sembra che i nostri antenati fossero cacciatori di
   resistenza, correndo per ore mentre inseguivano la preda.

## Fonti:

- [Come rallentare l'invecchiamento (e persino invertirlo)](https://www.youtube.com/watch?v=QRt7LjqJ45k) (*YouTube*)
- [Effetti del digiuno intermittente sulla salute, l'invecchiamento e le malattie](https://www.nejm.org/action/showFullText?downloadfile=showFullText&downloadfile=showFullText&doi=10.1056/nejmra1905136) (
  *New England Journal of Medicine*)
