# Ayuno intermitente

**El ayuno intermitente** es actualmente un campo de estudio muy activo. Algunas partes de esto están bien establecidas
y otras todavía se están investigando. Así que toma todo esto con cautela y consulta las fuentes primarias vinculadas a
continuación.

## Cómo y por qué funciona el ayuno:

Se cree que en nuestro desarrollo temprano como cazadores-recolectores, nuestra dieta era de festines o hambrunas. Tal
vez una pequeña tribu lograba una gran caza una vez por semana o menos. Por lo tanto, nuestros cuerpos están bien
diseñados para aprovechar al máximo eso y almacenar todo lo posible para su uso posterior.

Obtener carbohidratos en grandes cantidades habría sido difícil. Por ejemplo: recolectar bayas, que son ricas en azúcar,
requeriría mucho esfuerzo por solo una pequeña cantidad de azúcar.

### Así, nuestros cuerpos desarrollaron dos vías principales de energía:

1. **Glucosa:** Los carbohidratos se descomponen en glucosa cuando se consumen. La glucosa puede ser consumida
   directamente por las células para obtener energía. El exceso de glucosa se almacena como glucógeno en varios lugares
   del cuerpo como el hígado y el músculo esquelético. Una vez que tus reservas de glucógeno están llenas, la glucosa
   restante se convierte en tejido adiposo. Cuando sea necesario, el glucógeno almacenado puede descomponerse nuevamente
   en glucosa para ser consumida por tus células.
2. **Cuerpos cetónicos:** Estos se derivan al metabolizar la grasa, y las células pueden consumirlos en lugar de glucosa
   para obtener energía. Las calorías excedentes de carbohidratos o proteínas (*que se descomponen en glucosa y
   aminoácidos respectivamente*) se almacenan como tejido adiposo (*grasa*), y cuando se necesita, pueden descomponerse
   en cuerpos cetónicos que serán utilizados por tus células como energía.

En nuestros días como cazadores-recolectores, a menudo obteníamos nuestra energía tanto de cuerpos cetónicos como de
glucosa.

Sin embargo, hoy en las sociedades occidentales modernas, los carbohidratos son tan fáciles de obtener que las personas
pueden pasar la mayor parte de sus vidas sin que sus cuerpos tengan que recurrir a los cuerpos cetónicos para obtener
energía.

Un área activa de investigación es sobre qué procesos del cuerpo solo están activos cuando el cuerpo consume
principalmente cuerpos cetónicos.

## Etapas del ayuno:

1. **Quema de glucosa:** Al principio, tu cuerpo consumirá la glucosa que ya está libre en tu sangre. Es posible que
   hayas escuchado que durante el ejercicio cardiovascular toma 20 minutos agotar toda tu glucosa. Para los atletas de
   resistencia, como los corredores de maratón, se les aconseja consumir más glucosa cada 20 minutos si es posible. Como
   con todos los números aquí, esto es una estimación aproximada, una regla general. Esto se verá afectado por muchos
   factores: tu propio cuerpo, la actividad que estás haciendo, cuánta glucosa ya tenías debido a tu dieta, etc. Pero es
   una estimación lo suficientemente buena, así que la usaremos.
2. **Descomposición de glucógeno:** A medida que la glucosa en tu sangre se agota, tu cuerpo la repondrá descomponiendo
   tus reservas de glucógeno. Las personas que siguen dietas bajas en carbohidratos tendrán reservas de glucógeno más
   pequeñas, por lo que esta fase puede variar mucho. Alguien con una dieta baja en carbohidratos puede completar esta
   etapa en solo unas pocas horas, mientras que alguien con una dieta alta en carbohidratos que no hace ejercicio
   regularmente podría tardar entre 24 y 48 horas en agotar sus reservas. El ejercicio durante esta etapa la acelerará
   al obligar a tu cuerpo a quemar glucosa más rápido.
3. **Descomposición de tejido adiposo:** A medida que tus reservas de glucógeno comienzan a agotarse, tu cuerpo
   comenzará a cambiar a la descomposición del tejido adiposo (*grasa*) en cuerpos cetónicos. Este es el comienzo de
   la "quema de grasa".
4. **Cetosis:** Esta es la primera etapa que parece mostrar más beneficios que la simple restricción calórica. La
   cetosis es el estado en el que los cuerpos cetónicos son la fuente principal de energía en tu sangre. Aunque el
   mecanismo de acción aún no se conoce, este estado parece tener beneficios significativos para la inflamación y
   enfermedades relacionadas con la inflamación como la gota.
5. **Autofagia:** El cuerpo tiene otro mecanismo para obtener energía. En esta etapa, tu cuerpo comenzará a consumir
   células viejas o dañadas para obtener energía. Esta área de investigación aún está en sus inicios, pero parece ser un
   mecanismo importante para que el cuerpo solucione problemas. Los cánceres son simplemente células dañadas que no
   saben cuándo dejar de dividirse. Si un cuerpo entra regularmente en autofagia, parece que esas células dañadas se
   descomponen para obtener energía antes de que tengan tiempo de convertirse en un problema. Otra área de investigación
   es sobre la enfermedad de Alzheimer. Sabemos que la causa del Alzheimer es una acumulación de placas de amiloide en
   el cerebro, por lo que cualquier forma de prevenir esas acumulaciones debería prevenir la enfermedad desde el
   principio. La autofagia podría hacer precisamente eso, al consumir las placas antes de que se conviertan en un
   problema. Además, algunos lugares que almacenan glucógeno y tejidos adiposos están bien en pequeñas cantidades, pero
   se convierten en un problema cuando esas reservas nunca se agotan. La cirrosis hepática, por ejemplo, puede ser
   causada por depósitos de grasa en el hígado que impiden su funcionamiento normal. Si bebes alcohol con frecuencia y
   no sigues una dieta baja en carbohidratos, el glucógeno almacenado en tu hígado rara vez se agotará.
6. **Autofagia óptima:** Probablemente esta sea el área más nueva de investigación, así que tómala con cautela. Pero
   cuando tu cuerpo ha estado en autofagia durante un período de tiempo suficientemente largo, parece que se activan
   sistemas adicionales de "reparación". El mecanismo de acción aún no se conoce. Pero los estudios han demostrado que
   los daños en el ADN, como la longitud de los telómeros en los extremos de tu ADN, se reparan, revirtiendo
   efectivamente el daño relacionado con la edad en el ADN y reduciendo tu edad biológica. Parece que no solo la
   autofagia activa estos sistemas, estresar al cuerpo de diversas maneras también puede activarlos. Los atletas de
   resistencia pueden activar estos sistemas, lo que tiene sentido ya que parece que nuestros antepasados eran cazadores
   de resistencia, corriendo durante horas mientras acechaban a sus presas.

## Fuentes:

- [Cómo ralentizar el envejecimiento (e incluso revertirlo)](https://www.youtube.com/watch?v=QRt7LjqJ45k) (*YouTube*)
- [Efectos del ayuno intermitente en la salud, el envejecimiento y las enfermedades](https://www.nejm.org/action/showFullText?downloadfile=showFullText&downloadfile=showFullText&doi=10.1056/nejmra1905136) (
  *New England Journal of Medicine*)
